/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.repo;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.ai.gai.core.enuz.es.ESTokenizerType;
import kd.ai.gai.core.repo.constant.RepoConstant;
import kd.ai.gai.core.repo.entity.StructRepoField;
import kd.ai.gai.core.repo.helper.GaiStructRepoHelper;
import kd.ai.gai.core.search.dto.CreateRepoResDTO;
import kd.ai.gai.core.search.helper.KnowledgeRepoServiceHelper;
import kd.ai.gai.core.search.param.schema.SaveKnoSchemaParam;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.core.util.ListUtil;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class GaiStructRepoPlugin
extends AbstractBillPlugIn {
    private static final Log logger = LogFactory.getLog(GaiStructRepoPlugin.class);
    private static final String EMBEDDING_MODEL_SELECTOR = "vectormodel";
    private static final String OPERATION_KEY_SAVE = "save";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String STRUCT_REPO_FORM_ID = "gai_struct_repo";
    private static final String CONTROL_FIELD_VERSION = "version";
    private static final String CONTROL_ENTRY_FIELD_INDEX = "fieldindex";
    private static final String CONTROL_ENTRY_FIELD_SEQ = "seq";
    private static final String CONTROL_ENTRY_FIELD_NAME = "fieldname";
    private static final String CONTROL_ENTRY_FIELD_ENTRYID = "id";
    private static final String CONTROL_ENTRY_FIELD_DATA_TYPE = "datatype";
    private static final String CONTROL_ENTRY_FIELD_EMBEDINDEX = "embedindex";
    private static final String CONTROL_ENTRY_FIELD_FULLINDEX = "fullindex";
    private static final String CONTROL_REPO_TYPE = "repotype";
    private static final String CONTROL_VECTOR_METRICTYPE = "vectormetrictype";
    private static final String CONTROL_REPO_TOKENIZER = "tokenizer";
    private static final String CONTROL_FIELD_DELETE = "btnfielddelete";
    private static final String REPO_FIELDS_LIST_CACHE_KEY = "repo_fields_list_cache";
    private static final String REPO_EDIT_MODEL_CACHE = "repo_edit_model_cache";
    private static final String REPO_EDIT_MODEL_ADD = "add";
    private static final String REPO_EDIT_MODEL_MODIFY = "modify";
    private static final String REPO_ADD_FIELDS_LIST_CACHE_KEY = "repo_add_fields_list_cache";
    private static final String REPO_DELETE_FIELDS_LIST_CACHE_KEY = "repo_delete_fields_list_cache";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        OperationStatus status = billShowParameter.getStatus();
        this.initEmbeddingModelList();
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)status.name(), (CharSequence)OperationStatus.ADDNEW.name())) {
            this.getPageCache().put(REPO_EDIT_MODEL_CACHE, REPO_EDIT_MODEL_ADD);
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)status.name(), (CharSequence)OperationStatus.EDIT.name())) {
            String repoType;
            this.getPageCache().put(REPO_EDIT_MODEL_CACHE, REPO_EDIT_MODEL_MODIFY);
            this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_REPO_TYPE, EMBEDDING_MODEL_SELECTOR, CONTROL_FIELD_VERSION, CONTROL_REPO_TOKENIZER, CONTROL_VECTOR_METRICTYPE});
            DynamicObject entry = this.getModel().getDataEntity();
            Object pk = entry.getPkValue();
            DynamicObject repo = BusinessDataServiceHelper.loadSingle((Object)pk, (String)STRUCT_REPO_FORM_ID);
            DynamicObjectCollection fields = repo.getDynamicObjectCollection(ENTRY_ENTITY);
            if (fields != null && !fields.isEmpty()) {
                this.putRepoFiledsCache(fields);
            }
            if (this.repoHasData(repoType = repo.getString(CONTROL_REPO_TYPE), pk)) {
                this.handlerRowData();
            }
        }
    }

    private void handlerRowData() {
        this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_FIELD_DELETE});
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        DynamicObject[] fields = grid.getEntryData().getDataEntitys();
        if (fields != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{CONTROL_ENTRY_FIELD_NAME});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{CONTROL_ENTRY_FIELD_DATA_TYPE});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{CONTROL_ENTRY_FIELD_EMBEDINDEX});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{CONTROL_ENTRY_FIELD_FULLINDEX});
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initEmbeddingModelList();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        Object tokenizer = this.getModel().getValue(CONTROL_REPO_TOKENIZER);
        if (tokenizer == null || StringUtils.isEmpty((CharSequence)tokenizer.toString())) {
            this.getModel().setValue(CONTROL_REPO_TOKENIZER, (Object)ESTokenizerType.IKMAXWORD.toString());
        }
    }

    private void initEmbeddingModelList() {
        List embeddingList = GaiFieldTypeInitUtils.createRepoEmbeddingComboItem();
        ComboEdit embeddingSelect = (ComboEdit)this.getControl(EMBEDDING_MODEL_SELECTOR);
        embeddingSelect.setComboItems(embeddingList);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String operateKey = evt.getOperationKey();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)operateKey, (CharSequence)OPERATION_KEY_SAVE)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            DynamicObject[] fields = entryGrid.getEntryData().getDataEntitys();
            int size = fields.length;
            if (size == 0) {
                this.getView().showTipNotification("\u81f3\u5c11\u8981\u65b0\u589e\u4e00\u4e2a\u81ea\u5b9a\u4e49\u5b57\u6bb5.", Integer.valueOf(3000));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            if (size > 20) {
                this.getView().showTipNotification("\u6700\u591a\u5141\u8bb8\u65b0\u589e20\u4e2a\u81ea\u5b9a\u4e49\u5b57\u6bb5.", Integer.valueOf(3000));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            if (!this.checkNameSame()) {
                this.getView().showTipNotification("\u5b57\u6bb5\u540d\u4e0d\u80fd\u91cd\u590d\u3002");
                evt.setCancel(Boolean.TRUE.booleanValue());
            }
            int indexCount = 0;
            Boolean hasEmptyField = Boolean.FALSE;
            for (DynamicObject field : fields) {
                Boolean fullIndex = field.getBoolean(CONTROL_ENTRY_FIELD_FULLINDEX);
                Boolean vectorIndex = field.getBoolean(CONTROL_ENTRY_FIELD_EMBEDINDEX);
                String fieldName = field.getString(CONTROL_ENTRY_FIELD_NAME);
                if (fullIndex.booleanValue() || vectorIndex.booleanValue()) {
                    ++indexCount;
                }
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fieldName)) continue;
                hasEmptyField = Boolean.TRUE;
            }
            if (indexCount == 0) {
                evt.setCancel(Boolean.TRUE.booleanValue());
                this.getView().showTipNotification("\u81f3\u5c11\u6709\u4e00\u4e2a\u5b57\u6bb5\u9700\u8981\u6784\u5efa\u5411\u91cf\u7d22\u5f15\u6216\u8005\u5168\u6587\u7d22\u5f15\u3002");
            }
            if (hasEmptyField.booleanValue()) {
                evt.setCancel(Boolean.TRUE.booleanValue());
                this.getView().showTipNotification("\u8bf7\u6309\u8981\u6c42\u586b\u5199\"\u5b57\u6bb5\u540d\u79f0\"\u3002");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operation = (FormOperate)args.getSource();
        String operationKey = operation.getOperateKey();
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)OPERATION_KEY_SAVE)) {
            operation.getOption().setVariableValue("isshowmessage", "false");
        }
    }

    private boolean checkNameSame() {
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        DynamicObject[] data = grid.getEntryData().getDataEntitys();
        Boolean success = Boolean.TRUE;
        if (data != null && data.length > 0) {
            ArrayList<String> names = new ArrayList<String>(0);
            for (int i = 0; i < data.length; ++i) {
                DynamicObject dynamicObject = data[i];
                String fieldName = dynamicObject.getString(CONTROL_ENTRY_FIELD_NAME);
                names.add(fieldName);
            }
            HashSet newNames = new HashSet(names);
            if (newNames.size() != names.size()) {
                success = Boolean.FALSE;
            }
        }
        return success;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operationKey = afterDoOperationEventArgs.getOperateKey();
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)OPERATION_KEY_SAVE)) {
            DynamicObject entry = this.getModel().getDataEntity();
            Object pk = entry.getPkValue();
            DynamicObject repo = BusinessDataServiceHelper.loadSingle((Object)pk, (String)STRUCT_REPO_FORM_ID);
            long version = repo.getLong(CONTROL_FIELD_VERSION);
            String repoType = repo.getString(CONTROL_REPO_TYPE);
            DynamicObjectCollection fields = repo.getDynamicObjectCollection(ENTRY_ENTITY);
            if (fields != null && !fields.isEmpty()) {
                if (version == 0L) {
                    for (int i = 0; i < fields.size(); ++i) {
                        DynamicObject field = (DynamicObject)fields.get(i);
                        Integer seq = field.getInt(CONTROL_ENTRY_FIELD_SEQ);
                        field.set(CONTROL_ENTRY_FIELD_INDEX, (Object)seq);
                    }
                } else {
                    String fieldListJson = this.getPageCache().get(REPO_FIELDS_LIST_CACHE_KEY);
                    JSONArray list = (JSONArray)JSONObject.parseObject((String)fieldListJson, JSONArray.class);
                    this.restoreFieldIndex(fields, list);
                    this.updateRepoFieldsCache();
                }
            }
            this.updateRepoVersion(repo, version);
            this.updateRepoFieldsCache();
            this.setControlDisenable();
            this.afterOperationRepo(pk);
            if (this.repoHasData(repoType, pk)) {
                this.handlerRowData();
            }
        }
    }

    private void updateRepoVersion(DynamicObject repo, long version) {
        long currentVersion = version + 1L;
        repo.set(CONTROL_FIELD_VERSION, (Object)currentVersion);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{repo});
    }

    private void setControlDisenable() {
        this.getView().setEnable(Boolean.FALSE, new String[]{EMBEDDING_MODEL_SELECTOR, CONTROL_REPO_TYPE, CONTROL_VECTOR_METRICTYPE, CONTROL_REPO_TOKENIZER});
    }

    private void afterOperationRepo(Object pk) {
        DynamicObject repo = BusinessDataServiceHelper.loadSingle((Object)pk, (String)STRUCT_REPO_FORM_ID);
        String model = this.getPageCache().get(REPO_EDIT_MODEL_CACHE);
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)model, (CharSequence)REPO_EDIT_MODEL_ADD)) {
            this.getPageCache().put(REPO_EDIT_MODEL_CACHE, REPO_EDIT_MODEL_MODIFY);
            SaveKnoSchemaParam knowledgeRepoParam = this.buildAddRepoParam(repo);
            logger.info("\u5f00\u59cb\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93\u521b\u5efa\uff0c\u8bf7\u6c42\u53c2\u6570\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)knowledgeRepoParam));
            try {
                repo.set("datastatus", (Object)RepoConstant.RepoDataStatus.PROCESSING.getStatus());
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{repo});
                CreateRepoResDTO dto = KnowledgeRepoServiceHelper.getRepoService().saveSchema(knowledgeRepoParam);
                logger.info("\u5b8c\u6210\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93\u521b\u5efa\uff0c\u8fd4\u56de\u53c2\u6570\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
                String repoNumber = dto.getSchemaNumber();
                repo.set("reponumber", (Object)repoNumber);
                repo.set("datastatus", (Object)RepoConstant.RepoDataStatus.SUCCESS.getStatus());
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{repo});
                this.getView().showSuccessNotification("\u4fdd\u5b58\u6210\u529f\u3002");
            }
            catch (Exception e) {
                logger.error("\u5411\u91cf\u5316\u8fc7\u7a0b\u4e2d\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
                repo.set("datastatus", (Object)RepoConstant.RepoDataStatus.FAILED.getStatus());
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{repo});
                this.getView().showErrorNotification("\u5411\u91cf\u5316\u8fc7\u7a0b\u4e2d\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f=" + e.getMessage());
            }
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)model, (CharSequence)REPO_EDIT_MODEL_MODIFY)) {
            SaveKnoSchemaParam knowledgeRepoParam = this.buildUpdateRepoParam(repo);
            logger.info("\u5f00\u59cb\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93\u4fee\u6539\uff0c\u8bf7\u6c42\u53c2\u6570\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)knowledgeRepoParam));
            logger.info("\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93\uff0c\u4fee\u6539schema\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)knowledgeRepoParam));
            try {
                repo.set("datastatus", (Object)RepoConstant.RepoDataStatus.PROCESSING.getStatus());
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{repo});
                CreateRepoResDTO dto = KnowledgeRepoServiceHelper.getRepoService().saveSchema(knowledgeRepoParam);
                logger.info("\u5b8c\u6210\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93\u4fee\u6539\uff0c\u8fd4\u56de\u53c2\u6570\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
                repo.set("datastatus", (Object)RepoConstant.RepoDataStatus.SUCCESS.getStatus());
                String repoNumber = dto.getSchemaNumber();
                repo.set("reponumber", (Object)repoNumber);
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{repo});
                this.getView().showSuccessNotification("\u4fdd\u5b58\u6210\u529f\u3002");
            }
            catch (Exception e) {
                logger.error("\u5411\u91cf\u5316\u8fc7\u7a0b\u4e2d\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
                repo.set("datastatus", (Object)RepoConstant.RepoDataStatus.FAILED.getStatus());
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{repo});
                this.getView().showErrorNotification("\u5411\u91cf\u5316\u8fc7\u7a0b\u4e2d\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f=" + e.getMessage());
            }
        }
    }

    private SaveKnoSchemaParam buildRepoParam(DynamicObject repo) {
        long repoId = repo.getLong(CONTROL_ENTRY_FIELD_ENTRYID);
        SaveKnoSchemaParam param = new SaveKnoSchemaParam();
        String number = repo.getString("number");
        String name = repo.getString("name");
        String vectorModel = repo.getString(EMBEDDING_MODEL_SELECTOR);
        String repoType = repo.getString(CONTROL_REPO_TYPE);
        String vectormetrictype = repo.getString(CONTROL_VECTOR_METRICTYPE);
        param.setRepoId(Long.valueOf(repoId));
        param.setRepoNumber(number);
        param.setRepoName(name);
        param.setVectorModel(vectorModel);
        param.setVectorMetricType(vectormetrictype);
        param.setRepoType(repoType);
        param.setTokenizerType(repo.getString(CONTROL_REPO_TOKENIZER));
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)repoType, (CharSequence)RepoConstant.RepoType.LEVEL.getType())) {
            param.setDataSrcNumber("gai_repo_treedata");
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)repoType, (CharSequence)RepoConstant.RepoType.TABLE.getType())) {
            param.setDataSrcNumber("gai_table_repo");
        }
        ArrayList<SaveKnoSchemaParam.SchemaFieldInfo> fields = new ArrayList<SaveKnoSchemaParam.SchemaFieldInfo>(0);
        List repoFields = GaiStructRepoHelper.queryStructRepoFields((long)repoId);
        if (repoFields != null && !repoFields.isEmpty()) {
            for (StructRepoField structRepoField : repoFields) {
                SaveKnoSchemaParam.SchemaFieldInfo info = new SaveKnoSchemaParam.SchemaFieldInfo();
                info.setFieldId(structRepoField.getId());
                info.setFieldKey(structRepoField.getFieldName());
                info.setFieldName(structRepoField.getName());
                info.setFieldType(structRepoField.getDataType());
                info.setFullIndexEnable(structRepoField.getFullIndex());
                info.setVectorIndexEnable(structRepoField.getEmbeddingIndex());
                fields.add(info);
            }
        }
        param.setFields(fields);
        return param;
    }

    private SaveKnoSchemaParam buildUpdateRepoParam(DynamicObject repo) {
        SaveKnoSchemaParam param = this.buildRepoParam(repo);
        String repoNumber = repo.getString("reponumber");
        param.setSchemaNumber(repoNumber);
        return param;
    }

    private SaveKnoSchemaParam buildAddRepoParam(DynamicObject repo) {
        return this.buildRepoParam(repo);
    }

    private void updateRepoFieldsCache() {
        DynamicObject entry = this.getModel().getDataEntity();
        Object pk = entry.getPkValue();
        DynamicObject repo = BusinessDataServiceHelper.loadSingle((Object)pk, (String)STRUCT_REPO_FORM_ID);
        DynamicObjectCollection fields = repo.getDynamicObjectCollection(ENTRY_ENTITY);
        if (fields != null && !fields.isEmpty()) {
            this.putRepoFiledsCache(fields);
        }
    }

    private void putRepoFiledsCache(DynamicObjectCollection fields) {
        JSONArray fieldList = new JSONArray(0);
        for (int i = 0; i < fields.size(); ++i) {
            DynamicObject field = (DynamicObject)fields.get(i);
            Long index = field.getLong(CONTROL_ENTRY_FIELD_INDEX);
            long entryId = field.getLong(CONTROL_ENTRY_FIELD_ENTRYID);
            JSONObject item = new JSONObject();
            item.put(CONTROL_ENTRY_FIELD_ENTRYID, (Object)entryId);
            item.put("index", (Object)index);
            fieldList.add((Object)item);
        }
        this.getPageCache().put(REPO_FIELDS_LIST_CACHE_KEY, JSONObject.toJSONString((Object)fieldList));
    }

    private void restoreFieldIndex(DynamicObjectCollection fields, JSONArray beforeList) {
        if (fields != null && !fields.isEmpty()) {
            int currentSize = fields.size();
            Integer[] originIndex = new Integer[beforeList.size()];
            ArrayList<Long> originIds = new ArrayList<Long>(0);
            for (int j = 0; j < beforeList.size(); ++j) {
                JSONObject item = beforeList.getJSONObject(j);
                int index = item.getLong("index").intValue();
                Long id = item.getLong(CONTROL_ENTRY_FIELD_ENTRYID);
                originIds.add(id);
                originIndex[j] = index;
            }
            ArrayList<Long> currentIds = new ArrayList<Long>(0);
            ArrayList<Integer> currentNotZeroIndexs = new ArrayList<Integer>(0);
            Boolean isStore = Boolean.FALSE;
            for (int i = 0; i < fields.size(); ++i) {
                DynamicObject field = (DynamicObject)fields.get(i);
                Long id = field.getLong(CONTROL_ENTRY_FIELD_ENTRYID);
                currentIds.add(id);
                Long fieldIndex = field.getLong(CONTROL_ENTRY_FIELD_INDEX);
                int index = fieldIndex.intValue();
                if (index != 0) {
                    currentNotZeroIndexs.add(index);
                }
                if (index != 0) continue;
                isStore = Boolean.TRUE;
            }
            if (isStore.booleanValue()) {
                Integer[] originNotZeros = currentNotZeroIndexs.toArray(new Integer[0]);
                Integer[] missIndex = this.getMissIndex(originNotZeros, currentSize);
                int seqIndex = 0;
                for (int j = 0; j < fields.size(); ++j) {
                    DynamicObject field = (DynamicObject)fields.get(j);
                    Long fieldIndex = field.getLong(CONTROL_ENTRY_FIELD_INDEX);
                    int index = fieldIndex.intValue();
                    if (index != 0) continue;
                    field.set(CONTROL_ENTRY_FIELD_INDEX, (Object)missIndex[seqIndex]);
                    ++seqIndex;
                }
            }
            this.updateDeleteOrAddFieldCache(originIds, currentIds);
        }
    }

    private void updateDeleteOrAddFieldCache(List<Long> originIds, List<Long> currentIds) {
        List addFields = ListUtil.diff(currentIds, originIds);
        logger.info("\u77e5\u8bc6\u5e93\u521b\u5efa\uff0c\u65b0\u589e\u7684\u5b57\u6bb5ID\uff1a{}", (Object)JSONObject.toJSONString((Object)addFields));
        this.getPageCache().put(REPO_ADD_FIELDS_LIST_CACHE_KEY, JSONObject.toJSONString((Object)addFields));
        List deleteFields = ListUtil.diff(originIds, currentIds);
        logger.info("\u77e5\u8bc6\u5e93\u521b\u5efa\uff0c\u5220\u9664\u7684\u5b57\u6bb5ID\uff1a{}", (Object)JSONObject.toJSONString((Object)deleteFields));
        this.getPageCache().put(REPO_DELETE_FIELDS_LIST_CACHE_KEY, JSONObject.toJSONString((Object)deleteFields));
    }

    private Integer[] getMissIndex(Integer[] originNotZeros, int currentSize) {
        List<Integer> list = this.getOriginIndex(originNotZeros);
        HashSet<Integer> clearList = new HashSet<Integer>(list);
        Arrays.sort((Object[])originNotZeros);
        int maxIndex = originNotZeros[originNotZeros.length - 1];
        if (currentSize > maxIndex) {
            int size = currentSize - maxIndex;
            for (int j = 0; j < size; ++j) {
                clearList.add(maxIndex + j + 1);
            }
        }
        Integer[] indexs = clearList.toArray(new Integer[0]);
        return indexs;
    }

    private List<Integer> getOriginIndex(Integer[] originNotZeros) {
        ArrayList<Integer> indexs = new ArrayList<Integer>(0);
        Arrays.sort((Object[])originNotZeros);
        int max = originNotZeros[originNotZeros.length - 1];
        logger.info("\u6700\u5927\u7d22\u5f15\uff1a{}\uff0c\u6e90\u957f\u5ea6\uff1a{}", (Object)max, (Object)originNotZeros.length);
        if (max > originNotZeros.length) {
            int[] zeros = new int[max];
            for (int k = 0; k < originNotZeros.length; ++k) {
                int indexValue;
                zeros[indexValue - 1] = indexValue = originNotZeros[k].intValue();
            }
            for (int i = 0; i < zeros.length; ++i) {
                int value = zeros[i];
                if (value != 0) continue;
                int addIndex = i + 1;
                indexs.add(addIndex);
            }
        } else if (max == originNotZeros.length) {
            logger.info("\u6700\u5927\u7d22\u5f15\uff1a{}\uff0c\u6e90\u957f\u5ea6\uff1a{}", (Object)max, (Object)originNotZeros.length);
        } else {
            logger.info("\u6700\u5927\u7d22\u5f15\uff1a{}\uff0c\u6e90\u957f\u5ea6\uff1a{}", (Object)max, (Object)originNotZeros.length);
        }
        return indexs;
    }

    private boolean repoHasData(String repoType, Object structRepoId) {
        Boolean flag = Boolean.FALSE;
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)repoType, (CharSequence)RepoConstant.RepoType.LEVEL.getType())) {
            QFilter filter = new QFilter("structrepo", "=", structRepoId);
            DynamicObject levelRepoData = BusinessDataServiceHelper.loadSingle((String)"gai_repo_treedata", (QFilter[])new QFilter[]{filter});
            return levelRepoData == null ? Boolean.FALSE : Boolean.TRUE;
        }
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)repoType, (CharSequence)RepoConstant.RepoType.TABLE.getType())) {
            QFilter filter = new QFilter("structrepo", "=", structRepoId);
            DynamicObject tableRepoData = BusinessDataServiceHelper.loadSingle((String)"gai_table_repo", (QFilter[])new QFilter[]{filter});
            return tableRepoData == null ? Boolean.FALSE : Boolean.TRUE;
        }
        return flag;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }
}

