/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.repo;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.repo.constant.RepoConstant;
import kd.ai.gai.core.repo.entity.StructRepoField;
import kd.ai.gai.core.repo.helper.GaiStructRepoHelper;
import kd.ai.gai.plugin.repo.StructRepoUtil;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class GaiStructRepoTreeDataBatchEditPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(GaiStructRepoTreeDataBatchEditPlugin.class);
    private static final String KEY_ENTRY_TREE_DATAS = "entry_treedatas";
    private boolean isSetValueInPropertyChanged;

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadData();
    }

    private void loadData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        long parentId = Long.parseLong(formShowParameter.getCustomParam("parentId").toString());
        this.getModel().setValue("parentid", (Object)parentId);
        OperationStatus operationStatus = formShowParameter.getStatus();
        if (operationStatus.equals((Object)OperationStatus.EDIT)) {
            List dataIds = (List)formShowParameter.getCustomParam("dataIds");
            Map datas = BusinessDataServiceHelper.loadFromCache((Object[])dataIds.toArray(), (String)"gai_repo_treedata");
            long pkStructRepo = (Long)this.getView().getFormShowParameter().getCustomParam("StructRepoID");
            List fieldDefinitionList = GaiStructRepoHelper.queryStructRepoFields((long)pkStructRepo);
            this.getModel().batchCreateNewEntryRow(KEY_ENTRY_TREE_DATAS, datas.size());
            EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRY_TREE_DATAS);
            DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_ENTRY_TREE_DATAS);
            rows.clear();
            for (Map.Entry entry : datas.entrySet()) {
                DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
                row.set("dataid", entry.getKey());
                row.set("number", (Object)((DynamicObject)entry.getValue()).getString("number"));
                row.set("name", (Object)((DynamicObject)entry.getValue()).getString("name"));
                fieldDefinitionList.forEach(field -> {
                    row.set(field.getFieldName(), (Object)((DynamicObject)entry.getValue()).getString(field.getFieldName()));
                    row.set(field.getFieldName() + "_tag", (Object)((DynamicObject)entry.getValue()).getString(field.getFieldName() + "_tag"));
                });
                rows.add((Object)row);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initEntryGrid();
        this.initCreateOrg();
    }

    private void initEntryGrid() {
        long pkStructRepo = (Long)this.getView().getFormShowParameter().getCustomParam("StructRepoID");
        List fieldDefinitionList = GaiStructRepoHelper.queryStructRepoFields((long)pkStructRepo);
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRY_TREE_DATAS);
        List<String> hideFieldKeys = StructRepoUtil.getDataFieldKeys();
        fieldDefinitionList.forEach(field -> {
            entryGrid.setColumnProperty(field.getFieldName(), "header", (Object)new LocaleString(field.getName()));
            hideFieldKeys.remove(field.getFieldName());
        });
        this.getView().setVisible(Boolean.FALSE, hideFieldKeys.toArray(new String[0]));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (operateKey.equals("batchsave")) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            List dataIds = (List)formShowParameter.getCustomParam("dataIds");
            DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_ENTRY_TREE_DATAS);
            rows.forEach(row -> {
                long pkDataId = row.getLong("dataid");
                if (pkDataId > 0L) {
                    dataIds.add(pkDataId);
                }
            });
            long pkStructRepo = (Long)this.getView().getFormShowParameter().getCustomParam("StructRepoID");
            List fieldDefinitionList = GaiStructRepoHelper.queryStructRepoFields((long)pkStructRepo);
            DynamicObject dObjStructRepo = BusinessDataServiceHelper.loadSingle((Object)pkStructRepo, (String)"gai_struct_repo");
            DynamicObject dObjCreateOrg = this.getCreateOrg();
            Map mapDatas = BusinessDataServiceHelper.loadFromCache((Object[])dataIds.toArray(), (String)"gai_repo_treedata");
            rows.forEach(row -> {
                DynamicObject repoOldData = (DynamicObject)mapDatas.get(row.getLong("dataid"));
                if (repoOldData == null) {
                    repoOldData = BusinessDataServiceHelper.newDynamicObject((String)"gai_repo_treedata");
                    long pkNewRepoDataId = DB.genLongId((String)"gai_repo_treedata");
                    repoOldData.set("id", (Object)pkNewRepoDataId);
                    Object parent = this.getModel().getValue("parentid");
                    repoOldData.set("parent", parent);
                    if (parent == null) {
                        repoOldData.set("level", (Object)1);
                    }
                    repoOldData.set("structrepo", (Object)dObjStructRepo);
                    repoOldData.set("datastatus", (Object)RepoConstant.RepoDataStatus.NONE.getStatus());
                    repoOldData.set("creator", (Object)RequestContext.get().getCurrUserId());
                    repoOldData.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    repoOldData.set("status", (Object)BillStatus.C);
                    repoOldData.set("enable", (Object)EnableEnum.YES.getKey());
                    repoOldData.set("createorg", (Object)dObjCreateOrg);
                    repoOldData.set("org", (Object)dObjCreateOrg);
                    repoOldData.set("useorg", (Object)dObjCreateOrg);
                    mapDatas.put(pkNewRepoDataId, repoOldData);
                    row.set("dataid", (Object)pkNewRepoDataId);
                }
                DynamicObject repoData = repoOldData;
                String name = row.getString(((StructRepoField)fieldDefinitionList.get(0)).getFieldName());
                name = name.length() > 50 ? name.substring(0, 50) : name;
                repoData.set("name", (Object)name);
                fieldDefinitionList.forEach(field -> {
                    repoData.set(field.getFieldName(), (Object)row.getString(field.getFieldName()));
                    String tagValue = row.getString(field.getFieldName() + "_tag");
                    if (StringUtils.isEmpty((CharSequence)tagValue) || StringUtils.isBlank((CharSequence)tagValue)) {
                        tagValue = row.getString(field.getFieldName());
                    }
                    repoData.set(field.getFieldName() + "_tag", (Object)tagValue);
                });
            });
            OperationResult operationResult = SaveServiceHelper.saveOperate((String)"gai_repo_treedata", (DynamicObject[])mapDatas.values().toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (operationResult.isSuccess()) {
                this.getView().setStatus(OperationStatus.EDIT);
                this.getView().showSuccessNotification("\u4fdd\u5b58\u6210\u529f");
                String message = operationResult.getMessage();
                if (StringUtils.isNotEmpty((CharSequence)message) && operationResult.isShowMessage()) {
                    this.getView().showErrorNotification(message);
                }
            } else {
                this.getView().showErrorNotification(this.getOperationResultMessage(operationResult));
            }
        }
    }

    public String getOperationResultMessage(OperationResult opResult) {
        StringBuilder sbMessage = new StringBuilder();
        sbMessage.append(opResult.getMessage());
        List operateInfos = opResult.getAllErrorOrValidateInfo();
        for (IOperateInfo info : operateInfos) {
            sbMessage.append('\n');
            sbMessage.append(info.getMessage());
        }
        return sbMessage.toString();
    }

    private void initCreateOrg() {
        long createOrg = 0L;
        DynamicObject objParent = this.getModel().getDataEntity().getDynamicObject("parentid");
        if (objParent != null) {
            DynamicObject dObjParent = BusinessDataServiceHelper.loadSingle((Object)objParent.getPkValue(), (String)"gai_repo_treedata");
            if (dObjParent != null) {
                createOrg = dObjParent.getDynamicObject("createorg").getLong("id");
            }
            logger.info(String.format("\u4ece\u4e0a\u7ea7\u4e2d\u83b7\u53d6\u5230\u521b\u5efa\u7ec4\u7ec7=%s", createOrg));
        } else {
            String parentPageId = this.getView().getFormShowParameter().getParentPageId();
            if (StringUtils.isNotBlank((CharSequence)parentPageId)) {
                IPageCache pageCache = SessionManager.getCurrent().getPageCache(parentPageId);
                String createOrgCache = pageCache.get("createOrg");
                if (StringUtils.isNotEmpty((CharSequence)createOrgCache)) {
                    createOrg = Long.parseLong(createOrgCache);
                }
                logger.info(String.format("\u4ece\u7236\u9875\u9762\u7f13\u5b58\u4e2d\u83b7\u53d6\u5230\u7ec4\u7ec7=%s", createOrg));
            }
            if (createOrg <= 0L) {
                createOrg = RequestContext.getOrCreate().getOrgId();
                logger.info(String.format("\u4ece\u4e0a\u4e0b\u6587\u4e2d\u83b7\u53d6\u5230\u7ec4\u7ec7=%s", createOrg));
            }
        }
        this.getPageCache().put("createorg", String.valueOf(createOrg));
    }

    private DynamicObject getCreateOrg() {
        long createOrgId = 0L;
        String createOrg = this.getPageCache().get("createorg");
        if (StringUtils.isNotEmpty((CharSequence)createOrg)) {
            createOrgId = Long.parseLong(createOrg);
            logger.info(String.format("\u4ece\u9875\u9762\u7f13\u5b58\u83b7\u53d6\u5230\u7ec4\u7ec7=%s", createOrgId));
        }
        if (createOrgId <= 0L) {
            createOrgId = RequestContext.getOrCreate().getOrgId();
            logger.info(String.format("\u4ece\u4e0a\u4e0b\u6587\u4e2d\u83b7\u53d6\u5230\u7ec4\u7ec7=%s", createOrgId));
        }
        return BusinessDataServiceHelper.loadSingle((Object)createOrgId, (String)"bos_org");
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        ArrayList<Object> dataIds = new ArrayList<Object>();
        DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_ENTRY_TREE_DATAS);
        rows.forEach(row -> {
            long pkDataId = row.getLong("dataid");
            if (pkDataId > 0L) {
                dataIds.add(pkDataId);
            }
        });
        StructRepoUtil.batchReleaseDataMutex("gai_repo_treedata", "modify", dataIds);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData;
        String wordsValue;
        String propertyName = e.getProperty().getName();
        if (propertyName.startsWith("datafield") && !this.isSetValueInPropertyChanged && (wordsValue = (changeData = e.getChangeSet()[0]).getNewValue().toString()).length() > 5000) {
            this.getView().showTipNotification("\u6587\u672c\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc75000\u5b57\u7b26\uff0c\u5df2\u622a\u65ad\u3002");
            this.isSetValueInPropertyChanged = true;
            wordsValue = wordsValue.substring(0, 5000);
            this.getModel().setValue(propertyName, (Object)wordsValue);
            this.getView().updateView(propertyName);
        }
        this.isSetValueInPropertyChanged = false;
    }
}

