/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.repo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.repo.constant.RepoConstant;
import kd.ai.gai.core.repo.entity.StructRepoField;
import kd.ai.gai.plugin.impexp.StructRepoDataExportUtil;
import kd.ai.gai.plugin.repo.AbstractStructRepoDataTreeListPlugin;
import kd.ai.gai.plugin.repo.StructRepoTemplateUtil;
import kd.ai.gai.plugin.repo.StructRepoUtil;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeExportFileEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class GaiStructRepoTreeDataListPlugin
extends AbstractStructRepoDataTreeListPlugin
implements ICloseCallBack {
    private static final Log logger = LogFactory.getLog(GaiStructRepoTreeDataListPlugin.class);
    private static final String CLOSECALLBACK_BATCHEDIT = "closecallback_batchedit";
    private static final String CONFIRMCALLBACK_SHOW_BATCH_EDIT = "confirm_callback_showbatchedit";
    private static final String RES_TEMPLATE_PREFIX = "\u77e5\u8bc6\u6570\u636e\u5f15\u5165\u6a21\u677f_";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        this.getPageCache().put("CurOperateKey", operateKey);
        switch (operateKey) {
            case "batchedit": {
                this.batchEditValidate(args);
                break;
            }
            case "new": {
                args.setCancel(true);
                this.batchNew();
                break;
            }
            case "importdata": {
                JSONObject jsonExtendData = new JSONObject();
                jsonExtendData.put("StructRepoID", this.getStructRepoId());
                operate.getParameter().put("ExtendData", jsonExtendData.toJSONString());
            }
        }
    }

    private void batchNew() {
        long parentId = this.getCurrentNodeId();
        if (parentId > 0L && QueryServiceHelper.exists((String)"gai_repo_treedata", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)parentId), new QFilter("level", ">=", (Object)18)})) {
            this.getView().showTipNotification("\u5f53\u524d\u8282\u70b9\u7684\u7ea7\u6b21\u4e3a18\u7ea7\uff0c\u4e0d\u80fd\u518d\u65b0\u589e\u5b50\u7ea7\u3002");
        } else {
            this.showBatchEditForm(parentId, Collections.emptyList());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "batchedit": {
                this.batchEdit(args);
                break;
            }
            case "exporttemplate": {
                this.customDownloadImportTemplate();
            }
        }
    }

    public void beforeExportFile(BeforeExportFileEvent e) {
        String operateKey;
        super.beforeExportFile(e);
        if (e.getSource() instanceof ListView && StringUtils.isNotEmpty((CharSequence)(operateKey = ((ListView)e.getSource()).getPageCache().get("CurOperateKey"))) && operateKey.equals("exportlist")) {
            List<StructRepoField> repoFieldList = this.getStructRepoFields();
            Map mapHeader = ((ExportFileEvent)e).getCustomHeaderMap();
            repoFieldList.forEach(field -> {
                mapHeader.put(field.getFieldName(), field.getName());
                mapHeader.put(field.getFieldName() + "_tag", field.getName());
            });
        }
    }

    public void afterExportFile(ExportFileEvent e) {
        String operateKey;
        super.afterExportFile(e);
        if (e.getSource() instanceof ListView && StringUtils.isNotEmpty((CharSequence)(operateKey = ((ListView)e.getSource()).getPageCache().get("CurOperateKey"))) && operateKey.equals("exportlist")) {
            List<StructRepoField> structRepoFieldList = this.getStructRepoFields();
            File file = e.getFile();
            StructRepoDataExportUtil.exportFields(file, structRepoFieldList);
        }
    }

    private void customDownloadImportTemplate() {
        List<StructRepoField> repoFieldList = this.getStructRepoFields();
        LinkedHashMap<String, String> nameMap = new LinkedHashMap<String, String>(repoFieldList.size());
        nameMap.put("number", "\u7f16\u7801");
        nameMap.put("parent.number", "\u4e0a\u7ea7.\u7f16\u7801");
        nameMap.put("parent.name", "\u4e0a\u7ea7.\u540d\u79f0");
        repoFieldList.forEach(field -> nameMap.put(field.getFieldName(), field.getName()));
        try {
            String path = StructRepoTemplateUtil.createRepoDataImportTemplate(RepoConstant.RepoType.LEVEL, this.getStructRepoNumber(), nameMap);
            String downloadUrl = RequestContext.get().getClientFullContextPath() + "/attachment/download.do?path=" + path;
            this.getView().openUrl(downloadUrl);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        this.getView().invokeOperation("batchedit");
    }

    private void batchEdit(AfterDoOperationEventArgs args) {
        List pkIds;
        List<Object> successPkIds;
        if (!args.getOperationResult().isSuccess() && args.getOperationResult().getSuccessPkIds().isEmpty()) {
            return;
        }
        if (!args.getOperationResult().isSuccess()) {
            args.getOperationResult().setShowMessage(false);
        }
        FormOperate operate = (FormOperate)args.getSource();
        long parentId = this.getCurrentNodeId();
        Object paramParentId = operate.getParameter().get("parentId");
        if (paramParentId != null && StringUtils.isNotEmpty((CharSequence)paramParentId.toString())) {
            parentId = Long.parseLong(paramParentId.toString());
        }
        if ((successPkIds = StructRepoUtil.batchRequireDataMutex("gai_repo_treedata", "modify", pkIds = args.getOperationResult().getSuccessPkIds())).isEmpty()) {
            this.getView().showTipNotification("\u60a8\u9009\u62e9\u7684\u6240\u6709\u6570\u636e\u6b63\u5728\u88ab\u5176\u4ed6\u7528\u6237\u7f16\u8f91\u4e2d\u3002");
        } else if (successPkIds.size() == pkIds.size()) {
            this.showBatchEditForm(parentId, successPkIds);
        } else {
            this.getPageCache().put("batchedit_parentId", String.valueOf(parentId));
            this.getPageCache().put("batchedit_dataPkIds", JSON.toJSONString(successPkIds));
            String message = String.format("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u6709%s\u6761\u6b63\u5728\u88ab\u5176\u4ed6\u7528\u6237\u7f16\u8f91\uff0c\u60a8\u53ef\u7f16\u8f91%s\u6761\u6570\u636e\u3002\u662f\u5426\u7ee7\u7eed\uff1f", pkIds.size() - successPkIds.size(), successPkIds.size());
            this.getView().showConfirm(message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRMCALLBACK_SHOW_BATCH_EDIT, (IFormPlugin)this));
        }
    }

    private long getCurrentNodeId() {
        TreeNode rootNode = this.getTreeModel().getRoot();
        long parentId = 0L;
        Object curNodeId = this.getTreeModel().getCurrentNodeId();
        if (!rootNode.getId().equals(curNodeId)) {
            parentId = Long.parseLong(curNodeId.toString());
        }
        return parentId;
    }

    private void showBatchEditForm(long parentId, List<Object> dataPkIds) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("gai_repo_treedata_edit");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (dataPkIds.size() > 0) {
            parameter.setStatus(OperationStatus.EDIT);
        } else {
            parameter.setStatus(OperationStatus.ADDNEW);
        }
        parameter.setCustomParam("parentId", (Object)parentId);
        parameter.setCustomParam("dataIds", dataPkIds);
        parameter.setCustomParam("StructRepoID", this.getStructRepoId());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_BATCHEDIT));
        this.getView().showForm(parameter);
    }

    private void batchEditValidate(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        long pkParentPre = -1L;
        ListSelectedRowCollection selectedRows = args.getListSelectedData();
        ArrayList pkIds = new ArrayList(selectedRows.size());
        selectedRows.forEach(row -> pkIds.add(row.getPrimaryKeyValue()));
        DynamicObjectCollection treeDatas = QueryServiceHelper.query((String)"gai_repo_treedata", (String)"parent", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
        boolean bExistDiffLevel = false;
        for (DynamicObject dObjData : treeDatas) {
            if (pkParentPre < 0L) {
                pkParentPre = dObjData.getLong("parent");
                continue;
            }
            if (dObjData.getLong("parent") == pkParentPre) continue;
            bExistDiffLevel = true;
            break;
        }
        if (bExistDiffLevel) {
            args.setCancelMessage("\u8bf7\u53ea\u9009\u62e9\u540c\u4e00\u7ea7\u7684\u77e5\u8bc6\u6570\u636e\u3002");
            this.getView().showTipNotification("\u8bf7\u53ea\u9009\u62e9\u540c\u4e00\u7ea7\u7684\u77e5\u8bc6\u6570\u636e\u3002");
            args.setCancel(true);
        } else {
            operate.getParameter().put("parentId", pkParentPre);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals(CLOSECALLBACK_BATCHEDIT)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (event.getCallBackId().equals(CONFIRMCALLBACK_SHOW_BATCH_EDIT) && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            String strPkParent = this.getPageCache().get("batchedit_parentId");
            String jsonSuccessPkIds = this.getPageCache().get("batchedit_dataPkIds");
            if (StringUtils.isEmpty((CharSequence)strPkParent) || StringUtils.isEmpty((CharSequence)jsonSuccessPkIds)) {
                this.getView().showErrorNotification("\u6253\u5f00\u6279\u91cf\u7f16\u8f91\u754c\u9762\u5931\u8d25\uff0c\u65e0\u6cd5\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u5230\u5df2\u9009\u62e9\u7684\u6570\u636e\u3002");
            }
            long pkParent = Long.parseLong(strPkParent);
            List dataPkIds = (List)JSON.parseObject((String)jsonSuccessPkIds, (TypeReference)new TypeReference<List<Object>>(){}, (Feature[])new Feature[0]);
            this.showBatchEditForm(pkParent, dataPkIds);
        }
    }
}

