/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.repo;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.ai.gai.core.repo.constant.RepoConstant;
import kd.ai.gai.core.repo.entity.StructRepoField;
import kd.ai.gai.core.repo.helper.GaiStructRepoHelper;
import kd.ai.gai.plugin.repo.StructRepoUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class GaiStructTableRepoDataBatchEditPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(GaiStructTableRepoDataBatchEditPlugin.class);
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String CURRENT_REPO_ID_CACHE = "curren_repo_id";
    private static final String TOOL_BAR = "toolbarap";
    private static final String BTN_SAVE = "btnsave";
    private static final String CURRENT_SHOW_FIELDS_CACEH = "current_show_fields_cache";
    private static final String CURRENT_EDIT_MODEL = "current_edit_model";
    private static final String CONTROL_BTN_DELETE = "btndelete";
    private static final String CONTROL_BTN_ADD = "btnadd";
    private static final String CONTROL_FIELD_DATASTATUS = "datastatus";
    private static final String SHOW_COLUMN_CACHE = "show_column_cache";
    private boolean isSetValueInPropertyChanged;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOL_BAR});
        this.addClickListeners(new String[]{CONTROL_BTN_DELETE, CONTROL_BTN_ADD});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long repoId = (Long)formShowParameter.getCustomParam("StructRepoID");
        this.getPageCache().put(CURRENT_REPO_ID_CACHE, String.valueOf(repoId));
        this.initStructRepoDataFields(repoId);
        String model = (String)formShowParameter.getCustomParam("model");
        this.getPageCache().put(CURRENT_EDIT_MODEL, model);
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)model, (CharSequence)"edit")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_BTN_ADD, CONTROL_BTN_DELETE});
            String repoDataIdsList = (String)formShowParameter.getCustomParam("StructRepoDataIDS");
            List repoDataIdList = JSONObject.parseArray((String)repoDataIdsList, Long.class);
            this.showEditTableRepoData(repoDataIdList);
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)model, (CharSequence)"add")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_FIELD_DATASTATUS});
            this.getView().invokeOperation("newentry");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btnsave": {
                this.save();
            }
        }
    }

    private void showEditTableRepoData(List<Long> repoDataIdList) {
        if (repoDataIdList != null && !repoDataIdList.isEmpty()) {
            String showFiledCache = this.getPageCache().get(CURRENT_SHOW_FIELDS_CACEH);
            List dataFields = JSONObject.parseArray((String)showFiledCache, String.class);
            QFilter idFilter = new QFilter("id", "in", repoDataIdList);
            String properties = this.buildQueryProperties();
            DynamicObject[] data = BusinessDataServiceHelper.load((String)"gai_table_repo", (String)properties, (QFilter[])new QFilter[]{idFilter});
            if (data != null && data.length > 0) {
                DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRY_ENTITY);
                for (int i = 0; i < data.length; ++i) {
                    DynamicObject row = data[i];
                    DynamicObject rowData = collection.addNew();
                    for (String field : dataFields) {
                        String value = row.getString(String.format("%s_tag", field));
                        rowData.set(field, (Object)value);
                        rowData.set(String.format("%s_tag", field), (Object)value);
                    }
                    Object dataPk = row.getPkValue();
                    String dataStatus = row.getString(CONTROL_FIELD_DATASTATUS);
                    if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)dataStatus, (CharSequence)RepoConstant.RepoDataStatus.PROCESSING.getStatus())) {
                        this.setDisabledFields(i, dataFields);
                    }
                    rowData.set(CONTROL_FIELD_DATASTATUS, (Object)dataStatus);
                    rowData.set("dataid", dataPk);
                }
                this.getModel().updateEntryCache(collection);
                this.getView().updateView(ENTRY_ENTITY);
            }
        }
    }

    private void setDisabledFields(int row, List<String> dataFields) {
        for (String field : dataFields) {
            this.getView().setEnable(Boolean.FALSE, row, new String[]{field});
        }
    }

    private String buildQueryProperties() {
        String showFiledCache = this.getPageCache().get(CURRENT_SHOW_FIELDS_CACEH);
        List dataFields = JSONObject.parseArray((String)showFiledCache, String.class);
        ArrayList<String> fields = new ArrayList<String>(0);
        for (String field : dataFields) {
            fields.add(String.format("%s_tag", field));
        }
        fields.addAll(dataFields);
        fields.add("number");
        fields.add("name");
        fields.add(CONTROL_FIELD_DATASTATUS);
        fields.add("id");
        return org.apache.commons.lang3.StringUtils.join(fields, (String)",");
    }

    private void save() {
        String model = this.getPageCache().get(CURRENT_EDIT_MODEL);
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)model, (CharSequence)"edit")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_BTN_DELETE});
            this.editData();
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)model, (CharSequence)"add")) {
            this.newData();
            this.getPageCache().put(CURRENT_EDIT_MODEL, "edit");
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_BTN_DELETE, CONTROL_BTN_ADD});
    }

    private long getCreateOrgId() {
        IPageCache pageCache;
        String createOrgCache;
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        long createOrg = 0L;
        if (StringUtils.isNotBlank((CharSequence)parentPageId) && StringUtils.isNotEmpty((CharSequence)(createOrgCache = (pageCache = SessionManager.getCurrent().getPageCache(parentPageId)).get("createOrg")))) {
            createOrg = Long.parseLong(createOrgCache);
        }
        if (createOrg <= 0L) {
            createOrg = RequestContext.getOrCreate().getOrgId();
        }
        return createOrg;
    }

    private void editData() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        DynamicObject[] datas = entryGrid.getEntryData().getDataEntitys();
        if (datas != null && datas.length > 0) {
            OperationResult result;
            Object[] batchData;
            String repo = this.getPageCache().get(CURRENT_REPO_ID_CACHE);
            Long repoId = Long.parseLong(repo);
            String showFiledCache = this.getPageCache().get(CURRENT_SHOW_FIELDS_CACEH);
            List dataFields = JSONObject.parseArray((String)showFiledCache, String.class);
            ArrayList<DynamicObject> batchEditData = new ArrayList<DynamicObject>(0);
            HashMap<String, DynamicObject> indexAddData = new HashMap<String, DynamicObject>(0);
            long userId = UserServiceHelper.getCurrentUserId();
            long createOrgId = this.getCreateOrgId();
            DynamicObject dObjCreateOrg = BusinessDataServiceHelper.loadSingle((Object)createOrgId, (String)"bos_org");
            for (int i = 0; i < datas.length; ++i) {
                DynamicObject tableData;
                DynamicObject rowData = datas[i];
                String dataStatus = rowData.getString(CONTROL_FIELD_DATASTATUS);
                if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)dataStatus, (CharSequence)RepoConstant.RepoDataStatus.PROCESSING.getStatus())) continue;
                Long dataId = rowData.getLong("dataid");
                if (dataId == null || dataId == 0L) {
                    tableData = this.buildAddRowData(repoId, i, dataFields, userId, dObjCreateOrg);
                    indexAddData.put(String.format("row_%s", i), tableData);
                    continue;
                }
                tableData = this.buildModifyRowData(userId, dataId, i, dataFields);
                batchEditData.add(tableData);
            }
            boolean addSuccess = Boolean.TRUE;
            if (!indexAddData.isEmpty()) {
                List<DynamicObject> batchAddDataList = indexAddData.entrySet().stream().map(new Function<Map.Entry<String, DynamicObject>, DynamicObject>(){

                    @Override
                    public DynamicObject apply(Map.Entry<String, DynamicObject> stringDynamicObjectEntry) {
                        return stringDynamicObjectEntry.getValue();
                    }
                }).collect(Collectors.toList());
                batchData = batchAddDataList.toArray(new DynamicObject[0]);
                logger.info("\u6279\u91cf\u65b0\u589e\u8868\u683c\u77e5\u8bc6\u6570\u636e\uff1a{}", batchData);
                result = SaveServiceHelper.saveOperate((String)"save", (String)"gai_table_repo", (DynamicObject[])batchData, (OperateOption)OperateOption.create());
                logger.info("\u6279\u91cf\u65b0\u589e\u8868\u683c\u77e5\u8bc6\u6570\u636e\u64cd\u4f5c\u8fd4\u56de\uff1a{}", (Object)JSONObject.toJSONString((Object)result));
                if (result.isSuccess()) {
                    this.updateModifyAndAddDataId(indexAddData);
                } else {
                    logger.info("\u65b0\u589e\u5931\u8d25");
                    addSuccess = Boolean.FALSE;
                }
            }
            boolean modifySuccess = Boolean.TRUE;
            if (!batchEditData.isEmpty()) {
                batchData = batchEditData.toArray(new DynamicObject[0]);
                logger.info("\u6279\u91cf\u4fee\u6539\u8868\u683c\u77e5\u8bc6\u6570\u636e\uff1a{}", batchData);
                result = SaveServiceHelper.saveOperate((String)"save", (String)"gai_table_repo", (DynamicObject[])batchData, (OperateOption)OperateOption.create());
                logger.info("\u6279\u91cf\u4fee\u6539\u8868\u683c\u77e5\u8bc6\u6570\u636e\u64cd\u4f5c\u8fd4\u56de\uff1a{}", (Object)JSONObject.toJSONString((Object)result));
                if (!result.isSuccess()) {
                    logger.info("\u4fee\u6539\u5931\u8d25");
                    modifySuccess = Boolean.FALSE;
                }
            }
            if (modifySuccess && addSuccess) {
                this.getView().showSuccessNotification("\u4fdd\u5b58\u6210\u529f\u3002");
            } else {
                this.getView().showErrorNotification("\u4fdd\u5b58\u5931\u8d25\u3002");
            }
        }
    }

    private void updateModifyAndAddDataId(Map<String, DynamicObject> indexAddData) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRY_ENTITY);
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject row = (DynamicObject)collection.get(i);
            String rowKey = String.format("row_%s", i);
            if (!indexAddData.containsKey(rowKey)) continue;
            DynamicObject bd = indexAddData.get(rowKey);
            row.set("dataid", bd.getPkValue());
        }
        this.getModel().updateEntryCache(collection);
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void newData() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        DynamicObject[] datas = entryGrid.getEntryData().getDataEntitys();
        if (datas != null && datas.length > 0) {
            long createOrgId = this.getCreateOrgId();
            DynamicObject dObjCreateOrg = BusinessDataServiceHelper.loadSingle((Object)createOrgId, (String)"bos_org");
            String repo = this.getPageCache().get(CURRENT_REPO_ID_CACHE);
            Long repoId = Long.parseLong(repo);
            String showFiledCache = this.getPageCache().get(CURRENT_SHOW_FIELDS_CACEH);
            List dataFields = JSONObject.parseArray((String)showFiledCache, String.class);
            Object[] batchData = new DynamicObject[datas.length];
            long userId = UserServiceHelper.getCurrentUserId();
            for (int i = 0; i < datas.length; ++i) {
                DynamicObject tableData = this.buildAddRowData(repoId, i, dataFields, userId, dObjCreateOrg);
                batchData[i] = tableData;
            }
            logger.info("\u6279\u91cf\u4fdd\u5b58\u8868\u683c\u77e5\u8bc6\u6570\u636e\uff1a{}", batchData);
            OperationResult result = SaveServiceHelper.saveOperate((String)"save", (String)"gai_table_repo", (DynamicObject[])batchData, (OperateOption)OperateOption.create());
            logger.info("\u6279\u91cf\u4fdd\u5b58\u8868\u683c\u77e5\u8bc6\u6570\u636e\u64cd\u4f5c\u8fd4\u56de\uff1a{}", (Object)JSONObject.toJSONString((Object)result));
            if (result.isSuccess()) {
                this.updateRowDataId((DynamicObject[])batchData);
                this.getView().showSuccessNotification("\u4fdd\u5b58\u6210\u529f\u3002");
            }
        }
    }

    private DynamicObject buildModifyRowData(Long userId, Long dataId, int row, List<String> dataFields) {
        DynamicObject tableData = BusinessDataServiceHelper.loadSingle((Object)dataId, (String)"gai_table_repo");
        for (String fieldName : dataFields) {
            Object shortValue = this.getModel().getValue(fieldName, row);
            Object longValue = this.getModel().getValue(String.format("%s_tag", fieldName), row);
            tableData.set(fieldName, shortValue);
            tableData.set(String.format("%s_tag", fieldName), longValue);
        }
        tableData.set("modifier", (Object)userId);
        tableData.set("modifytime", (Object)new Date());
        tableData.set("operation", (Object)"modify");
        return tableData;
    }

    private DynamicObject buildAddRowData(Long repoId, int row, List<String> dataFields, long userId, DynamicObject dObjCreateOrg) {
        DynamicObject tableData = BusinessDataServiceHelper.newDynamicObject((String)"gai_table_repo");
        tableData.set("name", (Object)"\u77e5\u8bc6\u6570\u636e");
        tableData.set("structrepo", (Object)repoId);
        tableData.set(CONTROL_FIELD_DATASTATUS, (Object)RepoConstant.RepoDataStatus.NONE.getStatus());
        tableData.set("enable", (Object)"1");
        tableData.set("creator", (Object)userId);
        tableData.set("createorg", (Object)dObjCreateOrg);
        tableData.set("ctrlstrategy", (Object)5);
        tableData.set("operation", (Object)"add");
        for (String fieldName : dataFields) {
            Object shortValue = this.getModel().getValue(fieldName, row);
            Object longValue = this.getModel().getValue(String.format("%s_tag", fieldName), row);
            if (longValue == null || StringUtils.isBlank((CharSequence)longValue.toString())) {
                longValue = shortValue;
            }
            tableData.set(fieldName, shortValue);
            tableData.set(String.format("%s_tag", fieldName), longValue);
        }
        return tableData;
    }

    private void updateRowDataId(DynamicObject[] batchData) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRY_ENTITY);
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject row = (DynamicObject)collection.get(i);
            DynamicObject data = batchData[i];
            Object dataPk = data.getPkValue();
            row.set("dataid", dataPk);
        }
        this.getModel().updateEntryCache(collection);
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void initStructRepoDataFields(Long repoId) {
        Map<String, String> map;
        List fields = GaiStructRepoHelper.queryStructRepoFields((long)repoId);
        logger.info("fields:{}", (Object)JSONObject.toJSONString((Object)fields));
        final EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        List<String> hiddenFields = this.getHiddenColumns(fields);
        List<String> showFields = this.getShowColumns(fields);
        this.getPageCache().put(CURRENT_SHOW_FIELDS_CACEH, JSONObject.toJSONString(showFields));
        logger.info("\u9690\u85cf\u7684\u5217\uff1a{}", hiddenFields);
        if (hiddenFields != null && !hiddenFields.isEmpty()) {
            hiddenFields.stream().forEach(new Consumer<String>(){

                @Override
                public void accept(String field) {
                    entryGrid.setColumnProperty(field, "vi", (Object)false);
                }
            });
        }
        if ((map = this.getChangeColumns(fields)) != null && !map.isEmpty()) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String field = entry.getKey();
                String name = entry.getValue();
                entryGrid.setColumnProperty(field, "header", (Object)new LocaleString(name));
            }
        }
        logger.info("\u5217\u540d\u79f0\u5173\u7cfb\uff1a{}", (Object)JSONObject.toJSONString(map));
        this.getPageCache().put(SHOW_COLUMN_CACHE, JSONObject.toJSONString(map));
    }

    private List<String> getHiddenColumns(List<StructRepoField> fields) {
        int size = 20;
        ArrayList<String> fieldList = new ArrayList<String>(0);
        for (int i = 0; i < size; ++i) {
            int index = i + 1;
            if (index < 10) {
                fieldList.add(String.format("datafield0%s", index));
                continue;
            }
            fieldList.add(String.format("datafield%s", index));
        }
        if (fields != null && !fields.isEmpty()) {
            for (StructRepoField repo : fields) {
                String fieldName = repo.getFieldName();
                if (!fieldList.contains(fieldName)) continue;
                fieldList.remove(fieldName);
            }
            logger.info("\u9690\u85cf\u7684\u5217\u4e3a\uff1a{}", (Object)JSONObject.toJSONString(fieldList));
        }
        return fieldList;
    }

    private List<String> getShowColumns(List<StructRepoField> fields) {
        ArrayList<String> fieldList = new ArrayList<String>(0);
        if (fields != null && !fields.isEmpty()) {
            for (StructRepoField repo : fields) {
                String fieldName = repo.getFieldName();
                fieldList.add(fieldName);
            }
        }
        return fieldList;
    }

    private Map<String, String> getChangeColumns(List<StructRepoField> fields) {
        HashMap<String, String> map = new HashMap<String, String>(0);
        if (fields != null && !fields.isEmpty()) {
            for (StructRepoField repo : fields) {
                String columnName = repo.getFieldName();
                String name = repo.getName();
                map.put(columnName, name);
            }
        }
        return map;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        final ArrayList<Object> dataIds = new ArrayList<Object>();
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        DynamicObject[] rows = grid.getEntryData().getDataEntitys();
        Arrays.asList(rows).stream().forEach(new Consumer<DynamicObject>(){

            @Override
            public void accept(DynamicObject dynamicObject) {
                long pkDataId = dynamicObject.getLong("dataid");
                if (pkDataId > 0L) {
                    dataIds.add(pkDataId);
                }
            }
        });
        StructRepoUtil.batchReleaseDataMutex("gai_table_repo", "modify", dataIds);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData;
        String wordsValue;
        String propertyName = e.getProperty().getName();
        if (propertyName.startsWith("datafield") && !this.isSetValueInPropertyChanged && (wordsValue = (changeData = e.getChangeSet()[0]).getNewValue().toString()).length() > 5000) {
            this.getView().showTipNotification("\u6587\u672c\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc75000\u5b57\u7b26\uff0c\u5df2\u622a\u65ad\u3002");
            this.isSetValueInPropertyChanged = true;
            wordsValue = wordsValue.substring(0, 5000);
            this.getModel().setValue(propertyName, (Object)wordsValue);
            this.getView().updateView(propertyName);
        }
        this.isSetValueInPropertyChanged = false;
    }
}

