/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.repo;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.ai.gai.core.repo.entity.StructRepo;
import kd.ai.gai.core.repo.helper.GaiStructRepoHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;

public class GaiTableRepoDataImportEntityListPlugin
extends AbstractListPlugin {
    private static final String CURRENT_REPO_ID_CACHE = "curren_repo_id";
    private static final String CONFIRM_CALLBACK_BATCHIMPORTFROMBIZOBJECT = "confirm_callback_batchImportFromBizObject";
    private static final String CONFIRM_CALLBACK_BATCHIMPORTFROMBIZOBJECT_PKIDS = "confirm_callback_batchImportFromBizObject_pkIds";
    private static final String CLOSECALLBACK_IMPORT_SELECT_BIZOBJECTDATA = "CloseCallBack_ImportSelectBizObjectData";
    private static final String CLOSECALLBACK_IMPORT_TASK_BIZOBJECTDATA = "CloseCallBack_Import_Task_BizObjectData";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String strRepoId = this.getPageCache().get(CURRENT_REPO_ID_CACHE);
        Long repoId = Long.parseLong(strRepoId);
        StructRepo repo = GaiStructRepoHelper.queryStructRepo((long)repoId);
        if (kd.bos.util.StringUtils.isEmpty((String)repo.getSourceBizObjectNumber())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_importentitydata", "bar_schimport"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if (opKey.equals("importbyf7")) {
            this.showImportBizObjectForm();
        }
        if (opKey.equals("importbyfilter")) {
            this.showImportBizObjectByCustom();
        }
        if (opKey.equals("embeding")) {
            this.getView().invokeOperation("refresh");
        }
        if (opKey.equals("schimport")) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("gai_schimport");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("StructRepoID", this.getView().getFormShowParameter().getCustomParam("StructRepoID"));
            this.getView().showForm(showParameter);
        }
    }

    private void showImportBizObjectForm() {
        String strRepoId = this.getPageCache().get(CURRENT_REPO_ID_CACHE);
        Long repoId = Long.parseLong(strRepoId);
        StructRepo repo = GaiStructRepoHelper.queryStructRepo((long)repoId);
        if (StringUtils.isEmpty((CharSequence)repo.getSourceBizObjectNumber())) {
            this.getView().showTipNotification("\u5f53\u524d\u77e5\u8bc6\u5e93\u672a\u8bbe\u7f6e\u6765\u6e90\u4e1a\u52a1\u5bf9\u8c61\uff0c\u4e0d\u652f\u6301\u5bfc\u5165\u3002");
            return;
        }
        String bizObjectEntityNumber = repo.getSourceBizObjectNumber();
        String bizObjectEntityName = repo.getSourceBizObjectName().getLocaleValue();
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)bizObjectEntityNumber);
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setCaption(String.format("\u5bfc\u5165\u4e1a\u52a1\u6570\u636e\u3010%s\u3011", bizObjectEntityName));
        listShowParameter.setLookUp(true);
        listShowParameter.setBillFormId(bizObjectEntityNumber);
        listShowParameter.setFormId(formConfig.getF7ListFormId());
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("580");
        inlineStyleCss.setWidth("960");
        listShowParameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_IMPORT_SELECT_BIZOBJECTDATA));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showImportBizObjectByCustom() {
        String strRepoId = this.getPageCache().get(CURRENT_REPO_ID_CACHE);
        Long repoId = Long.parseLong(strRepoId);
        StructRepo repo = GaiStructRepoHelper.queryStructRepo((long)repoId);
        if (StringUtils.isEmpty((CharSequence)repo.getSourceBizObjectNumber())) {
            this.getView().showTipNotification("\u5f53\u524d\u77e5\u8bc6\u5e93\u672a\u8bbe\u7f6e\u6765\u6e90\u4e1a\u52a1\u5bf9\u8c61\uff0c\u4e0d\u652f\u6301\u5bfc\u5165\u3002");
            return;
        }
        String bizObjectEntityNumber = repo.getSourceBizObjectNumber();
        String bizObjectEntityName = repo.getSourceBizObjectName().getLocaleValue();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("gai_repo_import_entity");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("entityNumber", (Object)bizObjectEntityNumber);
        formShowParameter.setCustomParam("entityName", (Object)bizObjectEntityName);
        formShowParameter.setCustomParam("org", (Object)this.getPageCache().get("createOrg"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_IMPORT_SELECT_BIZOBJECTDATA));
        this.getView().showForm(formShowParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)callBackId, (CharSequence)CONFIRM_CALLBACK_BATCHIMPORTFROMBIZOBJECT)) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.importBizObjectDataByFilter();
            }
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)callBackId, (CharSequence)CONFIRM_CALLBACK_BATCHIMPORTFROMBIZOBJECT_PKIDS) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.importBizObjectDataByPkIds();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals(CLOSECALLBACK_IMPORT_SELECT_BIZOBJECTDATA)) {
            Map<String, Object> mapReturn;
            returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            if (returnData instanceof ListSelectedRowCollection) {
                mapReturn = this.returnSelectedRows((ListSelectedRowCollection)returnData);
                this.showConfirmImportPkIds(mapReturn);
            } else {
                mapReturn = (Map<String, Object>)returnData;
                if (mapReturn.containsKey("FilterStringList")) {
                    this.showConfirmImportFilter(mapReturn);
                }
            }
        }
        if (actionId.equals(CLOSECALLBACK_IMPORT_TASK_BIZOBJECTDATA)) {
            String str;
            this.getView().invokeOperation("refresh");
            returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            Map mapReturnData = (Map)returnData;
            if (mapReturnData.containsKey("taskinfo") && StringUtils.isNotEmpty((CharSequence)(str = (String)mapReturnData.get("taskinfo")))) {
                TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)str, TaskInfo.class);
                this.showImportBizObjectTaskResult(taskInfo);
            }
        }
    }

    private void showConfirmImportPkIds(Map<String, Object> mapReturn) {
        int selectedCount = Integer.parseInt(mapReturn.get("selectedCount").toString());
        if (selectedCount > 0) {
            for (Map.Entry<String, Object> entry : mapReturn.entrySet()) {
                this.getPageCache().put(entry.getKey(), entry.getValue().toString());
            }
            this.getView().showConfirm(String.format("\u60a8\u5171\u9009\u62e9\u4e86%s\u6761\u6570\u636e\uff0c\u662f\u5426\u786e\u8ba4\u5bfc\u5165\uff1f", selectedCount), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_CALLBACK_BATCHIMPORTFROMBIZOBJECT_PKIDS));
        } else {
            this.getView().showMessage("\u60a8\u6ca1\u6709\u9009\u62e9\u6570\u636e\uff0c\u65e0\u9700\u5bfc\u5165\u3002");
        }
    }

    private void showConfirmImportFilter(Map<String, Object> mapReturn) {
        String bizObjectfilterListString = mapReturn.get("FilterStringList").toString();
        int maxCount = Integer.parseInt(mapReturn.get("MaxCount").toString());
        if (maxCount > 0) {
            this.getPageCache().put("CacheKey_FilterStringList", bizObjectfilterListString);
            this.getView().showConfirm(String.format("\u67e5\u8be2\u5230%s\u6761\u6570\u636e\uff0c\u662f\u5426\u786e\u8ba4\u5bfc\u5165\uff1f", maxCount), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_CALLBACK_BATCHIMPORTFROMBIZOBJECT));
        } else {
            this.getView().showMessage("\u6839\u636e\u4f60\u8bbe\u7f6e\u7684\u67e5\u8be2\u6761\u4ef6\uff0c\u67e5\u8be2\u52300\u6761\u6570\u636e\uff0c\u65e0\u9700\u5bfc\u5165\u3002");
        }
    }

    private void showImportBizObjectTaskResult(TaskInfo taskInfo) {
        Map data = (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class);
        boolean bSuccess = data.getOrDefault("success", "false").equals("true");
        int dealCount = Integer.parseInt(data.getOrDefault("dealCount", "0").toString());
        int count = Integer.parseInt(data.getOrDefault("count", "0").toString());
        String error = data.getOrDefault("error", "").toString();
        if (bSuccess) {
            this.getView().showMessage(String.format("\u5bfc\u5165\u5b8c\u6210\u3002\u5171%s\u6761\u8bb0\u5f55\uff0c\u5bfc\u5165%s\u6761\u8bb0\u5f55\u3002", count, dealCount));
        } else {
            this.getView().showErrMessage(String.format("\u5bfc\u5165\u5931\u8d25\u3002\n%s", error), String.format("\u5931\u8d25\u8be6\u7ec6\u4fe1\u606f:\ntraceId:%s\n%s", taskInfo.getTraceId(), taskInfo.getFailureReason()));
        }
    }

    private void importBizObjectDataByFilter() {
        String bizObjectFilterString = this.getPageCache().get("CacheKey_FilterStringList");
        this.getPageCache().remove("CacheKey_FilterStringList");
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("bizObjectFilterString", bizObjectFilterString);
        this.createImportTaskJob(params);
    }

    private Map<String, Object> returnSelectedRows(ListSelectedRowCollection selectedRows) {
        HashMap<String, Object> mapReturnData = new HashMap<String, Object>(2);
        StringBuilder sbBatchKeys = new StringBuilder();
        StringBuilder sbPkIds = new StringBuilder();
        int batchCount = 10000;
        int allCount = selectedRows.size();
        int j = 1;
        for (int i = 0; i < allCount; ++i) {
            ListSelectedRow row = selectedRows.get(i);
            sbPkIds.append(row.getPrimaryKeyValue());
            sbPkIds.append(",");
            if ((i + 1) % batchCount != 0) continue;
            String batchKey = "batchKey" + j;
            sbBatchKeys.append(batchKey);
            sbBatchKeys.append(",");
            sbPkIds.deleteCharAt(sbPkIds.length() - 1);
            mapReturnData.put(batchKey, sbPkIds.toString());
            ++j;
            sbPkIds = new StringBuilder();
        }
        if (sbPkIds.length() > 0) {
            String batchKey = "batchKey" + j;
            sbBatchKeys.append(batchKey);
            sbBatchKeys.append(",");
            sbPkIds.deleteCharAt(sbPkIds.length() - 1);
            mapReturnData.put(batchKey, sbPkIds.toString());
        }
        sbBatchKeys.deleteCharAt(sbBatchKeys.length() - 1);
        mapReturnData.put("batchKeys", sbBatchKeys.toString());
        mapReturnData.put("selectedCount", selectedRows.size());
        return mapReturnData;
    }

    private void importBizObjectDataByPkIds() {
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        String batchKeysCache = this.getPageCache().get("batchKeys");
        String[] batchKeys = batchKeysCache.split(",");
        this.getPageCache().remove("batchKeys");
        params.put("batchKeys", batchKeysCache);
        params.put("selectedCount", this.getPageCache().get("selectedCount"));
        for (int i = 0; i < batchKeys.length; ++i) {
            String batchKey = batchKeys[i];
            params.put(batchKey, this.getPageCache().get(batchKey));
            this.getPageCache().remove(batchKey);
        }
        this.createImportTaskJob(params);
    }

    private void createImportTaskJob(Map<String, Object> params) {
        String strRepoId = this.getPageCache().get(CURRENT_REPO_ID_CACHE);
        Long repoId = Long.parseLong(strRepoId);
        StructRepo repo = GaiStructRepoHelper.queryStructRepo((long)repoId);
        String taskName = String.format("[\u6279\u91cf\u5bfc\u5165]\u8868\u683c\u77e5\u8bc6\u6570\u636e-%s", repo.getSourceBizObjectName().getLocaleValue());
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("gai");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(taskName);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.ai.gai.core.repo.exp.ImportTableRepoDataTask");
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByLang(RequestContext.get().getLang());
        params.put("StructRepoID", repoId);
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_IMPORT_TASK_BIZOBJECTDATA);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(taskName);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setParentPageId(this.getView().getPageId());
        jobFormInfo.setClickClassName("kd.ai.gai.core.repo.exp.ImportTableRepoDataTaskClick");
        jobFormInfo.setCloseCallBack(closeCallBack);
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }
}

