/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.repo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.ai.gai.core.repo.constant.RepoConstant;
import kd.ai.gai.core.repo.entity.StructRepo;
import kd.ai.gai.core.repo.entity.StructRepoField;
import kd.ai.gai.core.repo.helper.GaiStructRepoHelper;
import kd.ai.gai.core.search.helper.KnowledgeRepoServiceHelper;
import kd.ai.gai.core.search.param.knoData.DelKnoDataParam;
import kd.ai.gai.plugin.impexp.StructRepoDataExportUtil;
import kd.ai.gai.plugin.repo.StructRepoTemplateUtil;
import kd.ai.gai.plugin.repo.StructRepoUtil;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeExportFileEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class GaiTableRepoListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(GaiTableRepoListPlugin.class);
    private static final String INIT_HIDDEN_COLUMN_CACHE = "init_hidden_column_cache";
    private static final String SHOW_COLUMN_CACHE = "show_column_cache";
    private static final String CURRENT_REPO_ID_CACHE = "curren_repo_id";
    private static final String CURRENT_SHOW_FIELDS_CACEH = "current_show_fields_cache";
    private static final String DATA_DELETE_CONFIRM_ID = "DATA_DELETE_CONFIRM_ID";
    private static final String CURRENT_DELETE_SELECT_ROW_CACHE = "current_delete_selected_row_pks";
    private static final String CONFIRMCALLBACK_SHOW_BATCH_EDIT = "confirm_callback_showbatchedit";
    private static final String CURRENT_SHOW_FIELDS_SEQ_CACEH = "current_show_fields_seq_cache";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long repoId = (Long)formShowParameter.getCustomParam("StructRepoID");
        this.getPageCache().put(CURRENT_REPO_ID_CACHE, String.valueOf(repoId));
        List fields = GaiStructRepoHelper.queryStructRepoFields((long)repoId);
        List seqFieldNames = fields.stream().map(new Function<StructRepoField, String>(){

            @Override
            public String apply(StructRepoField structRepoField) {
                return structRepoField.getFieldName();
            }
        }).collect(Collectors.toList());
        this.getPageCache().put(CURRENT_SHOW_FIELDS_SEQ_CACEH, JSONObject.toJSONString(seqFieldNames));
        logger.info("fields:{}", (Object)JSONObject.toJSONString((Object)fields));
        List<String> list = this.getHiddenColumns(fields);
        List<String> showFields = this.getShowColumns(fields);
        this.getPageCache().put(CURRENT_SHOW_FIELDS_CACEH, JSONObject.toJSONString(showFields));
        this.getPageCache().put(INIT_HIDDEN_COLUMN_CACHE, JSONObject.toJSONString(list));
        Map<String, String> map = this.getChangeColumns(fields);
        this.getPageCache().put(SHOW_COLUMN_CACHE, JSONObject.toJSONString(map));
    }

    private String getShowColumnCache() {
        Long repoId = Long.parseLong(this.getPageCache().get(CURRENT_REPO_ID_CACHE));
        List fields = GaiStructRepoHelper.queryStructRepoFields((long)repoId);
        Map<String, String> map = this.getChangeColumns(fields);
        String json = JSONObject.toJSONString(map);
        this.getPageCache().put(SHOW_COLUMN_CACHE, json);
        return json;
    }

    private String getSeqFieldNameCache() {
        Long repoId = Long.parseLong(this.getPageCache().get(CURRENT_REPO_ID_CACHE));
        List fields = GaiStructRepoHelper.queryStructRepoFields((long)repoId);
        List seqFieldNames = fields.stream().map(new Function<StructRepoField, String>(){

            @Override
            public String apply(StructRepoField structRepoField) {
                return structRepoField.getFieldName();
            }
        }).collect(Collectors.toList());
        String json = JSONObject.toJSONString(seqFieldNames);
        this.getPageCache().put(CURRENT_SHOW_FIELDS_SEQ_CACEH, json);
        return json;
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        String fieldName;
        super.beforeCreateListColumns(args);
        String namesStr = this.getShowColumnCache();
        Map nameMap = (Map)JSONObject.parseObject((String)namesStr, Map.class);
        String hiddenStr = this.getPageCache().get(INIT_HIDDEN_COLUMN_CACHE);
        List list = JSONObject.parseArray((String)hiddenStr, String.class);
        for (String field : list) {
            IListColumn column = args.getListColumn(field);
            args.getListColumns().remove(column);
        }
        HashMap<String, IListColumn> columnMap = new HashMap<String, IListColumn>(0);
        List originList = args.getListColumns();
        ArrayList<IListColumn> notDataFieldList = new ArrayList<IListColumn>(0);
        ArrayList<IListColumn> removeList = new ArrayList<IListColumn>(0);
        for (IListColumn iListColumn : originList) {
            fieldName = iListColumn.getListFieldKey();
            if (fieldName.startsWith("datafield") || fieldName.equalsIgnoreCase("number")) continue;
            notDataFieldList.add(iListColumn);
            removeList.add(iListColumn);
        }
        args.getListColumns().removeAll(removeList);
        for (Map.Entry entry : nameMap.entrySet()) {
            fieldName = (String)entry.getKey();
            String name = (String)entry.getValue();
            IListColumn column = args.getListColumn(fieldName);
            column.setCaption(new LocaleString(name));
            column.setFixed(true);
            columnMap.put(fieldName, column);
            args.getListColumns().remove(column);
        }
        String repo = this.getPageCache().get(CURRENT_REPO_ID_CACHE);
        Long l = Long.parseLong(repo);
        List fieldDefinitionList = GaiStructRepoHelper.queryStructRepoFields((long)l);
        ArrayList dataFieldList = new ArrayList(0);
        for (int i = 0; i < fieldDefinitionList.size(); ++i) {
            StructRepoField fieldDefinition = (StructRepoField)fieldDefinitionList.get(i);
            String fieldName2 = fieldDefinition.getFieldName();
            dataFieldList.add(columnMap.get(fieldName2));
        }
        args.getListColumns().addAll(dataFieldList);
        args.getListColumns().addAll(notDataFieldList);
    }

    private List<String> getHiddenColumns(List<StructRepoField> fields) {
        int size = 20;
        ArrayList<String> fieldList = new ArrayList<String>(0);
        for (int i = 0; i < size; ++i) {
            int index = i + 1;
            if (index < 10) {
                fieldList.add(String.format("datafield0%s", index));
                continue;
            }
            fieldList.add(String.format("datafield%s", index));
        }
        if (fields != null && !fields.isEmpty()) {
            for (StructRepoField repo : fields) {
                String fieldName = repo.getFieldName();
                if (!fieldList.contains(fieldName)) continue;
                fieldList.remove(fieldName);
            }
            logger.info("\u9690\u85cf\u7684\u5217\u4e3a\uff1a{}", (Object)JSONObject.toJSONString(fieldList));
        }
        return fieldList;
    }

    private List<String> getShowColumns(List<StructRepoField> fields) {
        ArrayList<String> fieldList = new ArrayList<String>(0);
        if (fields != null && !fields.isEmpty()) {
            for (StructRepoField repo : fields) {
                String fieldName = repo.getFieldName();
                fieldList.add(fieldName);
            }
        }
        return fieldList;
    }

    private Map<String, String> getChangeColumns(List<StructRepoField> fields) {
        HashMap<String, String> map = new HashMap<String, String>(0);
        if (fields != null && !fields.isEmpty()) {
            for (StructRepoField repo : fields) {
                String columnName = repo.getFieldName();
                String name = repo.getName();
                map.put(columnName, name);
            }
        }
        return map;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String operationKey = evt.getOperationKey();
        ArrayList<Long> dataIdList = new ArrayList<Long>(0);
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"modifydata")) {
            this.validateModifySelectedData(evt, dataIdList);
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"deletedata")) {
            if (!this.validateDeleteDataSelected(evt, dataIdList)) {
                return;
            }
            int size = dataIdList.size();
            logger.info("\u5f00\u59cb\u8fdb\u884c\u5220\u9664\u524d\u7684\u786e\u8ba4\u64cd\u4f5c\uff0c\u5171\u5220\u9664{}\u6761\u8868\u683c\u77e5\u8bc6\u6570\u636e", (Object)size);
            this.getPageCache().put(CURRENT_DELETE_SELECT_ROW_CACHE, JSONObject.toJSONString(dataIdList));
            ConfirmCallBackListener listener = new ConfirmCallBackListener(DATA_DELETE_CONFIRM_ID, (IFormPlugin)this);
            this.getView().showConfirm("\u5220\u9664\u9009\u4e2d\u7684" + size + "\u5f20\u5355\u636e\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\n\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", MessageBoxOptions.OKCancel, listener);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)DATA_DELETE_CONFIRM_ID, (CharSequence)callBackId)) {
            int value = messageBoxClosedEvent.getResult().getValue();
            if (value == MessageBoxResult.Yes.getValue()) {
                String pkJson = this.getPageCache().get(CURRENT_DELETE_SELECT_ROW_CACHE);
                List dataIdList = JSONObject.parseArray((String)pkJson, Long.class);
                logger.info("\u6279\u91cf\u5220\u9664\u8868\u683c\u77e5\u8bc6\u6570\u636e\u5220\u9664\uff0cdataIds\uff1a{}", (Object)dataIdList);
                if (dataIdList == null) return;
                if (dataIdList.isEmpty()) return;
                String repo = this.getPageCache().get(CURRENT_REPO_ID_CACHE);
                Long repoId = Long.parseLong(repo);
                List<Object> knoDataIds = dataIdList.stream().map(new Function<Long, Object>(){

                    @Override
                    public Object apply(Long aLong) {
                        return aLong;
                    }
                }).collect(Collectors.toList());
                DelKnoDataParam param = this.buildBatchDeleteTableDataParam(repoId, knoDataIds);
                logger.info("\u5f00\u59cb\u6279\u91cf\u5220\u9664\u8868\u683c\u77e5\u8bc6\u6570\u636e\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
                try {
                    KnowledgeRepoServiceHelper.getDataService().batchDelKnowledge(param);
                    logger.info("\u5b8c\u6210\u6279\u91cf\u5220\u9664\u8868\u683c\u77e5\u8bc6\u6570\u636e");
                    logger.info("\u5f00\u59cb\u6279\u91cf\u5220\u9664\u8868\u683c\u77e5\u8bc6\u8868\u5355\u6570\u636e");
                    DeleteServiceHelper helper = new DeleteServiceHelper();
                    OperateOption option = OperateOption.create();
                    OperationResult result = helper.deleteOperate("gai_table_repo", knoDataIds.toArray(), option);
                    if (result.isSuccess()) {
                        logger.info("\u6279\u91cf\u5220\u9664\u8868\u683c\u77e5\u8bc6\u8868\u5355\u6570\u636e\u6210\u529f");
                        this.getView().showSuccessNotification("\u5220\u9664\u6210\u529f\u3002", Integer.valueOf(3000));
                    } else {
                        logger.info("\u6279\u91cf\u5220\u9664\u8868\u683c\u77e5\u8bc6\u8868\u5355\u6570\u636e\u5931\u8d25 :{}", (Object)result.toString());
                        String errorMsg = this.parseErrorMsg(result.toString());
                        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)errorMsg)) {
                            this.getView().showErrorNotification(errorMsg);
                        } else {
                            this.getView().showErrorNotification("\u5220\u9664\u5931\u8d25\u3002");
                        }
                    }
                    BillList list = (BillList)this.getControl("billlistap");
                    list.refresh();
                    return;
                }
                catch (KDBizException e) {
                    logger.error("\u6279\u91cf\u5220\u9664\u8868\u683c\u77e5\u8bc6\u6570\u636e\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
                    this.getView().showErrorNotification("\u5220\u9664\u8868\u683c\u77e5\u8bc6\u6570\u636e\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f=" + e.getMessage());
                    return;
                }
            }
            if (value != MessageBoxResult.Cancel.getValue()) return;
            return;
        } else {
            if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)callBackId, (CharSequence)CONFIRMCALLBACK_SHOW_BATCH_EDIT)) return;
            String jsonSuccessPkIds = this.getPageCache().get("batchedit_dataPkIds");
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)jsonSuccessPkIds)) {
                this.getView().showErrorNotification("\u6253\u5f00\u6279\u91cf\u7f16\u8f91\u754c\u9762\u5931\u8d25\uff0c\u65e0\u6cd5\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u5230\u5df2\u9009\u62e9\u7684\u6570\u636e\u3002");
            }
            List dataPkIds = (List)JSON.parseObject((String)jsonSuccessPkIds, (TypeReference)new TypeReference<List<Object>>(){}, (Feature[])new Feature[0]);
            this.showBatchEditForm(dataPkIds);
        }
    }

    private String parseErrorMsg(String result) {
        JSONObject errorItem;
        JSONArray allErrorInfo;
        JSONObject item;
        String errorMsg = "";
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)result) && (item = JSONObject.parseObject((String)result)) != null && item.containsKey((Object)"allErrorInfo") && (allErrorInfo = item.getJSONArray("allErrorInfo")) != null && !allErrorInfo.isEmpty() && (errorItem = allErrorInfo.getJSONObject(0)) != null) {
            errorMsg = errorItem.getString("message");
        }
        return errorMsg;
    }

    private DelKnoDataParam buildBatchDeleteTableDataParam(Long repoId, List<Object> knoDataIds) {
        StructRepo repo = GaiStructRepoHelper.queryStructRepo((long)repoId);
        DelKnoDataParam param = new DelKnoDataParam();
        String repoNumber = repo.getRepoNumber();
        param.setSchemaNumber(repoNumber);
        param.setKnoDataIds(knoDataIds);
        return param;
    }

    private void validateModifySelectedData(BeforeItemClickEvent evt, List<Long> dataIdList) {
        if (!this.checkProcessStatus().booleanValue()) {
            return;
        }
        ListSelectedRowCollection collection = ((IListView)this.getView()).getSelectedRows();
        if (!collection.isEmpty()) {
            ArrayList<Object> pkIds = new ArrayList<Object>(collection.size());
            collection.forEach(row -> pkIds.add(row.getPrimaryKeyValue()));
            List<Object> successPkIds = StructRepoUtil.batchRequireDataMutex("gai_table_repo", "modify", pkIds);
            if (successPkIds.isEmpty()) {
                this.getView().showTipNotification("\u60a8\u9009\u62e9\u7684\u6240\u6709\u6570\u636e\u6b63\u5728\u88ab\u5176\u4ed6\u7528\u6237\u7f16\u8f91\u4e2d\u3002", Integer.valueOf(3000));
            } else if (successPkIds.size() == pkIds.size()) {
                this.showBatchEditForm(successPkIds);
            } else {
                this.getPageCache().put("batchedit_dataPkIds", JSON.toJSONString(successPkIds));
                String message = String.format("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u6709%s\u6761\u6b63\u5728\u88ab\u5176\u4ed6\u7528\u6237\u7f16\u8f91\uff0c\u60a8\u53ef\u7f16\u8f91%s\u6761\u6570\u636e\u3002\u662f\u5426\u7ee7\u7eed\uff1f", pkIds.size() - successPkIds.size(), successPkIds.size());
                this.getView().showConfirm(message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRMCALLBACK_SHOW_BATCH_EDIT, (IFormPlugin)this));
            }
        }
    }

    private Boolean checkProcessStatus() {
        Boolean pass = Boolean.TRUE;
        ListSelectedRowCollection collection = ((IListView)this.getView()).getSelectedRows();
        for (int i = 0; i < collection.size(); ++i) {
            String datastatus;
            ListSelectedRow row = collection.get(i);
            Object pk = row.getPrimaryKeyValue();
            DynamicObject repoData = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"gai_table_repo");
            if (repoData == null || !org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)(datastatus = repoData.getString("datastatus")), (CharSequence)RepoConstant.RepoDataStatus.PROCESSING.getStatus())) continue;
            this.getView().showTipNotification("\u5411\u91cf\u5316\u72b6\u6001\u4e3a\u5904\u7406\u4e2d\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u4fee\u6539\u3002");
            pass = Boolean.FALSE;
            break;
        }
        return pass;
    }

    private boolean validateDeleteDataSelected(BeforeItemClickEvent evt, List<Long> dataIdList) {
        Boolean success = Boolean.TRUE;
        ListSelectedRowCollection collection = ((IListView)this.getView()).getSelectedRows();
        if (!collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                ListSelectedRow row = collection.get(i);
                Object pk = row.getPrimaryKeyValue();
                DynamicObject repoData = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"gai_table_repo");
                if (repoData == null) continue;
                String datastatus = repoData.getString("datastatus");
                Long dataId = repoData.getLong("id");
                dataIdList.add(dataId);
                if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)datastatus, (CharSequence)RepoConstant.RepoDataStatus.PROCESSING.getStatus())) continue;
                this.getView().showTipNotification("\u5411\u91cf\u5316\u72b6\u6001\u4e3a\u5904\u7406\u4e2d\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\u3002");
                evt.setCancel(Boolean.TRUE.booleanValue());
                success = Boolean.FALSE;
                break;
            }
        } else {
            success = Boolean.FALSE;
        }
        return success;
    }

    private void showBatchAddForm() {
        String repo = this.getPageCache().get(CURRENT_REPO_ID_CACHE);
        Long repoId = Long.parseLong(repo);
        logger.info("\u7ef4\u62a4\u8868\u683c\u77e5\u8bc6\u5e93\u6570\u636e\u65b0\u589e\uff0c\u77e5\u8bc6\u5e93ID\uff1a{}", (Object)repoId);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("gai_table_repo_data");
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCustomParam("StructRepoID", (Object)repoId);
        showParameter.setCustomParam("model", (Object)"add");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batch_edit_data_callback"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("batch_edit_data_callback")) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }

    private void showBatchEditForm(List<Object> repoDataIds) {
        String repo = this.getPageCache().get(CURRENT_REPO_ID_CACHE);
        Long repoId = Long.parseLong(repo);
        logger.info("\u7ef4\u62a4\u8868\u683c\u77e5\u8bc6\u5e93\u6570\u636e\u4fee\u6539\uff0c\u77e5\u8bc6\u5e93ID\uff1a{}", (Object)repoId);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("gai_table_repo_data");
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setCustomParam("model", (Object)"edit");
        showParameter.setCustomParam("StructRepoID", (Object)repoId);
        showParameter.setCustomParam("StructRepoDataIDS", (Object)JSONObject.toJSONString(repoDataIds));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batch_edit_data_callback"));
        this.getView().showForm(showParameter);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String operationKey = evt.getOperationKey();
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"adddata")) {
            this.showBatchAddForm();
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"exporttemplate")) {
            this.downImportTemplate();
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"refresh")) {
            this.getShowColumnCache();
        }
    }

    private void downImportTemplate() {
        String str = this.getSeqFieldNameCache();
        List dataFields = JSONObject.parseArray((String)str, String.class);
        String namesStr = this.getShowColumnCache();
        Map nameMap = (Map)JSONObject.parseObject((String)namesStr, Map.class);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String repoNumber = (String)listShowParameter.getCustomParam("StructRepoNumber");
        try {
            String path = StructRepoTemplateUtil.createRepoTableDataImportTemplate(repoNumber, dataFields, nameMap);
            String downloadUrl = RequestContext.get().getClientFullContextPath() + "/attachment/download.do?path=" + path;
            this.getView().openUrl(downloadUrl);
        }
        catch (Exception e) {
            logger.error("\u5f15\u51fa\u6a21\u7248\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f={}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String repo = this.getPageCache().get(CURRENT_REPO_ID_CACHE);
        Long repoId = Long.parseLong(repo);
        QFilter filter = new QFilter("structrepo", "=", (Object)repoId);
        e.getQFilters().add(filter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String datastatus;
        super.billListHyperLinkClick(args);
        args.setCancel(Boolean.TRUE.booleanValue());
        BillListHyperLinkClickEvent linkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        Object repoDataId = linkClickEvent.getCurrentRow().getPrimaryKeyValue();
        DynamicObject repoData = BusinessDataServiceHelper.loadSingle((Object)repoDataId, (String)"gai_table_repo");
        if (repoData != null && org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)(datastatus = repoData.getString("datastatus")), (CharSequence)RepoConstant.RepoDataStatus.PROCESSING.getStatus())) {
            this.getView().showTipNotification("\u5411\u91cf\u5316\u72b6\u6001\u4e3a\u5904\u7406\u4e2d\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u4fee\u6539\u3002");
            return;
        }
        ArrayList<Object> pkDataIds = new ArrayList<Object>(0);
        pkDataIds.add(repoDataId);
        List<Object> successPkIds = StructRepoUtil.batchRequireDataMutex("gai_table_repo", "modify", pkDataIds);
        if (successPkIds.isEmpty()) {
            this.getView().showTipNotification("\u60a8\u9009\u62e9\u7684\u6240\u6709\u6570\u636e\u6b63\u5728\u88ab\u5176\u4ed6\u7528\u6237\u7f16\u8f91\u4e2d\u3002", Integer.valueOf(3000));
        } else if (successPkIds.size() == pkDataIds.size()) {
            this.showBatchEditForm(successPkIds);
        } else {
            this.getPageCache().put("batchedit_dataPkIds", JSON.toJSONString(successPkIds));
            String message = String.format("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u6709%s\u6761\u6b63\u5728\u88ab\u5176\u4ed6\u7528\u6237\u7f16\u8f91\uff0c\u60a8\u53ef\u7f16\u8f91%s\u6761\u6570\u636e\u3002\u662f\u5426\u7ee7\u7eed\uff1f", pkDataIds.size() - successPkIds.size(), successPkIds.size());
            this.getView().showConfirm(message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRMCALLBACK_SHOW_BATCH_EDIT, (IFormPlugin)this));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        this.getPageCache().put("CurOperateKey", operateKey);
    }

    public void beforeExportFile(BeforeExportFileEvent e) {
        String operateKey;
        super.beforeExportFile(e);
        if (e.getSource() instanceof ListView && StringUtils.isNotEmpty((CharSequence)(operateKey = ((ListView)e.getSource()).getPageCache().get("CurOperateKey"))) && operateKey.equals("exportlist")) {
            List<StructRepoField> repoFieldList = this.getStructRepoFields();
            Map mapHeader = ((ExportFileEvent)e).getCustomHeaderMap();
            repoFieldList.forEach(field -> {
                mapHeader.put(field.getFieldName(), field.getName());
                mapHeader.put(field.getFieldName() + "_tag", field.getName());
            });
        }
    }

    public void afterExportFile(ExportFileEvent e) {
        String operateKey;
        super.afterExportFile(e);
        if (e.getSource() instanceof ListView && StringUtils.isNotEmpty((CharSequence)(operateKey = ((ListView)e.getSource()).getPageCache().get("CurOperateKey"))) && operateKey.equals("exportlist")) {
            List<StructRepoField> structRepoFieldList = this.getStructRepoFields();
            File file = e.getFile();
            StructRepoDataExportUtil.exportFields(file, structRepoFieldList);
        }
    }

    private List<StructRepoField> getStructRepoFields() {
        String repo = this.getPageCache().get(CURRENT_REPO_ID_CACHE);
        Long repoId = Long.parseLong(repo);
        return GaiStructRepoHelper.queryStructRepoFields((long)repoId);
    }
}

