/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.repo;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.AfterSearchClickListener;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class RepoDataImortEntityDataPlugin
extends AbstractFormPlugin
implements FilterContainerInitListener,
AfterSearchClickListener {
    private static final Log logger = LogFactory.getLog(RepoDataImortEntityDataPlugin.class);
    private String billFormId;

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String billFormId = (String)e.getFormShowParameter().getCustomParam("entityNumber");
        ListShowParameter f7ViewParameter = this.getShowF7ViewParameter(billFormId);
        Map config = FormConfigFactory.createConfig((FormShowParameter)f7ViewParameter);
        if (config.get("cancel") != null) {
            e.setCancel(true);
            e.setCancelMessage((String)config.get("cancelMessage"));
        }
    }

    public void initialize() {
        super.initialize();
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
        String billFormName = (String)this.getView().getFormShowParameter().getCustomParam("entityName");
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        if (filterContainer != null) {
            filterContainer.setBillFormId(billFormId);
            filterContainer.setNeedShareScheme(false);
            filterContainer.setTitle(new LocaleString(billFormName));
            filterContainer.addFilterContainerInitListener((FilterContainerInitListener)this);
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setBillFormId(this.getBillFormId());
        billList.setEntityId(this.getBillFormId());
    }

    private String getBillFormId() {
        if (StringUtils.isEmpty((CharSequence)this.billFormId)) {
            this.billFormId = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
        }
        return this.billFormId;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.addAfterSearchClickListener((AfterSearchClickListener)this);
        Toolbar toolbar = (Toolbar)this.getControl("toolbarap");
        toolbar.addItemClickListener((ItemClickListener)this);
    }

    public void filterContainerInit(FilterContainerInitEvent filterContainerInitEvent) {
        List filterColumnList = filterContainerInitEvent.getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumnList) {
            if (!(filterColumn instanceof CommonBaseDataFilterColumn) || !filterColumn.getFieldName().contains("useorg")) continue;
            Object org = this.getView().getFormShowParameter().getCustomParam("org");
            filterColumn.setDefaultValue(org.toString());
        }
    }

    public void click(SearchClickEvent searchClickEvent) {
        List clientFilters = searchClickEvent.getFilterParameter().getQFilters();
        List fastFilters = searchClickEvent.getFastQFilters();
        this.setBillListFilters(clientFilters, fastFilters);
    }

    private FilterParameter getBillListClientQueryFilterParameter(List<QFilter> clientFilters) {
        ListIterator<QFilter> iterator = clientFilters.listIterator();
        QFilter baseDataFilter = null;
        while (iterator.hasNext()) {
            QFilter qFilter = (QFilter)iterator.next();
            if (!qFilter.getProperty().equals("useorg.id")) continue;
            iterator.remove();
            if (qFilter.getValue() == null) continue;
            baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)this.getBillFormId(), (Long)Long.parseLong(qFilter.getValue().toString()));
        }
        if (baseDataFilter != null) {
            clientFilters.add(baseDataFilter);
        }
        return new FilterParameter(clientFilters, null);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    private ListShowParameter getShowF7ViewParameter(String entityNumber) {
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)entityNumber);
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setCaption(String.format("\u5bfc\u5165\u4e1a\u52a1\u6570\u636e\u3010%s\u3011", formConfig.getCaption()));
        listShowParameter.setLookUp(true);
        listShowParameter.setBillFormId(entityNumber);
        listShowParameter.setFormId(formConfig.getF7ListFormId());
        listShowParameter.setShowTitle(false);
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.getOpenStyle().setTargetKey("flex_f7");
        listShowParameter.setMultiSelect(true);
        return listShowParameter;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        BillList billList = (BillList)this.getControl("billlistap");
        if (evt.getItemKey().equals("barselected")) {
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.isEmpty()) {
                this.getView().showTipNotification("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002");
                return;
            }
            this.getView().returnDataToParent((Object)selectedRows);
            this.getView().close();
        } else if (evt.getItemKey().equals("barfilter")) {
            List qFilterList = billList.generalFilterParameter().getQFilters();
            ArrayList qFilterStringList = new ArrayList(qFilterList.size());
            qFilterList.forEach(qFilter -> qFilterStringList.add(qFilter.toSerializedString()));
            int maxCount = ORM.create().count(String.format("AlgoKey_%s_%s", ((Object)((Object)this)).getClass().getName(), "getMaxCount"), this.getBillFormId(), qFilterList.toArray(new QFilter[0]));
            String cacheFilterString = JSON.toJSONString(qFilterStringList);
            HashMap<String, Object> mapReturn = new HashMap<String, Object>(2);
            mapReturn.put("FilterStringList", cacheFilterString);
            mapReturn.put("MaxCount", maxCount);
            this.getView().returnDataToParent(mapReturn);
            this.getView().close();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        List clientFilters = filterContainer.getContext().getClientQueryFilterParameter().getQFilters();
        List fastFilters = filterContainer.getContext().getFastQueryFilterParameter().getQFilters();
        this.setBillListFilters(clientFilters, fastFilters);
    }

    private void setBillListFilters(List<QFilter> clientFilters, List<QFilter> fastFilters) {
        BillList billList = (BillList)this.getControl("billlistap");
        FilterParameter filterParameter = this.getBillListClientQueryFilterParameter(clientFilters);
        billList.setClientQueryFilterParameter(filterParameter);
        billList.setQueryFilterParameter(new FilterParameter(fastFilters, null));
        billList.clearSelection();
        billList.refresh();
        this.getView().updateView("billlistap");
    }
}

