/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.repo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.repo.constant.RepoConstant;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class StructRepoTemplateUtil {
    public static String createRepoTableDataImportTemplate(String repoNumber, List<String> dataFields, Map<String, String> nameMap) throws Exception {
        LinkedHashMap<String, String> mapFieldName = new LinkedHashMap<String, String>(0);
        HashMap<String, CellStyle> mapFieldSytle = new HashMap<String, CellStyle>(0);
        mapFieldName.put("number", "\u7f16\u7801");
        mapFieldSytle.put("number", CellStyle.MustInput);
        for (String fieldKey : dataFields) {
            String fieldName = nameMap.get(fieldKey);
            mapFieldName.put(fieldKey, fieldName);
        }
        return StructRepoTemplateUtil.createRepoDataImportTemplate(RepoConstant.RepoType.TABLE, repoNumber, mapFieldName, mapFieldSytle);
    }

    public static String createRepoDataImportTemplate(RepoConstant.RepoType repoType, String repoNumber, Map<String, String> fieldNameMap) throws Exception {
        return StructRepoTemplateUtil.createRepoDataImportTemplate(repoType, repoNumber, fieldNameMap, new HashMap<String, CellStyle>(0));
    }

    public static String createRepoDataImportTemplate(RepoConstant.RepoType repoType, String repoNumber, Map<String, String> fieldNameMap, Map<String, CellStyle> fieldStyleMap) throws Exception {
        String entityNumber = "";
        String entityName = "";
        String repoName = "";
        switch (repoType) {
            case LEVEL: {
                entityNumber = "gai_repo_treedata";
                entityName = "\u5c42\u7ea7\u77e5\u8bc6\u6570\u636e";
                repoName = "\u5c42\u7ea7\u77e5\u8bc6\u5e93";
                break;
            }
            case TABLE: {
                entityNumber = "gai_table_repo";
                entityName = "\u8868\u683c\u77e5\u8bc6";
                repoName = "\u8868\u683c\u77e5\u8bc6\u5e93";
            }
        }
        if (fieldStyleMap == null) {
            fieldStyleMap = new HashMap<String, CellStyle>(0);
        }
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = StructRepoTemplateUtil.createSheet(workbook);
        XSSFRow headRow = sheet.createRow(0);
        StructRepoTemplateUtil.createHeader(workbook, sheet, headRow, entityName, entityNumber);
        XSSFRow fieldKeyRow = sheet.createRow(2);
        XSSFRow fieldNameRow = sheet.createRow(3);
        XSSFCellStyle fieldNameStyle = StructRepoTemplateUtil.getFieldNameStyle(workbook);
        XSSFCellStyle mustInputStyle = StructRepoTemplateUtil.getMustInputCellStyle(workbook);
        int index = 0;
        for (Map.Entry<String, String> entry : fieldNameMap.entrySet()) {
            String fieldKey = entry.getKey();
            String fieldName = entry.getValue();
            CellStyle cellStyle = fieldStyleMap.getOrDefault(fieldKey, CellStyle.FieldName);
            XSSFCellStyle xssfCellStyle = fieldNameStyle;
            if (cellStyle == CellStyle.MustInput) {
                xssfCellStyle = mustInputStyle;
            }
            if (fieldKey.startsWith("datafield")) {
                fieldKey = String.format("%s_tag", fieldKey);
            }
            StructRepoTemplateUtil.createCell(fieldKeyRow, index, fieldKey, null);
            StructRepoTemplateUtil.createCell(fieldNameRow, index, fieldName, xssfCellStyle);
            ++index;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = String.format("\u5f15\u5165\u6a21\u677f_%s[%s]_\u77e5\u8bc6\u6570\u636e\u5f15\u5165.xlsx", repoName, repoNumber);
        String pathName = "/struct/repo/" + fileName;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        workbook.write((OutputStream)outputStream);
        ByteArrayInputStream inputStream = StructRepoTemplateUtil.parse(outputStream);
        FileService fs = FileServiceFactory.getAttachmentFileService();
        String path = fs.upload(new FileItem(fileName, pathName, (InputStream)inputStream));
        return path;
    }

    public static ByteArrayInputStream parse(OutputStream out) throws Exception {
        ByteArrayOutputStream baos = (ByteArrayOutputStream)out;
        ByteArrayInputStream swapStream = new ByteArrayInputStream(baos.toByteArray());
        return swapStream;
    }

    private static XSSFSheet createSheet(XSSFWorkbook workbook) {
        XSSFSheet sheet = workbook.createSheet();
        sheet.setDefaultColumnWidth(30);
        return sheet;
    }

    private static XSSFCellStyle getFieldNameStyle(XSSFWorkbook workbook) {
        XSSFCellStyle style = workbook.createCellStyle();
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_40_PERCENT.getIndex());
        style.setWrapText(Boolean.TRUE.booleanValue());
        return style;
    }

    private static XSSFComment createComment(XSSFSheet sheet, String text) {
        XSSFDrawing p = sheet.createDrawingPatriarch();
        XSSFComment comment = p.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, 3, 3, 5, 6));
        comment.setString((RichTextString)new XSSFRichTextString(text));
        return comment;
    }

    private static XSSFCellStyle getMustInputCellStyle(XSSFWorkbook workbook) {
        XSSFCellStyle style = workbook.createCellStyle();
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_40_PERCENT.getIndex());
        XSSFFont font = workbook.createFont();
        font.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        style.setFont((Font)font);
        return style;
    }

    private static void createHeader(XSSFWorkbook workbook, XSSFSheet sheet, XSSFRow row, String entityName, String entityNumber) {
        XSSFCell seqCell = row.createCell(0);
        seqCell.setCellValue(String.format("%s # %s", entityName, entityNumber));
        XSSFRow secondRow = sheet.createRow(1);
        XSSFCellStyle style = workbook.createCellStyle();
        XSSFFont font = workbook.createFont();
        font.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        style.setFont((Font)font);
        style.setWrapText(Boolean.TRUE.booleanValue());
        XSSFCell tipCell = secondRow.createCell(0);
        String tips = "1\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002\n2\u3001\u7ea2\u8272\u5e26\u661f\u53f7\uff08*\uff09\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5\u3002\n3\u3001\u5982\u9700\u66f4\u65b0\u5df2\u6709\u6570\u636e\uff0c\u8bf7\u5148\u6309\u5f15\u5165\u6a21\u677f\u5f15\u51fa\u8be5\u6570\u636e\uff0c\u4fee\u6539\u540e\u518d\u6b21\u5f15\u5165\u3002\n#SetNULL\uff08\u542f\u7528\u5355\u5143\u683c\u8f93\u5165NULL\u6e05\u7a7a\u5b57\u6bb5\uff09";
        tipCell.setCellValue(tips);
        tipCell.setCellStyle((org.apache.poi.ss.usermodel.CellStyle)style);
    }

    private static void createCell(XSSFRow row, int index, String value, XSSFCellStyle cellStyle) {
        XSSFCell cell = row.createCell(index);
        cell.setCellValue(value);
        if (cellStyle != null) {
            cell.setCellStyle((org.apache.poi.ss.usermodel.CellStyle)cellStyle);
        }
    }

    public static enum CellStyle {
        MustInput,
        FieldName;

    }
}

