/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.repo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.plugin.repo.GaiStructRepoTreeDataListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;

public class StructRepoUtil {
    private static final Log logger = LogFactory.getLog(GaiStructRepoTreeDataListPlugin.class);

    public static List<String> getDataFieldKeys() {
        ArrayList<String> dataFieldKeys = new ArrayList<String>();
        for (int i = 1; i <= 20; ++i) {
            dataFieldKeys.add("datafield" + (i >= 10 ? Integer.valueOf(i) : "0" + i));
        }
        return dataFieldKeys;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Object> batchRequireDataMutex(String entityKey, String operationKey, List<Object> dataPkIds) {
        if (dataPkIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> successPkIds = new ArrayList<Object>(dataPkIds.size());
        Map<String, Boolean> mutexResult = new HashMap();
        String groupId = "default_netctrl";
        try (DataMutex dataMutex = DataMutex.create();){
            ArrayList mutexRequireList = new ArrayList(dataPkIds.size());
            dataPkIds.forEach(pkId -> {
                HashMap<String, Object> requireParam = new HashMap<String, Object>();
                requireParam.put("entityKey", entityKey);
                requireParam.put("dataObjId", pkId.toString());
                requireParam.put("groupId", groupId);
                requireParam.put("operationKey", operationKey);
                requireParam.put("isStrict", true);
                requireParam.put("callSource", "default");
                mutexRequireList.add(requireParam);
            });
            mutexResult = dataMutex.batchrequire(mutexRequireList);
            mutexResult.forEach((key, value) -> {
                if (value.booleanValue()) {
                    successPkIds.add(Long.parseLong(key));
                }
            });
            ArrayList<Object> arrayList = successPkIds;
            return arrayList;
        }
        catch (Exception ex) {
            logger.error("\u6279\u91cf\u7f16\u8f91 - \u83b7\u53d6\u7f51\u7edc\u63a7\u5236\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
            return successPkIds;
        }
    }

    public static void batchReleaseDataMutex(String entityKey, String operationKey, List<Object> dataPkIds) {
        try (DataMutex dataMutex = DataMutex.create();){
            String groupId = "default_netctrl";
            ArrayList mutexReleaseList = new ArrayList(dataPkIds.size());
            dataPkIds.forEach(pkId -> {
                HashMap<String, String> releaseParam = new HashMap<String, String>();
                releaseParam.put("dataObjId", pkId.toString());
                releaseParam.put("groupId", groupId);
                releaseParam.put("entityKey", entityKey);
                releaseParam.put("operationKey", operationKey);
                mutexReleaseList.add(releaseParam);
            });
            Map mutexResult = dataMutex.batchRelease(mutexReleaseList);
            ArrayList failReleasePkIds = new ArrayList(mutexResult.size());
            mutexResult.forEach((key, value) -> {
                if (!value.booleanValue()) {
                    failReleasePkIds.add(key);
                }
            });
            if (!failReleasePkIds.isEmpty()) {
                logger.info(String.format("\u8868\u5355[%s] \u6279\u91cf\u64cd\u4f5c[%s] - \u91ca\u653e\u7f51\u7edc\u63a7\u5236\u5b58\u5728\u5931\u8d25\u8bb0\u5f55\uff1a%s", entityKey, operationKey, failReleasePkIds));
            }
        }
        catch (Exception ex) {
            logger.error(String.format("\u8868\u5355[%s] \u6279\u91cf\u64cd\u4f5c[%s] - \u91ca\u653e\u7f51\u7edc\u63a7\u5236\u53d1\u751f\u5f02\u5e38", entityKey, operationKey), (Throwable)ex);
        }
    }
}

