/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.repo;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import kd.ai.gai.core.repo.entity.StructRepo;
import kd.ai.gai.core.repo.helper.GaiStructRepoHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.control.Control;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class TableRepoSchImportEntityDataPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(TableRepoSchImportEntityDataPlugin.class);
    private static final String KEY_BTN_OK = "btnok";
    private static final String KEY_BTN_REBUILD = "btnrebuild";
    private static final String KEY_JOB_NUMBER = "jobnumber";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        Object structRepoId = e.getFormShowParameter().getCustomParam("StructRepoID");
        if (structRepoId == null || (Long)structRepoId == 0L) {
            e.setCancel(true);
            e.setCancelMessage("\u7f3a\u5c11\u77e5\u8bc6\u5e93\u4fe1\u606f\u3002\u8bf7\u5728\u8868\u683c\u77e5\u8bc6\u6570\u636e\u5217\u8868\u754c\u9762\u6253\u5f00\u3002");
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object structRepoId = this.getView().getFormShowParameter().getCustomParam("StructRepoID");
        DynamicObject dObjSchJob = QueryServiceHelper.queryOne((String)"sch_job", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)structRepoId.toString())});
        if (dObjSchJob != null) {
            this.getView().getModel().setValue(KEY_JOB_NUMBER, dObjSchJob.get("number"));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_OK, KEY_BTN_REBUILD});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(KEY_BTN_OK)) {
            this.createJob(false);
        }
        if (key.equals(KEY_BTN_REBUILD)) {
            this.createJob(true);
        }
    }

    private boolean deleteOldJob(String jobId) {
        boolean deleteResult = false;
        boolean isStatic = false;
        try {
            Method method = ScheduleServiceHelper.class.getMethod("deleteJob", String.class);
            isStatic = Modifier.isStatic(method.getModifiers());
            deleteResult = isStatic ? ((Boolean)method.invoke(null, jobId)).booleanValue() : ((Boolean)method.invoke((Object)new ScheduleServiceHelper(), jobId)).booleanValue();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            logger.error(String.format("\u8c03\u7528[ScheduleServiceHelper]\u7684%s[deleteJob]\u5931\u8d25", isStatic ? "\u9759\u6001\u65b9\u6cd5" : "\u975e\u9759\u6001\u65b9\u6cd5"), (Throwable)ex);
        }
        return deleteResult;
    }

    private void createJob(boolean reCreate) {
        Object structRepoId = this.getView().getFormShowParameter().getCustomParam("StructRepoID");
        StructRepo structRepo = GaiStructRepoHelper.queryStructRepo((long)((Long)structRepoId));
        String jobName = String.format("\u540c\u6b65[%s]\u6570\u636e\u5230\u8868\u683c\u77e5\u8bc6\u5e93[%s]", structRepo.getSourceBizObjectNumber(), structRepo.getNumber());
        String jobNumber = String.format("repoScheduleJob-%s", System.currentTimeMillis());
        if (reCreate) {
            boolean bDeleted = this.deleteOldJob(structRepoId.toString());
            if (!bDeleted) {
                this.getView().showErrorNotification("\u91cd\u5efa\u5931\u8d25\u3002\u5220\u9664\u539f\u6709\u7684\u8c03\u5ea6\u4f5c\u4e1a\u5931\u8d25\u3002");
                return;
            }
            this.getView().getModel().setValue(KEY_JOB_NUMBER, (Object)"");
        }
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("gai");
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setId(structRepoId.toString());
        jobInfo.setName(jobName);
        jobInfo.setNumber(jobNumber);
        jobInfo.setTaskClassname("kd.ai.gai.core.repo.exp.SyncDataToTableRepoTask");
        jobInfo.setEnable(true);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByLang(RequestContext.get().getLang());
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("StructRepoID", structRepoId);
        params.put("bizObjectFilterString", JSON.toJSONString(Collections.emptyList()));
        jobInfo.setParams(params);
        String uploadJobId = ScheduleServiceHelper.createJob((JobInfo)jobInfo);
        this.getView().getModel().setValue(KEY_JOB_NUMBER, (Object)jobNumber);
        this.getView().showSuccessNotification(reCreate ? "\u91cd\u65b0\u521b\u5efa\u8c03\u5ea6\u4f5c\u4e1a\u6210\u529f" : "\u521b\u5efa\u8c03\u5ea6\u4f5c\u4e1a\u6210\u529f");
    }
}

