/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.search;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.Constant;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListColumn;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.mvc.list.ListDataProvider;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaiFieldChosePlugin
extends AbstractFormPlugin
implements CreateListColumnsListener,
BeforeBindDataListener {
    private static final Logger log = LoggerFactory.getLogger(GaiFieldChosePlugin.class);
    private static final String KEY_BTN_OK = "btnok";
    private static final String KEY_BILL_LIST = "billlistap";

    public void initialize() {
        super.initialize();
        Button button = (Button)this.getView().getControl(KEY_BTN_OK);
        button.addClickListener((ClickListener)this);
        BillList billList = (BillList)this.getControl(KEY_BILL_LIST);
        billList.addCreateListColumnsListener((CreateListColumnsListener)this);
        billList.addBeforeBindDataListener((BeforeBindDataListener)this);
    }

    public void createListColumns(BeforeCreateListColumnsArgs columnsArgs) {
        List columns = columnsArgs.getListColumns();
        ListColumn col0 = this.createListColumn("id", "id", 0);
        col0.setVisible(0);
        columns.add(col0);
        ListColumn col1 = this.createListColumn("repo_name", "\u5b57\u6bb5", 1);
        col1.setVisible(0);
        columns.add(col1);
        ListColumn col2 = this.createListColumn("number", "\u6807\u8bc6", 2);
        columns.add(col2);
        ListColumn col3 = this.createListColumn("name", "\u540d\u79f0", 3);
        columns.add(col3);
    }

    private ListColumn createListColumn(String key, String caption, int colIndex) {
        ListColumn col = new ListColumn();
        col.setCaption(new LocaleString(caption));
        col.setListFieldKey(key);
        col.setKey(key);
        col.setFieldName(key);
        col.setSeq(colIndex);
        col.setWidth(new LocaleString("8%"));
        return col;
    }

    public void beforeBindData(BeforeBindDataEvent beforeBindDataEvent) {
        BillList billList = (BillList)this.getControl(KEY_BILL_LIST);
        billList.addCreateListDataProviderListener(providerArgs -> providerArgs.setListDataProvider((IListDataProvider)new PropertyProvider()));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)KEY_BTN_OK, (CharSequence)source.getKey())) {
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u70b9\u51fb\u5b57\u6bb5\u9009\u62e9\u5f39\u6846\u786e\u5b9a\u6309\u94ae");
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl(KEY_BILL_LIST)).getSelectedRows();
            ArrayList rowMaps = Lists.newArrayListWithExpectedSize((int)selectedRows.size());
            for (ListSelectedRow selectedRow : selectedRows) {
                HashMap rowMap = Maps.newHashMapWithExpectedSize((int)2);
                rowMap.put("fieldKey", selectedRow.getNumber());
                rowMap.put("fieldName", selectedRow.getName());
                rowMap.put("fieldShowName", selectedRow.getName());
                rowMaps.add(rowMap);
            }
            this.getView().returnDataToParent((Object)rowMaps);
            this.getView().close();
        }
    }

    public class PropertyProvider
    extends ListDataProvider {
        public DynamicObjectCollection getData(int start, int limit) {
            Map customParams = GaiFieldChosePlugin.this.getView().getFormShowParameter().getCustomParams();
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u5b57\u6bb5\u9009\u62e9\u6a21\u6001\u6846\u6253\u5f00,\u63a5\u53d7\u5230\u53c2\u6570:[{}]", (Object)JSON.toJSONString((Object)customParams));
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)customParams.get("entity").toString());
            DataEntityPropertyCollection properties = mainType.getProperties();
            DynamicObjectCollection doCollection = new DynamicObjectCollection();
            for (IDataEntityProperty property : properties) {
                String displayNameStr;
                String alias = property.getAlias();
                String name = property.getName();
                LocaleString displayName = property.getDisplayName();
                String string = displayNameStr = ObjectUtils.isEmpty((Object)displayName) ? name : displayName.toString();
                if (property instanceof EntryProp) continue;
                if (property instanceof BasedataProp) {
                    DynamicObjectType entryDO = ((BasedataProp)property).getDynamicComplexPropertyType();
                    DataEntityPropertyCollection entryProperties = entryDO.getProperties();
                    for (IDataEntityProperty entryProperty : entryProperties) {
                        String entryDisplayNameStr;
                        String entryAlias = entryProperty.getAlias();
                        String entryName = entryProperty.getName();
                        LocaleString entryDisplayName = entryProperty.getDisplayName();
                        String string2 = entryDisplayNameStr = ObjectUtils.isEmpty((Object)entryDisplayName) ? entryName : entryDisplayName.toString();
                        if (StringUtils.isBlank((CharSequence)entryAlias)) continue;
                        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"gai_repo_schema");
                        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)entityType);
                        dynamicObject.set("id", (Object)RandomUtils.nextLong());
                        dynamicObject.set("repo_name", (Object)entryAlias);
                        dynamicObject.set("number", (Object)(name + "." + entryName));
                        dynamicObject.set("name", (Object)(displayNameStr + "." + entryDisplayNameStr));
                        doCollection.add((Object)dynamicObject);
                    }
                }
                if (StringUtils.isBlank((CharSequence)alias)) continue;
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"gai_repo_schema");
                DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)entityType);
                dynamicObject.set("id", (Object)RandomUtils.nextLong());
                dynamicObject.set("repo_name", (Object)alias);
                dynamicObject.set("number", (Object)name);
                dynamicObject.set("name", (Object)displayNameStr);
                doCollection.add((Object)dynamicObject);
            }
            this.getQueryResult().setCollection(doCollection);
            this.getQueryResult().setDataCount(doCollection.size());
            return doCollection;
        }
    }
}

