/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.search;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Map;
import kd.ai.gai.core.Constant;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaiStructDataImportPlugin
extends AbstractFormPlugin {
    private static final Logger log = LoggerFactory.getLogger(GaiStructDataImportPlugin.class);
    private static final String KEY_ADV_CON_BAR = "advcontoolbarap";
    private static final String KEY_SRC_BIZ_OBJ = "srcbizobject";
    private static final String KEY_ADD_FROM_OTHER = "add_from_other";
    private static final String AC_FIELD_CHOSE = "fieldChose";
    private static final String PAGE_ID_FIELD_CHOSE = "gai_field_chose";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_ADV_CON_BAR});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entryDoCollection = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryDoCollection.size(); ++i) {
            DynamicObject entryDO = (DynamicObject)entryDoCollection.get(i);
            if (!ObjectUtils.isNotEmpty((Object)entryDO.get("srcfieldkey"))) continue;
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_SRC_BIZ_OBJ});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equals((CharSequence)KEY_ADD_FROM_OTHER, (CharSequence)evt.getItemKey())) {
            this.showFieldChoseModal();
        }
    }

    private void showFieldChoseModal() {
        MainEntityType mainType;
        String appId;
        DynamicObject srcDO = (DynamicObject)this.getModel().getValue(KEY_SRC_BIZ_OBJ);
        if (ObjectUtils.isEmpty((Object)srcDO)) {
            this.getView().showErrorNotification("\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u6765\u6e90\u5bf9\u8c61");
            return;
        }
        String entityNum = srcDO.getString(0);
        RequestContext context = RequestContext.get();
        long userId = context.getCurrUserId();
        boolean hasPermission = PermissionServiceHelper.hasViewPermission((long)userId, (String)(appId = (mainType = EntityMetadataCache.getDataEntityType((String)entityNum)).getAppId()), (String)entityNum);
        if (!hasPermission) {
            log.info("\u6743\u9650\u9a8c\u8bc1\u4e0d\u901a\u8fc7,\u5f53\u524d\u7528\u6237:{},appId:{},entityNum:{}", new Object[]{userId, appId, entityNum});
            this.getView().showErrorNotification("\u5f53\u524d\u7528\u6237\u65e0\u8be5\u4e1a\u52a1\u5bf9\u8c61\u6743\u9650");
            return;
        }
        FormShowParameter showParam = new FormShowParameter();
        Map customParams = showParam.getCustomParams();
        customParams.put("appId", appId);
        customParams.put("entity", entityNum);
        log.info(Constant.RepoSchema.LOG_PREFIX + "\u5b57\u6bb5\u9009\u62e9\u6a21\u6001\u6846\u6253\u5f00,\u4f20\u5165\u53c2\u6570:[{}]", (Object)JSON.toJSONString((Object)customParams));
        showParam.setFormId(PAGE_ID_FIELD_CHOSE);
        showParam.setCaption("\u9009\u62e9\u5b57\u6bb5");
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, AC_FIELD_CHOSE));
        this.getView().showForm(showParam);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)AC_FIELD_CHOSE)) {
            Object returnData = evt.getReturnData();
            if (ObjectUtils.isEmpty((Object)returnData)) {
                log.info(Constant.RepoSchema.LOG_PREFIX + "\u5b57\u6bb5\u9009\u62e9\u6a21\u6001\u6846\u5173\u95ed,\u6ca1\u6709\u70b9\u51fb\u786e\u5b9a\u6309\u94ae\u5173\u95ed,\u4e0d\u505a\u5904\u7406");
                return;
            }
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u5b57\u6bb5\u9009\u62e9\u6a21\u6001\u6846\u5173\u95ed,\u5c06\u9009\u62e9\u7684\u5b57\u6bb5\u5199\u5165\u81ea\u5b9a\u4e49\u5b57\u6bb5\u5217\u8868");
            String resDataJsonStr = JSON.toJSONString((Object)returnData);
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u9009\u62e9\u7684\u5b57\u6bb5:[{}]", (Object)resDataJsonStr);
            JSONArray resDataJsonArr = JSON.parseArray((String)resDataJsonStr);
            for (int i = 0; i < resDataJsonArr.size(); ++i) {
                JSONObject resDataJsonObj = resDataJsonArr.getJSONObject(i);
                int rowIndex = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("srcfieldkey", (Object)resDataJsonObj.getString("fieldKey"), rowIndex);
                this.getModel().setValue("fieldname", (Object)resDataJsonObj.getString("fieldName"), rowIndex);
            }
            if (!resDataJsonArr.isEmpty()) {
                this.getView().setEnable(Boolean.FALSE, new String[]{KEY_SRC_BIZ_OBJ});
            }
        }
    }
}

