/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.search;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.EventObject;
import java.util.List;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public class RepoSchemaDataInitPlugin
extends AbstractFormPlugin {
    public static final String NUMBER_PREFIX = "repoSchema_";
    public static final String PURE_DATETIME_PATTERN = "yyMMddHHmmss";

    public void afterBindData(EventObject e) {
        Object numberValue = this.getModel().getValue("number");
        if (numberValue == null || StringUtils.isBlank((CharSequence)numberValue.toString())) {
            LocalDateTime curDateTime = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(PURE_DATETIME_PATTERN);
            String formattedStamp = formatter.format(curDateTime);
            String number = NUMBER_PREFIX + formattedStamp + RandomStringUtils.randomAlphanumeric((int)4);
            this.getModel().setValue("number", (Object)number);
        }
        List embeddingItems = GaiFieldTypeInitUtils.createEmbeddingComboItem();
        ComboEdit vectorModel = (ComboEdit)this.getView().getControl("vector_model");
        vectorModel.setComboItems(embeddingItems);
        Object modelValue = this.getModel().getValue("vector_model");
        if (modelValue == null || StringUtils.isBlank((CharSequence)modelValue.toString())) {
            this.getModel().setValue("vector_model", (Object)GaiFieldTypeInitUtils.getFirstEnableEmbedding());
        }
    }
}

