/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.session;

import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.agent.ChatSessionDTO;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.service.agent.ChatService;
import kd.ai.gai.core.util.ShowFormUtil;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class GaiSessionTabPlugin
extends AbstractFormPlugin
implements BeforeBindDataListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(GaiSessionTabPlugin.class);
    private final String SESSION_BILL_LIST = "sessionbilllist";
    private final String SESSION_FILTER_CONTROL = "sessionfiltercontainerap";
    private final String ITEM_CLICK_REFRESH = "sessionrefresh";
    private static final String ITEM_REFRESH = "refresh";
    private static final String KEY_ALGO_KEY = "kd.ai.gai.plugin.session.GaiSessionTabPlugin.queryDataSet";
    private static final String CONTROL_DATE_RANGE = "daterange";
    private static final String FILTER_CONDITION_CACHE = "filter_condition_cache";
    private static final String CONTROL_BTN_CLEAN = "barclear";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("sessionbilllist");
        billList.addBeforeBindDataListener((BeforeBindDataListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl("sessionbilllist");
        billList.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"sessiontoolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String keyName = evt.getItemKey();
        if (keyName.equals("sessionrefresh") || keyName.equals(ITEM_REFRESH)) {
            DateRangeEdit edit = (DateRangeEdit)this.getControl(CONTROL_DATE_RANGE);
            String startKey = edit.getStartDateFieldKey();
            String endKey = edit.getEndDateFieldKey();
            Date endDate = (Date)this.getModel().getValue(endKey);
            Date startDate = (Date)this.getModel().getValue(startKey);
            if (KDDateUtils.addDays((Date)startDate, (int)7).before(endDate)) {
                this.getView().showTipNotification("\u6700\u957f\u53ef\u67e5\u770b7\u5929\u5185\u7684\u8bb0\u5f55");
                return;
            }
            this.cacheQueryFilter();
            this.refreshBillList();
        } else if (keyName.equals(CONTROL_BTN_CLEAN)) {
            this.clearQueryCondition();
            this.refreshBillList();
        }
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl("sessionbilllist");
        this.getView().updateView(billList.getKey());
    }

    private void clearQueryCondition() {
        DateRangeEdit edit = (DateRangeEdit)this.getControl(CONTROL_DATE_RANGE);
        String startKey = edit.getStartDateFieldKey();
        String endKey = edit.getEndDateFieldKey();
        this.getModel().setValue(startKey, (Object)KDDateUtils.today());
        this.getModel().setValue(endKey, (Object)DateFormatUtils.format((Date)KDDateUtils.now(), (String)String.format("%s 23:59:59", "yyyy-MM-dd")));
        this.getModel().setValue("schatsessionid", null);
        this.cacheQueryFilter();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.clearQueryCondition();
    }

    private void cacheQueryFilter() {
        DateRangeEdit edit = (DateRangeEdit)this.getControl(CONTROL_DATE_RANGE);
        String startKey = edit.getStartDateFieldKey();
        String endKey = edit.getEndDateFieldKey();
        String start = DateFormatUtils.format((Date)((Date)this.getModel().getValue(startKey)), (String)"yyyy-MM-dd HH:mm:ss");
        String end = DateFormatUtils.format((Date)((Date)this.getModel().getValue(endKey)), (String)"yyyy-MM-dd HH:mm:ss");
        HashMap<String, String> filterCondition = new HashMap<String, String>();
        filterCondition.put("startTime", start);
        filterCondition.put("endTime", end);
        filterCondition.put("chatSessionId", (String)this.getModel().getValue("schatsessionid"));
        this.getPageCache().put(FILTER_CONDITION_CACHE, JSONObject.toJSONString(filterCondition));
    }

    public void beforeBindData(BeforeBindDataEvent beforeBindDataEvent) {
        super.beforeBindData((EventObject)beforeBindDataEvent);
        BillList billList = (BillList)this.getControl("sessionbilllist");
        billList.addCreateListDataProviderListener(new CreateListDataProviderListener(){

            public void createListDataProvider(BeforeCreateListDataProviderArgs args) {
                args.setListDataProvider((IListDataProvider)new BillListDataProvider());
            }
        });
    }

    private List<QFilter> buildQueryFilters() {
        String condition = this.getPageCache().get(FILTER_CONDITION_CACHE);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(0);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)condition)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Map cons = (Map)JSONObject.parseObject((String)condition, Map.class);
            for (Map.Entry entry : cons.entrySet()) {
                String queryKey = (String)entry.getKey();
                String queryValue = (String)entry.getValue();
                if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)queryKey, (CharSequence)"startTime")) {
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)queryValue)) continue;
                    Date startDate = null;
                    try {
                        startDate = sdf.parse(queryValue);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    if (startDate == null) continue;
                    QFilter start = new QFilter("createtime", ">=", (Object)startDate);
                    filters.add(start);
                    continue;
                }
                if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)queryKey, (CharSequence)"endTime")) {
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)queryValue)) continue;
                    Date endDate = null;
                    try {
                        endDate = sdf.parse(queryValue);
                    }
                    catch (ParseException start) {
                        // empty catch block
                    }
                    if (endDate == null) continue;
                    QFilter end = new QFilter("createtime", "<=", (Object)endDate);
                    filters.add(end);
                    continue;
                }
                if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)queryKey, (CharSequence)"chatSessionId") || !StringUtils.isNotEmpty((CharSequence)queryValue)) continue;
                QFilter chatSessionIdQFilter = new QFilter("chatsessionid", "=", (Object)queryValue);
                filters.add(chatSessionIdQFilter);
            }
        }
        return filters;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        BillList billList = (BillList)hyperLinkClickEvent.getSource();
        ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
        long pkId = (Long)selectedRow.getPrimaryKeyValue();
        DynamicObject rowData = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"gai_log");
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"sessionid") || StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"number")) {
            long sessionId = rowData.getLong("sessionid");
            String chatSessionId = rowData.getString("chatsessionid");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("gai_log_view");
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setCustomParam("id", (Object)sessionId);
            showParameter.setCustomParam("chatSessionId", (Object)chatSessionId);
            showParameter.setCustomParam("origin", (Object)"session");
            showParameter.setCaption(String.format("\u4f1a\u8bdd\u8be6\u60c5-%s", chatSessionId.substring(0, 8)));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("switchlist".equals(propertyName)) {
            String value = (String)e.getChangeSet()[0].getNewValue();
            if ("trace".equalsIgnoreCase(value)) {
                ShowFormUtil.showFormInCurrentForm((IFormView)this.getView(), (String)GaiFormIdEnum.GAI_TRACE_TAB.getId(), (String)"\u4f1a\u8bdd\u65e5\u5fd7");
            } else if ("session".equalsIgnoreCase(value)) {
                ShowFormUtil.showFormInCurrentForm((IFormView)this.getView(), (String)GaiFormIdEnum.GAI_SESSION_TAB.getId(), (String)"\u4f1a\u8bdd\u65e5\u5fd7");
            }
        }
    }

    public class BillListDataProvider
    extends ListDataProvider {
        public DynamicObjectCollection getData(int start, int limit) {
            List qFilters = super.getQFilters();
            List timeQFilter = GaiSessionTabPlugin.this.buildQueryFilters();
            qFilters.addAll(timeQFilter);
            QFilter dataQFilter = PermissionServiceHelper.getOperationRuleFilter((String)"gai", (String)"gai_log", (String)"view", (StringBuilder)new StringBuilder("\u65e0\u6743\u9650\u8bbf\u95ee"));
            HashMap<String, String> propMapper = new HashMap<String, String>();
            propMapper.put("traceinput", "creator.name");
            propMapper.put("tracetoken", "createorg.name");
            propMapper.put("number", "chatsessionid");
            int len = qFilters.size();
            for (int i = 0; i < len; ++i) {
                QFilter qFilter = (QFilter)qFilters.get(i);
                String fieldName = qFilter.getProperty();
                if (!propMapper.containsKey(fieldName)) continue;
                QFilter tmpFilter = new QFilter((String)propMapper.get(fieldName), qFilter.getCP(), qFilter.getValue());
                qFilters.set(i, tmpFilter);
            }
            if (dataQFilter != null) {
                qFilters.add(dataQFilter);
            }
            QFilter[] filters = qFilters.toArray(new QFilter[0]);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gai_log", (String)"sessionid, chatsessionid, cloudid, appid,createtime,createorg.name,creator.name,0 as tracenum,prompt,process ", (QFilter[])filters, null);
            String sql = "select sessionid, chatsessionid, cloudid, appid,createorg.name,creator.name,count(1) as tracenum,min(createtime) as createtime  group by sessionid, chatsessionid, cloudid, appid,createorg.name,creator.name";
            DataSet metricDataSet = dataSet.executeSql(sql).orderBy(new String[]{"createtime desc"});
            CacheHint hint = new CacheHint();
            hint.setTimeout(600000L);
            CachedDataSet cachedOriginDataSet = metricDataSet.cache(hint);
            Algo algo = Algo.create((String)GaiSessionTabPlugin.KEY_ALGO_KEY);
            int totalSize = cachedOriginDataSet.toDataSet(algo, false).count("sessionid", true);
            if (start > totalSize) {
                double pageHandle = totalSize / limit;
                int page = (int)Math.ceil(pageHandle);
                start = page * limit;
                BillList billList = (BillList)GaiSessionTabPlugin.this.getControl("sessionbilllist");
                billList.getEntryState().setCurrentPageIndex(Integer.valueOf(page + 1));
            }
            DynamicObjectCollection resultCollection = this.datasetToDynamicObjectCollection(cachedOriginDataSet, start, limit);
            for (DynamicObject dynamicObject : resultCollection) {
                long sessionid = (Long)dynamicObject.get("sessionid");
                QFilter qFilter = new QFilter("sessionid", "=", (Object)sessionid);
                DynamicObject newObject = QueryServiceHelper.queryOne((String)"gai_log", (String)"id", (QFilter[])qFilter.toArray());
                long pkId = (Long)newObject.get("id");
                dynamicObject.set("id", (Object)pkId);
            }
            if (resultCollection.size() == 0) {
                QFilter nullFilter = new QFilter("sessionid", "=", (Object)1111);
                resultCollection = QueryServiceHelper.query((String)"gai_log", (String)"sessionid, cloudid, appid", (QFilter[])nullFilter.toArray());
            }
            dataSet.close();
            this.getQueryResult().setNumberFormatProvider(new NumberFormatProvider(new ArrayList(), resultCollection));
            this.getQueryResult().setCollection(resultCollection);
            this.getQueryResult().setDataCount(totalSize);
            return resultCollection;
        }

        public DynamicObjectCollection datasetToDynamicObjectCollection(CachedDataSet cachedOriginDataSet, int start, int limit) {
            Algo algo = Algo.create((String)GaiSessionTabPlugin.KEY_ALGO_KEY);
            DataSet tempDataSet = cachedOriginDataSet.toDataSet(algo, false);
            Field[] fields = tempDataSet.getRowMeta().getFields();
            DynamicObjectCollection collection = new DynamicObjectCollection();
            int fieldLength = fields.length;
            int index = 0;
            int dataCount = 0;
            for (Row rowData : tempDataSet) {
                if (++index <= start) continue;
                if (dataCount >= limit) break;
                Iterator dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"gai_log");
                String chatSessionId = "";
                for (int i = 0; i < fieldLength; ++i) {
                    String key = fields[i].getName();
                    if (key.equals("createorg.name")) {
                        dynamicObject.set("tracetoken", rowData.get(key));
                        continue;
                    }
                    if (key.equals("creator.name")) {
                        dynamicObject.set("traceinput", rowData.get(key));
                        continue;
                    }
                    if (key.equals("chatsessionid")) {
                        chatSessionId = (String)rowData.get(key);
                        dynamicObject.set("number", chatSessionId);
                        continue;
                    }
                    Object value = rowData.get(key);
                    dynamicObject.set(key, value);
                }
                collection.add((Object)dynamicObject);
                ++dataCount;
            }
            tempDataSet.close();
            ArrayList<String> chatSessionIdList = new ArrayList<String>();
            if (CollectionUtils.isNotEmpty((Collection)collection)) {
                for (DynamicObject dynamicObject : collection) {
                    String chatSessionId = dynamicObject.getString("number");
                    if (!StringUtils.isNotEmpty((CharSequence)chatSessionId)) continue;
                    chatSessionIdList.add(chatSessionId);
                }
                Map<String, Map<String, String>> userQuestionMap = this.queryUserQuestionMap(chatSessionIdList);
                Map<String, String> chatSessionTitleMap = userQuestionMap.get("chatSessionTitleMap");
                for (DynamicObject dynamicObject : collection) {
                    String chatSessionId = dynamicObject.getString("number");
                    if (!StringUtils.isNotEmpty((CharSequence)chatSessionId)) continue;
                    dynamicObject.set("name", (Object)chatSessionTitleMap.getOrDefault(chatSessionId, ""));
                }
            }
            return collection;
        }

        private Map<String, Map<String, String>> queryUserQuestionMap(List<String> chatSessionIdList) {
            HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
            HashMap<String, String> chatSessionDTOMap = new HashMap<String, String>(20);
            if (CollectionUtils.isNotEmpty(chatSessionIdList) && CollectionUtils.isNotEmpty(chatSessionIdList)) {
                List chatSessionList = ChatService.getChatSessionList(chatSessionIdList);
                for (ChatSessionDTO chatSessionDTO : chatSessionList) {
                    chatSessionDTOMap.put(chatSessionDTO.getId(), StringUtils.isNotEmpty((CharSequence)chatSessionDTO.getLastUserMessage()) ? chatSessionDTO.getLastUserMessage() : chatSessionDTO.getTitle());
                }
            }
            map.put("chatSessionTitleMap", chatSessionDTOMap);
            return map;
        }
    }
}

