/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.session;

import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.trace.util.SessionLogUtil;
import kd.ai.gai.core.util.ShowFormUtil;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.apache.commons.lang3.time.DateFormatUtils;

public class GaiTraceTabPlugin
extends AbstractFormPlugin
implements BeforeBindDataListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(GaiTraceTabPlugin.class);
    private String TRACE_BILL_LIST = "tracebilllistap";
    private String TRACE_FILTER_CONTAILER = "tracefiltercontainerap";
    private String ITEM_CLICK_REFRESH = "tracerefresh";
    private static final String ITEM_REFRESH = "refresh";
    private static final String CONTROL_DATE_RANGE = "daterange";
    private static final String FILTER_CONDITION_CACHE = "filter_condition_cache";
    private static final String CONTROL_BTN_CLEAN = "barclear";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(this.TRACE_BILL_LIST);
        billList.addBeforeBindDataListener((BeforeBindDataListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl(this.TRACE_BILL_LIST);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"tracetoolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (key.equals(this.ITEM_CLICK_REFRESH) || key.equals(ITEM_REFRESH)) {
            DateRangeEdit edit = (DateRangeEdit)this.getControl(CONTROL_DATE_RANGE);
            String startKey = edit.getStartDateFieldKey();
            String endKey = edit.getEndDateFieldKey();
            Date endDate = (Date)this.getModel().getValue(endKey);
            Date startDate = (Date)this.getModel().getValue(startKey);
            if (KDDateUtils.addDays((Date)startDate, (int)7).before(endDate)) {
                this.getView().showTipNotification("\u6700\u957f\u53ef\u67e5\u770b7\u5929\u5185\u7684\u8bb0\u5f55");
                return;
            }
            this.cacheQueryFilter();
            this.refreshBillList();
        } else if (key.equals(CONTROL_BTN_CLEAN)) {
            this.clearQueryCondition();
            this.refreshBillList();
        }
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl(this.TRACE_BILL_LIST);
        this.getView().updateView(billList.getKey());
    }

    private void clearQueryCondition() {
        DateRangeEdit edit = (DateRangeEdit)this.getControl(CONTROL_DATE_RANGE);
        String startKey = edit.getStartDateFieldKey();
        String endKey = edit.getEndDateFieldKey();
        this.getModel().setValue(startKey, (Object)KDDateUtils.today());
        this.getModel().setValue(endKey, (Object)DateFormatUtils.format((Date)KDDateUtils.now(), (String)String.format("%s 23:59:59", "yyyy-MM-dd")));
        this.getModel().setValue("schatsessionid", null);
        this.getModel().setValue("smonitortrace", null);
        this.getModel().setValue("sagentname", null);
        this.cacheQueryFilter();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.clearQueryCondition();
    }

    private void cacheQueryFilter() {
        DateRangeEdit edit = (DateRangeEdit)this.getControl(CONTROL_DATE_RANGE);
        String startKey = edit.getStartDateFieldKey();
        String endKey = edit.getEndDateFieldKey();
        String start = DateFormatUtils.format((Date)((Date)this.getModel().getValue(startKey)), (String)"yyyy-MM-dd HH:mm:ss");
        String end = DateFormatUtils.format((Date)((Date)this.getModel().getValue(endKey)), (String)"yyyy-MM-dd HH:mm:ss");
        HashMap<String, String> filterCondition = new HashMap<String, String>();
        filterCondition.put("startTime", start);
        filterCondition.put("endTime", end);
        filterCondition.put("chatSessionId", (String)this.getModel().getValue("schatsessionid"));
        filterCondition.put("monitorTraceId", (String)this.getModel().getValue("smonitortrace"));
        String sAgentName = (String)this.getModel().getValue("sagentname");
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)sAgentName)) {
            filterCondition.put("sagentname", (String)this.getModel().getValue("sagentname"));
        }
        this.getPageCache().put(FILTER_CONDITION_CACHE, JSONObject.toJSONString(filterCondition));
    }

    public void beforeBindData(BeforeBindDataEvent beforeBindDataEvent) {
        BillList billList = (BillList)this.getControl(this.TRACE_BILL_LIST);
        billList.addCreateListDataProviderListener(new CreateListDataProviderListener(){

            public void createListDataProvider(BeforeCreateListDataProviderArgs beforeCreateListDataProviderArgs) {
                beforeCreateListDataProviderArgs.setListDataProvider((IListDataProvider)new TraceBillListDataProvider());
            }
        });
    }

    private List<QFilter> buildQueryFilters() {
        String condition = this.getPageCache().get(FILTER_CONDITION_CACHE);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(0);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)condition)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Map cons = (Map)JSONObject.parseObject((String)condition, Map.class);
            for (Map.Entry entry : cons.entrySet()) {
                String queryKey = (String)entry.getKey();
                String queryValue = (String)entry.getValue();
                if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)queryKey, (CharSequence)"startTime")) {
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)queryValue)) continue;
                    Date startDate = null;
                    try {
                        startDate = sdf.parse(queryValue);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    if (startDate == null) continue;
                    QFilter start = new QFilter("createtime", ">=", (Object)startDate);
                    filters.add(start);
                    continue;
                }
                if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)queryKey, (CharSequence)"endTime")) {
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)queryValue)) continue;
                    Date endDate = null;
                    try {
                        endDate = sdf.parse(queryValue);
                    }
                    catch (ParseException start) {
                        // empty catch block
                    }
                    if (endDate == null) continue;
                    QFilter end = new QFilter("createtime", "<=", (Object)endDate);
                    filters.add(end);
                    continue;
                }
                if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)queryKey, (CharSequence)"chatSessionId")) {
                    if (!StringUtils.isNotEmpty((CharSequence)queryValue)) continue;
                    QFilter chatSessionIdQFilter = new QFilter("chatsessionid", "=", (Object)queryValue);
                    filters.add(chatSessionIdQFilter);
                    continue;
                }
                if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)queryKey, (CharSequence)"monitorTraceId")) {
                    if (!StringUtils.isNotEmpty((CharSequence)queryValue)) continue;
                    QFilter monitorTraceIdQFilter = new QFilter("monitortraceid", "=", (Object)queryValue);
                    filters.add(monitorTraceIdQFilter);
                    continue;
                }
                if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)queryKey, (CharSequence)"sagentname")) continue;
                Map<String, List<Long>> agentKeys = this.searchAgentAndProcess(queryValue);
                if (!agentKeys.isEmpty()) {
                    QFilter agentFilter = null;
                    if (agentKeys != null && agentKeys.containsKey("agent")) {
                        agentFilter = new QFilter("agent", "in", agentKeys.get("agent"));
                    }
                    QFilter processFilter = null;
                    if (agentKeys.containsKey("process")) {
                        processFilter = new QFilter("process", "in", agentKeys.get("process"));
                    }
                    if (agentFilter != null && processFilter != null) {
                        QFilter filter = agentFilter.or(processFilter);
                        filters.add(filter);
                        continue;
                    }
                    if (agentFilter != null) {
                        filters.add(agentFilter);
                    }
                    if (processFilter == null) continue;
                    filters.add(processFilter);
                    continue;
                }
                filters.add(new QFilter("agent", "=", (Object)Long.MAX_VALUE));
            }
        }
        return filters;
    }

    private Map<String, List<Long>> searchAgentAndProcess(String keywords) {
        HashMap<String, List<Long>> agentKeys = new HashMap<String, List<Long>>(0);
        String likeStr = "%" + keywords + "%";
        DynamicObjectCollection agents = QueryServiceHelper.query((String)"gai_agent", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("name", "like", (Object)likeStr)});
        DynamicObjectCollection processes = QueryServiceHelper.query((String)"gai_process", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("name", "like", (Object)likeStr)});
        if (agents != null && !agents.isEmpty()) {
            List agentIds = agents.stream().map(new Function<DynamicObject, Long>(){

                @Override
                public Long apply(DynamicObject dynamicObject) {
                    return dynamicObject.getLong("id");
                }
            }).collect(Collectors.toList());
            agentKeys.put("agent", agentIds);
        }
        if (processes != null && !processes.isEmpty()) {
            List processIds = processes.stream().map(new Function<DynamicObject, Long>(){

                @Override
                public Long apply(DynamicObject dynamicObject) {
                    return dynamicObject.getLong("id");
                }
            }).collect(Collectors.toList());
            agentKeys.put("process", processIds);
        }
        return agentKeys;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        BillList traceBillList = (BillList)hyperLinkClickEvent.getSource();
        ListSelectedRow selectedRow = traceBillList.getCurrentSelectedRowInfo();
        long pkId = (Long)selectedRow.getPrimaryKeyValue();
        DynamicObject rowData = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"gai_log");
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)fieldName, (CharSequence)"traceid") || org.apache.commons.lang3.StringUtils.equals((CharSequence)fieldName, (CharSequence)"chatsessionid")) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("gai_log_view");
            showParameter.setStatus(OperationStatus.VIEW);
            String chatSessionId = rowData.getString("chatsessionid");
            showParameter.setCustomParam("chatSessionId", (Object)chatSessionId);
            switch (fieldName) {
                case "traceid": {
                    long traceId = rowData.getLong("traceid");
                    showParameter.setCustomParam("origin", (Object)"trace");
                    showParameter.setCustomParam("id", (Object)traceId);
                    showParameter.setCaption(String.format("Trace\u8be6\u60c5-%s", traceId));
                    break;
                }
                case "chatsessionid": {
                    long sessionId = rowData.getLong("sessionid");
                    showParameter.setCustomParam("origin", (Object)"session");
                    showParameter.setCustomParam("id", (Object)sessionId);
                    showParameter.setCaption(String.format("\u4f1a\u8bdd\u8be6\u60c5-%s", chatSessionId.substring(0, 8)));
                }
            }
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        } else if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"monitortraceid")) {
            String monitorTraceId = rowData.getString("monitortraceid");
            String clientFullContextPath = RequestContext.get().getClientFullContextPath();
            if (StringUtils.isNotEmpty((CharSequence)clientFullContextPath)) {
                clientFullContextPath = StringUtils.endsWith((CharSequence)clientFullContextPath, (CharSequence)"/") ? clientFullContextPath.substring(0, clientFullContextPath.length() - 1) : clientFullContextPath;
                this.getView().openUrl(String.format("%s/monitor/eye/#/logQuery-new?traceId=%s", clientFullContextPath, monitorTraceId));
            } else {
                this.getView().showTipNotification("clientFullContextPath\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8df3\u8f6c\u81f3monitor");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("switchlist".equals(propertyName)) {
            String value = (String)e.getChangeSet()[0].getNewValue();
            if ("trace".equalsIgnoreCase(value)) {
                ShowFormUtil.showFormInCurrentForm((IFormView)this.getView(), (String)GaiFormIdEnum.GAI_TRACE_TAB.getId(), (String)"\u4f1a\u8bdd\u65e5\u5fd7");
            } else if ("session".equalsIgnoreCase(value)) {
                ShowFormUtil.showFormInCurrentForm((IFormView)this.getView(), (String)GaiFormIdEnum.GAI_SESSION_TAB.getId(), (String)"\u4f1a\u8bdd\u65e5\u5fd7");
            }
        }
    }

    public class TraceBillListDataProvider
    extends ListDataProvider {
        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection dynamicObjects;
            QFilter[] filters;
            DynamicObject[] tracesObjects;
            int totalSize;
            List qFilters = super.getQFilters();
            List timeQFilter = GaiTraceTabPlugin.this.buildQueryFilters();
            qFilters.addAll(timeQFilter);
            String properties = this.buildProperties();
            QFilter dataQFilter = PermissionServiceHelper.getOperationRuleFilter((String)"gai", (String)"gai_log", (String)"view", (StringBuilder)new StringBuilder("\u65e0\u6743\u9650\u8bbf\u95ee"));
            HashMap<String, String> propMapper = new HashMap<String, String>();
            propMapper.put("number", "creator.name");
            propMapper.put("name", "createorg.name");
            int len = qFilters.size();
            for (int i = 0; i < len; ++i) {
                QFilter qFilter = (QFilter)qFilters.get(i);
                String fieldName = qFilter.getProperty();
                if (propMapper.containsKey(fieldName)) {
                    QFilter tmpFilter = new QFilter((String)propMapper.get(fieldName), qFilter.getCP(), qFilter.getValue());
                    qFilters.set(i, tmpFilter);
                }
                qFilters.add(qFilters.get(i));
            }
            if (dataQFilter != null) {
                qFilters.add(dataQFilter);
            }
            if (start > (totalSize = (tracesObjects = BusinessDataServiceHelper.load((String)"gai_log", (String)properties, (QFilter[])(filters = qFilters.toArray(new QFilter[0])), (String)"createtime desc")).length)) {
                double pageHandle = totalSize / limit;
                int page = (int)Math.ceil(pageHandle);
                start = page * limit;
                BillList billList = (BillList)GaiTraceTabPlugin.this.getControl(GaiTraceTabPlugin.this.TRACE_BILL_LIST);
                billList.getEntryState().setCurrentPageIndex(Integer.valueOf(page + 1));
            }
            if ((dynamicObjects = this.CustomPageByDynamicObjectCollection(tracesObjects, start, limit)).size() == 0) {
                QFilter nullFilter = new QFilter("sessionid", "=", (Object)1111);
                dynamicObjects = QueryServiceHelper.query((String)"gai_log", (String)"sessionid, cloudid, appid", (QFilter[])nullFilter.toArray());
            }
            this.getQueryResult().setNumberFormatProvider(new NumberFormatProvider(new ArrayList(), dynamicObjects));
            this.getQueryResult().setCollection(dynamicObjects);
            this.getQueryResult().setDataCount(totalSize);
            return dynamicObjects;
        }

        public DynamicObjectCollection CustomPageByDynamicObjectCollection(DynamicObject[] tracesObjects, int start, int limit) {
            int fieldLength = tracesObjects.length;
            int index = 0;
            int dataCount = 0;
            DynamicObjectCollection newCollection = new DynamicObjectCollection();
            for (DynamicObject dynamicObject : tracesObjects) {
                DynamicObjectCollection collection = (DynamicObjectCollection)dynamicObject.get("entryentity");
                if (++index <= start) continue;
                if (dataCount >= limit) break;
                String inputContent = "";
                Date tmpMinTime = null;
                Date tmpMaxTime = null;
                long tmpMinEntryId = 0L;
                int totalToken = 0;
                long tracelatency = 0L;
                for (DynamicObject subObject : collection) {
                    int childToken = (Integer)subObject.get("totaltoken");
                    totalToken += childToken;
                    Date beginDate = (Date)subObject.get("stepbegintime");
                    Date finishDate = (Date)subObject.get("stepfinishtime");
                    long beginEntryId = (Long)subObject.get("id");
                    if (beginEntryId == 0L || finishDate == null) continue;
                    if (tmpMinEntryId == 0L || beginEntryId < tmpMinEntryId) {
                        tmpMinEntryId = beginEntryId;
                        inputContent = subObject.get("stepinput_tag").toString();
                        String userInput = SessionLogUtil.getUserInput((String)inputContent);
                        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)userInput)) {
                            inputContent = userInput;
                        }
                    }
                    if (tmpMaxTime == null || finishDate.compareTo(tmpMaxTime) > 0) {
                        tmpMaxTime = finishDate;
                    }
                    if (tmpMinTime != null && beginDate.compareTo(tmpMinTime) >= 0) continue;
                    tmpMinTime = beginDate;
                }
                if (tmpMaxTime != null && tmpMinTime != null) {
                    tracelatency = TimeUnit.MILLISECONDS.toSeconds(tmpMaxTime.getTime() - tmpMinTime.getTime());
                }
                dynamicObject.set("tracetoken", (Object)totalToken);
                dynamicObject.set("tracelatency", (Object)tracelatency);
                dynamicObject.set("traceinput", (Object)inputContent);
                Long agentId = dynamicObject.getLong("agent");
                dynamicObject.set("agentname", (Object)this.findAgentName(agentId, "gai_agent"));
                Long processId = dynamicObject.getLong("process");
                dynamicObject.set("processname", (Object)this.findAgentName(processId, "gai_process"));
                dynamicObject.set("name", dynamicObject.get("createorg.name"));
                dynamicObject.set("number", dynamicObject.get("creator.name"));
                dynamicObject.set("chatsessionid", dynamicObject.get("chatsessionid"));
                newCollection.add((Object)dynamicObject);
                ++dataCount;
            }
            return newCollection;
        }

        private String findAgentName(Long agentId, String entryNumber) {
            String agentName = "";
            if (agentId != 0L) {
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)entryNumber, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)agentId)});
                return dynamicObject != null ? dynamicObject.getString("name") : "";
            }
            return agentName;
        }

        public String buildProperties() {
            String traceProperties = org.apache.commons.lang3.StringUtils.join((Object[])new String[]{"traceid", "sessionid", "appid", "cloudid", "userid", "createtime", "tracetoken", "tracelatency", "traceinput", "name", "chatsessionid", "createorg.name", "creator.name", "monitortraceid", "agent", "agentname", "process", "processname"}, (String)",");
            String stepProperties = org.apache.commons.lang3.StringUtils.join((Object[])new String[]{String.format("%s.%s", "entryentity", "totaltoken"), String.format("%s.%s", "entryentity", "stepinput_tag"), String.format("%s.%s", "entryentity", "stepinput"), String.format("%s.%s", "entryentity", "stepbegintime"), String.format("%s.%s", "entryentity", "stepfinishtime"), String.format("%s.%s", "entryentity", "entryid")}, (String)",");
            org.apache.commons.lang3.StringUtils.join((Object[])new String[]{traceProperties, stepProperties}, (String)",");
            return org.apache.commons.lang3.StringUtils.join((Object[])new String[]{traceProperties, stepProperties}, (String)",");
        }
    }
}

