/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.trace;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.trace.util.SessionLogUtil;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class GaiAPILogDetailListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(GaiAPILogDetailListPlugin.class);
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String API_INFO_CHACHE_KEY = "api_info_cache";
    private static final String API_INFO_ID_CHACHE_KEY = "api_info_id_cache";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumnList) {
            if (filterColumn.getFieldName().contains("apiinfo.number")) {
                Object apiInfoId = this.getView().getFormShowParameter().getCustomParam("apiInfoId");
                if (null == apiInfoId) continue;
                filterColumn.setDefaultValue(apiInfoId.toString());
                continue;
            }
            if (!filterColumn.getFieldName().contains("createtime")) continue;
            Object startTime = this.getView().getFormShowParameter().getCustomParam("startTime");
            Object endTime = this.getView().getFormShowParameter().getCustomParam("endTime");
            if (startTime == null || endTime == null) continue;
            ArrayList<Object> time = new ArrayList<Object>();
            time.add(startTime);
            time.add(endTime);
            filterColumn.setDefaultValues(time);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        HyperLinkClickEvent clickEvent = args.getHyperLinkClickEvent();
        BillList billList = (BillList)clickEvent.getSource();
        ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
        long pkId = (Long)selectedRow.getPrimaryKeyValue();
        DynamicObject rowData = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"gai_api_detail");
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"chatsessionid")) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("gai_log_view");
            showParameter.setStatus(OperationStatus.VIEW);
            String chatSessionId = rowData.getString("chatsessionid");
            showParameter.setCustomParam("chatSessionId", (Object)chatSessionId);
            switch (fieldName) {
                case "chatsessionid": {
                    QFilter chatsessionFilter = new QFilter("chatsessionid", ">=", (Object)chatSessionId);
                    DynamicObject logDynamicObject = BusinessDataServiceHelper.loadSingle((String)"gai_log", (QFilter[])chatsessionFilter.toArray());
                    if (logDynamicObject == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684chatsessionid", (String)"GaiAPILogDetailListPlugin_15173921", (String)"ai-gai-plugin", (Object[])new Object[0]));
                    }
                    Long querySessionId = SessionLogUtil.querySessionIdByChatSessionId((String)chatSessionId);
                    if (querySessionId == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684chatsessionid", (String)"GaiAPILogDetailListPlugin_15173921", (String)"ai-gai-plugin", (Object[])new Object[0]));
                    }
                    long sessionId = logDynamicObject.getLong("sessionid");
                    showParameter.setCustomParam("origin", (Object)"session");
                    showParameter.setCustomParam("id", (Object)sessionId);
                    String message = ResManager.loadKDString((String)"\u4f1a\u8bdd\u8be6\u60c5", (String)"GaiAPILogDetailListPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
                    showParameter.setCaption(String.format(message, "-%s", chatSessionId.substring(0, 8)));
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm(showParameter);
                }
            }
        }
        args.setCancel(true);
    }

    private List<Map<String, String>> queryAPIInfoList() {
        QFilter status;
        ArrayList<Map<String, String>> datas = new ArrayList<Map<String, String>>();
        QFilter[] filters = new QFilter[2];
        filters[0] = status = new QFilter("status", "=", (Object)"C");
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)"gai_api_info", (String)"id,number,name,path,status", (QFilter[])filters);
        if (collection != null) {
            for (DynamicObject service : collection) {
                String id = service.getString("id");
                String name = service.getString("name");
                String number = service.getString("number");
                String path = service.getString("path");
                HashMap<String, String> ser = new HashMap<String, String>();
                ser.put("id", id);
                ser.put("name", name);
                ser.put("number", number);
                ser.put("path", path);
                datas.add(ser);
            }
        }
        return datas;
    }

    private Map<String, Map<String, String>> transformAPIInfoList(List<Map<String, String>> list) {
        HashMap<String, Map<String, String>> data = new HashMap<String, Map<String, String>>(0);
        if (list != null && !list.isEmpty()) {
            for (Map<String, String> apiInfo : list) {
                String id = apiInfo.get("id");
                data.put(id, apiInfo);
            }
        }
        return data;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new BillListDataProvider());
    }

    public static class BillListDataProvider
    extends ListDataProvider {
        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            rows.forEach(dynamicObject -> {
                String errcode = dynamicObject.getString("errcode");
                errcode = StringUtils.isEmpty((CharSequence)errcode) ? ResManager.loadKDString((String)"\u5f02\u5e38", (String)"GaiAPIDetailListPlugin_Exception", (String)"ai-gai-plugin", (Object[])new Object[0]) : (errcode.equals("0") ? ResManager.loadKDString((String)"\u6210\u529f", (String)"GaiAPIDetailListPlugin_Ok", (String)"ai-gai-plugin", (Object[])new Object[0]) : errcode);
                dynamicObject.set("errcode", (Object)errcode);
            });
            return rows;
        }
    }
}

