/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.trace;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class GaiMonitorAPILogDetailFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(GaiMonitorAPILogDetailFormPlugin.class);
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String API_INFO_CHACHE_KEY = "api_info_cache";
    private static final String CONTROL_SESSION_COLUMN_NAME = "sessionid";
    private static final String API_INFO_ID_CHACHE_KEY = "api_info_id_cache";
    private static final String QUERY_TOOL_BAR = "toolbarap";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{ENTRY_ENTITY});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        LLMDetailGridControl gridControl = (LLMDetailGridControl)this.getControl(ENTRY_ENTITY);
        gridControl.addHyperClickListener(this);
        this.addItemClickListeners(new String[]{QUERY_TOOL_BAR});
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String entryKey = e.getKey();
        if (entryKey.equalsIgnoreCase(ENTRY_ENTITY)) {
            Control oldGrid = e.getControl();
            if (oldGrid == null) {
                return;
            }
            LLMDetailGridControl newCustGrid = oldGrid instanceof LLMDetailGridControl ? (LLMDetailGridControl)oldGrid : new LLMDetailGridControl();
            newCustGrid.setView(this.getView());
            newCustGrid.setKey(entryKey);
            newCustGrid.setEntryKey(entryKey);
            newCustGrid.setSplitPage(true);
            if (oldGrid instanceof EntryGrid) {
                newCustGrid.getItems().addAll(((EntryGrid)oldGrid).getItems());
                newCustGrid.setPageRow(((EntryGrid)oldGrid).getPageRow());
            }
            e.setControl((Control)newCustGrid);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List<Map<String, String>> list = this.queryAPIInfoList();
        Map<String, Map<String, String>> apiInfoMap = this.transformAPIInfoList(list);
        this.getPageCache().put(API_INFO_CHACHE_KEY, JSON.toJSONString(apiInfoMap));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long apiInfoId = (Long)formShowParameter.getCustomParam("apiInfoId");
        logger.info("apiInfoId:{}", (Object)apiInfoId);
        this.getPageCache().put(API_INFO_ID_CHACHE_KEY, apiInfoId + "");
        EntryGrid entry = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entry.setPageRows(entry.getPageRow());
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if (StringUtils.equalsIgnoreCase((CharSequence)CONTROL_SESSION_COLUMN_NAME, (CharSequence)fieldName)) {
            int pageRows;
            int pageIndex;
            int realIndex;
            int row = hyperLinkClickEvent.getRowIndex();
            DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRY_ENTITY);
            DynamicObject rowData = (DynamicObject)collection.get(realIndex = row - ((pageIndex = Integer.parseInt(this.getPageCache().get("current_page_number"))) - 1) * (pageRows = Integer.parseInt(this.getPageCache().get("page_row"))));
            if (rowData != null) {
                String sessionId = rowData.getString(CONTROL_SESSION_COLUMN_NAME);
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("gai_log_view");
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.setCustomParam("id", (Object)Long.parseLong(sessionId));
                showParameter.setCustomParam("origin", (Object)"session");
                showParameter.setCaption(String.format("\u4f1a\u8bdd\u8be6\u60c5-%s", sessionId));
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(showParameter);
            }
        }
    }

    private int queryTotalCount(QFilter[] filters) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gai_api_detail", (String)" id,apiinfo,cost,createtime ", (QFilter[])filters, (String)"createtime desc");
        String sql = "select  id,apiinfo,cost,createtime ";
        DataSet llmDataSet = dataSet.executeSql(sql);
        int count = llmDataSet.count("apiinfo", false);
        return count;
    }

    private List<Map<String, String>> queryAPIInfoList() {
        QFilter status;
        ArrayList<Map<String, String>> datas = new ArrayList<Map<String, String>>();
        QFilter[] filters = new QFilter[2];
        filters[0] = status = new QFilter("status", "=", (Object)"C");
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)"gai_api_info", (String)"id,number,name,path,status", (QFilter[])filters);
        if (collection != null) {
            for (DynamicObject service : collection) {
                String id = service.getString("id");
                String name = service.getString("name");
                String number = service.getString("number");
                String path = service.getString("path");
                HashMap<String, String> ser = new HashMap<String, String>();
                ser.put("id", id);
                ser.put("name", name);
                ser.put("number", number);
                ser.put("path", path);
                datas.add(ser);
            }
        }
        return datas;
    }

    private Map<String, Map<String, String>> transformAPIInfoList(List<Map<String, String>> list) {
        HashMap<String, Map<String, String>> data = new HashMap<String, Map<String, String>>(0);
        if (list != null && !list.isEmpty()) {
            for (Map<String, String> apiInfo : list) {
                String id = apiInfo.get("id");
                data.put(id, apiInfo);
            }
        }
        return data;
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "barrefresh": {
                this.refresh();
            }
        }
    }

    private void refresh() {
        this.getView().updateView(ENTRY_ENTITY);
    }

    class LLMDetailGridControl
    extends EntryGrid {
        private static final String ENTRY_ENTITY = "entryentity";

        LLMDetailGridControl() {
        }

        protected boolean onFetchPageData(int pageIndex, int pageRows) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection(this.getKey());
            entryEntities.clear();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(0);
            String apiInfoId = GaiMonitorAPILogDetailFormPlugin.this.getPageCache().get(GaiMonitorAPILogDetailFormPlugin.API_INFO_ID_CHACHE_KEY);
            if (!StringUtils.isEmpty((CharSequence)apiInfoId)) {
                QFilter numberFilter = new QFilter("apiinfo", "=", (Object)Long.parseLong(apiInfoId));
                qFilters.add(numberFilter);
            }
            QFilter[] filters = qFilters.toArray(new QFilter[qFilters.size()]);
            Map<String, Object> res = this.queryAPICallData(filters, pageIndex, pageRows);
            int count = (Integer)res.get("count");
            List list = (List)res.get("list");
            DynamicObjectType dynamicObjectType = this.getModel().getEntryEntity("entryentity").getDynamicObjectType();
            if (list != null && !list.isEmpty()) {
                IPageCache pageCache = GaiMonitorAPILogDetailFormPlugin.this.getPageCache();
                String apiInfoCache = pageCache.get(GaiMonitorAPILogDetailFormPlugin.API_INFO_CHACHE_KEY);
                Map apiInfoMap = (Map)JSONObject.parseObject((String)apiInfoCache, Map.class);
                for (Map data : list) {
                    String apiId = (String)data.get("apiId");
                    Map apiInfo = (Map)apiInfoMap.get(apiId);
                    DynamicObject item = new DynamicObject(dynamicObjectType);
                    item.set("apinumber", apiInfo.get("number"));
                    item.set("apiname", apiInfo.get("name"));
                    item.set("apipath", apiInfo.get("path"));
                    String billno = (String)data.get("billno");
                    Long cost = Long.parseLong((String)data.get("cost"));
                    item.set("cost", (Object)cost);
                    Date createTime = data.get("createTime") == null ? null : (Date)data.get("createTime");
                    String chatsessionid = (String)data.get("chatsessionid");
                    String errorCode = data.get("errCode") == null ? null : (String)data.get("errCode");
                    item.set("billno", (Object)String.valueOf(billno));
                    item.set("createtime", (Object)createTime);
                    item.set("chatsessionid", (Object)String.valueOf(chatsessionid));
                    if (!StringUtils.equalsIgnoreCase((CharSequence)errorCode, (CharSequence)"0")) {
                        item.set("errcode", (Object)"\u5931\u8d25");
                    } else {
                        item.set("errcode", (Object)"\u6210\u529f");
                    }
                    entryEntities.add((Object)item);
                }
            }
            this.getModel().updateEntryCache(entryEntities);
            this.getView().updateView("entryentity");
            int startRowIndex = (pageIndex - 1) * pageRows;
            GaiMonitorAPILogDetailFormPlugin.this.getPageCache().put("current_page_number", String.valueOf(pageIndex));
            GaiMonitorAPILogDetailFormPlugin.this.getPageCache().put("page_row", String.valueOf(pageRows));
            dataEntity.getDataEntityState().setEntryStartRowIndex(this.getKey(), startRowIndex);
            dataEntity.getDataEntityState().setEntryPageSize(this.getKey(), pageRows);
            dataEntity.getDataEntityState().setEntryRowCount(this.getKey(), count);
            return true;
        }

        protected Map<String, Object> queryAPICallData(QFilter[] filters, int pageIndex, int pageRows) {
            HashMap<String, Object> data = new HashMap<String, Object>(0);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gai_api_detail", (String)" billno,chatsessionid,apiinfo,cost,errcode,createtime ", (QFilter[])filters, (String)"createtime desc");
            String sql = "select  billno,chatsessionid,apiinfo,cost,errcode,createtime ";
            DataSet llmDataSet = dataSet.limit((pageIndex - 1) * pageRows, pageRows).orderBy(new String[]{"createtime desc"}).executeSql(sql);
            Iterator iterable = llmDataSet.iterator();
            ArrayList listDatas = new ArrayList(0);
            while (iterable.hasNext()) {
                Row rowData = (Row)iterable.next();
                String apiId = rowData.getString("apiinfo");
                HashMap<String, Object> row = new HashMap<String, Object>(3);
                row.put("apiId", apiId);
                row.put("billno", rowData.getString("billno"));
                row.put("cost", rowData.getString("cost"));
                row.put("chatsessionid", rowData.getString("chatsessionid"));
                row.put("errCode", rowData.getString("errcode"));
                row.put("createTime", rowData.getDate("createtime"));
                listDatas.add(row);
            }
            int count = GaiMonitorAPILogDetailFormPlugin.this.queryTotalCount(filters);
            data.put("count", count);
            data.put("list", listDatas);
            return data;
        }
    }
}

