/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.trace;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class GaiMonitorAPILogFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(GaiMonitorAPILogFormPlugin.class);
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String API_SERVICE_CHACHE_KEY = "api_service_cache";
    private static final String CONTROL_DATE_RANGE = "daterange";
    private static final String CONTROL_SERVICE_NUMBER_COLUMN_NAME = "llm_service_number";
    private static final String GAI_LOG_LLM_ANA_DETAIL_FORM = "gai_log_llm_ana_detail";
    private static final String DATE_RANGE_START = "daterange_startdate";
    private static final String DATE_RANGE_END = "daterange_enddate";
    private static final String START_DATE_CACHE = "start_date_cache";
    private static final String END_DATE_CACHE = "end_date_cache";
    public static final String BTN_QUERY = "barquery";
    private static final String QUERY_TOOL_BAR = "querytoolbarap";

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{ENTRY_ENTITY});
        ((TraceLLMGridControl)this.getControl(ENTRY_ENTITY)).setSplitPage(false);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ((TraceLLMGridControl)this.getControl(ENTRY_ENTITY)).setSplitPage(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TraceLLMGridControl gridControl = (TraceLLMGridControl)this.getControl(ENTRY_ENTITY);
        gridControl.addHyperClickListener(this);
        this.addItemClickListeners(new String[]{QUERY_TOOL_BAR});
        Toolbar toolbar = (Toolbar)this.getView().getControl("toolbarap");
        toolbar.addItemClickListener((ItemClickListener)this);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String entryKey = e.getKey();
        if (entryKey.equalsIgnoreCase(ENTRY_ENTITY)) {
            Control oldGrid = e.getControl();
            if (oldGrid == null) {
                return;
            }
            TraceLLMGridControl newCustGrid = oldGrid instanceof TraceLLMGridControl ? (TraceLLMGridControl)oldGrid : new TraceLLMGridControl();
            newCustGrid.setView(this.getView());
            newCustGrid.setKey(entryKey);
            newCustGrid.setEntryKey(entryKey);
            newCustGrid.setSplitPage(false);
            if (oldGrid instanceof EntryGrid) {
                if (newCustGrid.getItems().isEmpty()) {
                    newCustGrid.getItems().addAll(((EntryGrid)oldGrid).getItems());
                }
                newCustGrid.setPageRow(((EntryGrid)oldGrid).getPageRow());
            }
            e.setControl((Control)newCustGrid);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setLast3Month(3);
        List<Map<String, String>> apiInfoList = this.queryAPIInfoList();
        Map<String, Map<String, String>> apiInfoMap = this.transformAPIInfoList(apiInfoList);
        this.getPageCache().put(API_SERVICE_CHACHE_KEY, JSON.toJSONString(apiInfoMap));
        EntryGrid entry = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entry.setPageRows(entry.getPageRow());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ((TraceLLMGridControl)this.getControl(ENTRY_ENTITY)).setSplitPage(false);
    }

    private void setLast3Month(int month) {
        DateRangeEdit edit = (DateRangeEdit)this.getControl(CONTROL_DATE_RANGE);
        String startKey = edit.getStartDateFieldKey();
        String endKey = edit.getEndDateFieldKey();
        LocalDate current = LocalDate.now();
        LocalDate threeMonths = current.minusMonths(month);
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zonedDateTimeStart = threeMonths.atStartOfDay(zoneId);
        ZonedDateTime zonedDateTimeEnd = current.atStartOfDay(zoneId);
        Date startDate = Date.from(zonedDateTimeStart.toInstant());
        Date endDate = Date.from(zonedDateTimeEnd.toInstant());
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            endDate = sdf.parse(String.format("%s 23:59:59", sdfDate.format(endDate)));
        }
        catch (ParseException e) {
            logger.info("");
        }
        this.getModel().setValue(startKey, (Object)startDate);
        this.getModel().setValue(endKey, (Object)endDate);
        String start = sdf.format(startDate);
        String end = sdf.format(endDate);
        this.getPageCache().put(START_DATE_CACHE, start);
        this.getPageCache().put(END_DATE_CACHE, end);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if (StringUtils.equalsIgnoreCase((CharSequence)"api_number", (CharSequence)fieldName)) {
            int pageRows;
            int pageIndex;
            int realIndex;
            int row = hyperLinkClickEvent.getRowIndex();
            DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRY_ENTITY);
            DynamicObject rowData = (DynamicObject)collection.get(realIndex = row - ((pageIndex = Integer.parseInt(this.getPageCache().get("current_page_number"))) - 1) * (pageRows = Integer.parseInt(this.getPageCache().get("page_row"))));
            if (rowData != null) {
                String apiNumber = rowData.getString("api_number");
                String apiName = rowData.getString("api_name");
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("gai_api_detail");
                showParameter.setStatus(OperationStatus.VIEW);
                QFilter qFilter = new QFilter("number", "=", (Object)apiNumber);
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"gai_api_info", (QFilter[])new QFilter[]{qFilter});
                String startTime = this.getPageCache().get(START_DATE_CACHE);
                String endTime = this.getPageCache().get(END_DATE_CACHE);
                showParameter.setCustomParam("apiInfoId", dynamicObject.getPkValue());
                showParameter.setCustomParam("startTime", (Object)startTime);
                showParameter.setCustomParam("endTime", (Object)endTime);
                showParameter.setCaption(String.format("\u8c03\u7528\u660e\u7ec6-%s", apiName));
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    private int queryTotalCount(QFilter[] filters) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gai_api_detail", (String)" id,createtime ", (QFilter[])filters, (String)"createtime desc");
        String sql = "select id,createtime";
        GroupbyDataSet groupbyDataSet = dataSet.executeSql(sql).groupBy(new String[]{"id"});
        DataSet apiDataSet = groupbyDataSet.finish();
        return apiDataSet.count("id", false);
    }

    private int queryFailCount(QFilter[] filters) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gai_api_detail", (String)" id,errcode,createtime ", (QFilter[])filters, (String)"createtime desc");
        String sql = "select id,errcode,createtime ";
        DataSet resDataSet = dataSet.executeSql(sql).where("errcode != '0'");
        int count = resDataSet.count("id", false);
        return count;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)DATE_RANGE_START)) {
            DateRangeEdit edit = (DateRangeEdit)this.getControl(CONTROL_DATE_RANGE);
            String startKey = edit.getStartDateFieldKey();
            Date startDate = (Date)this.getModel().getValue(startKey);
            String start = sdf.format(startDate);
            this.getModel().setValue(startKey, (Object)startDate);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)DATE_RANGE_END)) {
            DateRangeEdit edit = (DateRangeEdit)this.getControl(CONTROL_DATE_RANGE);
            String endKey = edit.getEndDateFieldKey();
            Date endDate = (Date)this.getModel().getValue(endKey);
            String end = sdf.format(endDate);
            this.getModel().setValue(endKey, (Object)endDate);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (key.startsWith(BTN_QUERY)) {
            this.query();
        }
    }

    private void query() {
        DateRangeEdit edit = (DateRangeEdit)this.getControl(CONTROL_DATE_RANGE);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String startKey = edit.getStartDateFieldKey();
        String endKey = edit.getEndDateFieldKey();
        Date endDate = (Date)this.getModel().getValue(endKey);
        Date startDate = (Date)this.getModel().getValue(startKey);
        String start = sdf.format(startDate);
        this.getPageCache().put(START_DATE_CACHE, start);
        String end = sdf.format(endDate);
        this.getPageCache().put(END_DATE_CACHE, end);
        TraceLLMGridControl entry = (TraceLLMGridControl)this.getView().getControl(ENTRY_ENTITY);
        int pageRow = entry.getPageRow();
        entry.onFetchPageData(1, pageRow);
    }

    private List<Map<String, String>> queryAPIInfoList() {
        QFilter status;
        ArrayList<Map<String, String>> datas = new ArrayList<Map<String, String>>();
        QFilter[] filters = new QFilter[2];
        filters[0] = status = new QFilter("status", "=", (Object)"C");
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)"gai_api_info", (String)"id,number,name,path,status", (QFilter[])filters);
        if (collection != null) {
            for (DynamicObject service : collection) {
                String id = service.getString("id");
                String name = service.getString("name");
                String number = service.getString("number");
                String path = service.getString("path");
                HashMap<String, String> ser = new HashMap<String, String>();
                ser.put("id", id);
                ser.put("name", name);
                ser.put("number", number);
                ser.put("path", path);
                datas.add(ser);
            }
        }
        return datas;
    }

    private Map<String, Map<String, String>> transformAPIInfoList(List<Map<String, String>> list) {
        HashMap<String, Map<String, String>> data = new HashMap<String, Map<String, String>>(0);
        if (list != null && !list.isEmpty()) {
            for (Map<String, String> apiInfo : list) {
                String id = apiInfo.get("id");
                data.put(id, apiInfo);
            }
        }
        return data;
    }

    class TraceLLMGridControl
    extends EntryGrid {
        private static final String ENTRY_ENTITY = "entryentity";

        TraceLLMGridControl() {
        }

        protected boolean onFetchPageData(int pageIndex, int pageRows) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection(this.getKey());
            entryEntities.clear();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(0);
            Date startDate = null;
            Date endDate = null;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String startDateCache = GaiMonitorAPILogFormPlugin.this.getPageCache().get(GaiMonitorAPILogFormPlugin.START_DATE_CACHE);
            String endDateCache = GaiMonitorAPILogFormPlugin.this.getPageCache().get(GaiMonitorAPILogFormPlugin.END_DATE_CACHE);
            if (!StringUtils.isEmpty((CharSequence)startDateCache)) {
                try {
                    startDate = sdf.parse(startDateCache);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (!StringUtils.isEmpty((CharSequence)endDateCache)) {
                try {
                    endDate = sdf.parse(endDateCache);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (startDate != null) {
                QFilter start = new QFilter("createtime", ">=", (Object)startDate);
                qFilters.add(start);
            }
            if (endDate != null) {
                QFilter end = new QFilter("createtime", "<=", (Object)endDate);
                qFilters.add(end);
            }
            Map<String, Object> res = this.queryLLMCallData(qFilters, pageIndex, pageRows);
            int count = (Integer)res.get("count");
            int allCount = (Integer)res.get("allCount");
            int failCount = (Integer)res.get("failCount");
            DecimalFormat df = new DecimalFormat("#,###");
            BigDecimal allAvgLatency = (BigDecimal)res.get("allAvgLatency");
            Label allCountLabel = (Label)GaiMonitorAPILogFormPlugin.this.getControl("api_total_count");
            allCountLabel.setText(df.format(allCount));
            Label avgLatencyLabel = (Label)GaiMonitorAPILogFormPlugin.this.getControl("api_avg_time");
            avgLatencyLabel.setText(df.format(allAvgLatency) + "ms");
            Label failCountLabel = (Label)GaiMonitorAPILogFormPlugin.this.getControl("api_fail_count");
            failCountLabel.setText(df.format(failCount));
            List list = (List)res.get("list");
            DynamicObjectType dynamicObjectType = this.getModel().getEntryEntity("entryentity").getDynamicObjectType();
            List apiInfoList = GaiMonitorAPILogFormPlugin.this.queryAPIInfoList();
            Map apiInfoMap = GaiMonitorAPILogFormPlugin.this.transformAPIInfoList(apiInfoList);
            if (list != null && !list.isEmpty()) {
                for (Map data : list) {
                    String apiId = (String)data.get("apiId");
                    int total = (Integer)data.get("callCount");
                    int fail = (Integer)data.get("failCount");
                    BigDecimal avgLatency = (BigDecimal)data.get("avgCost");
                    DynamicObject item = new DynamicObject(dynamicObjectType);
                    Map apiInfo = (Map)apiInfoMap.get(apiId);
                    item.set("api_number", apiInfo.get("number"));
                    item.set("api_name", apiInfo.get("name"));
                    item.set("api_total_call_count", (Object)total);
                    item.set("api_fail_call_count", (Object)(fail + ""));
                    item.set("api_ava_call_time", (Object)avgLatency);
                    entryEntities.add((Object)item);
                }
            }
            this.getModel().updateEntryCache(entryEntities);
            this.getView().updateView("entryentity");
            int startRowIndex = (pageIndex - 1) * pageRows;
            GaiMonitorAPILogFormPlugin.this.getPageCache().put("current_page_number", String.valueOf(pageIndex));
            GaiMonitorAPILogFormPlugin.this.getPageCache().put("page_row", String.valueOf(pageRows));
            dataEntity.getDataEntityState().setEntryStartRowIndex(this.getKey(), startRowIndex);
            dataEntity.getDataEntityState().setEntryPageSize(this.getKey(), pageRows);
            dataEntity.getDataEntityState().setEntryRowCount(this.getKey(), count);
            return true;
        }

        protected Map<String, Object> queryLLMCallData(List<QFilter> filterList, int pageIndex, int pageRows) {
            QFilter[] filters = filterList.toArray(new QFilter[filterList.size()]);
            HashMap<String, Object> data = new HashMap<String, Object>(0);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gai_api_detail", (String)" billno,apiinfo,errcode,cost,createtime ", (QFilter[])filters, (String)"createtime desc");
            String sql = "select billno,apiinfo,errcode,cost,createtime ";
            dataSet = dataSet.executeSql(sql);
            GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"apiinfo"});
            groupbyDataSet = groupbyDataSet.sum("1", "total_count");
            groupbyDataSet = groupbyDataSet.avg("cost", "avg_time");
            DataSet llmDataSet = groupbyDataSet.finish();
            Iterator iterable = llmDataSet.iterator();
            ArrayList listDatas = new ArrayList(0);
            int allCount = 0;
            BigDecimal allLatency = new BigDecimal(0);
            while (iterable.hasNext()) {
                Row rowData = (Row)iterable.next();
                long apiId = rowData.getLong("apiinfo");
                int total = rowData.getInteger("total_count");
                filterList.add(new QFilter("apiinfo", "=", (Object)apiId));
                int failCount = GaiMonitorAPILogFormPlugin.this.queryFailCount(filterList.toArray(new QFilter[filterList.size()]));
                filterList.remove(filterList.size() - 1);
                allCount += total;
                BigDecimal avgCost = rowData.getBigDecimal("avg_time");
                allLatency = allLatency.add(avgCost);
                HashMap<String, Object> row = new HashMap<String, Object>(3);
                row.put("apiId", apiId + "");
                row.put("callCount", total);
                row.put("failCount", failCount);
                row.put("avgCost", avgCost);
                listDatas.add(row);
            }
            int count = GaiMonitorAPILogFormPlugin.this.queryTotalCount(filters);
            data.put("count", count);
            data.put("list", listDatas);
            data.put("allCount", allCount);
            BigDecimal avg = new BigDecimal(0);
            if (count != 0) {
                avg = allLatency.divide(new BigDecimal(count), 0, 4);
            }
            data.put("allAvgLatency", avg);
            int failCountTotal = GaiMonitorAPILogFormPlugin.this.queryFailCount(filters);
            data.put("failCount", failCountTotal);
            return data;
        }
    }
}

