/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.trace;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class GaiMonitorLLMLogDetailFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(GaiMonitorLLMLogDetailFormPlugin.class);
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String LLM_SERVICE_CHACHE_KEY = "llm_service_cache";
    private static final String CONTROL_SESSION_COLUMN_NAME = "sessionid";
    private static final String LLM_SERVICE_NUMBER_CHACHE_KEY = "llm_service_number_cache";
    private static final String QUERY_TOOL_BAR = "toolbarap";

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{ENTRY_ENTITY});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        LLMDetailGridControl gridControl = (LLMDetailGridControl)this.getControl(ENTRY_ENTITY);
        gridControl.addHyperClickListener(this);
        this.addItemClickListeners(new String[]{QUERY_TOOL_BAR});
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String entryKey = e.getKey();
        if (entryKey.equalsIgnoreCase(ENTRY_ENTITY)) {
            Control oldGrid = e.getControl();
            if (oldGrid == null) {
                return;
            }
            LLMDetailGridControl newCustGrid = oldGrid instanceof LLMDetailGridControl ? (LLMDetailGridControl)oldGrid : new LLMDetailGridControl();
            newCustGrid.setView(this.getView());
            newCustGrid.setKey(entryKey);
            newCustGrid.setEntryKey(entryKey);
            newCustGrid.setSplitPage(true);
            if (oldGrid instanceof EntryGrid) {
                if (newCustGrid.getItems().isEmpty()) {
                    newCustGrid.getItems().addAll(((EntryGrid)oldGrid).getItems());
                }
                newCustGrid.setPageRow(((EntryGrid)oldGrid).getPageRow());
            }
            e.setControl((Control)newCustGrid);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List<Map<String, String>> list = this.queryLLMServices();
        Map<String, String> serviceData = this.transformLLMServices(list);
        this.getPageCache().put(LLM_SERVICE_CHACHE_KEY, JSONObject.toJSONString(serviceData));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String serviceNumber = (String)formShowParameter.getCustomParam("serviceNumber");
        logger.info("serviceNumber:{}", (Object)serviceNumber);
        this.getPageCache().put(LLM_SERVICE_NUMBER_CHACHE_KEY, serviceNumber);
        EntryGrid entry = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entry.setPageRows(entry.getPageRow());
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if (StringUtils.equalsIgnoreCase((CharSequence)CONTROL_SESSION_COLUMN_NAME, (CharSequence)fieldName)) {
            int pageRows;
            int pageIndex;
            int realIndex;
            int row = hyperLinkClickEvent.getRowIndex();
            DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRY_ENTITY);
            DynamicObject rowData = (DynamicObject)collection.get(realIndex = row - ((pageIndex = Integer.parseInt(this.getPageCache().get("current_page_number"))) - 1) * (pageRows = Integer.parseInt(this.getPageCache().get("page_row"))));
            if (rowData != null) {
                String sessionId = rowData.getString(CONTROL_SESSION_COLUMN_NAME);
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("gai_log_view");
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.setCustomParam("id", (Object)Long.parseLong(sessionId));
                showParameter.setCustomParam("origin", (Object)"session");
                showParameter.setCaption(String.format("\u4f1a\u8bdd\u8be6\u60c5-%s", sessionId));
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(showParameter);
            }
        }
    }

    private int queryTotalCount(QFilter[] filters) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gai_log", (String)" entryentity.stepid,entryentity.modelname,entryentity.steptype,createtime ", (QFilter[])filters, (String)"createtime desc");
        String sql = "select entryentity.stepid,entryentity.modelname,entryentity.steptype";
        DataSet llmDataSet = dataSet.executeSql(sql);
        int count = llmDataSet.count("entryentity.stepid", false);
        return count;
    }

    private List<Map<String, String>> queryLLMServices() {
        ArrayList<Map<String, String>> datas = new ArrayList<Map<String, String>>();
        QFilter[] filters = new QFilter[2];
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        filters[0] = status;
        filters[1] = enable;
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)"aicc_service", (String)"id,number,name,status,enable", (QFilter[])filters);
        if (collection != null && collection.length > 0) {
            for (DynamicObject service : collection) {
                String number = service.getString("number");
                String name = service.getString("name");
                HashMap<String, String> ser = new HashMap<String, String>();
                ser.put("name", name);
                ser.put("number", number);
                datas.add(ser);
            }
        }
        return datas;
    }

    private Map<String, String> transformLLMServices(List<Map<String, String>> list) {
        HashMap<String, String> data = new HashMap<String, String>(0);
        if (list != null && !list.isEmpty()) {
            for (Map<String, String> service : list) {
                String number = service.get("number");
                String name = service.get("name");
                data.put(number, name);
            }
        }
        return data;
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "barrefresh": {
                this.refresh();
            }
        }
    }

    private void refresh() {
        this.getView().updateView(ENTRY_ENTITY);
    }

    class LLMDetailGridControl
    extends EntryGrid {
        private static final String ENTRY_ENTITY = "entryentity";

        LLMDetailGridControl() {
        }

        protected boolean onFetchPageData(int pageIndex, int pageRows) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection(this.getKey());
            entryEntities.clear();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(0);
            QFilter step = new QFilter("entryentity.steptype", "=", (Object)"generation");
            qFilters.add(step);
            String serviceNumber = GaiMonitorLLMLogDetailFormPlugin.this.getPageCache().get(GaiMonitorLLMLogDetailFormPlugin.LLM_SERVICE_NUMBER_CHACHE_KEY);
            if (!StringUtils.isEmpty((CharSequence)serviceNumber)) {
                QFilter numberFilter = new QFilter("entryentity.modelname", "=", (Object)serviceNumber);
                qFilters.add(numberFilter);
            }
            QFilter[] filters = qFilters.toArray(new QFilter[qFilters.size()]);
            Map<String, Object> res = this.queryLLMCallData(filters, pageIndex, pageRows);
            int count = (Integer)res.get("count");
            List list = (List)res.get("list");
            DynamicObjectType dynamicObjectType = this.getModel().getEntryEntity("entryentity").getDynamicObjectType();
            if (list != null && !list.isEmpty()) {
                IPageCache pageCache = GaiMonitorLLMLogDetailFormPlugin.this.getPageCache();
                String serviceCache = pageCache.get(GaiMonitorLLMLogDetailFormPlugin.LLM_SERVICE_CHACHE_KEY);
                Map serviceData = (Map)JSONObject.parseObject((String)serviceCache, Map.class);
                for (Map data : list) {
                    Date firstTokenTime;
                    String modelName = (String)data.get("modelName");
                    DynamicObject item = new DynamicObject(dynamicObjectType);
                    item.set("llm_service_number", (Object)modelName);
                    if (serviceData != null) {
                        if (StringUtils.isEmpty((CharSequence)((CharSequence)serviceData.get(modelName)))) {
                            item.set("llm_service_name", (Object)modelName);
                        } else {
                            item.set("llm_service_name", serviceData.get(modelName));
                        }
                    }
                    Long stepId = (Long)data.get("stepId");
                    BigDecimal latency = data.get("latency") == null ? new BigDecimal(0) : (BigDecimal)data.get("latency");
                    Date createTime = data.get("createTime") == null ? null : (Date)data.get("createTime");
                    Long sessionId = data.get("sessionId") == null ? Long.valueOf(0L) : (Long)data.get("sessionId");
                    String errorCode = data.get("errorCode") == null ? null : (String)data.get("errorCode");
                    Date date = firstTokenTime = data.get("firstTokenTime") == null ? null : (Date)data.get("firstTokenTime");
                    if (firstTokenTime != null && createTime != null) {
                        long firstLatency = firstTokenTime.getTime() - createTime.getTime();
                        BigDecimal bd = new BigDecimal(firstLatency);
                        item.set("firsttokenlatency", (Object)bd);
                    }
                    item.set("stepid", (Object)String.valueOf(stepId));
                    item.set("createtime", (Object)createTime);
                    item.set("calllatency", (Object)latency);
                    item.set(GaiMonitorLLMLogDetailFormPlugin.CONTROL_SESSION_COLUMN_NAME, (Object)String.valueOf(sessionId));
                    if (!StringUtils.equalsIgnoreCase((CharSequence)errorCode, (CharSequence)"0")) {
                        item.set("status", (Object)"\u5931\u8d25");
                    } else {
                        item.set("status", (Object)"\u6210\u529f");
                    }
                    entryEntities.add((Object)item);
                }
            }
            this.getModel().updateEntryCache(entryEntities);
            this.getView().updateView("entryentity");
            int startRowIndex = (pageIndex - 1) * pageRows;
            GaiMonitorLLMLogDetailFormPlugin.this.getPageCache().put("current_page_number", String.valueOf(pageIndex));
            GaiMonitorLLMLogDetailFormPlugin.this.getPageCache().put("page_row", String.valueOf(pageRows));
            dataEntity.getDataEntityState().setEntryStartRowIndex(this.getKey(), startRowIndex);
            dataEntity.getDataEntityState().setEntryPageSize(this.getKey(), pageRows);
            dataEntity.getDataEntityState().setEntryRowCount(this.getKey(), count);
            return true;
        }

        protected Map<String, Object> queryLLMCallData(QFilter[] filters, int pageIndex, int pageRows) {
            HashMap<String, Object> data = new HashMap<String, Object>(0);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gai_log", (String)" sessionid,entryentity.firsttokentime,entryentity.errorcode,entryentity.step_traceid,entryentity.stepid,entryentity.modelname,entryentity.latency,entryentity.steptype,entryentity.step_createtime,entryentity.stepbegintime,createtime ", (QFilter[])filters, (String)"entryentity.step_createtime desc");
            String sql = "select sessionid,entryentity.firsttokentime,entryentity.errorcode,entryentity.step_traceid,entryentity.stepid,entryentity.modelname,entryentity.latency,entryentity.steptype,entryentity.step_createtime,entryentity.stepbegintime";
            DataSet llmDataSet = dataSet.limit((pageIndex - 1) * pageRows, pageRows).orderBy(new String[]{"entryentity.step_createtime desc"}).executeSql(sql);
            Iterator iterable = llmDataSet.iterator();
            ArrayList listDatas = new ArrayList(0);
            while (iterable.hasNext()) {
                Row rowData = (Row)iterable.next();
                String modelName = rowData.getString("entryentity.modelname");
                HashMap<String, Object> row = new HashMap<String, Object>(3);
                row.put("modelName", modelName);
                row.put("stepId", rowData.getLong("entryentity.stepid"));
                row.put("latency", rowData.getBigDecimal("entryentity.latency"));
                row.put("createTime", rowData.getDate("entryentity.stepbegintime"));
                row.put("sessionId", rowData.getLong(GaiMonitorLLMLogDetailFormPlugin.CONTROL_SESSION_COLUMN_NAME));
                row.put("traceId", rowData.getLong("entryentity.step_traceid"));
                row.put("errorCode", rowData.getString("entryentity.errorcode"));
                row.put("firstTokenTime", rowData.getDate("entryentity.firsttokentime"));
                listDatas.add(row);
            }
            int count = GaiMonitorLLMLogDetailFormPlugin.this.queryTotalCount(filters);
            data.put("count", count);
            data.put("list", listDatas);
            return data;
        }
    }
}

