/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.trace;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class GaiMonitorLLMLogFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(GaiMonitorLLMLogFormPlugin.class);
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String LLM_SERVICE_CHACHE_KEY = "llm_service_cache";
    private static final String CONTROL_DATE_RANGE = "daterange";
    private static final String CONTROL_SERVICE_NUMBER_COLUMN_NAME = "llm_service_number";
    private static final String GAI_LOG_LLM_ANA_DETAIL_FORM = "gai_log_llm_ana_detail";
    private static final String DATE_RANGE_START = "daterange_startdate";
    private static final String DATE_RANGE_END = "daterange_enddate";
    private static final String START_DATE_CACHE = "start_date_cache";
    private static final String END_DATE_CACHE = "end_date_cache";
    public static final String BTN_QUERY = "barquery";
    private static final String QUERY_TOOL_BAR = "querytoolbarap";

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{ENTRY_ENTITY});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TraceLLMGridControl gridControl = (TraceLLMGridControl)this.getControl(ENTRY_ENTITY);
        gridControl.addHyperClickListener(this);
        this.addItemClickListeners(new String[]{QUERY_TOOL_BAR});
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String entryKey = e.getKey();
        if (entryKey.equalsIgnoreCase(ENTRY_ENTITY)) {
            Control oldGrid = e.getControl();
            if (oldGrid == null) {
                return;
            }
            TraceLLMGridControl newCustGrid = oldGrid instanceof TraceLLMGridControl ? (TraceLLMGridControl)oldGrid : new TraceLLMGridControl();
            newCustGrid.setView(this.getView());
            newCustGrid.setKey(entryKey);
            newCustGrid.setEntryKey(entryKey);
            newCustGrid.setSplitPage(false);
            if (oldGrid instanceof EntryGrid) {
                if (newCustGrid.getItems().isEmpty()) {
                    newCustGrid.getItems().addAll(((EntryGrid)oldGrid).getItems());
                }
                newCustGrid.setPageRow(((EntryGrid)oldGrid).getPageRow());
            }
            e.setControl((Control)newCustGrid);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setLast3Month(3);
        List<Map<String, String>> list = this.queryLLMServices();
        Map<String, String> serviceData = this.transformLLMServices(list);
        this.getPageCache().put(LLM_SERVICE_CHACHE_KEY, JSONObject.toJSONString(serviceData));
        EntryGrid entry = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entry.setPageRows(entry.getPageRow());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private void setLast3Month(int month) {
        DateRangeEdit edit = (DateRangeEdit)this.getControl(CONTROL_DATE_RANGE);
        String startKey = edit.getStartDateFieldKey();
        String endKey = edit.getEndDateFieldKey();
        LocalDate current = LocalDate.now();
        LocalDate threeMonths = current.minusMonths(month);
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zonedDateTimeStart = threeMonths.atStartOfDay(zoneId);
        ZonedDateTime zonedDateTimeEnd = current.atStartOfDay(zoneId);
        Date startDate = Date.from(zonedDateTimeStart.toInstant());
        Date endDate = Date.from(zonedDateTimeEnd.toInstant());
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            endDate = sdf.parse(String.format("%s 23:59:59", sdfDate.format(endDate)));
        }
        catch (ParseException e) {
            logger.info("");
        }
        this.getModel().setValue(startKey, (Object)startDate);
        this.getModel().setValue(endKey, (Object)endDate);
        String start = sdf.format(startDate);
        String end = sdf.format(endDate);
        this.getPageCache().put(START_DATE_CACHE, start);
        this.getPageCache().put(END_DATE_CACHE, end);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if (StringUtils.equalsIgnoreCase((CharSequence)CONTROL_SERVICE_NUMBER_COLUMN_NAME, (CharSequence)fieldName)) {
            int pageRows;
            int pageIndex;
            int realIndex;
            int row = hyperLinkClickEvent.getRowIndex();
            DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRY_ENTITY);
            DynamicObject rowData = (DynamicObject)collection.get(realIndex = row - ((pageIndex = Integer.parseInt(this.getPageCache().get("current_page_number"))) - 1) * (pageRows = Integer.parseInt(this.getPageCache().get("page_row"))));
            if (rowData != null) {
                String serviceNumber = rowData.getString(CONTROL_SERVICE_NUMBER_COLUMN_NAME);
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId(GAI_LOG_LLM_ANA_DETAIL_FORM);
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.setCustomParam("serviceNumber", (Object)serviceNumber);
                showParameter.setCaption(String.format("\u8c03\u7528\u660e\u7ec6-%s", serviceNumber));
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(showParameter);
            }
        }
    }

    private int queryTotalCount(QFilter[] filters) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gai_log", (String)" entryentity.modelname,createtime ", (QFilter[])filters, (String)"createtime desc");
        String sql = "select entryentity.modelname";
        GroupbyDataSet groupbyDataSet = dataSet.executeSql(sql).groupBy(new String[]{"entryentity.modelname"});
        DataSet llmDataSet = groupbyDataSet.finish();
        int count = llmDataSet.count("entryentity.modelname", false);
        return count;
    }

    private int queryFailCount(QFilter[] filters) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gai_log", (String)" entryentity.errorcode,entryentity.modelname,createtime ", (QFilter[])filters, (String)"createtime desc");
        String sql = "select entryentity.errorcode,entryentity.modelname";
        DataSet resDataSet = dataSet.executeSql(sql).where("entryentity.errorcode != '0'");
        int count = resDataSet.count("entryentity.modelname", false);
        return count;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)DATE_RANGE_START)) {
            DateRangeEdit edit = (DateRangeEdit)this.getControl(CONTROL_DATE_RANGE);
            String startKey = edit.getStartDateFieldKey();
            Date startDate = (Date)this.getModel().getValue(startKey);
            String start = sdf.format(startDate);
            this.getPageCache().put(START_DATE_CACHE, start);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)DATE_RANGE_END)) {
            DateRangeEdit edit = (DateRangeEdit)this.getControl(CONTROL_DATE_RANGE);
            String endKey = edit.getEndDateFieldKey();
            Date endDate = (Date)this.getModel().getValue(endKey);
            String end = sdf.format(endDate);
            this.getPageCache().put(END_DATE_CACHE, end);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "barquery": {
                this.query();
            }
        }
    }

    private void query() {
        DateRangeEdit edit = (DateRangeEdit)this.getControl(CONTROL_DATE_RANGE);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String startKey = edit.getStartDateFieldKey();
        String endKey = edit.getEndDateFieldKey();
        Date endDate = (Date)this.getModel().getValue(endKey);
        Date startDate = (Date)this.getModel().getValue(startKey);
        String start = sdf.format(startDate);
        this.getPageCache().put(START_DATE_CACHE, start);
        String end = sdf.format(endDate);
        this.getPageCache().put(END_DATE_CACHE, end);
        TraceLLMGridControl entry = (TraceLLMGridControl)this.getView().getControl(ENTRY_ENTITY);
        int pageRow = entry.getPageRow();
        entry.onFetchPageData(1, pageRow);
    }

    private List<Map<String, String>> queryLLMServices() {
        ArrayList<Map<String, String>> datas = new ArrayList<Map<String, String>>();
        QFilter[] filters = new QFilter[2];
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        filters[0] = status;
        filters[1] = enable;
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)"aicc_service", (String)"id,number,name,status,enable", (QFilter[])filters);
        if (collection != null && collection.length > 0) {
            for (DynamicObject service : collection) {
                String number = service.getString("number");
                String name = service.getString("name");
                HashMap<String, String> ser = new HashMap<String, String>();
                ser.put("name", name);
                ser.put("number", number);
                datas.add(ser);
            }
        }
        return datas;
    }

    private Map<String, String> transformLLMServices(List<Map<String, String>> list) {
        HashMap<String, String> data = new HashMap<String, String>(0);
        if (list != null && !list.isEmpty()) {
            for (Map<String, String> service : list) {
                String number = service.get("number");
                String name = service.get("name");
                data.put(number, name);
            }
        }
        return data;
    }

    class TraceLLMGridControl
    extends EntryGrid {
        private static final String ENTRY_ENTITY = "entryentity";

        TraceLLMGridControl() {
        }

        protected boolean onFetchPageData(int pageIndex, int pageRows) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection(this.getKey());
            entryEntities.clear();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(0);
            Date startDate = null;
            Date endDate = null;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String startDateCache = GaiMonitorLLMLogFormPlugin.this.getPageCache().get(GaiMonitorLLMLogFormPlugin.START_DATE_CACHE);
            String endDateCache = GaiMonitorLLMLogFormPlugin.this.getPageCache().get(GaiMonitorLLMLogFormPlugin.END_DATE_CACHE);
            if (!StringUtils.isEmpty((CharSequence)startDateCache)) {
                try {
                    startDate = sdf.parse(startDateCache);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (!StringUtils.isEmpty((CharSequence)endDateCache)) {
                try {
                    endDate = sdf.parse(endDateCache);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (startDate != null) {
                QFilter start = new QFilter("entryentity.step_createtime", ">=", (Object)startDate);
                qFilters.add(start);
            }
            if (endDate != null) {
                QFilter end = new QFilter("entryentity.step_createtime", "<=", (Object)endDate);
                qFilters.add(end);
            }
            QFilter step = new QFilter("entryentity.steptype", "=", (Object)"generation");
            qFilters.add(step);
            QFilter[] filters = qFilters.toArray(new QFilter[qFilters.size()]);
            Map<String, Object> res = this.queryLLMCallData(filters, pageIndex, pageRows);
            int count = (Integer)res.get("count");
            int allCount = (Integer)res.get("allCount");
            int totalToken = (Integer)res.get("totalToken");
            int failCount = (Integer)res.get("failCount");
            DecimalFormat df = new DecimalFormat("#,###");
            BigDecimal allAvgLatency = (BigDecimal)res.get("allAvgLatency");
            Label allCountLabel = (Label)GaiMonitorLLMLogFormPlugin.this.getControl("llmtotal_count");
            allCountLabel.setText(df.format(allCount));
            Label avgLatencyLabel = (Label)GaiMonitorLLMLogFormPlugin.this.getControl("llm_avg_time");
            avgLatencyLabel.setText(df.format(allAvgLatency) + "ms");
            Label totalTokenLabel = (Label)GaiMonitorLLMLogFormPlugin.this.getControl("llm_token_total");
            totalTokenLabel.setText(df.format(totalToken));
            Label failCountLabel = (Label)GaiMonitorLLMLogFormPlugin.this.getControl("llmfail_count");
            failCountLabel.setText(df.format(failCount));
            List list = (List)res.get("list");
            DynamicObjectType dynamicObjectType = this.getModel().getEntryEntity("entryentity").getDynamicObjectType();
            if (list != null && !list.isEmpty()) {
                IPageCache pageCache = GaiMonitorLLMLogFormPlugin.this.getPageCache();
                String serviceCache = pageCache.get(GaiMonitorLLMLogFormPlugin.LLM_SERVICE_CHACHE_KEY);
                Map serviceData = (Map)JSONObject.parseObject((String)serviceCache, Map.class);
                for (Map data : list) {
                    String modelName = (String)data.get("modelName");
                    int total = (Integer)data.get("callCount");
                    int token = (Integer)data.get("token");
                    BigDecimal avgLatency = (BigDecimal)data.get("avgLatency");
                    DynamicObject item = new DynamicObject(dynamicObjectType);
                    item.set(GaiMonitorLLMLogFormPlugin.CONTROL_SERVICE_NUMBER_COLUMN_NAME, (Object)modelName);
                    item.set("llm_total_call_count", (Object)total);
                    item.set("llm_ava_call_time", (Object)avgLatency);
                    item.set("llm_total_token_count", (Object)token);
                    if (serviceData != null) {
                        if (StringUtils.isEmpty((CharSequence)((CharSequence)serviceData.get(modelName)))) {
                            item.set("llm_service_name", (Object)modelName);
                        } else {
                            item.set("llm_service_name", serviceData.get(modelName));
                        }
                    }
                    entryEntities.add((Object)item);
                }
            }
            this.getModel().updateEntryCache(entryEntities);
            this.getView().updateView("entryentity");
            int startRowIndex = (pageIndex - 1) * pageRows;
            GaiMonitorLLMLogFormPlugin.this.getPageCache().put("current_page_number", String.valueOf(pageIndex));
            GaiMonitorLLMLogFormPlugin.this.getPageCache().put("page_row", String.valueOf(pageRows));
            dataEntity.getDataEntityState().setEntryStartRowIndex(this.getKey(), startRowIndex);
            dataEntity.getDataEntityState().setEntryPageSize(this.getKey(), pageRows);
            dataEntity.getDataEntityState().setEntryRowCount(this.getKey(), count);
            return true;
        }

        protected Map<String, Object> queryLLMCallData(QFilter[] filters, int pageIndex, int pageRows) {
            HashMap<String, Object> data = new HashMap<String, Object>(0);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gai_log", (String)" entryentity.totaltoken,entryentity.modelname,entryentity.latency,entryentity.steptype,entryentity.step_createtime,createtime ", (QFilter[])filters, (String)"createtime desc");
            String sql = "select entryentity.totaltoken,entryentity.modelname,entryentity.latency,entryentity.steptype,entryentity.step_createtime";
            dataSet = dataSet.executeSql(sql);
            GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"entryentity.modelname"});
            groupbyDataSet = groupbyDataSet.sum("1", "total_count");
            groupbyDataSet = groupbyDataSet.avg("entryentity.latency", "avg_time");
            groupbyDataSet = groupbyDataSet.sum("entryentity.totaltoken", "token");
            DataSet llmDataSet = groupbyDataSet.finish();
            Iterator iterable = llmDataSet.iterator();
            ArrayList listDatas = new ArrayList(0);
            int allCount = 0;
            BigDecimal allLatency = new BigDecimal(0);
            int totalToken = 0;
            while (iterable.hasNext()) {
                Row rowData = (Row)iterable.next();
                String modelName = rowData.getString("entryentity.modelname");
                int total = rowData.getInteger("total_count");
                int token = rowData.getInteger("token");
                allCount += total;
                totalToken += token;
                BigDecimal avgLatency = rowData.getBigDecimal("avg_time");
                allLatency = allLatency.add(avgLatency);
                HashMap<String, Object> row = new HashMap<String, Object>(3);
                row.put("modelName", modelName);
                row.put("token", token);
                row.put("callCount", total);
                row.put("avgLatency", avgLatency);
                listDatas.add(row);
            }
            int count = GaiMonitorLLMLogFormPlugin.this.queryTotalCount(filters);
            data.put("count", count);
            data.put("list", listDatas);
            data.put("allCount", allCount);
            BigDecimal avg = new BigDecimal(0);
            if (count != 0) {
                avg = allLatency.divide(new BigDecimal(count), 0, 4);
            }
            data.put("allAvgLatency", avg);
            data.put("totalToken", totalToken);
            int failCount = GaiMonitorLLMLogFormPlugin.this.queryFailCount(filters);
            data.put("failCount", failCount);
            return data;
        }
    }
}

