/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.trace;

import java.util.ArrayList;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class GaiUserFeedBackPlugin
extends AbstractListPlugin {
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new FeedBackDataProvider());
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if ("chatsessionid".equals(fieldName)) {
            HyperLinkClickEvent clickEvent = args.getHyperLinkClickEvent();
            BillList billList = (BillList)clickEvent.getSource();
            ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
            long pkId = (Long)selectedRow.getPrimaryKeyValue();
            DynamicObject rowData = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"gai_chat_msg_feedback");
            if (rowData != null) {
                String chatSessionId = rowData.getString("chatsessionid");
                QFilter qFilter = new QFilter("chatsessionid", "=", (Object)chatSessionId);
                DynamicObject logDynamicObject = BusinessDataServiceHelper.loadSingle((String)"gai_log", (QFilter[])qFilter.toArray());
                if (logDynamicObject == null) {
                    throw new KDBizException("\u6ca1\u6709\u5bf9\u5e94\u7684chatsessionid");
                }
                String sessionId = logDynamicObject.getString("sessionid");
                long session = Long.parseLong(sessionId);
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("gai_log_view");
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.setCustomParam("id", (Object)session);
                showParameter.setCustomParam("chatSessionId", (Object)chatSessionId);
                showParameter.setCustomParam("origin", (Object)"session");
                showParameter.setCaption(String.format("\u4f1a\u8bdd\u8be6\u60c5-%s", chatSessionId.substring(0, 8)));
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(showParameter);
            }
            args.setCancel(true);
        }
    }

    public static class FeedBackDataProvider
    extends ListDataProvider {
        public DynamicObjectCollection getData(int start, int limit) {
            List QFilters = this.getQFilters();
            ArrayList<QFilter> newFilterList = new ArrayList<QFilter>(5);
            ArrayList<String> assistantIds = new ArrayList<String>();
            block6: for (QFilter qFilters : QFilters) {
                String properties;
                switch (properties = qFilters.getProperty()) {
                    case "assistantid": {
                        DynamicObject[] assistantCollection;
                        String assistantProperties = "id,name";
                        qFilters.setProperty("name");
                        for (DynamicObject assistantDynamicObject : assistantCollection = BusinessDataServiceHelper.load((String)"gai_gpt_assistant_config", (String)assistantProperties, (QFilter[])qFilters.toArray())) {
                            String id = assistantDynamicObject.getString("id");
                            String assistantName = assistantDynamicObject.getString("name");
                            assistantIds.add(id);
                        }
                        continue block6;
                    }
                    default: {
                        newFilterList.add(qFilters);
                    }
                }
            }
            this.getQFilters().clear();
            if (assistantIds.size() != 0) {
                QFilter agentQfilter = new QFilter("assistantid", "in", assistantIds);
                newFilterList.add(agentQfilter);
            }
            this.setQFilters(newFilterList);
            DynamicObjectCollection rows = super.getData(start, limit);
            for (DynamicObject childDynamicObject : rows) {
                String assistantId = childDynamicObject.getString("assistantid");
                if (StringUtils.isNotEmpty((CharSequence)assistantId)) {
                    long assistantInt = Long.parseLong(assistantId);
                    QFilter assistantQFilter = new QFilter("id", "=", (Object)assistantInt);
                    DynamicObject assistantDynamic = BusinessDataServiceHelper.loadSingle((String)"gai_gpt_assistant_config", (QFilter[])assistantQFilter.toArray());
                    if (assistantDynamic != null) {
                        String assistantName = assistantDynamic.getString("name");
                        childDynamicObject.set("assistantid", (Object)assistantName);
                        continue;
                    }
                    childDynamicObject.set("assistantid", (Object)"");
                    continue;
                }
                childDynamicObject.set("assistantid", (Object)"");
            }
            this.getQueryResult().setNumberFormatProvider(new NumberFormatProvider(new ArrayList(), rows));
            return rows;
        }
    }
}

