/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;

public class PopAppUtils {
    public static boolean formListOpened(String formId, String billFormId, IFormView iFormView, String bizAppId) {
        List appMenuInfos = AppMetadataCache.getAppMenusInfoByAppId((String)bizAppId);
        Optional<AppMenuInfo> menuOptional = appMenuInfos.stream().filter(appMenuInfo -> formId.equals(appMenuInfo.getFormId()) && "ListShowParameter".equals(appMenuInfo.getParamType())).findFirst();
        String menuId = null;
        if (menuOptional.isPresent()) {
            menuId = menuOptional.get().getId();
        }
        String appId = AppMetadataCache.getAppInfo((String)bizAppId).getAppId();
        IFormView mainView = iFormView.getMainView();
        if (mainView == null) {
            return false;
        }
        String mainViewPageId = mainView.getPageId();
        String mainPageId = appId + mainViewPageId;
        String billPageId = menuId + mainViewPageId;
        return null != mainView.getViewNoPlugin(billPageId);
    }

    public static void openFormList(String formId, String billFormId, IFormView iFormView, String bizAppId, ShowType showType) {
        List appMenuInfos = AppMetadataCache.getAppMenusInfoByAppId((String)bizAppId);
        Optional<AppMenuInfo> menuOptional = appMenuInfos.stream().filter(appMenuInfo -> formId.equals(appMenuInfo.getFormId()) && "ListShowParameter".equals(appMenuInfo.getParamType())).findFirst();
        String menuId = null;
        if (menuOptional.isPresent()) {
            menuId = menuOptional.get().getId();
        }
        String appId = AppMetadataCache.getAppInfo((String)bizAppId).getAppId();
        IFormView mainView = iFormView.getMainView();
        if (mainView == null) {
            return;
        }
        String mainViewPageId = mainView.getPageId();
        String mainPageId = appId + mainViewPageId;
        String billPageId = menuId + mainViewPageId;
        if (null != mainView.getViewNoPlugin(billPageId)) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
            hashMap.put("view", iFormView);
            hashMap.put("formnumber", billFormId);
            hashMap.put("parametertype", "ListShowParameter");
            PopAppUtils.activatePage(billPageId, iFormView, hashMap);
        } else {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setFormId(formId);
            listShowParameter.setBillFormId(billFormId);
            listShowParameter.getOpenStyle().setShowType(showType);
            listShowParameter.setHasRight(true);
            listShowParameter.setAppId(appId);
            listShowParameter.setCustomParam("billFormId", (Object)formId);
            listShowParameter.setCustomParam("appid", (Object)appId);
            listShowParameter.setParentPageId(mainPageId);
            listShowParameter.setCustomParam("type", (Object)"list");
            listShowParameter.getOpenStyle().setTargetKey("_submaintab_");
            listShowParameter.setPageId(billPageId);
            IFormView view = iFormView.getView(mainPageId);
            view.showForm((FormShowParameter)listShowParameter);
            iFormView.sendFormAction(view);
        }
    }

    public static void activatePage(String pageID, IFormView view, Map<String, Object> customParams) {
        IFormView childView = view.getViewNoPlugin(pageID);
        if ("bos".equals(childView.getFormShowParameter().getServiceAppId())) {
            childView = view.getView(pageID);
        }
        if (childView != null) {
            if (!view.getPageId().equalsIgnoreCase(childView.getPageId())) {
                HashMap customparameters = (HashMap)customParams.get("customparameters");
                childView.getFormShowParameter().getCustomParams().remove("messageId");
                childView.getFormShowParameter().getCustomParams().remove("tabType");
                childView.getFormShowParameter().getCustomParams().remove("openPage");
                if (customparameters != null) {
                    if (customparameters.get("messageId") != null) {
                        childView.getFormShowParameter().setCustomParam("messageId", customparameters.get("messageId"));
                    }
                    if (customparameters.get("tabType") != null) {
                        childView.getFormShowParameter().setCustomParam("tabType", customparameters.get("tabType"));
                    }
                    if (customparameters.get("openPage") != null) {
                        childView.getFormShowParameter().setCustomParam("openPage", customparameters.get("openPage"));
                    }
                }
                childView.getFormShowParameter().setHasRight(true);
                childView.activate();
                if ("bos".equals(childView.getFormShowParameter().getServiceAppId())) {
                    childView.updateView();
                }
                view.sendFormAction(childView);
            }
        } else {
            view.showTipNotification("\u7cfb\u7edf\u5df2\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u767b\u5f55!");
        }
    }

    public static void showFormOnlyOnce(IFormView formView, String formId, String caption, Map<String, Object> customParams, Object pkValue) {
        String billPageId;
        IFormView mainView = formView.getMainView();
        String mainViewPageId = mainView.getPageId();
        String appNumber = "gai";
        String appPageId = appNumber + mainViewPageId;
        String appId = AppMetadataCache.getAppInfo((String)appNumber).getAppId();
        if (customParams == null) {
            customParams = new HashMap<String, Object>();
        }
        List appMenuInfos = AppMetadataCache.getAppMenusInfoByAppId((String)appId);
        Optional<AppMenuInfo> first = appMenuInfos.stream().filter(appMenuInfo -> formId.equals(appMenuInfo.getFormId()) && "FormShowParameter".equals(appMenuInfo.getParamType())).findFirst();
        String menuId = formId;
        if (first.isPresent()) {
            menuId = first.get().getId();
        }
        if (null != mainView.getViewNoPlugin(billPageId = menuId + mainViewPageId + pkValue)) {
            customParams.put("view", formView);
            if (StringUtils.isNotEmpty((CharSequence)caption)) {
                customParams.put("appname", caption);
            }
            customParams.put("formnumber", formId);
            customParams.put("parametertype", "FormShowParameter");
            PopAppUtils.activatePage(billPageId, formView, customParams);
        } else if ("gai_tool".equals(formId)) {
            BillShowParameter bsp = new BillShowParameter();
            bsp.setPkId(pkValue);
            bsp.setFormId("gai_tool");
            bsp.setCaption(caption);
            bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            bsp.getOpenStyle().setTargetKey("_submaintab_");
            bsp.setStatus(OperationStatus.EDIT);
            bsp.setPageId(billPageId);
            IFormView appFormView = formView.getView(appPageId);
            if (appFormView != null) {
                appFormView.showForm((FormShowParameter)bsp);
                formView.sendFormAction(appFormView);
            }
        } else {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(formId);
            formShowParameter.setAppId(appId);
            if (StringUtils.isNotEmpty((CharSequence)caption)) {
                formShowParameter.setCaption(caption);
            }
            customParams.put("appid", appId);
            formShowParameter.setCustomParams(customParams);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
            formShowParameter.setPageId(billPageId);
            IFormView appFormView = formView.getView(appPageId);
            if (appFormView != null) {
                appFormView.showForm(formShowParameter);
                formView.sendFormAction(appFormView);
            }
        }
    }
}

