/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.vision;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.ai.gai.core.enuz.flow.TemplateTypeCodeEnum;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.DispatchServiceHelper;

public class VisionBusinessObjectPlugin
extends AbstractFormPlugin
implements ItemClickListener,
SearchEnterListener {
    private static final String SEARCH = "searchap";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String BUSINESS_OBJECT_NAME = "businessobjectname";
    private static final String BUSINESS_OBJECT_NUMBER = "businessobjectnumber";
    private static final String MAP_ID = "mapid";
    private static final String NEW_BUSINESS_OBJECT = "newbusinessobject";
    private static final String TEMPLATE_ID = "templateid";
    private static final String TEMPLATE_TYPE = "templatetype";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String BACK_FILL_BILL_DATA = "backFillBillData";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button button = (Button)this.getControl("btnok");
        button.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{NEW_BUSINESS_OBJECT});
        Search search = (Search)this.getView().getControl(SEARCH);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object data = formShowParameter.getCustomParam("data");
        Map param = (Map)objectMapper.convertValue(data, Map.class);
        if (param == null || param.isEmpty()) {
            return;
        }
        this.getModel().setValue(TEMPLATE_ID, param.get("templateId"));
        this.getModel().setValue(TEMPLATE_TYPE, param.get("templateType"));
        this.setEntryEntityData(null);
    }

    public void initialize() {
    }

    private void setEntryEntityData(String filterParams) {
        String search = Optional.ofNullable(filterParams).orElse("");
        String templateId = this.getModel().getValue(TEMPLATE_ID).toString();
        String templateType = this.getModel().getValue(TEMPLATE_TYPE).toString();
        String resultStr = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)"AgentFlowService", (String)"getBizObjList", (Object[])new Object[]{templateId, templateType, null});
        Map result = null;
        try {
            result = (Map)objectMapper.readValue(resultStr, Map.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        if (result == null || result.isEmpty() || (Integer)result.get("errorCode") != 0) {
            return;
        }
        List businessObjects = (List)objectMapper.convertValue(((Map)objectMapper.convertValue(result.get("data"), Map.class)).get("list"), List.class);
        List filterBusinessObjects = businessObjects.stream().filter(businessObject -> businessObject.get("name").toString().contains(search) || businessObject.get("number").toString().contains(search)).collect(Collectors.toList());
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        if (filterBusinessObjects.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, filterBusinessObjects.size());
        for (int i = 0; i < filterBusinessObjects.size(); ++i) {
            this.getModel().setValue(BUSINESS_OBJECT_NAME, ((Map)filterBusinessObjects.get(i)).get("name"), i);
            this.getModel().setValue(BUSINESS_OBJECT_NUMBER, ((Map)filterBusinessObjects.get(i)).get("number"), i);
            this.getModel().setValue(MAP_ID, ((Map)filterBusinessObjects.get(i)).get("id"), i);
        }
        this.getView().updateView();
    }

    public void click(EventObject e) {
        super.click(e);
        Control control = (Control)e.getSource();
        if ("btnok".equalsIgnoreCase(control.getKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(entryCurrentRowIndex);
            HashMap<String, Object> returnData = new HashMap<String, Object>(2);
            String name = dynamicObject.get(BUSINESS_OBJECT_NAME).toString();
            String number = dynamicObject.get(BUSINESS_OBJECT_NUMBER).toString();
            long mapid = dynamicObject.getLong(MAP_ID);
            returnData.put(MAP_ID, mapid);
            returnData.put("name", name);
            returnData.put("number", number);
            if (null == name) {
                this.getView().showTipNotification("please select one row of data at least");
            } else {
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            }
        }
        if (NEW_BUSINESS_OBJECT.equalsIgnoreCase(control.getKey())) {
            IFormView view = this.getView();
            BillShowParameter showParameter = new BillShowParameter();
            String templateType = this.getModel().getValue(TEMPLATE_TYPE).toString();
            TemplateTypeCodeEnum typeCodeEnum = TemplateTypeCodeEnum.getEnumByCode((String)templateType);
            String formId = typeCodeEnum.getRelateFormid();
            showParameter.setFormId(formId);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth("1000");
            styleCss.setHeight("600");
            showParameter.getOpenStyle().setInlineStyleCss(styleCss);
            view.showForm((FormShowParameter)showParameter);
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String text = searchEnterEvent.getText();
        this.setEntryEntityData(text);
    }
}

