/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.sidebar.vipknowledge.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import kd.ai.gai.core.domain.vo.ContextData;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.enuz.AttType;
import kd.ai.gai.core.helper.GptPrivacyHelper;
import kd.ai.gai.core.n2aparam.N2aParamConfig;
import kd.ai.gai.core.sse.client.SSEClient;
import kd.ai.gai.core.util.GaiUtils;
import kd.ai.gai.core.util.ProductUtil;
import kd.ai.gai.sidebar.vipknowledge.utils.PushMessageUtils;
import kd.ai.gai.vipknowledge.cloud.CloudPlatFormAuth;
import kd.ai.gai.vipknowledge.cloud.CloudPlatformResult;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.gpt.IGPTFormAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class VipKnowledgeAction
implements IGPTFormAction {
    private static final Log logger = LogFactory.getLog(VipKnowledgeAction.class);
    private static final String OPENAPI_COSMIC_GPT_PROMPT_CALL = "/openapi/cosmic/gpt/prompt-call";
    private static final String URL_PARAM_AUTH_CODE = "?auth_code=";
    private static final String BIND_MSG = "**\u670d\u52a1\u63d0\u793a\uff1a\u5f53\u524d\u8d26\u53f7\u5c1a\u672a\u7ed1\u5b9a\u91d1\u8776\u4e91\u8d26\u53f7**\n\n\n\u4e3a\u9075\u5b88\u56fd\u5bb6\u5173\u4e8e\u4e2a\u4eba\u4fe1\u606f\u4fdd\u62a4\u7684\u76f8\u5173\u6cd5\u89c4\uff0c\u5e76\u786e\u4fdd\u60a8\u53ef\u4ee5\u987a\u5229\u4f7f\u7528\u91d1\u8776\u5b98\u65b9\u63d0\u4f9b\u7684\u5404\u7c7b\u4e91\u670d\u52a1\uff0c\u73b0\u9700\u8981\u60a8\u6ce8\u518c\u5e76\u7ed1\u5b9a\u91d1\u8776\u4e91\u8d26\u53f7\n\n\u7ed1\u5b9a\u6d41\u7a0b\uff1a\n1.\u9009\u62e9\u5165\u53e3\uff0c\u8fdb\u5165\u7ed1\u5b9a\u9875\u9762\n\n- \u5165\u53e31\uff1a\u70b9\u51fb\u4ea7\u54c1\u5185\u3010\u552e\u540e\u5728\u7ebf\u54a8\u8be2\u670d\u52a1\u3011\n\n- \u5165\u53e32\uff1a\u70b9\u51fb\u53f3\u4e0a\u89d2\u5934\u50cf \u2192\u3010\u8bbe\u7f6e\u3011\u2192\u3010\u7b2c\u4e09\u65b9\u8d26\u53f7\u3011\u2192\u3010\u7ed1\u5b9a\u8d26\u53f7\u3011\n\n\n2.\u6388\u6743\u7ed1\u5b9a\n  \u5728\u5f39\u7a97\u4e2d\u52fe\u9009\u540c\u610f\u9690\u79c1\u534f\u8bae\uff0c\u70b9\u51fb\u3010\u7ed1\u5b9a\u4e91\u8d26\u53f7\u3011\n\n3.\u586b\u5199\u4fe1\u606f\u5e76\u5b8c\u6210\u7ed1\u5b9a\n  \u8f93\u5165\u60a8\u7684\u624b\u673a\u53f7\u7801\u6216\u90ae\u7bb1\uff0c\u83b7\u53d6\u9a8c\u8bc1\u7801\u540e\u5b8c\u6210\u6388\u6743\u7ed1\u5b9a\u3002\n\n**\u611f\u8c22\u60a8\u7684\u914d\u5408\uff0c\u7ed1\u5b9a\u64cd\u4f5c\u4ec5\u97001\u5206\u949f\uff0c\u7acb\u5373\u5f00\u542f\u5b8c\u6574\u4e91\u670d\u52a1\u4f53\u9a8c\uff01**";
    private static final String CONNECT_MSG = "\u5f53\u524d\u8bbf\u95ee\u4eba\u6570\u8f83\u591a\uff0c\u8bf7\u7a0d\u7b49\u7247\u523b\u3002";
    private boolean complete = false;

    public Map<String, String> invokeAction(String pageId, String action, Map<String, String> map) {
        if ("askKdKnowledge".equals(action)) {
            JSONObject appConfig = N2aParamConfig.getAppConfigInfo();
            String chatSessionId = map.get("chatSessionId");
            Context context = FlowCacheData.getContext((String)chatSessionId);
            if (context == null) {
                GaiUtils.newContextInSlide((IFormView)SessionManager.getCurrent().getView(pageId), (String)chatSessionId, (long)10000L);
                context = FlowCacheData.getContext((String)chatSessionId);
            }
            if (!GptPrivacyHelper.isTenantAgree((String)RequestContext.get().getTenantId())) {
                PushMessageUtils.pushErrorMessage(context, "ai.gai.50003", ResManager.loadKDString((String)"\u672a\u7b7e\u7f72\u82cd\u7a79\u5927\u6a21\u578b\u670d\u52a1\u534f\u8bae\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7b7e\u7f72\u3002", (String)"VipKnowledgeAction_3", (String)"ai-gai-plugin", (Object[])new Object[0]));
                return Collections.emptyMap();
            }
            if (!CloudPlatFormAuth.hasCloudUserRelation()) {
                PushMessageUtils.pushMessage(context, ResManager.loadKDString((String)BIND_MSG, (String)"VipKnowledgeAction_0", (String)"ai-gai-plugin", (Object[])new Object[0]), null, false, true, 0);
                return Collections.emptyMap();
            }
            CloudPlatformResult cloudPlatformResult = CloudPlatFormAuth.identity2codeByCloudPlatform((String)appConfig.getString("target"), (String)chatSessionId);
            if (!cloudPlatformResult.isSuccess()) {
                PushMessageUtils.pushErrorMessage(context, "CloudPlatFormAuth", cloudPlatformResult.getMessage());
                return Collections.emptyMap();
            }
            Object data = cloudPlatformResult.getData();
            JSONObject object = JSON.parseObject((String)data.toString());
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("auth_code", object.getString("code"));
            JSONObject body = VipKnowledgeAction.buildBody(map, appConfig, context);
            SSEClient.SSEConfig config = new SSEClient.SSEConfig().endpoint(appConfig.getString("knowledgeUrl") + OPENAPI_COSMIC_GPT_PROMPT_CALL + URL_PARAM_AUTH_CODE + object.getString("code")).requestBody(body.toJSONString()).headers(CloudPlatFormAuth.getHeader((JSONObject)appConfig, treeMap));
            logger.info(config.toString());
            SSEClient client = new SSEClient(config, this.buildSSEEventListener(context), context);
            client.request();
        }
        long time = System.currentTimeMillis();
        do {
            this.doSomeThing(time);
        } while (!this.complete);
        return Collections.emptyMap();
    }

    private void doSomeThing(long time) {
        long now = System.currentTimeMillis();
        if (now - time > 180000L) {
            this.complete = true;
        }
    }

    private static JSONObject buildBody(Map<String, String> map, JSONObject appConfig, Context context) {
        JSONObject body = new JSONObject();
        body.put("question", (Object)map.get("userInput"));
        Map licenseInfo = LicenseServiceHelper.getProductInfo();
        ProductUtil.ProductType productType = ProductUtil.getProductType();
        body.put("productId", (Object)appConfig.getString(productType.getName()));
        body.put("productSN", licenseInfo.get("productNo"));
        body.put("productInstanceId", licenseInfo.get("prodInstCode"));
        body.put("enableDeepseek", (Object)context.isEnableDeepSeek());
        String productVersion = StringUtils.isBlank((CharSequence)((CharSequence)licenseInfo.get("productversion"))) ? "7.0" : (String)licenseInfo.get("productversion");
        String channelLevel = productType.getDesc() + "|" + productVersion + "|" + ResManager.loadKDString((String)"\u4fa7\u8fb9\u680f|\u667a\u80fd\u52a9\u624b", (String)"VipKnowledgeAction_2", (String)"ai-gai-plugin", (Object[])new Object[0]);
        body.put("channel_level", (Object)channelLevel);
        return body;
    }

    private SSEClient.SSEEventListener buildSSEEventListener(final Context context) {
        return new SSEClient.SSEEventListener(){

            public void onEvent(String data, int index) {
                JSONObject dataObj = JSON.parseObject((String)data);
                logger.info("sse data:{}", (Object)dataObj);
                logger.info("sse index:{}", (Object)index);
                String message = dataObj.getString("message");
                boolean isThink = dataObj.getBooleanValue("isThink");
                boolean end = dataObj.getBooleanValue("answerEnd");
                PushMessageUtils.pushMessage(context, message, dataObj.getString("questionId"), isThink, end, index);
                this.sendSource(dataObj.getJSONArray("source"));
            }

            public void onError(Throwable t) {
                PushMessageUtils.pushErrorMessage(context, "connect_99", ResManager.loadKDString((String)VipKnowledgeAction.CONNECT_MSG, (String)"VipKnowledgeAction_1", (String)"ai-gai-plugin", (Object[])new Object[0]));
                logger.warn(t);
            }

            public void onComplete() {
                VipKnowledgeAction.this.complete = true;
            }

            private void sendSource(JSONArray source) {
                if (source == null || source.isEmpty()) {
                    return;
                }
                ArrayList<ContextData.Item> items = new ArrayList<ContextData.Item>(source.size());
                for (int i = 0; i < source.size(); ++i) {
                    JSONObject jsonObject = source.getJSONObject(i);
                    String title = jsonObject.getString("title");
                    String url = jsonObject.getString("url");
                    int order = jsonObject.getInteger("order");
                    ContextData.Item item = new ContextData.Item();
                    item.setName(title);
                    item.setContent(this.buildContent(url));
                    item.setOrder(order);
                    item.setType(AttType.document);
                    item.setFileId(jsonObject.getInteger("order") + "");
                    item.setPreviewByCosmic(false);
                    items.add(item);
                }
                ContextData contextData = new ContextData(context.getChatSessionId(), context.getTaskId(), context.getFlowId() + "", "\u53c2\u8003\u6587\u4ef6", items);
                PushMessageUtils.pushChatBottom(context, contextData);
            }

            private String buildContent(String url) {
                String s = this.addParams(url);
                return s + "method=autoJump";
            }

            private String addParams(String s) {
                if (s.contains("?")) {
                    return s + "&";
                }
                return s + "?";
            }
        };
    }
}

