/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.sidebar.vipknowledge.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.List;
import kd.ai.gai.core.domain.dto.ChatItem;
import kd.ai.gai.core.domain.vo.ContextData;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiTagEnum;
import kd.ai.gai.core.service.ChatHistoryService;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.bos.cache.LocalMemoryCache;
import org.apache.commons.lang3.StringUtils;

public class PushMessageUtils {
    public static void pushMessage(Context context, String message, String questionId, boolean isThink, boolean end, int index) {
        String taskId = StringUtils.isBlank((CharSequence)context.getTaskId()) ? context.getChatTraceId() : context.getTaskId();
        LocalMemoryCache appCache = EngineCache.getLocalCache((String)context.getChatSessionId());
        String cacheKey = isThink ? "streamThinkBuffer" + taskId : "streamBuffer" + taskId;
        String streamBuffer = (String)appCache.get(cacheKey);
        streamBuffer = streamBuffer == null ? "" : streamBuffer;
        streamBuffer = streamBuffer + message;
        appCache.put(cacheKey, (Object)streamBuffer);
        if (isThink) {
            PushMsgService.pushStreamThinkChat((Context)context, (String)taskId, (String)(context.getFlowId() + ""), (int)index, (String)message, (boolean)true, null);
        } else {
            PushMsgService.pushStreamChat((Context)context, (String)taskId, (String)(context.getFlowId() + ""), (int)index, (String)message, (boolean)true, null);
        }
        if (end) {
            ChatHistoryService.save((String)context.getChatSessionId(), (long)0L, Collections.singletonList(new ChatItem(1, streamBuffer, isThink ? streamBuffer : null)));
            JSONObject object = new JSONObject();
            object.put("questionId", (Object)questionId);
            MessageService.insertMessage((String)context.getChatSessionId(), (String)streamBuffer, (String)((String)appCache.get("streamThinkBuffer" + taskId)), (String)object.toJSONString(), (Skill)context.getCurrentSkill(), (ChatMessageTypeEnum)ChatMessageTypeEnum.ASSISTANT, (EnableEnum)EnableEnum.YES, (long)context.getTraceId());
        }
    }

    public static void pushErrorMessage(Context context, String errorCode, String msg) {
        MessageService.insertMessage((String)context.getChatSessionId(), (String)msg, null, null, (Skill)context.getCurrentSkill(), (ChatMessageTypeEnum)ChatMessageTypeEnum.PROCESS, (EnableEnum)EnableEnum.YES, (long)context.getTraceId());
        PushMsgService.pushErrMsg((Context)context, (String)errorCode, (String)msg);
    }

    public static void pushChatBottom(Context context, ContextData contextData) {
        String taskId = StringUtils.isBlank((CharSequence)context.getTaskId()) ? context.getChatTraceId() : context.getTaskId();
        contextData.setTaskId(taskId);
        StringBuilder builder = new StringBuilder();
        List fileList = contextData.getFileList();
        for (ContextData.Item item : fileList) {
            builder.append("[").append(GaiTagEnum.gaireferenceurl.name()).append("]");
            builder.append("<urlname>");
            builder.append(item.getName());
            builder.append("</urlname>");
            builder.append("<urlhref>");
            builder.append(item.getContent());
            builder.append("</urlhref>");
            builder.append("<urlorder>");
            builder.append(item.getOrder());
            builder.append("</urlorder>");
            builder.append("[/").append(GaiTagEnum.gaireferenceurl.name()).append("]");
        }
        MessageService.insertMessage((String)context.getChatSessionId(), (String)builder.toString(), null, null, (Skill)context.getCurrentSkill(), (ChatMessageTypeEnum)ChatMessageTypeEnum.PROCESS, (EnableEnum)EnableEnum.YES, (long)context.getTraceId());
        PushMsgService.pushChatBottom((Context)context, (ContextData)contextData);
    }
}

