﻿IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 'T_COMM_USER') 
 CREATE TABLE T_COMM_USER (
FNUMBER VARCHAR(50) DEFAULT ' ' NOT NULL,
FNAME VARCHAR(50) DEFAULT ' ' NOT NULL,
FSTATUS INT DEFAULT 0 NOT NULL,
FENABLE VARCHAR(50) DEFAULT ' ' NOT NULL,
FMASTERID VARCHAR(50) DEFAULT ' ' NOT NULL,
FUID BIGINT DEFAULT 0 NOT NULL,
FNICKNAME VARCHAR(50) DEFAULT ' ' NOT NULL,
FPHONE VARCHAR(50) DEFAULT ' ' NOT NULL,
FEMAIL VARCHAR(100) DEFAULT ' ' NOT NULL,
FADDRESS VARCHAR(255) DEFAULT ' ' NOT NULL,
FBIRTHDAY VARCHAR(50) DEFAULT ' ' NOT NULL,
FAVATAR VARCHAR(512) DEFAULT ' ' NOT NULL,
FUSEDCREDIT INT DEFAULT 0 NOT NULL,
FAVAILABLECREDIT INT DEFAULT 0 NOT NULL,
FUSERTYPE INT DEFAULT 0 NOT NULL,
FCOMPANY VARCHAR(50) DEFAULT ' ' NOT NULL,
FGENDER INT DEFAULT 0 NOT NULL,
FID BIGINT DEFAULT 0 NOT NULL
);

 EXEC p_AlterPK 'PK_COMM_USER', 't_comm_user', 'fid', '1';

 IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_TABNAME = 'T_COMM_USER' AND KSQL_INDNAME = 'IDX_COMM_USER')
 CREATE INDEX IDX_COMM_USER ON T_COMM_USER (FUID );

IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 'T_COMM_USER_L') 
 CREATE TABLE T_COMM_USER_L (
FPKID VARCHAR(36) DEFAULT ' ' NOT NULL,
FID BIGINT DEFAULT 0 NOT NULL,
FLOCALEID VARCHAR(10) DEFAULT ' ' NOT NULL,
FNAME VARCHAR(50) DEFAULT ' ' NOT NULL
);

 EXEC p_AlterPK 'PK_T_COMM_USER_L', 't_comm_user_l', 'fpkid', '1';

 IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_TABNAME = 'T_COMM_USER_L' AND KSQL_INDNAME = 'IDX_COMM_USER_L')
 CREATE UNIQUE INDEX IDX_COMM_USER_L ON T_COMM_USER_L (FID ,FLOCALEID );

IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 'T_COMM_CONSUME') 
 CREATE TABLE T_COMM_CONSUME (
FNUMBER VARCHAR(512) DEFAULT ' ' NOT NULL,
FNAME  VARCHAR(50) DEFAULT ' ' NOT NULL,
FSTATUS VARCHAR(50) DEFAULT ' ' NOT NULL,
FCREATORID VARCHAR(50) DEFAULT ' ' NOT NULL,
FENABLE VARCHAR(50) DEFAULT ' ' NOT NULL,
FMASTERID VARCHAR(50) DEFAULT ' ' NOT NULL,
FUID BIGINT DEFAULT 0 NOT NULL,
FSESSIONID VARCHAR(50) DEFAULT ' ' NOT NULL,
FCLIENTYPE INT DEFAULT 0 NOT NULL,
FCONSUMESIZE INT DEFAULT 0 NOT NULL,
FCREATETIME DATETIME DEFAULT GETDATE() NOT NULL,
FEXECSTATUS INT DEFAULT 0 NOT NULL,
FCUSER BIGINT DEFAULT 0 NOT NULL,
FCOMPANY VARCHAR(255) DEFAULT ' ' NOT NULL,
FUSERTYPE INT DEFAULT 0 NOT NULL,
FID BIGINT DEFAULT 0 NOT NULL
);

 EXEC p_AlterPK 'PK_COMM_CONSUME', 't_comm_consume', 'fid', '1';

 IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_TABNAME = 'T_COMM_CONSUME' AND KSQL_INDNAME = 'IDX_COMM_CONSUME')
 CREATE INDEX IDX_COMM_CONSUME ON T_COMM_CONSUME (FUID );

IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 'T_COMM_CONSUME_L') 
 CREATE TABLE T_COMM_CONSUME_L (
FPKID VARCHAR(36) DEFAULT ' ' NOT NULL,
FID BIGINT DEFAULT 0 NOT NULL,
FLOCALEID VARCHAR(10) DEFAULT ' ' NOT NULL,
FNAME VARCHAR(50) DEFAULT ' ' NOT NULL
);

 EXEC p_AlterPK 'PK_T_COMM_CONSUME_L', 't_comm_consume_l', 'fpkid', '1';

 IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_TABNAME = 'T_COMM_CONSUME_L' AND KSQL_INDNAME = 'IDX_COMM_CONSUME_L')
 CREATE UNIQUE INDEX IDX_COMM_CONSUME_L ON T_COMM_CONSUME_L (FID ,FLOCALEID );

IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 'T_COMM_RECHARGE_RECORD') 
 CREATE TABLE T_COMM_RECHARGE_RECORD (
FNUMBER VARCHAR(512) DEFAULT ' ' NOT NULL,
FNAME  VARCHAR(50) DEFAULT ' ' NOT NULL,
FSTATUS VARCHAR(50) DEFAULT ' ' NOT NULL,
FCREATORID VARCHAR(50) DEFAULT ' ' NOT NULL,
FENABLE VARCHAR(50) DEFAULT ' ' NOT NULL,
FMASTERID BIGINT DEFAULT 0 NOT NULL,
FUID BIGINT DEFAULT 0 NOT NULL,
FRECHARGESIZE INT DEFAULT 0 NOT NULL,
FRECHARGETYPE INT DEFAULT 0 NOT NULL,
FRECHARGESTATUS INT DEFAULT 0 NOT NULL,
FCREDITTYPE INT DEFAULT 0 NOT NULL,
FCREATEDTIME DATETIME DEFAULT GETDATE() NOT NULL,
FCUSER BIGINT DEFAULT 0 NOT NULL,
FID BIGINT DEFAULT 0 NOT NULL
);

 EXEC p_AlterPK 'PK_COMM_RECHARGE_RECORD', 't_comm_recharge_record', 'fid', '1';

 IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_TABNAME = 'T_COMM_RECHARGE_RECORD' AND KSQL_INDNAME = 'IDX_C_RECHARGE_RECORD')
 CREATE INDEX IDX_C_RECHARGE_RECORD ON T_COMM_RECHARGE_RECORD (FUID );

IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 'T_COMM_RECHARGE_RECORD_L') 
 CREATE TABLE T_COMM_RECHARGE_RECORD_L (
FPKID VARCHAR(36) DEFAULT ' ' NOT NULL,
FID BIGINT DEFAULT 0 NOT NULL,
FLOCALEID VARCHAR(10) DEFAULT ' ' NOT NULL,
FNAME VARCHAR(50) DEFAULT ' ' NOT NULL
);

 EXEC p_AlterPK 'PK_COMM_RECHARGE_RECORD_L', 't_comm_recharge_record_l', 'fpkid', '1';

 IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_TABNAME = 'T_COMM_RECHARGE_RECORD_L' AND KSQL_INDNAME = 'IDX_C_RECHARGE_R_L')
 CREATE UNIQUE INDEX IDX_C_RECHARGE_R_L ON T_COMM_RECHARGE_RECORD_L (FID ,FLOCALEID );