/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.mcp.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import kd.ai.mcp.spec.McpSchema;
import kd.ai.mcp.util.Assert;
import kd.ai.mcp.util.Utils;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

class McpClientFeatures {
    McpClientFeatures() {
    }

    public static final class Sync {
        private final McpSchema.Implementation clientInfo;
        private final McpSchema.ClientCapabilities clientCapabilities;
        private final Map<String, McpSchema.Root> roots;
        private final List<Consumer<List<McpSchema.Tool>>> toolsChangeConsumers;
        private final List<Consumer<List<McpSchema.Resource>>> resourcesChangeConsumers;
        private final List<Consumer<List<McpSchema.Prompt>>> promptsChangeConsumers;
        private final List<Consumer<McpSchema.LoggingMessageNotification>> loggingConsumers;
        private final List<Consumer<List<McpSchema.Root>>> rootsChangeConsumers;
        private final Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> samplingHandler;

        public Sync(McpSchema.Implementation clientInfo, McpSchema.ClientCapabilities clientCapabilities, Map<String, McpSchema.Root> roots, List<Consumer<List<McpSchema.Tool>>> toolsChangeConsumers, List<Consumer<List<McpSchema.Resource>>> resourcesChangeConsumers, List<Consumer<List<McpSchema.Prompt>>> promptsChangeConsumers, List<Consumer<McpSchema.LoggingMessageNotification>> loggingConsumers, List<Consumer<List<McpSchema.Root>>> rootsChangeConsumers, Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> samplingHandler) {
            Assert.notNull(clientInfo, "Client info must not be null");
            this.clientInfo = clientInfo;
            this.clientCapabilities = clientCapabilities != null ? clientCapabilities : new McpSchema.ClientCapabilities(null, !Utils.isEmpty(roots) ? new McpSchema.ClientCapabilities.RootsCapabilities(false) : null, samplingHandler != null ? new McpSchema.ClientCapabilities.SamplingCapabilities(false) : null);
            this.roots = roots != null ? new HashMap<String, McpSchema.Root>(roots) : new HashMap();
            this.toolsChangeConsumers = toolsChangeConsumers != null ? toolsChangeConsumers : Collections.emptyList();
            this.resourcesChangeConsumers = resourcesChangeConsumers != null ? resourcesChangeConsumers : Collections.emptyList();
            this.promptsChangeConsumers = promptsChangeConsumers != null ? promptsChangeConsumers : Collections.emptyList();
            this.loggingConsumers = loggingConsumers != null ? loggingConsumers : Collections.emptyList();
            this.rootsChangeConsumers = rootsChangeConsumers != null ? rootsChangeConsumers : Collections.emptyList();
            this.samplingHandler = samplingHandler;
        }

        public McpSchema.Implementation clientInfo() {
            return this.clientInfo;
        }

        public McpSchema.ClientCapabilities clientCapabilities() {
            return this.clientCapabilities;
        }

        public Map<String, McpSchema.Root> roots() {
            return this.roots;
        }

        public List<Consumer<List<McpSchema.Tool>>> toolsChangeConsumers() {
            return this.toolsChangeConsumers;
        }

        public List<Consumer<List<McpSchema.Resource>>> resourcesChangeConsumers() {
            return this.resourcesChangeConsumers;
        }

        public List<Consumer<List<McpSchema.Prompt>>> promptsChangeConsumers() {
            return this.promptsChangeConsumers;
        }

        public List<Consumer<McpSchema.LoggingMessageNotification>> loggingConsumers() {
            return this.loggingConsumers;
        }

        public List<Consumer<List<McpSchema.Root>>> rootsChangeConsumers() {
            return this.rootsChangeConsumers;
        }

        public Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> samplingHandler() {
            return this.samplingHandler;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Sync that = (Sync)obj;
            return Objects.equals(this.clientInfo, that.clientInfo) && Objects.equals(this.clientCapabilities, that.clientCapabilities) && Objects.equals(this.roots, that.roots) && Objects.equals(this.toolsChangeConsumers, that.toolsChangeConsumers) && Objects.equals(this.resourcesChangeConsumers, that.resourcesChangeConsumers) && Objects.equals(this.promptsChangeConsumers, that.promptsChangeConsumers) && Objects.equals(this.loggingConsumers, that.loggingConsumers) && Objects.equals(this.rootsChangeConsumers, that.rootsChangeConsumers) && Objects.equals(this.samplingHandler, that.samplingHandler);
        }

        public int hashCode() {
            return Objects.hash(this.clientInfo, this.clientCapabilities, this.roots, this.toolsChangeConsumers, this.resourcesChangeConsumers, this.promptsChangeConsumers, this.loggingConsumers, this.rootsChangeConsumers, this.samplingHandler);
        }

        public String toString() {
            return "Sync[clientInfo=" + this.clientInfo + ", clientCapabilities=" + this.clientCapabilities + ", roots=" + this.roots + ", toolsChangeConsumers=" + this.toolsChangeConsumers + ", resourcesChangeConsumers=" + this.resourcesChangeConsumers + ", promptsChangeConsumers=" + this.promptsChangeConsumers + ", loggingConsumers=" + this.loggingConsumers + ", rootsChangeConsumers=" + this.rootsChangeConsumers + ", samplingHandler=" + this.samplingHandler + ']';
        }
    }

    public static final class Async {
        private final McpSchema.Implementation clientInfo;
        private final McpSchema.ClientCapabilities clientCapabilities;
        private final Map<String, McpSchema.Root> roots;
        private final List<Function<List<McpSchema.Tool>, Mono<Void>>> toolsChangeConsumers;
        private final List<Function<List<McpSchema.Resource>, Mono<Void>>> resourcesChangeConsumers;
        private final List<Function<List<McpSchema.Prompt>, Mono<Void>>> promptsChangeConsumers;
        private final List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> loggingConsumers;
        private final List<Function<List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers;
        private final Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> samplingHandler;

        public Async(McpSchema.Implementation clientInfo, McpSchema.ClientCapabilities clientCapabilities, Map<String, McpSchema.Root> roots, List<Function<List<McpSchema.Tool>, Mono<Void>>> toolsChangeConsumers, List<Function<List<McpSchema.Resource>, Mono<Void>>> resourcesChangeConsumers, List<Function<List<McpSchema.Prompt>, Mono<Void>>> promptsChangeConsumers, List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> loggingConsumers, List<Function<List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers, Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> samplingHandler) {
            Assert.notNull(clientInfo, "Client info must not be null");
            this.clientInfo = clientInfo;
            this.clientCapabilities = clientCapabilities != null ? clientCapabilities : new McpSchema.ClientCapabilities(null, !Utils.isEmpty(roots) ? new McpSchema.ClientCapabilities.RootsCapabilities(false) : null, samplingHandler != null ? new McpSchema.ClientCapabilities.SamplingCapabilities(false) : null);
            this.roots = roots != null ? new ConcurrentHashMap<String, McpSchema.Root>(roots) : new ConcurrentHashMap();
            this.toolsChangeConsumers = toolsChangeConsumers != null ? toolsChangeConsumers : Collections.emptyList();
            this.resourcesChangeConsumers = resourcesChangeConsumers != null ? resourcesChangeConsumers : Collections.emptyList();
            this.promptsChangeConsumers = promptsChangeConsumers != null ? promptsChangeConsumers : Collections.emptyList();
            this.loggingConsumers = loggingConsumers != null ? loggingConsumers : Collections.emptyList();
            this.rootsChangeConsumers = rootsChangeConsumers != null ? rootsChangeConsumers : Collections.emptyList();
            this.samplingHandler = samplingHandler;
        }

        public McpSchema.Implementation clientInfo() {
            return this.clientInfo;
        }

        public McpSchema.ClientCapabilities clientCapabilities() {
            return this.clientCapabilities;
        }

        public Map<String, McpSchema.Root> roots() {
            return this.roots;
        }

        public List<Function<List<McpSchema.Tool>, Mono<Void>>> toolsChangeConsumers() {
            return this.toolsChangeConsumers;
        }

        public List<Function<List<McpSchema.Resource>, Mono<Void>>> resourcesChangeConsumers() {
            return this.resourcesChangeConsumers;
        }

        public List<Function<List<McpSchema.Prompt>, Mono<Void>>> promptsChangeConsumers() {
            return this.promptsChangeConsumers;
        }

        public List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> loggingConsumers() {
            return this.loggingConsumers;
        }

        public List<Function<List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers() {
            return this.rootsChangeConsumers;
        }

        public Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> samplingHandler() {
            return this.samplingHandler;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Async that = (Async)obj;
            return Objects.equals(this.clientInfo, that.clientInfo) && Objects.equals(this.clientCapabilities, that.clientCapabilities) && Objects.equals(this.roots, that.roots) && Objects.equals(this.toolsChangeConsumers, that.toolsChangeConsumers) && Objects.equals(this.resourcesChangeConsumers, that.resourcesChangeConsumers) && Objects.equals(this.promptsChangeConsumers, that.promptsChangeConsumers) && Objects.equals(this.loggingConsumers, that.loggingConsumers) && Objects.equals(this.rootsChangeConsumers, that.rootsChangeConsumers) && Objects.equals(this.samplingHandler, that.samplingHandler);
        }

        public int hashCode() {
            return Objects.hash(this.clientInfo, this.clientCapabilities, this.roots, this.toolsChangeConsumers, this.resourcesChangeConsumers, this.promptsChangeConsumers, this.loggingConsumers, this.rootsChangeConsumers, this.samplingHandler);
        }

        public String toString() {
            return "Async[clientInfo=" + this.clientInfo + ", clientCapabilities=" + this.clientCapabilities + ", roots=" + this.roots + ", toolsChangeConsumers=" + this.toolsChangeConsumers + ", resourcesChangeConsumers=" + this.resourcesChangeConsumers + ", promptsChangeConsumers=" + this.promptsChangeConsumers + ", loggingConsumers=" + this.loggingConsumers + ", rootsChangeConsumers=" + this.rootsChangeConsumers + ", samplingHandler=" + this.samplingHandler + ']';
        }

        public static Async fromSync(Sync syncSpec) {
            ArrayList<Function<List<McpSchema.Tool>, Mono<Void>>> toolsChangeConsumers = new ArrayList<Function<List<McpSchema.Tool>, Mono<Void>>>(syncSpec.toolsChangeConsumers().size());
            for (Consumer<List<McpSchema.Tool>> consumer : syncSpec.toolsChangeConsumers()) {
                toolsChangeConsumers.add(t -> Mono.fromRunnable(() -> consumer.accept(t)).subscribeOn(Schedulers.boundedElastic()));
            }
            ArrayList<Function<List<McpSchema.Resource>, Mono<Void>>> resourcesChangeConsumers = new ArrayList<Function<List<McpSchema.Resource>, Mono<Void>>>(syncSpec.resourcesChangeConsumers().size());
            for (Consumer<List<McpSchema.Resource>> consumer : syncSpec.resourcesChangeConsumers()) {
                resourcesChangeConsumers.add(r -> Mono.fromRunnable(() -> consumer.accept((List<McpSchema.Resource>)r)).subscribeOn(Schedulers.boundedElastic()));
            }
            ArrayList<Function<List<McpSchema.Prompt>, Mono<Void>>> arrayList = new ArrayList<Function<List<McpSchema.Prompt>, Mono<Void>>>(syncSpec.promptsChangeConsumers().size());
            for (Consumer<List<McpSchema.Prompt>> consumer : syncSpec.promptsChangeConsumers()) {
                arrayList.add(p -> Mono.fromRunnable(() -> consumer.accept((List<McpSchema.Prompt>)p)).subscribeOn(Schedulers.boundedElastic()));
            }
            ArrayList<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> arrayList2 = new ArrayList<Function<McpSchema.LoggingMessageNotification, Mono<Void>>>(syncSpec.loggingConsumers().size());
            for (Consumer<McpSchema.LoggingMessageNotification> consumer : syncSpec.loggingConsumers()) {
                arrayList2.add(l -> Mono.fromRunnable(() -> consumer.accept((McpSchema.LoggingMessageNotification)l)).subscribeOn(Schedulers.boundedElastic()));
            }
            ArrayList<Function<List<McpSchema.Root>, Mono<Void>>> arrayList3 = new ArrayList<Function<List<McpSchema.Root>, Mono<Void>>>(syncSpec.rootsChangeConsumers().size());
            for (Consumer<List<McpSchema.Root>> consumer : syncSpec.rootsChangeConsumers()) {
                arrayList3.add(r -> Mono.fromRunnable(() -> consumer.accept(r)).subscribeOn(Schedulers.boundedElastic()));
            }
            Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> function = r -> Mono.fromCallable(() -> syncSpec.samplingHandler().apply((McpSchema.CreateMessageRequest)r)).subscribeOn(Schedulers.boundedElastic());
            return new Async(syncSpec.clientInfo(), syncSpec.clientCapabilities(), syncSpec.roots(), toolsChangeConsumers, resourcesChangeConsumers, arrayList, arrayList2, arrayList3, function);
        }
    }
}

