/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.mcp.client;

import java.time.Duration;
import kd.ai.mcp.client.McpAsyncClient;
import kd.ai.mcp.spec.McpSchema;
import kd.ai.mcp.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpSyncClient
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(McpSyncClient.class);
    private static final long DEFAULT_CLOSE_TIMEOUT_MS = 10000L;
    private final McpAsyncClient delegate;
    private final Duration initializationTimeout;

    @Deprecated
    public McpSyncClient(McpAsyncClient delegate) {
        Assert.notNull(delegate, "The delegate can not be null");
        this.delegate = delegate;
        this.initializationTimeout = Duration.ofSeconds(10L);
    }

    public McpSyncClient(McpAsyncClient delegate, Duration initializationTimeout) {
        Assert.notNull(delegate, "The delegate can not be null");
        Assert.notNull(initializationTimeout, "The initializationTimeout can not be null");
        this.delegate = delegate;
        this.initializationTimeout = initializationTimeout;
    }

    public McpSchema.ServerCapabilities getServerCapabilities() {
        return this.delegate.getServerCapabilities();
    }

    public McpSchema.Implementation getServerInfo() {
        return this.delegate.getServerInfo();
    }

    public McpSchema.ClientCapabilities getClientCapabilities() {
        return this.delegate.getClientCapabilities();
    }

    public McpSchema.Implementation getClientInfo() {
        return this.delegate.getClientInfo();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public boolean closeGracefully() {
        try {
            this.delegate.closeGracefully().block(Duration.ofMillis(10000L));
        }
        catch (RuntimeException e) {
            logger.warn("Client didn't close within timeout of {} ms.", (Object)10000L, (Object)e);
            return false;
        }
        return true;
    }

    public McpSchema.InitializeResult initialize() {
        try {
            return (McpSchema.InitializeResult)this.delegate.initialize().block();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw e;
        }
    }

    public void rootsListChangedNotification() {
        this.delegate.rootsListChangedNotification().block();
    }

    public void addRoot(McpSchema.Root root) {
        this.delegate.addRoot(root).block();
    }

    public void removeRoot(String rootUri) {
        this.delegate.removeRoot(rootUri).block();
    }

    public Object ping() {
        return this.delegate.ping().block();
    }

    public McpSchema.CallToolResult callTool(McpSchema.CallToolRequest callToolRequest) {
        return (McpSchema.CallToolResult)this.delegate.callTool(callToolRequest).block();
    }

    public McpSchema.ListToolsResult listTools() {
        return (McpSchema.ListToolsResult)this.delegate.listTools().block();
    }

    public McpSchema.ListToolsResult listTools(String cursor) {
        return (McpSchema.ListToolsResult)this.delegate.listTools(cursor).block();
    }

    public McpSchema.ListResourcesResult listResources(String cursor) {
        return (McpSchema.ListResourcesResult)this.delegate.listResources(cursor).block();
    }

    public McpSchema.ListResourcesResult listResources() {
        return (McpSchema.ListResourcesResult)this.delegate.listResources().block();
    }

    public McpSchema.ReadResourceResult readResource(McpSchema.Resource resource) {
        return (McpSchema.ReadResourceResult)this.delegate.readResource(resource).block();
    }

    public McpSchema.ReadResourceResult readResource(McpSchema.ReadResourceRequest readResourceRequest) {
        return (McpSchema.ReadResourceResult)this.delegate.readResource(readResourceRequest).block();
    }

    public McpSchema.ListResourceTemplatesResult listResourceTemplates(String cursor) {
        return (McpSchema.ListResourceTemplatesResult)this.delegate.listResourceTemplates(cursor).block();
    }

    public McpSchema.ListResourceTemplatesResult listResourceTemplates() {
        return (McpSchema.ListResourceTemplatesResult)this.delegate.listResourceTemplates().block();
    }

    public void subscribeResource(McpSchema.SubscribeRequest subscribeRequest) {
        this.delegate.subscribeResource(subscribeRequest).block();
    }

    public void unsubscribeResource(McpSchema.UnsubscribeRequest unsubscribeRequest) {
        this.delegate.unsubscribeResource(unsubscribeRequest).block();
    }

    public McpSchema.ListPromptsResult listPrompts(String cursor) {
        return (McpSchema.ListPromptsResult)this.delegate.listPrompts(cursor).block();
    }

    public McpSchema.ListPromptsResult listPrompts() {
        return (McpSchema.ListPromptsResult)this.delegate.listPrompts().block();
    }

    public McpSchema.GetPromptResult getPrompt(McpSchema.GetPromptRequest getPromptRequest) {
        return (McpSchema.GetPromptResult)this.delegate.getPrompt(getPromptRequest).block();
    }

    public void setLoggingLevel(McpSchema.LoggingLevel loggingLevel) {
        this.delegate.setLoggingLevel(loggingLevel).block();
    }
}

