/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.mcp.client.transport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.ai.mcp.client.transport.HttpUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;

public class FlowSseClient {
    private static final Pattern EVENT_DATA_PATTERN = Pattern.compile("^data:(.+)$", 8);
    private static final Pattern EVENT_ID_PATTERN = Pattern.compile("^id:(.+)$", 8);
    private static final Pattern EVENT_TYPE_PATTERN = Pattern.compile("^event:(.+)$", 8);
    private final CloseableHttpClient httpClient;
    private final Map<String, String> headers;

    public FlowSseClient(CloseableHttpClient httpClient, Map<String, String> headers) {
        this.httpClient = httpClient;
        this.headers = headers;
    }

    public void subscribe(final String url, final SseEventHandler eventHandler) {
        try {
            Thread readerThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        SseEvent event;
                        String eventData;
                        String line;
                        CloseableHttpResponse response = HttpUtils.getSSE(FlowSseClient.this.httpClient, url, FlowSseClient.this.headers);
                        int statusCode = response.getStatusLine().getStatusCode();
                        if (statusCode != 200 && statusCode != 201 && statusCode != 202 && statusCode != 206) {
                            throw new RuntimeException("Failed to connect to SSE stream. Unexpected status code: " + statusCode);
                        }
                        BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
                        StringBuilder eventBuilder = new StringBuilder();
                        AtomicReference<String> currentEventId = new AtomicReference<String>();
                        AtomicReference<String> currentEventType = new AtomicReference<String>("message");
                        while ((line = reader.readLine()) != null) {
                            Matcher matcher;
                            if (line.isEmpty()) {
                                if (eventBuilder.length() <= 0) continue;
                                eventData = eventBuilder.toString();
                                event = new SseEvent((String)currentEventId.get(), currentEventType.get(), eventData.trim());
                                eventBuilder.setLength(0);
                                eventHandler.onEvent(event);
                                continue;
                            }
                            if (line.startsWith("data:")) {
                                matcher = EVENT_DATA_PATTERN.matcher(line);
                                if (!matcher.find()) continue;
                                eventBuilder.append(matcher.group(1).trim()).append("\n");
                                continue;
                            }
                            if (line.startsWith("id:")) {
                                matcher = EVENT_ID_PATTERN.matcher(line);
                                if (!matcher.find()) continue;
                                currentEventId.set(matcher.group(1).trim());
                                continue;
                            }
                            if (!line.startsWith("event:") || !(matcher = EVENT_TYPE_PATTERN.matcher(line)).find()) continue;
                            currentEventType.set(matcher.group(1).trim());
                        }
                        if (eventBuilder.length() > 0) {
                            eventData = eventBuilder.toString();
                            event = new SseEvent((String)currentEventId.get(), currentEventType.get(), eventData.trim());
                            eventHandler.onEvent(event);
                        }
                        reader.close();
                        response.close();
                    }
                    catch (IOException e) {
                        eventHandler.onError(e);
                    }
                }
            });
            readerThread.setDaemon(true);
            readerThread.start();
        }
        catch (Exception e) {
            eventHandler.onError(e);
        }
    }

    public void close() throws IOException {
    }

    public static final class SseEvent {
        private final String id;
        private final String type;
        private final String data;

        public SseEvent(String id, String type, String data) {
            this.id = id;
            this.type = type;
            this.data = data;
        }

        public String id() {
            return this.id;
        }

        public String type() {
            return this.type;
        }

        public String data() {
            return this.data;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SseEvent sseEvent = (SseEvent)o;
            return Objects.equals(this.id, sseEvent.id) && Objects.equals(this.type, sseEvent.type) && Objects.equals(this.data, sseEvent.data);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.type, this.data);
        }

        public String toString() {
            return "SseEvent{id='" + this.id + '\'' + ", type='" + this.type + '\'' + ", data='" + this.data + '\'' + '}';
        }
    }

    public static interface SseEventHandler {
        public void onEvent(SseEvent var1);

        public void onError(Throwable var1);
    }
}

