/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.mcp.client.transport;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import kd.ai.mcp.client.transport.FlowSseClient;
import kd.ai.mcp.client.transport.HttpUtils;
import kd.ai.mcp.spec.McpClientTransport;
import kd.ai.mcp.spec.McpError;
import kd.ai.mcp.spec.McpSchema;
import kd.ai.mcp.util.Assert;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class HttpClientSseClientTransport
implements McpClientTransport {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientSseClientTransport.class);
    private static final String MESSAGE_EVENT_TYPE = "message";
    private static final String ENDPOINT_EVENT_TYPE = "endpoint";
    private static final String SSE_ENDPOINT = "/sse";
    private final String baseUri;
    private final FlowSseClient sseClient;
    private final CloseableHttpClient httpClient;
    private final Map<String, String> headers;
    private final String sseEndpoint;
    private final CountDownLatch closeLatch = new CountDownLatch(1);
    private final AtomicReference<String> messageEndpoint = new AtomicReference();
    protected ObjectMapper objectMapper;
    private volatile boolean isClosing = false;

    public HttpClientSseClientTransport(String baseUri, String sseEndpoint) {
        this(baseUri, sseEndpoint, new ObjectMapper());
    }

    public HttpClientSseClientTransport(String baseUri, String sseEndpoint, ObjectMapper objectMapper) {
        this(baseUri, sseEndpoint, objectMapper, null);
    }

    public HttpClientSseClientTransport(String baseUri, String sseEndpoint, ObjectMapper objectMapper, Map<String, String> headers) {
        Assert.notNull(objectMapper, "ObjectMapper must not be null");
        Assert.hasText(baseUri, "baseUri must not be empty");
        this.baseUri = baseUri;
        this.sseEndpoint = sseEndpoint;
        this.objectMapper = objectMapper;
        this.httpClient = HttpUtils.newClient();
        this.sseClient = new FlowSseClient(this.httpClient, headers);
        this.headers = headers;
    }

    @Override
    public Mono<Void> connect(Function<Mono<McpSchema.JSONRPCMessage>, Mono<McpSchema.JSONRPCMessage>> handler) {
        return Mono.create(sink -> {
            String sseEndpoint = StringUtils.isNotEmpty((CharSequence)this.sseEndpoint) ? this.sseEndpoint : SSE_ENDPOINT;
            logger.info("sseUrl: {}", (Object)(this.baseUri + sseEndpoint));
            this.sseClient.subscribe(this.baseUri + sseEndpoint, new FlowSseClient.SseEventHandler((MonoSink)sink, handler){
                final /* synthetic */ MonoSink val$sink;
                final /* synthetic */ Function val$handler;
                {
                    this.val$sink = monoSink;
                    this.val$handler = function;
                }

                @Override
                public void onEvent(FlowSseClient.SseEvent event) {
                    if (HttpClientSseClientTransport.this.isClosing) {
                        return;
                    }
                    try {
                        if (HttpClientSseClientTransport.ENDPOINT_EVENT_TYPE.equals(event.type())) {
                            String endpoint = event.data();
                            HttpClientSseClientTransport.this.messageEndpoint.set(endpoint);
                            HttpClientSseClientTransport.this.closeLatch.countDown();
                            this.val$sink.success();
                        } else if (HttpClientSseClientTransport.MESSAGE_EVENT_TYPE.equals(event.type())) {
                            McpSchema.JSONRPCMessage message = McpSchema.deserializeJsonRpcMessage(HttpClientSseClientTransport.this.objectMapper, event.data());
                            ((Mono)this.val$handler.apply(Mono.just((Object)message))).subscribe();
                        } else {
                            logger.error("Received unrecognized SSE event type: {}", (Object)event.type());
                        }
                    }
                    catch (IOException e) {
                        logger.error("Error processing SSE event", (Throwable)e);
                        this.val$sink.error((Throwable)e);
                    }
                }

                @Override
                public void onError(Throwable error) {
                    if (!HttpClientSseClientTransport.this.isClosing) {
                        HttpClientSseClientTransport.this.closeLatch.countDown();
                        logger.error("SSE connection error", error);
                        this.val$sink.error(error);
                    }
                }
            });
        });
    }

    @Override
    public Mono<Void> sendMessage(McpSchema.JSONRPCMessage message) {
        if (this.isClosing) {
            return Mono.empty();
        }
        try {
            if (!this.closeLatch.await(10L, TimeUnit.SECONDS)) {
                return Mono.error((Throwable)new McpError((Object)"Failed to wait for the message endpoint"));
            }
        }
        catch (InterruptedException e) {
            return Mono.error((Throwable)new McpError((Object)"Failed to wait for the message endpoint"));
        }
        String endpoint = this.messageEndpoint.get();
        if (endpoint == null) {
            return Mono.error((Throwable)new McpError((Object)"No message endpoint available"));
        }
        return Mono.create(sink -> {
            try {
                String jsonText = this.objectMapper.writeValueAsString((Object)message);
                String url = URI.create(this.baseUri + endpoint).toString();
                try (CloseableHttpResponse response = HttpUtils.postJson(this.httpClient, url, jsonText, this.headers);){
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode != 200 && statusCode != 204 && statusCode != 202 && statusCode != 206) {
                        logger.error("Error sending message: {}", (Object)statusCode);
                        sink.error((Throwable)new McpError((Object)("Failed to send message, status code: " + statusCode)));
                    } else {
                        sink.success();
                    }
                }
            }
            catch (Exception e) {
                if (!this.isClosing) {
                    sink.error((Throwable)new RuntimeException("Failed to send message", e));
                }
                sink.success();
            }
        });
    }

    @Override
    public Mono<Void> closeGracefully() {
        return Mono.fromRunnable(() -> {
            this.isClosing = true;
            try {
                this.sseClient.close();
                this.httpClient.close();
            }
            catch (IOException e) {
                logger.warn("Error closing HTTP client", (Throwable)e);
            }
        });
    }

    @Override
    public <T> T unmarshalFrom(Object data, TypeReference<T> typeRef) {
        return (T)this.objectMapper.convertValue(data, typeRef);
    }
}

