/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.mcp.client.transport;

import java.io.IOException;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.MapUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpUtils {
    private static final PoolingHttpClientConnectionManager connectionManager;
    private static String sites;
    private static final Map<String, String> otherHeaders;

    public static CloseableHttpClient newClient() {
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
    }

    public static void setResponseHeaders(HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/event-stream");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Connection", "keep-alive");
        for (Map.Entry<String, String> entry : otherHeaders.entrySet()) {
            response.setHeader(entry.getKey(), entry.getValue());
        }
    }

    public static CloseableHttpResponse postJson(CloseableHttpClient client, String url, String json, Map<String, String> headers) throws IOException {
        HttpPost request = new HttpPost(url);
        request.setHeader("Content-Type", "application/json");
        if (MapUtils.isNotEmpty(headers)) {
            headers.forEach((arg_0, arg_1) -> ((HttpPost)request).addHeader(arg_0, arg_1));
        }
        request.setEntity((HttpEntity)new StringEntity(json, "UTF-8"));
        return client.execute((HttpUriRequest)request);
    }

    public static CloseableHttpResponse getSSE(CloseableHttpClient client, String url, Map<String, String> headers) throws IOException {
        HttpGet request = new HttpGet(URI.create(url));
        request.addHeader("Accept", "text/event-stream");
        request.addHeader("Cache-Control", "no-cache");
        if (MapUtils.isNotEmpty(headers)) {
            headers.forEach((arg_0, arg_1) -> ((HttpGet)request).addHeader(arg_0, arg_1));
        }
        return client.execute((HttpUriRequest)request);
    }

    static {
        SSLContext sslContext;
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, trustAllCerts, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext)).build();
        connectionManager = new PoolingHttpClientConnectionManager(registry){

            public void shutdown() {
            }
        };
        connectionManager.setDefaultMaxPerRoute(100);
        connectionManager.setMaxTotal(100);
        sites = "*";
        otherHeaders = new HashMap<String, String>(){
            {
                this.put("Access-Control-Allow-Origin", sites);
            }
        };
    }
}

