/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.mcp.server;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.ai.mcp.server.McpAsyncServerExchange;
import kd.ai.mcp.server.McpServerFeatures;
import kd.ai.mcp.spec.McpClientSession;
import kd.ai.mcp.spec.McpError;
import kd.ai.mcp.spec.McpSchema;
import kd.ai.mcp.spec.McpServerSession;
import kd.ai.mcp.spec.McpServerTransportProvider;
import kd.ai.mcp.spec.ServerMcpTransport;
import kd.ai.mcp.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class McpAsyncServer {
    private static final Logger logger = LoggerFactory.getLogger(McpAsyncServer.class);
    private final McpAsyncServer delegate;

    McpAsyncServer() {
        this.delegate = null;
    }

    @Deprecated
    McpAsyncServer(ServerMcpTransport mcpTransport, McpServerFeatures.Async features) {
        this.delegate = new LegacyAsyncServer(mcpTransport, features);
    }

    McpAsyncServer(McpServerTransportProvider mcpTransportProvider, ObjectMapper objectMapper, McpServerFeatures.Async features) {
        this.delegate = new AsyncServerImpl(mcpTransportProvider, objectMapper, features);
    }

    public McpSchema.ServerCapabilities getServerCapabilities() {
        return this.delegate.getServerCapabilities();
    }

    public McpSchema.Implementation getServerInfo() {
        return this.delegate.getServerInfo();
    }

    @Deprecated
    public McpSchema.ClientCapabilities getClientCapabilities() {
        return this.delegate.getClientCapabilities();
    }

    @Deprecated
    public McpSchema.Implementation getClientInfo() {
        return this.delegate.getClientInfo();
    }

    public Mono<Void> closeGracefully() {
        return this.delegate.closeGracefully();
    }

    public void close() {
        this.delegate.close();
    }

    @Deprecated
    public Mono<McpSchema.ListRootsResult> listRoots() {
        return this.delegate.listRoots(null);
    }

    @Deprecated
    public Mono<McpSchema.ListRootsResult> listRoots(String cursor) {
        return this.delegate.listRoots(cursor);
    }

    @Deprecated
    public Mono<Void> addTool(McpServerFeatures.AsyncToolRegistration toolRegistration) {
        return this.delegate.addTool(toolRegistration);
    }

    public Mono<Void> addTool(McpServerFeatures.AsyncToolSpecification toolSpecification) {
        return this.delegate.addTool(toolSpecification);
    }

    public Mono<Void> removeTool(String toolName) {
        return this.delegate.removeTool(toolName);
    }

    public Mono<Void> notifyToolsListChanged() {
        return this.delegate.notifyToolsListChanged();
    }

    @Deprecated
    public Mono<Void> addResource(McpServerFeatures.AsyncResourceRegistration resourceHandler) {
        return this.delegate.addResource(resourceHandler);
    }

    public Mono<Void> addResource(McpServerFeatures.AsyncResourceSpecification resourceHandler) {
        return this.delegate.addResource(resourceHandler);
    }

    public Mono<Void> removeResource(String resourceUri) {
        return this.delegate.removeResource(resourceUri);
    }

    public Mono<Void> notifyResourcesListChanged() {
        return this.delegate.notifyResourcesListChanged();
    }

    @Deprecated
    public Mono<Void> addPrompt(McpServerFeatures.AsyncPromptRegistration promptRegistration) {
        return this.delegate.addPrompt(promptRegistration);
    }

    public Mono<Void> addPrompt(McpServerFeatures.AsyncPromptSpecification promptSpecification) {
        return this.delegate.addPrompt(promptSpecification);
    }

    public Mono<Void> removePrompt(String promptName) {
        return this.delegate.removePrompt(promptName);
    }

    public Mono<Void> notifyPromptsListChanged() {
        return this.delegate.notifyPromptsListChanged();
    }

    public Mono<Void> loggingNotification(McpSchema.LoggingMessageNotification loggingMessageNotification) {
        return this.delegate.loggingNotification(loggingMessageNotification);
    }

    @Deprecated
    public Mono<McpSchema.CreateMessageResult> createMessage(McpSchema.CreateMessageRequest createMessageRequest) {
        return this.delegate.createMessage(createMessageRequest);
    }

    void setProtocolVersions(List<String> protocolVersions) {
        this.delegate.setProtocolVersions(protocolVersions);
    }

    static class LegacyAsyncServer
    extends McpAsyncServer {
        private final McpClientSession mcpSession;
        private final ServerMcpTransport transport;
        private final McpSchema.ServerCapabilities serverCapabilities;
        private final McpSchema.Implementation serverInfo;
        private McpSchema.ClientCapabilities clientCapabilities;
        private McpSchema.Implementation clientInfo;
        private final CopyOnWriteArrayList<McpServerFeatures.AsyncToolSpecification> tools = new CopyOnWriteArrayList();
        private final CopyOnWriteArrayList<McpSchema.ResourceTemplate> resourceTemplates = new CopyOnWriteArrayList();
        private final ConcurrentHashMap<String, McpServerFeatures.AsyncResourceSpecification> resources = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, McpServerFeatures.AsyncPromptSpecification> prompts = new ConcurrentHashMap();
        private McpSchema.LoggingLevel minLoggingLevel = McpSchema.LoggingLevel.DEBUG;
        private List<String> protocolVersions = Collections.singletonList("2024-11-05");
        private static final TypeReference<McpSchema.ListRootsResult> LIST_ROOTS_RESULT_TYPE_REF = new TypeReference(){};
        private static final TypeReference<McpSchema.CreateMessageResult> CREATE_MESSAGE_RESULT_TYPE_REF = new TypeReference(){};

        LegacyAsyncServer(ServerMcpTransport mcpTransport, McpServerFeatures.Async features) {
            this.serverInfo = features.serverInfo();
            this.serverCapabilities = features.serverCapabilities();
            this.tools.addAll(features.tools());
            this.resources.putAll(features.resources());
            this.resourceTemplates.addAll(features.resourceTemplates());
            this.prompts.putAll(features.prompts());
            HashMap requestHandlers = new HashMap();
            requestHandlers.put("initialize", this.asyncInitializeRequestHandler());
            requestHandlers.put("ping", params -> Mono.just(Collections.emptyMap()));
            if (this.serverCapabilities.tools() != null) {
                requestHandlers.put("tools/list", this.toolsListRequestHandler());
                requestHandlers.put("tools/call", this.toolsCallRequestHandler());
            }
            if (this.serverCapabilities.resources() != null) {
                requestHandlers.put("resources/list", this.resourcesListRequestHandler());
                requestHandlers.put("resources/read", this.resourcesReadRequestHandler());
                requestHandlers.put("resources/templates/list", this.resourceTemplateListRequestHandler());
            }
            if (this.serverCapabilities.prompts() != null) {
                requestHandlers.put("prompts/list", this.promptsListRequestHandler());
                requestHandlers.put("prompts/get", this.promptsGetRequestHandler());
            }
            if (this.serverCapabilities.logging() != null) {
                requestHandlers.put("logging/setLevel", this.setLoggerRequestHandler());
            }
            HashMap<String, McpClientSession.NotificationHandler> notificationHandlers = new HashMap<String, McpClientSession.NotificationHandler>();
            notificationHandlers.put("notifications/initialized", params -> Mono.empty());
            List<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> rootsChangeHandlers = features.rootsChangeConsumers();
            List<Function<List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers = rootsChangeHandlers.stream().map(handler -> roots -> (Mono)handler.apply(null, roots)).collect(Collectors.toList());
            if (Utils.isEmpty(rootsChangeConsumers)) {
                rootsChangeConsumers = Collections.singletonList(roots -> Mono.fromRunnable(() -> logger.warn("Roots list changed notification, but no consumers provided. Roots list changed: {}", roots)));
            }
            notificationHandlers.put("notifications/roots/list_changed", this.asyncRootsListChangedNotificationHandler(rootsChangeConsumers));
            this.transport = mcpTransport;
            this.mcpSession = new McpClientSession(Duration.ofSeconds(10L), mcpTransport, requestHandlers, notificationHandlers);
        }

        @Override
        public Mono<Void> addTool(McpServerFeatures.AsyncToolSpecification toolSpecification) {
            throw new IllegalArgumentException("McpAsyncServer configured with legacy transport. Use McpServerTransportProvider instead.");
        }

        @Override
        public Mono<Void> addResource(McpServerFeatures.AsyncResourceSpecification resourceHandler) {
            throw new IllegalArgumentException("McpAsyncServer configured with legacy transport. Use McpServerTransportProvider instead.");
        }

        @Override
        public Mono<Void> addPrompt(McpServerFeatures.AsyncPromptSpecification promptSpecification) {
            throw new IllegalArgumentException("McpAsyncServer configured with legacy transport. Use McpServerTransportProvider instead.");
        }

        private McpClientSession.RequestHandler<McpSchema.InitializeResult> asyncInitializeRequestHandler() {
            return params -> {
                McpSchema.InitializeRequest initializeRequest = this.transport.unmarshalFrom(params, new TypeReference<McpSchema.InitializeRequest>(){});
                this.clientCapabilities = initializeRequest.capabilities();
                this.clientInfo = initializeRequest.clientInfo();
                logger.info("Client initialize request - Protocol: {}, Capabilities: {}, Info: {}", new Object[]{initializeRequest.protocolVersion(), initializeRequest.capabilities(), initializeRequest.clientInfo()});
                String serverProtocolVersion = this.protocolVersions.get(this.protocolVersions.size() - 1);
                if (this.protocolVersions.contains(initializeRequest.protocolVersion())) {
                    serverProtocolVersion = initializeRequest.protocolVersion();
                } else {
                    logger.warn("Client requested unsupported protocol version: {}, so the server will sugggest the {} version instead", (Object)initializeRequest.protocolVersion(), (Object)serverProtocolVersion);
                }
                return Mono.just((Object)new McpSchema.InitializeResult(serverProtocolVersion, this.serverCapabilities, this.serverInfo, null));
            };
        }

        @Override
        public McpSchema.ServerCapabilities getServerCapabilities() {
            return this.serverCapabilities;
        }

        @Override
        public McpSchema.Implementation getServerInfo() {
            return this.serverInfo;
        }

        @Override
        public McpSchema.ClientCapabilities getClientCapabilities() {
            return this.clientCapabilities;
        }

        @Override
        public McpSchema.Implementation getClientInfo() {
            return this.clientInfo;
        }

        @Override
        public Mono<Void> closeGracefully() {
            return this.mcpSession.closeGracefully();
        }

        @Override
        public void close() {
            this.mcpSession.close();
        }

        @Override
        public Mono<McpSchema.ListRootsResult> listRoots() {
            return this.listRoots(null);
        }

        @Override
        public Mono<McpSchema.ListRootsResult> listRoots(String cursor) {
            return this.mcpSession.sendRequest("roots/list", new McpSchema.PaginatedRequest(cursor), LIST_ROOTS_RESULT_TYPE_REF);
        }

        private McpClientSession.NotificationHandler asyncRootsListChangedNotificationHandler(List<Function<List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers) {
            return params -> this.listRoots().flatMap(listRootsResult -> Flux.fromIterable((Iterable)rootsChangeConsumers).flatMap(consumer -> (Mono)consumer.apply(listRootsResult.roots())).onErrorResume(error -> {
                logger.error("Error handling roots list change notification", error);
                return Mono.empty();
            }).then());
        }

        @Override
        public Mono<Void> addTool(McpServerFeatures.AsyncToolRegistration toolRegistration) {
            if (toolRegistration == null) {
                return Mono.error((Throwable)new McpError((Object)"Tool registration must not be null"));
            }
            if (toolRegistration.tool() == null) {
                return Mono.error((Throwable)new McpError((Object)"Tool must not be null"));
            }
            if (toolRegistration.call() == null) {
                return Mono.error((Throwable)new McpError((Object)"Tool call handler must not be null"));
            }
            if (this.serverCapabilities.tools() == null) {
                return Mono.error((Throwable)new McpError((Object)"Server must be configured with tool capabilities"));
            }
            return Mono.defer(() -> {
                if (this.tools.stream().anyMatch(th -> th.tool().name().equals(toolRegistration.tool().name()))) {
                    return Mono.error((Throwable)new McpError((Object)("Tool with name '" + toolRegistration.tool().name() + "' already exists")));
                }
                this.tools.add(toolRegistration.toSpecification());
                logger.debug("Added tool handler: {}", (Object)toolRegistration.tool().name());
                if (this.serverCapabilities.tools().listChanged()) {
                    return this.notifyToolsListChanged();
                }
                return Mono.empty();
            });
        }

        @Override
        public Mono<Void> removeTool(String toolName) {
            if (toolName == null) {
                return Mono.error((Throwable)new McpError((Object)"Tool name must not be null"));
            }
            if (this.serverCapabilities.tools() == null) {
                return Mono.error((Throwable)new McpError((Object)"Server must be configured with tool capabilities"));
            }
            return Mono.defer(() -> {
                boolean removed = this.tools.removeIf(toolRegistration -> toolRegistration.tool().name().equals(toolName));
                if (removed) {
                    logger.debug("Removed tool handler: {}", (Object)toolName);
                    if (this.serverCapabilities.tools().listChanged()) {
                        return this.notifyToolsListChanged();
                    }
                    return Mono.empty();
                }
                return Mono.error((Throwable)new McpError((Object)("Tool with name '" + toolName + "' not found")));
            });
        }

        @Override
        public Mono<Void> notifyToolsListChanged() {
            return this.mcpSession.sendNotification("notifications/tools/list_changed", null);
        }

        private McpClientSession.RequestHandler<McpSchema.ListToolsResult> toolsListRequestHandler() {
            return params -> {
                List<McpSchema.Tool> tools = this.tools.stream().map(McpServerFeatures.AsyncToolSpecification::tool).collect(Collectors.toList());
                return Mono.just((Object)new McpSchema.ListToolsResult(tools));
            };
        }

        private McpClientSession.RequestHandler<McpSchema.CallToolResult> toolsCallRequestHandler() {
            return params -> {
                McpSchema.CallToolRequest callToolRequest = this.transport.unmarshalFrom(params, new TypeReference<McpSchema.CallToolRequest>(){});
                Optional<McpServerFeatures.AsyncToolSpecification> toolRegistration = this.tools.stream().filter(tr -> callToolRequest.name().equals(tr.tool().name())).findAny();
                if (toolRegistration.isPresent()) {
                    return Mono.error((Throwable)new McpError((Object)("Tool not found: " + callToolRequest.name())));
                }
                return toolRegistration.map(tool -> tool.call().apply(null, callToolRequest.arguments())).orElseGet(() -> Mono.error((Throwable)new McpError((Object)("Tool not found: " + callToolRequest.name()))));
            };
        }

        @Override
        public Mono<Void> addResource(McpServerFeatures.AsyncResourceRegistration resourceHandler) {
            if (resourceHandler == null || resourceHandler.resource() == null) {
                return Mono.error((Throwable)new McpError((Object)"Resource must not be null"));
            }
            if (this.serverCapabilities.resources() == null) {
                return Mono.error((Throwable)new McpError((Object)"Server must be configured with resource capabilities"));
            }
            return Mono.defer(() -> {
                if (this.resources.putIfAbsent(resourceHandler.resource().uri(), resourceHandler.toSpecification()) != null) {
                    return Mono.error((Throwable)new McpError((Object)("Resource with URI '" + resourceHandler.resource().uri() + "' already exists")));
                }
                logger.debug("Added resource handler: {}", (Object)resourceHandler.resource().uri());
                if (this.serverCapabilities.resources().listChanged()) {
                    return this.notifyResourcesListChanged();
                }
                return Mono.empty();
            });
        }

        @Override
        public Mono<Void> removeResource(String resourceUri) {
            if (resourceUri == null) {
                return Mono.error((Throwable)new McpError((Object)"Resource URI must not be null"));
            }
            if (this.serverCapabilities.resources() == null) {
                return Mono.error((Throwable)new McpError((Object)"Server must be configured with resource capabilities"));
            }
            return Mono.defer(() -> {
                McpServerFeatures.AsyncResourceSpecification removed = this.resources.remove(resourceUri);
                if (removed != null) {
                    logger.debug("Removed resource handler: {}", (Object)resourceUri);
                    if (this.serverCapabilities.resources().listChanged()) {
                        return this.notifyResourcesListChanged();
                    }
                    return Mono.empty();
                }
                return Mono.error((Throwable)new McpError((Object)("Resource with URI '" + resourceUri + "' not found")));
            });
        }

        @Override
        public Mono<Void> notifyResourcesListChanged() {
            return this.mcpSession.sendNotification("notifications/resources/list_changed", null);
        }

        private McpClientSession.RequestHandler<McpSchema.ListResourcesResult> resourcesListRequestHandler() {
            return params -> {
                List<McpSchema.Resource> resourceList = this.resources.values().stream().map(McpServerFeatures.AsyncResourceSpecification::resource).collect(Collectors.toList());
                return Mono.just((Object)new McpSchema.ListResourcesResult(resourceList, null));
            };
        }

        private McpClientSession.RequestHandler<McpSchema.ListResourceTemplatesResult> resourceTemplateListRequestHandler() {
            return params -> Mono.just((Object)new McpSchema.ListResourceTemplatesResult(this.resourceTemplates, null));
        }

        private McpClientSession.RequestHandler<McpSchema.ReadResourceResult> resourcesReadRequestHandler() {
            return params -> {
                McpSchema.ReadResourceRequest resourceRequest = this.transport.unmarshalFrom(params, new TypeReference<McpSchema.ReadResourceRequest>(){});
                String resourceUri = resourceRequest.uri();
                McpServerFeatures.AsyncResourceSpecification registration = this.resources.get(resourceUri);
                if (registration != null) {
                    return registration.readHandler().apply(null, resourceRequest);
                }
                return Mono.error((Throwable)new McpError((Object)("Resource not found: " + resourceUri)));
            };
        }

        @Override
        public Mono<Void> addPrompt(McpServerFeatures.AsyncPromptRegistration promptRegistration) {
            if (promptRegistration == null) {
                return Mono.error((Throwable)new McpError((Object)"Prompt registration must not be null"));
            }
            if (this.serverCapabilities.prompts() == null) {
                return Mono.error((Throwable)new McpError((Object)"Server must be configured with prompt capabilities"));
            }
            return Mono.defer(() -> {
                McpServerFeatures.AsyncPromptSpecification registration = this.prompts.putIfAbsent(promptRegistration.prompt().name(), promptRegistration.toSpecification());
                if (registration != null) {
                    return Mono.error((Throwable)new McpError((Object)("Prompt with name '" + promptRegistration.prompt().name() + "' already exists")));
                }
                logger.debug("Added prompt handler: {}", (Object)promptRegistration.prompt().name());
                if (this.serverCapabilities.prompts().listChanged()) {
                    return this.notifyPromptsListChanged();
                }
                return Mono.empty();
            });
        }

        @Override
        public Mono<Void> removePrompt(String promptName) {
            if (promptName == null) {
                return Mono.error((Throwable)new McpError((Object)"Prompt name must not be null"));
            }
            if (this.serverCapabilities.prompts() == null) {
                return Mono.error((Throwable)new McpError((Object)"Server must be configured with prompt capabilities"));
            }
            return Mono.defer(() -> {
                McpServerFeatures.AsyncPromptSpecification removed = this.prompts.remove(promptName);
                if (removed != null) {
                    logger.debug("Removed prompt handler: {}", (Object)promptName);
                    if (this.serverCapabilities.prompts().listChanged()) {
                        return this.notifyPromptsListChanged();
                    }
                    return Mono.empty();
                }
                return Mono.error((Throwable)new McpError((Object)("Prompt with name '" + promptName + "' not found")));
            });
        }

        @Override
        public Mono<Void> notifyPromptsListChanged() {
            return this.mcpSession.sendNotification("notifications/prompts/list_changed", null);
        }

        private McpClientSession.RequestHandler<McpSchema.ListPromptsResult> promptsListRequestHandler() {
            return params -> {
                List<McpSchema.Prompt> promptList = this.prompts.values().stream().map(McpServerFeatures.AsyncPromptSpecification::prompt).collect(Collectors.toList());
                return Mono.just((Object)new McpSchema.ListPromptsResult(promptList, null));
            };
        }

        private McpClientSession.RequestHandler<McpSchema.GetPromptResult> promptsGetRequestHandler() {
            return params -> {
                McpSchema.GetPromptRequest promptRequest = this.transport.unmarshalFrom(params, new TypeReference<McpSchema.GetPromptRequest>(){});
                McpServerFeatures.AsyncPromptSpecification registration = this.prompts.get(promptRequest.name());
                if (registration == null) {
                    return Mono.error((Throwable)new McpError((Object)("Prompt not found: " + promptRequest.name())));
                }
                return registration.promptHandler().apply(null, promptRequest);
            };
        }

        @Override
        public Mono<Void> loggingNotification(McpSchema.LoggingMessageNotification loggingMessageNotification) {
            if (loggingMessageNotification == null) {
                return Mono.error((Throwable)new McpError((Object)"Logging message must not be null"));
            }
            Map<String, Object> params = this.transport.unmarshalFrom(loggingMessageNotification, new TypeReference<Map<String, Object>>(){});
            if (loggingMessageNotification.level().level() < this.minLoggingLevel.level()) {
                return Mono.empty();
            }
            return this.mcpSession.sendNotification("notifications/message", params);
        }

        private McpClientSession.RequestHandler<Void> setLoggerRequestHandler() {
            return params -> {
                this.minLoggingLevel = this.transport.unmarshalFrom(params, new TypeReference<McpSchema.LoggingLevel>(){});
                return Mono.empty();
            };
        }

        @Override
        public Mono<McpSchema.CreateMessageResult> createMessage(McpSchema.CreateMessageRequest createMessageRequest) {
            if (this.clientCapabilities == null) {
                return Mono.error((Throwable)new McpError((Object)"Client must be initialized. Call the initialize method first!"));
            }
            if (this.clientCapabilities.sampling() == null) {
                return Mono.error((Throwable)new McpError((Object)"Client must be configured with sampling capabilities"));
            }
            return this.mcpSession.sendRequest("sampling/createMessage", createMessageRequest, CREATE_MESSAGE_RESULT_TYPE_REF);
        }

        @Override
        void setProtocolVersions(List<String> protocolVersions) {
            this.protocolVersions = protocolVersions;
        }
    }

    static class AsyncServerImpl
    extends McpAsyncServer {
        private final McpServerTransportProvider mcpTransportProvider;
        private final ObjectMapper objectMapper;
        private final McpSchema.ServerCapabilities serverCapabilities;
        private final McpSchema.Implementation serverInfo;
        private final CopyOnWriteArrayList<McpServerFeatures.AsyncToolSpecification> tools = new CopyOnWriteArrayList();
        private final CopyOnWriteArrayList<McpSchema.ResourceTemplate> resourceTemplates = new CopyOnWriteArrayList();
        private final ConcurrentHashMap<String, McpServerFeatures.AsyncResourceSpecification> resources = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, McpServerFeatures.AsyncPromptSpecification> prompts = new ConcurrentHashMap();
        private McpSchema.LoggingLevel minLoggingLevel = McpSchema.LoggingLevel.DEBUG;
        private List<String> protocolVersions = Collections.singletonList("2024-11-05");

        AsyncServerImpl(McpServerTransportProvider mcpTransportProvider, ObjectMapper objectMapper, McpServerFeatures.Async features) {
            this.mcpTransportProvider = mcpTransportProvider;
            this.objectMapper = objectMapper;
            this.serverInfo = features.serverInfo();
            this.serverCapabilities = features.serverCapabilities();
            this.tools.addAll(features.tools());
            this.resources.putAll(features.resources());
            this.resourceTemplates.addAll(features.resourceTemplates());
            this.prompts.putAll(features.prompts());
            HashMap requestHandlers = new HashMap();
            requestHandlers.put("ping", (exchange, params) -> Mono.just(Collections.emptyMap()));
            if (this.serverCapabilities.tools() != null) {
                requestHandlers.put("tools/list", this.toolsListRequestHandler());
                requestHandlers.put("tools/call", this.toolsCallRequestHandler());
            }
            if (this.serverCapabilities.resources() != null) {
                requestHandlers.put("resources/list", this.resourcesListRequestHandler());
                requestHandlers.put("resources/read", this.resourcesReadRequestHandler());
                requestHandlers.put("resources/templates/list", this.resourceTemplateListRequestHandler());
            }
            if (this.serverCapabilities.prompts() != null) {
                requestHandlers.put("prompts/list", this.promptsListRequestHandler());
                requestHandlers.put("prompts/get", this.promptsGetRequestHandler());
            }
            if (this.serverCapabilities.logging() != null) {
                requestHandlers.put("logging/setLevel", this.setLoggerRequestHandler());
            }
            HashMap<String, McpServerSession.NotificationHandler> notificationHandlers = new HashMap<String, McpServerSession.NotificationHandler>();
            notificationHandlers.put("notifications/initialized", (exchange, params) -> Mono.empty());
            List<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers = features.rootsChangeConsumers();
            if (Utils.isEmpty(rootsChangeConsumers)) {
                rootsChangeConsumers = Collections.singletonList((exchange, roots) -> Mono.fromRunnable(() -> logger.warn("Roots list changed notification, but no consumers provided. Roots list changed: {}", roots)));
            }
            notificationHandlers.put("notifications/roots/list_changed", this.asyncRootsListChangedNotificationHandler(rootsChangeConsumers));
            mcpTransportProvider.setSessionFactory(transport -> new McpServerSession(UUID.randomUUID().toString(), transport, this::asyncInitializeRequestHandler, Mono::empty, requestHandlers, notificationHandlers));
        }

        private Mono<McpSchema.InitializeResult> asyncInitializeRequestHandler(McpSchema.InitializeRequest initializeRequest) {
            return Mono.defer(() -> {
                logger.info("Client initialize request - Protocol: {}, Capabilities: {}, Info: {}", new Object[]{initializeRequest.protocolVersion(), initializeRequest.capabilities(), initializeRequest.clientInfo()});
                String serverProtocolVersion = this.protocolVersions.get(this.protocolVersions.size() - 1);
                if (this.protocolVersions.contains(initializeRequest.protocolVersion())) {
                    serverProtocolVersion = initializeRequest.protocolVersion();
                } else {
                    logger.warn("Client requested unsupported protocol version: {}, so the server will sugggest the {} version instead", (Object)initializeRequest.protocolVersion(), (Object)serverProtocolVersion);
                }
                return Mono.just((Object)new McpSchema.InitializeResult(serverProtocolVersion, this.serverCapabilities, this.serverInfo, null));
            });
        }

        @Override
        public McpSchema.ServerCapabilities getServerCapabilities() {
            return this.serverCapabilities;
        }

        @Override
        public McpSchema.Implementation getServerInfo() {
            return this.serverInfo;
        }

        @Override
        @Deprecated
        public McpSchema.ClientCapabilities getClientCapabilities() {
            throw new IllegalStateException("This method is deprecated and should not be called");
        }

        @Override
        @Deprecated
        public McpSchema.Implementation getClientInfo() {
            throw new IllegalStateException("This method is deprecated and should not be called");
        }

        @Override
        public Mono<Void> closeGracefully() {
            return this.mcpTransportProvider.closeGracefully();
        }

        @Override
        public void close() {
            this.mcpTransportProvider.close();
        }

        @Override
        @Deprecated
        public Mono<McpSchema.ListRootsResult> listRoots() {
            return this.listRoots(null);
        }

        @Override
        @Deprecated
        public Mono<McpSchema.ListRootsResult> listRoots(String cursor) {
            return Mono.error((Throwable)new RuntimeException("Not implemented"));
        }

        private McpServerSession.NotificationHandler asyncRootsListChangedNotificationHandler(final List<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers) {
            return new McpServerSession.NotificationHandler(){

                @Override
                public Mono<Void> handle(final McpAsyncServerExchange exchange, Object params) {
                    return exchange.listRoots().flatMap(listRootsResult -> Flux.fromIterable((Iterable)rootsChangeConsumers).flatMap((Function)new Function<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>, Mono<Void>>(){

                        @Override
                        public Mono<Void> apply(BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>> consumer) {
                            return consumer.apply(exchange, listRootsResult.roots());
                        }
                    }).onErrorResume((Function)new Function<Throwable, Mono<Void>>(){

                        @Override
                        public Mono<Void> apply(Throwable error) {
                            logger.error("Error handling roots list change notification", error);
                            return Mono.empty();
                        }
                    }).then());
                }
            };
        }

        @Override
        public Mono<Void> addTool(McpServerFeatures.AsyncToolSpecification toolSpecification) {
            if (toolSpecification == null) {
                return Mono.error((Throwable)new McpError((Object)"Tool specification must not be null"));
            }
            if (toolSpecification.tool() == null) {
                return Mono.error((Throwable)new McpError((Object)"Tool must not be null"));
            }
            if (toolSpecification.call() == null) {
                return Mono.error((Throwable)new McpError((Object)"Tool call handler must not be null"));
            }
            if (this.serverCapabilities.tools() == null) {
                return Mono.error((Throwable)new McpError((Object)"Server must be configured with tool capabilities"));
            }
            return Mono.defer(() -> {
                if (this.tools.stream().anyMatch(th -> th.tool().name().equals(toolSpecification.tool().name()))) {
                    return Mono.error((Throwable)new McpError((Object)("Tool with name '" + toolSpecification.tool().name() + "' already exists")));
                }
                this.tools.add(toolSpecification);
                logger.debug("Added tool handler: {}", (Object)toolSpecification.tool().name());
                if (this.serverCapabilities.tools().listChanged()) {
                    return this.notifyToolsListChanged();
                }
                return Mono.empty();
            });
        }

        @Override
        public Mono<Void> addTool(McpServerFeatures.AsyncToolRegistration toolRegistration) {
            return this.addTool(toolRegistration.toSpecification());
        }

        @Override
        public Mono<Void> removeTool(String toolName) {
            if (toolName == null) {
                return Mono.error((Throwable)new McpError((Object)"Tool name must not be null"));
            }
            if (this.serverCapabilities.tools() == null) {
                return Mono.error((Throwable)new McpError((Object)"Server must be configured with tool capabilities"));
            }
            return Mono.defer(() -> {
                boolean removed = this.tools.removeIf(toolSpecification -> toolSpecification.tool().name().equals(toolName));
                if (removed) {
                    logger.debug("Removed tool handler: {}", (Object)toolName);
                    if (this.serverCapabilities.tools().listChanged()) {
                        return this.notifyToolsListChanged();
                    }
                    return Mono.empty();
                }
                return Mono.error((Throwable)new McpError((Object)("Tool with name '" + toolName + "' not found")));
            });
        }

        @Override
        public Mono<Void> notifyToolsListChanged() {
            return this.mcpTransportProvider.notifyClients("notifications/tools/list_changed", null);
        }

        private McpServerSession.RequestHandler<McpSchema.ListToolsResult> toolsListRequestHandler() {
            return new McpServerSession.RequestHandler<McpSchema.ListToolsResult>(){

                @Override
                public Mono<McpSchema.ListToolsResult> handle(McpAsyncServerExchange exchange, Object params) {
                    ArrayList<McpSchema.Tool> toolList = new ArrayList<McpSchema.Tool>();
                    for (McpServerFeatures.AsyncToolSpecification spec : tools) {
                        toolList.add(spec.tool());
                    }
                    return Mono.just((Object)new McpSchema.ListToolsResult(toolList));
                }
            };
        }

        private McpServerSession.RequestHandler<McpSchema.CallToolResult> toolsCallRequestHandler() {
            return new McpServerSession.RequestHandler<McpSchema.CallToolResult>(){

                @Override
                public Mono<McpSchema.CallToolResult> handle(McpAsyncServerExchange exchange, Object params) {
                    final McpSchema.CallToolRequest callToolRequest = (McpSchema.CallToolRequest)objectMapper.convertValue(params, (TypeReference)new TypeReference<McpSchema.CallToolRequest>(){});
                    Optional<McpServerFeatures.AsyncToolSpecification> toolSpecification = tools.stream().filter(new Predicate<McpServerFeatures.AsyncToolSpecification>(){

                        @Override
                        public boolean test(McpServerFeatures.AsyncToolSpecification tr) {
                            return callToolRequest.name().equals(tr.tool().name());
                        }
                    }).findAny();
                    if (!toolSpecification.isPresent()) {
                        return Mono.error((Throwable)new McpError((Object)("Tool not found: " + callToolRequest.name())));
                    }
                    return toolSpecification.get().call().apply(exchange, callToolRequest.arguments());
                }
            };
        }

        @Override
        public Mono<Void> addResource(McpServerFeatures.AsyncResourceSpecification resourceSpecification) {
            if (resourceSpecification == null || resourceSpecification.resource() == null) {
                return Mono.error((Throwable)new McpError((Object)"Resource must not be null"));
            }
            if (this.serverCapabilities.resources() == null) {
                return Mono.error((Throwable)new McpError((Object)"Server must be configured with resource capabilities"));
            }
            return Mono.defer(() -> {
                if (this.resources.putIfAbsent(resourceSpecification.resource().uri(), resourceSpecification) != null) {
                    return Mono.error((Throwable)new McpError((Object)("Resource with URI '" + resourceSpecification.resource().uri() + "' already exists")));
                }
                logger.debug("Added resource handler: {}", (Object)resourceSpecification.resource().uri());
                if (this.serverCapabilities.resources().listChanged()) {
                    return this.notifyResourcesListChanged();
                }
                return Mono.empty();
            });
        }

        @Override
        public Mono<Void> addResource(McpServerFeatures.AsyncResourceRegistration resourceHandler) {
            return this.addResource(resourceHandler.toSpecification());
        }

        @Override
        public Mono<Void> removeResource(String resourceUri) {
            if (resourceUri == null) {
                return Mono.error((Throwable)new McpError((Object)"Resource URI must not be null"));
            }
            if (this.serverCapabilities.resources() == null) {
                return Mono.error((Throwable)new McpError((Object)"Server must be configured with resource capabilities"));
            }
            return Mono.defer(() -> {
                McpServerFeatures.AsyncResourceSpecification removed = this.resources.remove(resourceUri);
                if (removed != null) {
                    logger.debug("Removed resource handler: {}", (Object)resourceUri);
                    if (this.serverCapabilities.resources().listChanged()) {
                        return this.notifyResourcesListChanged();
                    }
                    return Mono.empty();
                }
                return Mono.error((Throwable)new McpError((Object)("Resource with URI '" + resourceUri + "' not found")));
            });
        }

        @Override
        public Mono<Void> notifyResourcesListChanged() {
            return this.mcpTransportProvider.notifyClients("notifications/resources/list_changed", null);
        }

        private McpServerSession.RequestHandler<McpSchema.ListResourcesResult> resourcesListRequestHandler() {
            return new McpServerSession.RequestHandler<McpSchema.ListResourcesResult>(){

                @Override
                public Mono<McpSchema.ListResourcesResult> handle(McpAsyncServerExchange exchange, Object params) {
                    List<McpSchema.Resource> resourceList = resources.values().stream().map(new Function<McpServerFeatures.AsyncResourceSpecification, McpSchema.Resource>(){

                        @Override
                        public McpSchema.Resource apply(McpServerFeatures.AsyncResourceSpecification spec) {
                            return spec.resource();
                        }
                    }).collect(Collectors.toList());
                    return Mono.just((Object)new McpSchema.ListResourcesResult(resourceList, null));
                }
            };
        }

        private McpServerSession.RequestHandler<McpSchema.ListResourceTemplatesResult> resourceTemplateListRequestHandler() {
            return new McpServerSession.RequestHandler<McpSchema.ListResourceTemplatesResult>(){

                @Override
                public Mono<McpSchema.ListResourceTemplatesResult> handle(McpAsyncServerExchange exchange, Object params) {
                    return Mono.just((Object)new McpSchema.ListResourceTemplatesResult(resourceTemplates, null));
                }
            };
        }

        private McpServerSession.RequestHandler<McpSchema.ReadResourceResult> resourcesReadRequestHandler() {
            return new McpServerSession.RequestHandler<McpSchema.ReadResourceResult>(){

                @Override
                public Mono<McpSchema.ReadResourceResult> handle(McpAsyncServerExchange exchange, Object params) {
                    McpSchema.ReadResourceRequest resourceRequest = (McpSchema.ReadResourceRequest)objectMapper.convertValue(params, (TypeReference)new TypeReference<McpSchema.ReadResourceRequest>(){});
                    String resourceUri = resourceRequest.uri();
                    McpServerFeatures.AsyncResourceSpecification specification = (McpServerFeatures.AsyncResourceSpecification)resources.get(resourceUri);
                    if (specification != null) {
                        return specification.readHandler().apply(exchange, resourceRequest);
                    }
                    return Mono.error((Throwable)new McpError((Object)("Resource not found: " + resourceUri)));
                }
            };
        }

        @Override
        public Mono<Void> addPrompt(McpServerFeatures.AsyncPromptSpecification promptSpecification) {
            if (promptSpecification == null) {
                return Mono.error((Throwable)new McpError((Object)"Prompt specification must not be null"));
            }
            if (this.serverCapabilities.prompts() == null) {
                return Mono.error((Throwable)new McpError((Object)"Server must be configured with prompt capabilities"));
            }
            return Mono.defer(() -> {
                McpServerFeatures.AsyncPromptSpecification specification = this.prompts.putIfAbsent(promptSpecification.prompt().name(), promptSpecification);
                if (specification != null) {
                    return Mono.error((Throwable)new McpError((Object)("Prompt with name '" + promptSpecification.prompt().name() + "' already exists")));
                }
                logger.debug("Added prompt handler: {}", (Object)promptSpecification.prompt().name());
                if (this.serverCapabilities.prompts().listChanged()) {
                    return this.notifyPromptsListChanged();
                }
                return Mono.empty();
            });
        }

        @Override
        public Mono<Void> addPrompt(McpServerFeatures.AsyncPromptRegistration promptRegistration) {
            return this.addPrompt(promptRegistration.toSpecification());
        }

        @Override
        public Mono<Void> removePrompt(String promptName) {
            if (promptName == null) {
                return Mono.error((Throwable)new McpError((Object)"Prompt name must not be null"));
            }
            if (this.serverCapabilities.prompts() == null) {
                return Mono.error((Throwable)new McpError((Object)"Server must be configured with prompt capabilities"));
            }
            return Mono.defer(() -> {
                McpServerFeatures.AsyncPromptSpecification removed = this.prompts.remove(promptName);
                if (removed != null) {
                    logger.debug("Removed prompt handler: {}", (Object)promptName);
                    if (this.serverCapabilities.prompts().listChanged()) {
                        return this.notifyPromptsListChanged();
                    }
                    return Mono.empty();
                }
                return Mono.error((Throwable)new McpError((Object)("Prompt with name '" + promptName + "' not found")));
            });
        }

        @Override
        public Mono<Void> notifyPromptsListChanged() {
            return this.mcpTransportProvider.notifyClients("notifications/prompts/list_changed", null);
        }

        private McpServerSession.RequestHandler<McpSchema.ListPromptsResult> promptsListRequestHandler() {
            return new McpServerSession.RequestHandler<McpSchema.ListPromptsResult>(){

                @Override
                public Mono<McpSchema.ListPromptsResult> handle(McpAsyncServerExchange exchange, Object params) {
                    List<McpSchema.Prompt> promptList = prompts.values().stream().map(new Function<McpServerFeatures.AsyncPromptSpecification, McpSchema.Prompt>(){

                        @Override
                        public McpSchema.Prompt apply(McpServerFeatures.AsyncPromptSpecification spec) {
                            return spec.prompt();
                        }
                    }).collect(Collectors.toList());
                    return Mono.just((Object)new McpSchema.ListPromptsResult(promptList, null));
                }
            };
        }

        private McpServerSession.RequestHandler<McpSchema.GetPromptResult> promptsGetRequestHandler() {
            return new McpServerSession.RequestHandler<McpSchema.GetPromptResult>(){

                @Override
                public Mono<McpSchema.GetPromptResult> handle(McpAsyncServerExchange exchange, Object params) {
                    McpSchema.GetPromptRequest promptRequest = (McpSchema.GetPromptRequest)objectMapper.convertValue(params, (TypeReference)new TypeReference<McpSchema.GetPromptRequest>(){});
                    McpServerFeatures.AsyncPromptSpecification specification = (McpServerFeatures.AsyncPromptSpecification)prompts.get(promptRequest.name());
                    if (specification == null) {
                        return Mono.error((Throwable)new McpError((Object)("Prompt not found: " + promptRequest.name())));
                    }
                    return specification.promptHandler().apply(exchange, promptRequest);
                }
            };
        }

        @Override
        public Mono<Void> loggingNotification(McpSchema.LoggingMessageNotification loggingMessageNotification) {
            if (loggingMessageNotification == null) {
                return Mono.error((Throwable)new McpError((Object)"Logging message must not be null"));
            }
            Map params = (Map)this.objectMapper.convertValue((Object)loggingMessageNotification, (TypeReference)new TypeReference<Map<String, Object>>(){});
            if (loggingMessageNotification.level().level() < this.minLoggingLevel.level()) {
                return Mono.empty();
            }
            return this.mcpTransportProvider.notifyClients("notifications/message", params);
        }

        private McpServerSession.RequestHandler<Void> setLoggerRequestHandler() {
            return new McpServerSession.RequestHandler<Void>(){

                @Override
                public Mono<Void> handle(McpAsyncServerExchange exchange, Object params) {
                    minLoggingLevel = (McpSchema.LoggingLevel)((Object)objectMapper.convertValue(params, (TypeReference)new TypeReference<McpSchema.LoggingLevel>(){}));
                    return Mono.empty();
                }
            };
        }

        @Override
        @Deprecated
        public Mono<McpSchema.CreateMessageResult> createMessage(McpSchema.CreateMessageRequest createMessageRequest) {
            return Mono.error((Throwable)new RuntimeException("Not implemented"));
        }

        @Override
        void setProtocolVersions(List<String> protocolVersions) {
            this.protocolVersions = protocolVersions;
        }
    }
}

