/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.mcp.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import kd.ai.mcp.server.McpAsyncServer;
import kd.ai.mcp.server.McpAsyncServerExchange;
import kd.ai.mcp.server.McpServerFeatures;
import kd.ai.mcp.server.McpSyncServer;
import kd.ai.mcp.server.McpSyncServerExchange;
import kd.ai.mcp.spec.McpSchema;
import kd.ai.mcp.spec.McpServerSession;
import kd.ai.mcp.spec.McpServerTransportProvider;
import kd.ai.mcp.spec.ServerMcpTransport;
import kd.ai.mcp.util.Assert;
import kd.ai.mcp.util.Utils;
import reactor.core.publisher.Mono;

public interface McpServer {
    public static SyncSpecification sync(McpServerTransportProvider transportProvider) {
        return new SyncSpecification(transportProvider);
    }

    @Deprecated
    public static SyncSpec sync(ServerMcpTransport transport) {
        return new SyncSpec(transport);
    }

    public static AsyncSpecification async(McpServerTransportProvider transportProvider) {
        return new AsyncSpecification(transportProvider);
    }

    @Deprecated
    public static AsyncSpec async(ServerMcpTransport transport) {
        return new AsyncSpec(transport);
    }

    public static class SyncSpecification {
        private static final McpSchema.Implementation DEFAULT_SERVER_INFO = new McpSchema.Implementation("mcp-server", "1.0.0", null, null, null, null, null);
        private final McpServerTransportProvider transportProvider;
        private final List<McpServerFeatures.SyncToolSpecification> tools = new ArrayList<McpServerFeatures.SyncToolSpecification>();
        private final Map<String, McpServerFeatures.SyncResourceSpecification> resources = new HashMap<String, McpServerFeatures.SyncResourceSpecification>();
        private final List<McpSchema.ResourceTemplate> resourceTemplates = new ArrayList<McpSchema.ResourceTemplate>();
        private final Map<String, McpServerFeatures.SyncPromptSpecification> prompts = new HashMap<String, McpServerFeatures.SyncPromptSpecification>();
        private final List<BiConsumer<McpSyncServerExchange, List<McpSchema.Root>>> rootsChangeHandlers = new ArrayList<BiConsumer<McpSyncServerExchange, List<McpSchema.Root>>>();
        private ObjectMapper objectMapper;
        private McpSchema.Implementation serverInfo = DEFAULT_SERVER_INFO;
        private McpSchema.ServerCapabilities serverCapabilities;

        private SyncSpecification(McpServerTransportProvider transportProvider) {
            Assert.notNull(transportProvider, "Transport provider must not be null");
            this.transportProvider = transportProvider;
        }

        public SyncSpecification serverInfo(McpSchema.Implementation serverInfo) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            return this;
        }

        public SyncSpecification serverInfo(String name, String version) {
            Assert.hasText(name, "Name must not be null or empty");
            Assert.hasText(version, "Version must not be null or empty");
            this.serverInfo = new McpSchema.Implementation(name, version, null, null, null, null, null);
            return this;
        }

        public SyncSpecification capabilities(McpSchema.ServerCapabilities serverCapabilities) {
            Assert.notNull(serverCapabilities, "Server capabilities must not be null");
            this.serverCapabilities = serverCapabilities;
            return this;
        }

        public SyncSpecification tool(McpServerFeatures.SyncToolSpecification toolSpecification) {
            Assert.notNull(toolSpecification, "Tool specification must not be null");
            this.tools.add(toolSpecification);
            return this;
        }

        public SyncSpecification tools(McpServerFeatures.SyncToolSpecification ... toolSpecifications) {
            Assert.notNull(toolSpecifications, "Tool specifications must not be null");
            if (toolSpecifications.length == 0) {
                throw new IllegalArgumentException("Tool specifications must not be empty");
            }
            this.tools.addAll(Arrays.asList(toolSpecifications));
            return this;
        }

        public SyncSpecification tool(McpSchema.Tool tool, BiFunction<McpSyncServerExchange, Map<String, Object>, McpSchema.CallToolResult> handler) {
            Assert.notNull(tool, "Tool must not be null");
            Assert.notNull(handler, "Handler must not be null");
            this.tools.add(new McpServerFeatures.SyncToolSpecification(tool, handler));
            return this;
        }

        public SyncSpecification resource(McpServerFeatures.SyncResourceSpecification resourceSpecification) {
            Assert.notNull(resourceSpecification, "Resource specification must not be null");
            this.resources.put(resourceSpecification.resource().uri(), resourceSpecification);
            return this;
        }

        public SyncSpecification resources(McpServerFeatures.SyncResourceSpecification ... resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource specifications must not be null");
            if (resourceSpecifications.length == 0) {
                throw new IllegalArgumentException("Resource specifications must not be empty");
            }
            for (McpServerFeatures.SyncResourceSpecification resourceSpecification : resourceSpecifications) {
                this.resources.put(resourceSpecification.resource().uri(), resourceSpecification);
            }
            return this;
        }

        public SyncSpecification resource(McpSchema.Resource resource, BiFunction<McpSyncServerExchange, McpSchema.ReadResourceRequest, McpSchema.ReadResourceResult> handler) {
            Assert.notNull(resource, "Resource must not be null");
            Assert.notNull(handler, "Handler must not be null");
            this.resources.put(resource.uri(), new McpServerFeatures.SyncResourceSpecification(resource, handler));
            return this;
        }

        public SyncSpecification resourceTemplate(McpSchema.ResourceTemplate resourceTemplate) {
            Assert.notNull(resourceTemplate, "Resource template must not be null");
            this.resourceTemplates.add(resourceTemplate);
            return this;
        }

        public SyncSpecification resourceTemplates(McpSchema.ResourceTemplate ... resourceTemplates) {
            Assert.notNull(resourceTemplates, "Resource templates must not be null");
            if (resourceTemplates.length == 0) {
                throw new IllegalArgumentException("Resource templates must not be empty");
            }
            this.resourceTemplates.addAll(Arrays.asList(resourceTemplates));
            return this;
        }

        public SyncSpecification prompt(McpServerFeatures.SyncPromptSpecification promptSpecification) {
            Assert.notNull(promptSpecification, "Prompt specification must not be null");
            this.prompts.put(promptSpecification.prompt().name(), promptSpecification);
            return this;
        }

        public SyncSpecification prompts(McpServerFeatures.SyncPromptSpecification ... promptSpecifications) {
            Assert.notNull(promptSpecifications, "Prompt specifications must not be null");
            if (promptSpecifications.length == 0) {
                throw new IllegalArgumentException("Prompt specifications must not be empty");
            }
            for (McpServerFeatures.SyncPromptSpecification promptSpecification : promptSpecifications) {
                this.prompts.put(promptSpecification.prompt().name(), promptSpecification);
            }
            return this;
        }

        public SyncSpecification prompt(McpSchema.Prompt prompt, BiFunction<McpSyncServerExchange, McpSchema.GetPromptRequest, McpSchema.GetPromptResult> handler) {
            Assert.notNull(prompt, "Prompt must not be null");
            Assert.notNull(handler, "Handler must not be null");
            this.prompts.put(prompt.name(), new McpServerFeatures.SyncPromptSpecification(prompt, handler));
            return this;
        }

        public SyncSpecification rootsChangeHandler(BiConsumer<McpSyncServerExchange, List<McpSchema.Root>> rootsChangeHandler) {
            Assert.notNull(rootsChangeHandler, "Roots change handler must not be null");
            this.rootsChangeHandlers.add(rootsChangeHandler);
            return this;
        }

        public SyncSpecification objectMapper(ObjectMapper objectMapper) {
            Assert.notNull(objectMapper, "Object mapper must not be null");
            this.objectMapper = objectMapper;
            return this;
        }

        public McpSyncServer build() {
            McpServerFeatures.Sync features = new McpServerFeatures.Sync(this.serverInfo, this.serverCapabilities != null ? this.serverCapabilities : new McpSchema.ServerCapabilities.Builder().logging(true).prompts(!Utils.isEmpty(this.prompts)).resources(!Utils.isEmpty(this.resources), !Utils.isEmpty(this.resources)).tools(!Utils.isEmpty(this.tools)).build(), this.tools, this.resources, this.resourceTemplates, this.prompts, this.rootsChangeHandlers);
            return new McpSyncServer(this.objectMapper != null ? new McpAsyncServer.AsyncServerImpl(this.transportProvider, this.objectMapper, McpServerFeatures.Async.fromSync(features)) : new McpAsyncServer.LegacyAsyncServer(this.transportProvider.createTransport(), McpServerFeatures.Async.fromSync(features)));
        }
    }

    public static class AsyncSpecification {
        private static final McpSchema.Implementation DEFAULT_SERVER_INFO = new McpSchema.Implementation("mcp-server", "1.0.0", null, null, null, null, null);
        private final McpServerTransportProvider transportProvider;
        private final List<McpServerFeatures.AsyncToolSpecification> tools = new ArrayList<McpServerFeatures.AsyncToolSpecification>();
        private final Map<String, McpServerFeatures.AsyncResourceSpecification> resources = new HashMap<String, McpServerFeatures.AsyncResourceSpecification>();
        private final List<McpSchema.ResourceTemplate> resourceTemplates = new ArrayList<McpSchema.ResourceTemplate>();
        private final Map<String, McpServerFeatures.AsyncPromptSpecification> prompts = new HashMap<String, McpServerFeatures.AsyncPromptSpecification>();
        private final List<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> rootsChangeHandlers = new ArrayList<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>>();
        private ObjectMapper objectMapper = new ObjectMapper();
        private McpSchema.Implementation serverInfo = DEFAULT_SERVER_INFO;
        private McpSchema.ServerCapabilities serverCapabilities;

        private AsyncSpecification(McpServerTransportProvider transportProvider) {
            Assert.notNull(transportProvider, "Transport provider must not be null");
            this.transportProvider = transportProvider;
        }

        public AsyncSpecification serverInfo(McpSchema.Implementation serverInfo) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            return this;
        }

        public AsyncSpecification serverInfo(String name, String version) {
            Assert.hasText(name, "Name must not be null or empty");
            Assert.hasText(version, "Version must not be null or empty");
            this.serverInfo = new McpSchema.Implementation(name, version, null, null, null, null, null);
            return this;
        }

        public AsyncSpecification capabilities(McpSchema.ServerCapabilities serverCapabilities) {
            Assert.notNull(serverCapabilities, "Server capabilities must not be null");
            this.serverCapabilities = serverCapabilities;
            return this;
        }

        public AsyncSpecification tool(McpServerFeatures.AsyncToolSpecification toolSpecification) {
            Assert.notNull(toolSpecification, "Tool specification must not be null");
            this.tools.add(toolSpecification);
            return this;
        }

        public AsyncSpecification tools(McpServerFeatures.AsyncToolSpecification ... toolSpecifications) {
            Assert.notNull(toolSpecifications, "Tool specifications must not be null");
            if (toolSpecifications.length == 0) {
                throw new IllegalArgumentException("Tool specifications must not be empty");
            }
            this.tools.addAll(Arrays.asList(toolSpecifications));
            return this;
        }

        public AsyncSpecification tool(McpSchema.Tool tool, BiFunction<McpAsyncServerExchange, Map<String, Object>, Mono<McpSchema.CallToolResult>> handler) {
            Assert.notNull(tool, "Tool must not be null");
            Assert.notNull(handler, "Handler must not be null");
            this.tools.add(new McpServerFeatures.AsyncToolSpecification(tool, handler));
            return this;
        }

        public AsyncSpecification resource(McpServerFeatures.AsyncResourceSpecification resourceSpecification) {
            Assert.notNull(resourceSpecification, "Resource specification must not be null");
            this.resources.put(resourceSpecification.resource().uri(), resourceSpecification);
            return this;
        }

        public AsyncSpecification resources(McpServerFeatures.AsyncResourceSpecification ... resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource specifications must not be null");
            if (resourceSpecifications.length == 0) {
                throw new IllegalArgumentException("Resource specifications must not be empty");
            }
            for (McpServerFeatures.AsyncResourceSpecification resourceSpecification : resourceSpecifications) {
                this.resources.put(resourceSpecification.resource().uri(), resourceSpecification);
            }
            return this;
        }

        public AsyncSpecification resource(McpSchema.Resource resource, BiFunction<McpAsyncServerExchange, McpSchema.ReadResourceRequest, Mono<McpSchema.ReadResourceResult>> handler) {
            Assert.notNull(resource, "Resource must not be null");
            Assert.notNull(handler, "Handler must not be null");
            this.resources.put(resource.uri(), new McpServerFeatures.AsyncResourceSpecification(resource, handler));
            return this;
        }

        public AsyncSpecification resourceTemplate(McpSchema.ResourceTemplate resourceTemplate) {
            Assert.notNull(resourceTemplate, "Resource template must not be null");
            this.resourceTemplates.add(resourceTemplate);
            return this;
        }

        public AsyncSpecification resourceTemplates(McpSchema.ResourceTemplate ... resourceTemplates) {
            Assert.notNull(resourceTemplates, "Resource templates must not be null");
            if (resourceTemplates.length == 0) {
                throw new IllegalArgumentException("Resource templates must not be empty");
            }
            this.resourceTemplates.addAll(Arrays.asList(resourceTemplates));
            return this;
        }

        public AsyncSpecification prompt(McpServerFeatures.AsyncPromptSpecification promptSpecification) {
            Assert.notNull(promptSpecification, "Prompt specification must not be null");
            this.prompts.put(promptSpecification.prompt().name(), promptSpecification);
            return this;
        }

        public AsyncSpecification prompts(McpServerFeatures.AsyncPromptSpecification ... promptSpecifications) {
            Assert.notNull(promptSpecifications, "Prompt specifications must not be null");
            if (promptSpecifications.length == 0) {
                throw new IllegalArgumentException("Prompt specifications must not be empty");
            }
            for (McpServerFeatures.AsyncPromptSpecification promptSpecification : promptSpecifications) {
                this.prompts.put(promptSpecification.prompt().name(), promptSpecification);
            }
            return this;
        }

        public AsyncSpecification prompt(McpSchema.Prompt prompt, BiFunction<McpAsyncServerExchange, McpSchema.GetPromptRequest, Mono<McpSchema.GetPromptResult>> handler) {
            Assert.notNull(prompt, "Prompt must not be null");
            Assert.notNull(handler, "Handler must not be null");
            this.prompts.put(prompt.name(), new McpServerFeatures.AsyncPromptSpecification(prompt, handler));
            return this;
        }

        public AsyncSpecification rootsChangeHandler(BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>> rootsChangeHandler) {
            Assert.notNull(rootsChangeHandler, "Roots change handler must not be null");
            this.rootsChangeHandlers.add(rootsChangeHandler);
            return this;
        }

        public AsyncSpecification objectMapper(ObjectMapper objectMapper) {
            Assert.notNull(objectMapper, "Object mapper must not be null");
            this.objectMapper = objectMapper;
            return this;
        }

        public McpAsyncServer build() {
            McpServerFeatures.Async features = new McpServerFeatures.Async(this.serverInfo, this.serverCapabilities != null ? this.serverCapabilities : new McpSchema.ServerCapabilities.Builder().logging(true).prompts(!Utils.isEmpty(this.prompts)).resources(!Utils.isEmpty(this.resources), !Utils.isEmpty(this.resources)).tools(!Utils.isEmpty(this.tools)).build(), this.tools, this.resources, this.resourceTemplates, this.prompts, this.rootsChangeHandlers);
            return this.objectMapper != null ? new McpAsyncServer.AsyncServerImpl(this.transportProvider, this.objectMapper, features) : new McpAsyncServer.LegacyAsyncServer(this.transportProvider.createTransport(), features);
        }
    }

    @Deprecated
    public static class SyncSpec
    extends SyncSpecification {
        private SyncSpec(final ServerMcpTransport transport) {
            super(new McpServerTransportProvider(){

                @Override
                public void setSessionFactory(McpServerSession.Factory factory) {
                }

                @Override
                public ServerMcpTransport createTransport() {
                    return transport;
                }

                @Override
                public Mono<Void> notifyClients(String method, Map<String, Object> params) {
                    return Mono.empty();
                }

                @Override
                public Mono<Void> closeGracefully() {
                    return Mono.empty();
                }

                @Override
                public void close() {
                }
            });
        }
    }

    @Deprecated
    public static class AsyncSpec
    extends AsyncSpecification {
        private AsyncSpec(final ServerMcpTransport transport) {
            super(new McpServerTransportProvider(){

                @Override
                public void setSessionFactory(McpServerSession.Factory factory) {
                }

                @Override
                public ServerMcpTransport createTransport() {
                    return transport;
                }

                @Override
                public Mono<Void> notifyClients(String method, Map<String, Object> params) {
                    return Mono.empty();
                }

                @Override
                public Mono<Void> closeGracefully() {
                    return Mono.empty();
                }

                @Override
                public void close() {
                }
            });
        }
    }
}

