/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.mcp.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import kd.ai.mcp.server.McpAsyncServerExchange;
import kd.ai.mcp.server.McpSyncServerExchange;
import kd.ai.mcp.spec.McpSchema;
import kd.ai.mcp.util.Assert;
import kd.ai.mcp.util.Utils;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class McpServerFeatures {

    @Deprecated
    public static class SyncPromptRegistration {
        private final McpSchema.Prompt prompt;
        private final Function<McpSchema.GetPromptRequest, McpSchema.GetPromptResult> promptHandler;

        public SyncPromptRegistration(McpSchema.Prompt prompt, Function<McpSchema.GetPromptRequest, McpSchema.GetPromptResult> promptHandler) {
            this.prompt = prompt;
            this.promptHandler = promptHandler;
        }

        public McpSchema.Prompt prompt() {
            return this.prompt;
        }

        public Function<McpSchema.GetPromptRequest, McpSchema.GetPromptResult> promptHandler() {
            return this.promptHandler;
        }

        public SyncPromptSpecification toSpecification() {
            return new SyncPromptSpecification(this.prompt, (exchange, request) -> this.promptHandler.apply((McpSchema.GetPromptRequest)request));
        }
    }

    @Deprecated
    public static class SyncResourceRegistration {
        private final McpSchema.Resource resource;
        private final Function<McpSchema.ReadResourceRequest, McpSchema.ReadResourceResult> readHandler;

        public SyncResourceRegistration(McpSchema.Resource resource, Function<McpSchema.ReadResourceRequest, McpSchema.ReadResourceResult> readHandler) {
            this.resource = resource;
            this.readHandler = readHandler;
        }

        public McpSchema.Resource resource() {
            return this.resource;
        }

        public Function<McpSchema.ReadResourceRequest, McpSchema.ReadResourceResult> readHandler() {
            return this.readHandler;
        }

        public SyncResourceSpecification toSpecification() {
            return new SyncResourceSpecification(this.resource, (exchange, request) -> this.readHandler.apply((McpSchema.ReadResourceRequest)request));
        }
    }

    @Deprecated
    public static class SyncToolRegistration {
        private final McpSchema.Tool tool;
        private final Function<Map<String, Object>, McpSchema.CallToolResult> call;

        public SyncToolRegistration(McpSchema.Tool tool, Function<Map<String, Object>, McpSchema.CallToolResult> call) {
            this.tool = tool;
            this.call = call;
        }

        public McpSchema.Tool tool() {
            return this.tool;
        }

        public Function<Map<String, Object>, McpSchema.CallToolResult> call() {
            return this.call;
        }

        public SyncToolSpecification toSpecification() {
            return new SyncToolSpecification(this.tool, (exchange, map) -> this.call.apply((Map<String, Object>)map));
        }
    }

    @Deprecated
    public static class AsyncPromptRegistration {
        private final McpSchema.Prompt prompt;
        private final Function<McpSchema.GetPromptRequest, Mono<McpSchema.GetPromptResult>> promptHandler;

        public AsyncPromptRegistration(McpSchema.Prompt prompt, Function<McpSchema.GetPromptRequest, Mono<McpSchema.GetPromptResult>> promptHandler) {
            this.prompt = prompt;
            this.promptHandler = promptHandler;
        }

        public McpSchema.Prompt prompt() {
            return this.prompt;
        }

        public Function<McpSchema.GetPromptRequest, Mono<McpSchema.GetPromptResult>> promptHandler() {
            return this.promptHandler;
        }

        static AsyncPromptRegistration fromSync(SyncPromptRegistration prompt) {
            if (prompt == null) {
                return null;
            }
            return new AsyncPromptRegistration(prompt.prompt(), req -> Mono.fromCallable(() -> prompt.promptHandler().apply((McpSchema.GetPromptRequest)req)).subscribeOn(Schedulers.boundedElastic()));
        }

        public AsyncPromptSpecification toSpecification() {
            return new AsyncPromptSpecification(this.prompt(), (exchange, request) -> this.promptHandler.apply((McpSchema.GetPromptRequest)request));
        }
    }

    @Deprecated
    public static class AsyncResourceRegistration {
        private final McpSchema.Resource resource;
        private final Function<McpSchema.ReadResourceRequest, Mono<McpSchema.ReadResourceResult>> readHandler;

        public AsyncResourceRegistration(McpSchema.Resource resource, Function<McpSchema.ReadResourceRequest, Mono<McpSchema.ReadResourceResult>> readHandler) {
            this.resource = resource;
            this.readHandler = readHandler;
        }

        public McpSchema.Resource resource() {
            return this.resource;
        }

        public Function<McpSchema.ReadResourceRequest, Mono<McpSchema.ReadResourceResult>> readHandler() {
            return this.readHandler;
        }

        static AsyncResourceRegistration fromSync(SyncResourceRegistration resource) {
            if (resource == null) {
                return null;
            }
            return new AsyncResourceRegistration(resource.resource(), req -> Mono.fromCallable(() -> resource.readHandler().apply((McpSchema.ReadResourceRequest)req)).subscribeOn(Schedulers.boundedElastic()));
        }

        public AsyncResourceSpecification toSpecification() {
            return new AsyncResourceSpecification(this.resource(), (exchange, request) -> this.readHandler.apply((McpSchema.ReadResourceRequest)request));
        }
    }

    @Deprecated
    public static class AsyncToolRegistration {
        private final McpSchema.Tool tool;
        private final Function<Map<String, Object>, Mono<McpSchema.CallToolResult>> call;

        public AsyncToolRegistration(McpSchema.Tool tool, Function<Map<String, Object>, Mono<McpSchema.CallToolResult>> call) {
            this.tool = tool;
            this.call = call;
        }

        public McpSchema.Tool tool() {
            return this.tool;
        }

        public Function<Map<String, Object>, Mono<McpSchema.CallToolResult>> call() {
            return this.call;
        }

        static AsyncToolRegistration fromSync(SyncToolRegistration tool) {
            if (tool == null) {
                return null;
            }
            return new AsyncToolRegistration(tool.tool(), map -> Mono.fromCallable(() -> tool.call().apply((Map<String, Object>)map)).subscribeOn(Schedulers.boundedElastic()));
        }

        public AsyncToolSpecification toSpecification() {
            return new AsyncToolSpecification(this.tool(), (exchange, map) -> this.call.apply((Map<String, Object>)map));
        }
    }

    public static class SyncPromptSpecification {
        private final McpSchema.Prompt prompt;
        private final BiFunction<McpSyncServerExchange, McpSchema.GetPromptRequest, McpSchema.GetPromptResult> promptHandler;

        public SyncPromptSpecification(McpSchema.Prompt prompt, BiFunction<McpSyncServerExchange, McpSchema.GetPromptRequest, McpSchema.GetPromptResult> promptHandler) {
            this.prompt = prompt;
            this.promptHandler = promptHandler;
        }

        public McpSchema.Prompt prompt() {
            return this.prompt;
        }

        public BiFunction<McpSyncServerExchange, McpSchema.GetPromptRequest, McpSchema.GetPromptResult> promptHandler() {
            return this.promptHandler;
        }
    }

    public static class SyncResourceSpecification {
        private final McpSchema.Resource resource;
        private final BiFunction<McpSyncServerExchange, McpSchema.ReadResourceRequest, McpSchema.ReadResourceResult> readHandler;

        public SyncResourceSpecification(McpSchema.Resource resource, BiFunction<McpSyncServerExchange, McpSchema.ReadResourceRequest, McpSchema.ReadResourceResult> readHandler) {
            this.resource = resource;
            this.readHandler = readHandler;
        }

        public McpSchema.Resource resource() {
            return this.resource;
        }

        public BiFunction<McpSyncServerExchange, McpSchema.ReadResourceRequest, McpSchema.ReadResourceResult> readHandler() {
            return this.readHandler;
        }
    }

    public static class SyncToolSpecification {
        private final McpSchema.Tool tool;
        private final BiFunction<McpSyncServerExchange, Map<String, Object>, McpSchema.CallToolResult> call;

        public SyncToolSpecification(McpSchema.Tool tool, BiFunction<McpSyncServerExchange, Map<String, Object>, McpSchema.CallToolResult> call) {
            this.tool = tool;
            this.call = call;
        }

        public McpSchema.Tool tool() {
            return this.tool;
        }

        public BiFunction<McpSyncServerExchange, Map<String, Object>, McpSchema.CallToolResult> call() {
            return this.call;
        }
    }

    public static class AsyncPromptSpecification {
        private final McpSchema.Prompt prompt;
        private final BiFunction<McpAsyncServerExchange, McpSchema.GetPromptRequest, Mono<McpSchema.GetPromptResult>> promptHandler;

        public AsyncPromptSpecification(McpSchema.Prompt prompt, BiFunction<McpAsyncServerExchange, McpSchema.GetPromptRequest, Mono<McpSchema.GetPromptResult>> promptHandler) {
            this.prompt = prompt;
            this.promptHandler = promptHandler;
        }

        public McpSchema.Prompt prompt() {
            return this.prompt;
        }

        public BiFunction<McpAsyncServerExchange, McpSchema.GetPromptRequest, Mono<McpSchema.GetPromptResult>> promptHandler() {
            return this.promptHandler;
        }

        static AsyncPromptSpecification fromSync(SyncPromptSpecification prompt) {
            if (prompt == null) {
                return null;
            }
            return new AsyncPromptSpecification(prompt.prompt(), (exchange, req) -> Mono.fromCallable(() -> prompt.promptHandler().apply(new McpSyncServerExchange((McpAsyncServerExchange)exchange), (McpSchema.GetPromptRequest)req)).subscribeOn(Schedulers.boundedElastic()));
        }
    }

    public static class AsyncResourceSpecification {
        private final McpSchema.Resource resource;
        private final BiFunction<McpAsyncServerExchange, McpSchema.ReadResourceRequest, Mono<McpSchema.ReadResourceResult>> readHandler;

        public AsyncResourceSpecification(McpSchema.Resource resource, BiFunction<McpAsyncServerExchange, McpSchema.ReadResourceRequest, Mono<McpSchema.ReadResourceResult>> readHandler) {
            this.resource = resource;
            this.readHandler = readHandler;
        }

        public McpSchema.Resource resource() {
            return this.resource;
        }

        public BiFunction<McpAsyncServerExchange, McpSchema.ReadResourceRequest, Mono<McpSchema.ReadResourceResult>> readHandler() {
            return this.readHandler;
        }

        static AsyncResourceSpecification fromSync(SyncResourceSpecification resource) {
            if (resource == null) {
                return null;
            }
            return new AsyncResourceSpecification(resource.resource(), (exchange, req) -> Mono.fromCallable(() -> resource.readHandler().apply(new McpSyncServerExchange((McpAsyncServerExchange)exchange), (McpSchema.ReadResourceRequest)req)).subscribeOn(Schedulers.boundedElastic()));
        }
    }

    public static class AsyncToolSpecification {
        private final McpSchema.Tool tool;
        private final BiFunction<McpAsyncServerExchange, Map<String, Object>, Mono<McpSchema.CallToolResult>> call;

        public AsyncToolSpecification(McpSchema.Tool tool, BiFunction<McpAsyncServerExchange, Map<String, Object>, Mono<McpSchema.CallToolResult>> call) {
            this.tool = tool;
            this.call = call;
        }

        public McpSchema.Tool tool() {
            return this.tool;
        }

        public BiFunction<McpAsyncServerExchange, Map<String, Object>, Mono<McpSchema.CallToolResult>> call() {
            return this.call;
        }

        static AsyncToolSpecification fromSync(SyncToolSpecification tool) {
            if (tool == null) {
                return null;
            }
            return new AsyncToolSpecification(tool.tool(), (exchange, map) -> Mono.fromCallable(() -> tool.call().apply(new McpSyncServerExchange((McpAsyncServerExchange)exchange), (Map<String, Object>)map)).subscribeOn(Schedulers.boundedElastic()));
        }
    }

    public static class Sync {
        private final McpSchema.Implementation serverInfo;
        private final McpSchema.ServerCapabilities serverCapabilities;
        private final List<SyncToolSpecification> tools;
        private final Map<String, SyncResourceSpecification> resources;
        private final List<McpSchema.ResourceTemplate> resourceTemplates;
        private final Map<String, SyncPromptSpecification> prompts;
        private final List<BiConsumer<McpSyncServerExchange, List<McpSchema.Root>>> rootsChangeConsumers;

        public Sync(McpSchema.Implementation serverInfo, McpSchema.ServerCapabilities serverCapabilities, List<SyncToolSpecification> tools, Map<String, SyncResourceSpecification> resources, List<McpSchema.ResourceTemplate> resourceTemplates, Map<String, SyncPromptSpecification> prompts, List<BiConsumer<McpSyncServerExchange, List<McpSchema.Root>>> rootsChangeConsumers) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            this.serverCapabilities = serverCapabilities != null ? serverCapabilities : new McpSchema.ServerCapabilities.Builder().logging(true).prompts(!Utils.isEmpty(prompts)).resources(!Utils.isEmpty(resources), !Utils.isEmpty(resources)).tools(!Utils.isEmpty(tools)).build();
            this.tools = tools != null ? tools : new ArrayList();
            this.resources = resources != null ? resources : new HashMap();
            this.resourceTemplates = resourceTemplates != null ? resourceTemplates : new ArrayList();
            this.prompts = prompts != null ? prompts : new HashMap();
            this.rootsChangeConsumers = rootsChangeConsumers != null ? rootsChangeConsumers : new ArrayList();
        }

        public McpSchema.Implementation serverInfo() {
            return this.serverInfo;
        }

        public McpSchema.ServerCapabilities serverCapabilities() {
            return this.serverCapabilities;
        }

        public List<SyncToolSpecification> tools() {
            return this.tools;
        }

        public Map<String, SyncResourceSpecification> resources() {
            return this.resources;
        }

        public List<McpSchema.ResourceTemplate> resourceTemplates() {
            return this.resourceTemplates;
        }

        public Map<String, SyncPromptSpecification> prompts() {
            return this.prompts;
        }

        public List<BiConsumer<McpSyncServerExchange, List<McpSchema.Root>>> rootsChangeConsumers() {
            return this.rootsChangeConsumers;
        }
    }

    public static class Async {
        private final McpSchema.Implementation serverInfo;
        private final McpSchema.ServerCapabilities serverCapabilities;
        private final List<AsyncToolSpecification> tools;
        private final Map<String, AsyncResourceSpecification> resources;
        private final List<McpSchema.ResourceTemplate> resourceTemplates;
        private final Map<String, AsyncPromptSpecification> prompts;
        private final List<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers;

        public Async(McpSchema.Implementation serverInfo, McpSchema.ServerCapabilities serverCapabilities, List<AsyncToolSpecification> tools, Map<String, AsyncResourceSpecification> resources, List<McpSchema.ResourceTemplate> resourceTemplates, Map<String, AsyncPromptSpecification> prompts, List<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            this.serverCapabilities = serverCapabilities != null ? serverCapabilities : new McpSchema.ServerCapabilities.Builder().logging(true).prompts(!Utils.isEmpty(prompts)).resources(!Utils.isEmpty(resources), !Utils.isEmpty(resources)).tools(!Utils.isEmpty(tools)).build();
            this.tools = tools != null ? tools : new ArrayList();
            this.resources = resources != null ? resources : new HashMap();
            this.resourceTemplates = resourceTemplates != null ? resourceTemplates : new ArrayList();
            this.prompts = prompts != null ? prompts : new HashMap();
            this.rootsChangeConsumers = rootsChangeConsumers != null ? rootsChangeConsumers : new ArrayList();
        }

        public McpSchema.Implementation serverInfo() {
            return this.serverInfo;
        }

        public McpSchema.ServerCapabilities serverCapabilities() {
            return this.serverCapabilities;
        }

        public List<AsyncToolSpecification> tools() {
            return this.tools;
        }

        public Map<String, AsyncResourceSpecification> resources() {
            return this.resources;
        }

        public List<McpSchema.ResourceTemplate> resourceTemplates() {
            return this.resourceTemplates;
        }

        public Map<String, AsyncPromptSpecification> prompts() {
            return this.prompts;
        }

        public List<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers() {
            return this.rootsChangeConsumers;
        }

        static Async fromSync(Sync syncSpec) {
            ArrayList<AsyncToolSpecification> tools = new ArrayList<AsyncToolSpecification>(syncSpec.tools.size());
            for (SyncToolSpecification tool : syncSpec.tools()) {
                tools.add(AsyncToolSpecification.fromSync(tool));
            }
            HashMap<String, AsyncResourceSpecification> resources = new HashMap<String, AsyncResourceSpecification>(syncSpec.resources().size());
            syncSpec.resources().forEach((key, resource) -> resources.put((String)key, AsyncResourceSpecification.fromSync(resource)));
            HashMap<String, AsyncPromptSpecification> prompts = new HashMap<String, AsyncPromptSpecification>(syncSpec.prompts().size());
            syncSpec.prompts().forEach((key, prompt) -> prompts.put((String)key, AsyncPromptSpecification.fromSync(prompt)));
            ArrayList<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> rootChangeConsumers = new ArrayList<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>>(syncSpec.rootsChangeConsumers().size());
            for (BiConsumer<McpSyncServerExchange, List<McpSchema.Root>> rootChangeConsumer : syncSpec.rootsChangeConsumers()) {
                rootChangeConsumers.add((exchange, list) -> Mono.fromRunnable(() -> rootChangeConsumer.accept(new McpSyncServerExchange((McpAsyncServerExchange)exchange), (List<McpSchema.Root>)list)).subscribeOn(Schedulers.boundedElastic()));
            }
            return new Async(syncSpec.serverInfo(), syncSpec.serverCapabilities(), tools, resources, syncSpec.resourceTemplates(), prompts, rootChangeConsumers);
        }
    }
}

