/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.mcp.server.transport;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.ai.mcp.client.transport.HttpUtils;
import kd.ai.mcp.spec.McpError;
import kd.ai.mcp.spec.McpSchema;
import kd.ai.mcp.spec.ServerMcpTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.EmitterProcessor;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

@WebServlet(asyncSupported=true)
@Deprecated
public class HttpServletSseServerTransport
extends HttpServlet
implements ServerMcpTransport {
    private static final Logger logger = LoggerFactory.getLogger(HttpServletSseServerTransport.class);
    public static final String UTF_8 = "UTF-8";
    public static final String APPLICATION_JSON = "application/json";
    public static final String FAILED_TO_SEND_ERROR_RESPONSE = "Failed to send error response: {}";
    public static final String DEFAULT_SSE_ENDPOINT = "/sse";
    public static final String MESSAGE_EVENT_TYPE = "message";
    public static final String ENDPOINT_EVENT_TYPE = "endpoint";
    private final ObjectMapper objectMapper;
    private final String messageEndpoint;
    private final String sseEndpoint;
    private final Map<String, ClientSession> sessions = new ConcurrentHashMap<String, ClientSession>();
    private final AtomicBoolean isClosing = new AtomicBoolean(false);
    private Function<Mono<McpSchema.JSONRPCMessage>, Mono<McpSchema.JSONRPCMessage>> connectHandler;
    private final FluxProcessor<McpSchema.JSONRPCMessage, McpSchema.JSONRPCMessage> messageProcessor;
    private final FluxSink<McpSchema.JSONRPCMessage> messageSink;

    public HttpServletSseServerTransport(ObjectMapper objectMapper, String messageEndpoint, String sseEndpoint) {
        this.objectMapper = objectMapper;
        this.messageEndpoint = messageEndpoint;
        this.sseEndpoint = sseEndpoint;
        this.messageProcessor = EmitterProcessor.create((boolean)false);
        this.messageSink = this.messageProcessor.sink();
    }

    public HttpServletSseServerTransport(ObjectMapper objectMapper, String messageEndpoint) {
        this(objectMapper, messageEndpoint, DEFAULT_SSE_ENDPOINT);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if (!this.sseEndpoint.equals(pathInfo)) {
            response.sendError(404);
            return;
        }
        if (this.isClosing.get()) {
            response.sendError(503, "Server is shutting down");
            return;
        }
        HttpUtils.setResponseHeaders(response);
        String sessionId = UUID.randomUUID().toString();
        AsyncContext asyncContext = request.startAsync();
        asyncContext.setTimeout(0L);
        PrintWriter writer = response.getWriter();
        ClientSession session = new ClientSession(sessionId, asyncContext, writer);
        this.sessions.put(sessionId, session);
        this.sendEvent(writer, ENDPOINT_EVENT_TYPE, this.messageEndpoint);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isClosing.get()) {
            response.sendError(503, "Server is shutting down");
            return;
        }
        String pathInfo = request.getPathInfo();
        if (!this.messageEndpoint.equals(pathInfo)) {
            response.sendError(404);
            return;
        }
        try {
            String line;
            BufferedReader reader = request.getReader();
            StringBuilder body = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                body.append(line);
            }
            McpSchema.JSONRPCMessage message = McpSchema.deserializeJsonRpcMessage(this.objectMapper, body.toString());
            if (this.connectHandler != null) {
                this.connectHandler.apply((Mono<McpSchema.JSONRPCMessage>)Mono.just((Object)message)).doOnNext(responseMessage -> {
                    try {
                        response.setContentType(APPLICATION_JSON);
                        response.setCharacterEncoding(UTF_8);
                        String jsonResponse = this.objectMapper.writeValueAsString(responseMessage);
                        PrintWriter writer = response.getWriter();
                        writer.write(jsonResponse);
                        writer.flush();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to write response", e);
                    }
                }).doOnError(error -> {
                    try {
                        logger.error("Error processing message: {}", (Object)error.getMessage());
                        McpError mcpError = new McpError((Object)error.getMessage());
                        response.setContentType(APPLICATION_JSON);
                        response.setCharacterEncoding(UTF_8);
                        response.setStatus(500);
                        String jsonError = this.objectMapper.writeValueAsString((Object)mcpError);
                        PrintWriter writer = response.getWriter();
                        writer.write(jsonError);
                        writer.flush();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to write error response", e);
                    }
                }).subscribe();
            } else {
                response.sendError(503, "No message handler configured");
            }
        }
        catch (Exception e) {
            logger.error("Invalid message format: {}", (Object)e.getMessage());
            try {
                McpError mcpError = new McpError((Object)("Invalid message format: " + e.getMessage()));
                response.setContentType(APPLICATION_JSON);
                response.setCharacterEncoding(UTF_8);
                response.setStatus(400);
                String jsonError = this.objectMapper.writeValueAsString((Object)mcpError);
                PrintWriter writer = response.getWriter();
                writer.write(jsonError);
                writer.flush();
            }
            catch (IOException ex) {
                logger.error(FAILED_TO_SEND_ERROR_RESPONSE, (Object)ex.getMessage());
                response.sendError(400, "Invalid message format");
            }
        }
    }

    @Override
    public Mono<Void> connect(Function<Mono<McpSchema.JSONRPCMessage>, Mono<McpSchema.JSONRPCMessage>> handler) {
        this.connectHandler = handler;
        return Mono.empty();
    }

    @Override
    public Mono<Void> sendMessage(McpSchema.JSONRPCMessage message) {
        return Mono.fromRunnable(() -> this.messageSink.next((Object)message));
    }

    @Override
    public void close() {
        ServerMcpTransport.super.close();
    }

    @Override
    public <T> T unmarshalFrom(Object data, TypeReference<T> typeRef) {
        return (T)this.objectMapper.convertValue(data, typeRef);
    }

    @Override
    public Mono<Void> closeGracefully() {
        return Mono.fromRunnable(() -> this.messageSink.complete());
    }

    private void sendEvent(PrintWriter writer, String eventType, String data) throws IOException {
        writer.write("event: " + eventType + "\n");
        writer.write("data: " + data + "\n\n");
        writer.flush();
        if (writer.checkError()) {
            throw new IOException("Client disconnected");
        }
    }

    private void removeSession(ClientSession session) {
        this.sessions.remove(session.id);
        session.asyncContext.complete();
    }

    public void destroy() {
        this.closeGracefully().block();
        super.destroy();
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getMethod().equals("GET") && request.getRequestURI().equals(this.messageEndpoint)) {
            this.handleSseRequest(request, response);
        } else {
            super.service(request, response);
        }
    }

    private void handleSseRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AsyncContext asyncContext = request.startAsync();
        asyncContext.setTimeout(0L);
        response.setContentType("text/event-stream");
        response.setCharacterEncoding(UTF_8);
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Connection", "keep-alive");
        PrintWriter writer = response.getWriter();
        this.messageProcessor.subscribe(message -> {
            try {
                writer.write("data: " + this.objectMapper.writeValueAsString(message) + "\n\n");
                writer.flush();
            }
            catch (IOException e) {
                logger.error("Failed to write SSE message", (Throwable)e);
            }
        }, error -> {
            logger.error("Error in SSE stream", error);
            asyncContext.complete();
        }, () -> asyncContext.complete());
    }

    private static class ClientSession {
        private final String id;
        private final AsyncContext asyncContext;
        private final PrintWriter writer;

        ClientSession(String id, AsyncContext asyncContext, PrintWriter writer) {
            this.id = id;
            this.asyncContext = asyncContext;
            this.writer = writer;
        }
    }
}

