/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.mcp.server.transport;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import kd.ai.mcp.spec.McpError;
import kd.ai.mcp.spec.McpSchema;
import kd.ai.mcp.spec.McpServerSession;
import kd.ai.mcp.spec.McpServerTransport;
import kd.ai.mcp.spec.McpServerTransportProvider;
import kd.ai.mcp.spec.ServerMcpTransport;
import kd.ai.mcp.util.Assert;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.EmitterProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class StdioServerTransportProvider
extends McpServerTransportProvider {
    private static final Logger logger = LoggerFactory.getLogger(StdioServerTransportProvider.class);
    private final ObjectMapper objectMapper;
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private McpServerSession session;
    private final AtomicBoolean isClosing = new AtomicBoolean(false);
    private final FluxProcessor<Void, Void> inboundReadyProcessor = EmitterProcessor.create((boolean)false);
    private final FluxSink<Void> inboundReadySink;

    public StdioServerTransportProvider() {
        this(new ObjectMapper());
    }

    public StdioServerTransportProvider(ObjectMapper objectMapper) {
        this(objectMapper, System.in, System.out);
    }

    public StdioServerTransportProvider(ObjectMapper objectMapper, InputStream inputStream, OutputStream outputStream) {
        Assert.notNull(objectMapper, "The ObjectMapper can not be null");
        Assert.notNull(inputStream, "The InputStream can not be null");
        Assert.notNull(outputStream, "The OutputStream can not be null");
        this.objectMapper = objectMapper;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.inboundReadySink = this.inboundReadyProcessor.sink();
    }

    @Override
    public void setSessionFactory(McpServerSession.Factory sessionFactory) {
        this.session = sessionFactory.create(new StdioMcpSessionTransport());
    }

    @Override
    public Mono<Void> notifyClients(String method, Map<String, Object> params) {
        if (this.session == null) {
            return Mono.error((Throwable)new McpError((Object)"No session to close"));
        }
        return this.session.sendNotification(method, params).doOnError(e -> logger.error("Failed to send notification: {}", (Object)e.getMessage()));
    }

    @Override
    public Mono<Void> closeGracefully() {
        if (this.session == null) {
            return Mono.empty();
        }
        return this.session.closeGracefully();
    }

    @Override
    public ServerMcpTransport createTransport() {
        return new StdioMcpSessionTransport();
    }

    private class StdioMcpSessionTransport
    implements McpServerTransport,
    ServerMcpTransport {
        private final FluxProcessor<McpSchema.JSONRPCMessage, McpSchema.JSONRPCMessage> inboundProcessor;
        private final FluxSink<McpSchema.JSONRPCMessage> inboundSink;
        private final FluxProcessor<McpSchema.JSONRPCMessage, McpSchema.JSONRPCMessage> outboundProcessor;
        private final FluxSink<McpSchema.JSONRPCMessage> outboundSink;
        private final AtomicBoolean isStarted = new AtomicBoolean(false);
        private Scheduler inboundScheduler;
        private Scheduler outboundScheduler;
        private final FluxProcessor<Void, Void> outboundReadyProcessor = EmitterProcessor.create((boolean)false);
        private final FluxSink<Void> outboundReadySink;

        public StdioMcpSessionTransport() {
            this.inboundProcessor = EmitterProcessor.create((boolean)false);
            this.inboundSink = this.inboundProcessor.sink();
            this.outboundProcessor = EmitterProcessor.create((boolean)false);
            this.outboundSink = this.outboundProcessor.sink();
            this.outboundReadySink = this.outboundReadyProcessor.sink();
            this.inboundScheduler = Schedulers.fromExecutorService((ExecutorService)Executors.newSingleThreadExecutor(), (String)"stdio-inbound");
            this.outboundScheduler = Schedulers.fromExecutorService((ExecutorService)Executors.newSingleThreadExecutor(), (String)"stdio-outbound");
            this.handleIncomingMessages();
            this.startInboundProcessing();
            this.startOutboundProcessing();
        }

        @Override
        public Mono<Void> sendMessage(McpSchema.JSONRPCMessage message) {
            return Mono.when((Publisher[])new Publisher[]{Mono.from((Publisher)StdioServerTransportProvider.this.inboundReadyProcessor), Mono.from(this.outboundReadyProcessor)}).then(Mono.defer(() -> {
                this.outboundSink.next((Object)message);
                return Mono.empty();
            }));
        }

        @Override
        public <T> T unmarshalFrom(Object data, TypeReference<T> typeRef) {
            return (T)StdioServerTransportProvider.this.objectMapper.convertValue(data, typeRef);
        }

        @Override
        public Mono<Void> closeGracefully() {
            return Mono.fromRunnable(() -> {
                StdioServerTransportProvider.this.isClosing.set(true);
                logger.debug("Session transport closing gracefully");
                this.inboundSink.complete();
            });
        }

        @Override
        public void close() {
            StdioServerTransportProvider.this.isClosing.set(true);
            logger.debug("Session transport closed");
        }

        private void handleIncomingMessages() {
            Flux.from(this.inboundProcessor).flatMap(message -> StdioServerTransportProvider.this.session.handle((McpSchema.JSONRPCMessage)message)).doOnTerminate(() -> {
                this.outboundSink.complete();
                this.inboundScheduler.dispose();
            }).subscribe();
        }

        private void startInboundProcessing() {
            if (this.isStarted.compareAndSet(false, true)) {
                this.inboundScheduler.schedule(() -> {
                    StdioServerTransportProvider.this.inboundReadySink.next(null);
                    BufferedReader reader = null;
                    try {
                        reader = new BufferedReader(new InputStreamReader(StdioServerTransportProvider.this.inputStream));
                        while (!StdioServerTransportProvider.this.isClosing.get()) {
                            try {
                                String line = reader.readLine();
                                if (line == null) break;
                                if (StdioServerTransportProvider.this.isClosing.get()) {
                                    break;
                                }
                                logger.debug("Received JSON message: {}", (Object)line);
                                try {
                                    McpSchema.JSONRPCMessage message = McpSchema.deserializeJsonRpcMessage(StdioServerTransportProvider.this.objectMapper, line);
                                    this.inboundSink.next((Object)message);
                                    continue;
                                }
                                catch (Exception e) {
                                    this.logIfNotClosing("Error processing inbound message", e);
                                }
                            }
                            catch (IOException e) {
                                this.logIfNotClosing("Error reading from stdin", e);
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        this.logIfNotClosing("Error in inbound processing", e);
                    }
                    finally {
                        StdioServerTransportProvider.this.isClosing.set(true);
                        if (StdioServerTransportProvider.this.session != null) {
                            StdioServerTransportProvider.this.session.close();
                        }
                        this.inboundSink.complete();
                    }
                });
            }
        }

        private void startOutboundProcessing() {
            Function<Flux, Flux> outboundConsumer = messages -> messages.doOnSubscribe(subscription -> this.outboundReadySink.next(null)).publishOn(this.outboundScheduler).handle((message, sink) -> {
                block9: {
                    if (message != null && !StdioServerTransportProvider.this.isClosing.get()) {
                        try {
                            String jsonMessage = StdioServerTransportProvider.this.objectMapper.writeValueAsString(message);
                            jsonMessage = jsonMessage.replace("\r\n", "\\n").replace("\n", "\\n").replace("\r", "\\n");
                            OutputStream outputStream = StdioServerTransportProvider.this.outputStream;
                            synchronized (outputStream) {
                                StdioServerTransportProvider.this.outputStream.write(jsonMessage.getBytes(StandardCharsets.UTF_8));
                                StdioServerTransportProvider.this.outputStream.write("\n".getBytes(StandardCharsets.UTF_8));
                                StdioServerTransportProvider.this.outputStream.flush();
                            }
                            sink.next(message);
                        }
                        catch (IOException e) {
                            if (!StdioServerTransportProvider.this.isClosing.get()) {
                                logger.error("Error writing message", (Throwable)e);
                                sink.error((Throwable)new RuntimeException(e));
                                break block9;
                            }
                            logger.debug("Stream closed during shutdown", (Throwable)e);
                        }
                    } else if (StdioServerTransportProvider.this.isClosing.get()) {
                        sink.complete();
                    }
                }
            }).doOnComplete(() -> {
                StdioServerTransportProvider.this.isClosing.set(true);
                this.outboundScheduler.dispose();
            }).doOnError(e -> {
                if (!StdioServerTransportProvider.this.isClosing.get()) {
                    logger.error("Error in outbound processing", e);
                    StdioServerTransportProvider.this.isClosing.set(true);
                    this.outboundScheduler.dispose();
                }
            }).map(msg -> (McpSchema.JSONRPCMessage)msg);
            outboundConsumer.apply(Flux.from(this.outboundProcessor)).subscribe();
        }

        private void logIfNotClosing(String message, Exception e) {
            if (!StdioServerTransportProvider.this.isClosing.get()) {
                logger.error(message, (Throwable)e);
            }
        }
    }
}

