/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.mcp.spec;

import com.fasterxml.jackson.core.type.TypeReference;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import kd.ai.mcp.spec.McpError;
import kd.ai.mcp.spec.McpSchema;
import kd.ai.mcp.spec.McpSession;
import kd.ai.mcp.spec.McpTransport;
import kd.ai.mcp.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

@Deprecated
public class DefaultMcpSession
implements McpSession {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMcpSession.class);
    private final Duration requestTimeout;
    private final McpTransport transport;
    private final ConcurrentHashMap<Object, MonoSink<McpSchema.JSONRPCResponse>> pendingResponses = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, RequestHandler<?>> requestHandlers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, NotificationHandler> notificationHandlers = new ConcurrentHashMap();
    private final String sessionPrefix = UUID.randomUUID().toString().substring(0, 8);
    private final AtomicLong requestCounter = new AtomicLong(0L);
    private final Disposable connection;

    public DefaultMcpSession(Duration requestTimeout, McpTransport transport, Map<String, RequestHandler<?>> requestHandlers, Map<String, NotificationHandler> notificationHandlers) {
        Assert.notNull(requestTimeout, "The requstTimeout can not be null");
        Assert.notNull(transport, "The transport can not be null");
        Assert.notNull(requestHandlers, "The requestHandlers can not be null");
        Assert.notNull(notificationHandlers, "The notificationHandlers can not be null");
        this.requestTimeout = requestTimeout;
        this.transport = transport;
        this.requestHandlers.putAll(requestHandlers);
        this.notificationHandlers.putAll(notificationHandlers);
        this.connection = this.transport.connect(mono -> mono.doOnNext(message -> {
            if (message instanceof McpSchema.JSONRPCResponse) {
                McpSchema.JSONRPCResponse response2 = (McpSchema.JSONRPCResponse)message;
                logger.debug("Received Response: {}", (Object)response2);
                MonoSink<McpSchema.JSONRPCResponse> sink = this.pendingResponses.remove(response2.id());
                if (sink == null) {
                    logger.warn("Unexpected response for unkown id {}", response2.id());
                } else {
                    sink.success((Object)response2);
                }
            } else if (message instanceof McpSchema.JSONRPCRequest) {
                McpSchema.JSONRPCRequest request = (McpSchema.JSONRPCRequest)message;
                logger.debug("Received request: {}", (Object)request);
                this.handleIncomingRequest(request).subscribe(response -> transport.sendMessage((McpSchema.JSONRPCMessage)response).subscribe(), error -> {
                    McpSchema.JSONRPCResponse errorResponse = new McpSchema.JSONRPCResponse("2.0", request.id(), null, new McpSchema.JSONRPCResponse.JSONRPCError(-32603, error.getMessage(), null));
                    transport.sendMessage(errorResponse).subscribe();
                });
            } else if (message instanceof McpSchema.JSONRPCNotification) {
                McpSchema.JSONRPCNotification notification = (McpSchema.JSONRPCNotification)message;
                logger.debug("Received notification: {}", (Object)notification);
                this.handleIncomingNotification(notification).subscribe(null, error -> logger.error("Error handling notification: {}", (Object)error.getMessage()));
            }
        })).subscribe();
    }

    private Mono<McpSchema.JSONRPCResponse> handleIncomingRequest(McpSchema.JSONRPCRequest request) {
        return Mono.defer(() -> {
            RequestHandler<?> handler = this.requestHandlers.get(request.method());
            if (handler == null) {
                MethodNotFoundError error2 = DefaultMcpSession.getMethodNotFoundError(request.method());
                return Mono.just((Object)new McpSchema.JSONRPCResponse("2.0", request.id(), null, new McpSchema.JSONRPCResponse.JSONRPCError(-32601, error2.message(), error2.data())));
            }
            return handler.handle(request.params()).map(result -> new McpSchema.JSONRPCResponse("2.0", request.id(), result, null)).onErrorResume(error -> Mono.just((Object)new McpSchema.JSONRPCResponse("2.0", request.id(), null, new McpSchema.JSONRPCResponse.JSONRPCError(-32603, error.getMessage(), null))));
        });
    }

    public static MethodNotFoundError getMethodNotFoundError(String method) {
        switch (method) {
            case "roots/list": {
                return new MethodNotFoundError(method, "Roots not supported", Collections.singletonMap("reason", "Client does not have roots capability"));
            }
        }
        return new MethodNotFoundError(method, "Method not found: " + method, null);
    }

    private Mono<Void> handleIncomingNotification(McpSchema.JSONRPCNotification notification) {
        return Mono.defer(() -> {
            NotificationHandler handler = this.notificationHandlers.get(notification.method());
            if (handler == null) {
                logger.error("No handler registered for notification method: {}", (Object)notification.method());
                return Mono.empty();
            }
            return handler.handle(notification.params());
        });
    }

    private String generateRequestId() {
        return this.sessionPrefix + "-" + this.requestCounter.getAndIncrement();
    }

    @Override
    public <T> Mono<T> sendRequest(String method, Object requestParams, TypeReference<T> typeRef) {
        String requestId = this.generateRequestId();
        return Mono.create(sink -> {
            this.pendingResponses.put(requestId, (MonoSink<McpSchema.JSONRPCResponse>)sink);
            McpSchema.JSONRPCRequest jsonrpcRequest = new McpSchema.JSONRPCRequest("2.0", method, requestId, requestParams);
            this.transport.sendMessage(jsonrpcRequest).subscribe(v -> {}, error -> {
                this.pendingResponses.remove(requestId);
                sink.error(error);
            });
        }).timeout(this.requestTimeout).handle((jsonRpcResponse, sink) -> {
            if (jsonRpcResponse.error() != null) {
                sink.error((Throwable)new McpError(jsonRpcResponse.error()));
            } else if (typeRef.getType().equals(Void.class)) {
                sink.complete();
            } else {
                sink.next(this.transport.unmarshalFrom(jsonRpcResponse.result(), typeRef));
            }
        });
    }

    @Override
    public Mono<Void> sendNotification(String method, Map<String, Object> params) {
        McpSchema.JSONRPCNotification jsonrpcNotification = new McpSchema.JSONRPCNotification("2.0", method, params);
        return this.transport.sendMessage(jsonrpcNotification);
    }

    @Override
    public Mono<Void> closeGracefully() {
        return Mono.defer(() -> {
            this.connection.dispose();
            return this.transport.closeGracefully();
        });
    }

    @Override
    public void close() {
        this.connection.dispose();
        this.transport.close();
    }

    private static final class MethodNotFoundError {
        private final String method;
        private final String message;
        private final Object data;

        public MethodNotFoundError(String method, String message, Object data) {
            this.method = method;
            this.message = message;
            this.data = data;
        }

        public String method() {
            return this.method;
        }

        public String message() {
            return this.message;
        }

        public Object data() {
            return this.data;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodNotFoundError that = (MethodNotFoundError)o;
            return Objects.equals(this.method, that.method) && Objects.equals(this.message, that.message) && Objects.equals(this.data, that.data);
        }

        public int hashCode() {
            return Objects.hash(this.method, this.message, this.data);
        }

        public String toString() {
            return "MethodNotFoundError{method='" + this.method + '\'' + ", message='" + this.message + '\'' + ", data=" + this.data + '}';
        }
    }

    @FunctionalInterface
    public static interface NotificationHandler {
        public Mono<Void> handle(Object var1);
    }

    @FunctionalInterface
    public static interface RequestHandler<T> {
        public Mono<T> handle(Object var1);
    }
}

