/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.mcp.spec;

import com.fasterxml.jackson.core.type.TypeReference;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import kd.ai.mcp.spec.McpError;
import kd.ai.mcp.spec.McpSchema;
import kd.ai.mcp.spec.McpSession;
import kd.ai.mcp.spec.McpTransport;
import kd.ai.mcp.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class McpClientSession
implements McpSession {
    private static final Logger logger = LoggerFactory.getLogger(McpClientSession.class);
    private final Duration requestTimeout;
    private final McpTransport transport;
    private final ConcurrentHashMap<Object, MonoSink<McpSchema.JSONRPCResponse>> pendingResponses = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, RequestHandler<?>> requestHandlers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, NotificationHandler> notificationHandlers = new ConcurrentHashMap();
    private final String sessionPrefix = UUID.randomUUID().toString().substring(0, 8);
    private final AtomicLong requestCounter = new AtomicLong(0L);
    private final Disposable connection;

    public McpClientSession(Duration requestTimeout, McpTransport transport, Map<String, RequestHandler<?>> requestHandlers, Map<String, NotificationHandler> notificationHandlers) {
        Assert.notNull(requestTimeout, "The requstTimeout can not be null");
        Assert.notNull(transport, "The transport can not be null");
        this.requestTimeout = requestTimeout;
        this.transport = transport;
        if (requestHandlers != null) {
            this.requestHandlers.putAll(requestHandlers);
        }
        if (notificationHandlers != null) {
            this.notificationHandlers.putAll(notificationHandlers);
        }
        this.connection = transport.connect(this::handleMessage).subscribe();
    }

    private Mono<McpSchema.JSONRPCMessage> handleMessage(Mono<McpSchema.JSONRPCMessage> message) {
        return message.flatMap(msg -> {
            if (msg instanceof McpSchema.JSONRPCRequest) {
                return this.handleRequest((McpSchema.JSONRPCRequest)msg);
            }
            if (msg instanceof McpSchema.JSONRPCNotification) {
                return this.handleNotification((McpSchema.JSONRPCNotification)msg).then(Mono.empty());
            }
            if (msg instanceof McpSchema.JSONRPCResponse) {
                return this.handleResponse((McpSchema.JSONRPCResponse)msg).then(Mono.empty());
            }
            return Mono.error((Throwable)new McpError((Object)("Unknown message type: " + msg.getClass())));
        });
    }

    private Mono<McpSchema.JSONRPCMessage> handleRequest(McpSchema.JSONRPCRequest request) {
        RequestHandler<?> handler = this.requestHandlers.get(request.method());
        if (handler == null) {
            McpSchema.JSONRPCResponse response2 = new McpSchema.JSONRPCResponse("2.0", request.id(), null, new McpSchema.JSONRPCResponse.JSONRPCError(-32601, "Method not found: " + request.method(), null));
            return Mono.just((Object)response2);
        }
        return handler.handle(request.params()).map(result -> new McpSchema.JSONRPCResponse("2.0", request.id(), result, null)).map(response -> response).onErrorResume(error -> Mono.just((Object)new McpSchema.JSONRPCResponse("2.0", request.id(), null, new McpSchema.JSONRPCResponse.JSONRPCError(-32000, error.getMessage(), null))).map(response -> response));
    }

    private Mono<Void> handleNotification(McpSchema.JSONRPCNotification notification) {
        NotificationHandler handler = this.notificationHandlers.get(notification.method());
        if (handler != null) {
            return handler.handle(notification.params());
        }
        return Mono.empty();
    }

    private Mono<Void> handleResponse(McpSchema.JSONRPCResponse response) {
        MonoSink<McpSchema.JSONRPCResponse> processor = this.pendingResponses.get(response.id());
        if (processor != null) {
            processor.success((Object)response);
        }
        return Mono.empty();
    }

    @Override
    public <T> Mono<T> sendRequest(String method, Object requestParams, TypeReference<T> typeRef) {
        return Mono.create(sink -> {
            String requestId = this.generateRequestId();
            this.pendingResponses.put(requestId, (MonoSink<McpSchema.JSONRPCResponse>)sink);
            McpSchema.JSONRPCRequest jsonrpcRequest = new McpSchema.JSONRPCRequest("2.0", method, requestId, requestParams);
            this.transport.sendMessage(jsonrpcRequest).subscribe(v -> logger.debug("Request sent: {}", (Object)jsonrpcRequest), error -> {
                this.pendingResponses.remove(requestId);
                sink.error(error);
            }, () -> logger.debug("Request sending completed"));
        }).timeout(this.requestTimeout).handle((jsonRpcResponse, sink) -> {
            System.out.println("____result____: " + jsonRpcResponse.result());
            if (jsonRpcResponse.error() != null) {
                sink.error((Throwable)new McpError(jsonRpcResponse.error()));
            } else if (typeRef.getType().equals(Void.class)) {
                sink.complete();
            } else {
                try {
                    Object result = this.transport.unmarshalFrom(jsonRpcResponse.result(), typeRef);
                    sink.next(result);
                }
                catch (Exception e) {
                    sink.error((Throwable)new McpError((Object)("Failed to unmarshal response: " + e.getMessage())));
                }
            }
        });
    }

    private String generateRequestId() {
        return this.sessionPrefix + "-" + this.requestCounter.getAndIncrement();
    }

    @Override
    public Mono<Void> sendNotification(String method, Map<String, Object> params) {
        McpSchema.JSONRPCNotification notification = new McpSchema.JSONRPCNotification("2.0", method, params != null ? this.transport.unmarshalFrom(params, new TypeReference<Map<String, Object>>(){}) : null);
        return this.transport.sendMessage(notification);
    }

    @Override
    public Mono<Void> closeGracefully() {
        return Mono.defer(() -> {
            this.connection.dispose();
            return this.transport.closeGracefully();
        });
    }

    @Override
    public void close() {
        this.connection.dispose();
        this.transport.close();
    }

    @FunctionalInterface
    public static interface NotificationHandler {
        public Mono<Void> handle(Object var1);
    }

    @FunctionalInterface
    public static interface RequestHandler<T> {
        public Mono<T> handle(Object var1);
    }
}

