/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.mcp.spec;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class McpSchema {
    public static final String LATEST_PROTOCOL_VERSION = "2024-11-05";
    public static final String JSONRPC_VERSION = "2.0";
    public static final String METHOD_INITIALIZE = "initialize";
    public static final String METHOD_NOTIFICATION_INITIALIZED = "notifications/initialized";
    public static final String METHOD_PING = "ping";
    public static final String METHOD_TOOLS_LIST = "tools/list";
    public static final String METHOD_TOOLS_CALL = "tools/call";
    public static final String METHOD_NOTIFICATION_TOOLS_LIST_CHANGED = "notifications/tools/list_changed";
    public static final String METHOD_RESOURCES_LIST = "resources/list";
    public static final String METHOD_RESOURCES_READ = "resources/read";
    public static final String METHOD_NOTIFICATION_RESOURCES_LIST_CHANGED = "notifications/resources/list_changed";
    public static final String METHOD_RESOURCES_TEMPLATES_LIST = "resources/templates/list";
    public static final String METHOD_RESOURCES_SUBSCRIBE = "resources/subscribe";
    public static final String METHOD_RESOURCES_UNSUBSCRIBE = "resources/unsubscribe";
    public static final String METHOD_PROMPT_LIST = "prompts/list";
    public static final String METHOD_PROMPT_GET = "prompts/get";
    public static final String METHOD_NOTIFICATION_PROMPTS_LIST_CHANGED = "notifications/prompts/list_changed";
    public static final String METHOD_LOGGING_SET_LEVEL = "logging/setLevel";
    public static final String METHOD_NOTIFICATION_MESSAGE = "notifications/message";
    public static final String METHOD_ROOTS_LIST = "roots/list";
    public static final String METHOD_NOTIFICATION_ROOTS_LIST_CHANGED = "notifications/roots/list_changed";
    public static final String METHOD_SAMPLING_CREATE_MESSAGE = "sampling/createMessage";
    private static final Logger logger = LoggerFactory.getLogger(McpSchema.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final TypeReference<HashMap<String, Object>> MAP_TYPE_REF = new TypeReference<HashMap<String, Object>>(){};

    private McpSchema() {
    }

    public static JSONRPCMessage deserializeJsonRpcMessage(ObjectMapper objectMapper, String jsonText) throws IOException {
        logger.debug("Received JSON message: {}", (Object)jsonText);
        Map map = (Map)objectMapper.readValue(jsonText, MAP_TYPE_REF);
        if (map.containsKey("method") && map.containsKey("id")) {
            return (JSONRPCMessage)objectMapper.convertValue((Object)map, JSONRPCRequest.class);
        }
        if (map.containsKey("method") && !map.containsKey("id")) {
            return (JSONRPCMessage)objectMapper.convertValue((Object)map, JSONRPCNotification.class);
        }
        if (map.containsKey("result") || map.containsKey("error")) {
            return (JSONRPCMessage)objectMapper.convertValue((Object)map, JSONRPCResponse.class);
        }
        throw new IllegalArgumentException("Cannot deserialize JSONRPCMessage: " + jsonText);
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public static class CallToolResult {
        private final List<Content> content;
        private final Boolean isError;

        @JsonCreator
        public CallToolResult(@JsonProperty(value="content") List<Content> content, @JsonProperty(value="isError") Boolean isError) {
            this.content = content;
            this.isError = isError;
        }

        @JsonProperty(value="content")
        public List<Content> content() {
            return this.content;
        }

        @JsonProperty(value="isError")
        public Boolean isError() {
            return this.isError;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public static class CallToolRequest
    implements Request {
        private final String name;
        private final Map<String, Object> arguments;

        @JsonCreator
        public CallToolRequest(@JsonProperty(value="name") String name, @JsonProperty(value="arguments") Map<String, Object> arguments) {
            this.name = name;
            this.arguments = arguments;
        }

        @JsonProperty(value="name")
        public String name() {
            return this.name;
        }

        @JsonProperty(value="arguments")
        public Map<String, Object> arguments() {
            return this.arguments;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ListRootsResult {
        private final List<Root> roots;

        @JsonCreator
        public ListRootsResult(@JsonProperty(value="roots") List<Root> roots) {
            this.roots = roots;
        }

        @JsonProperty(value="roots")
        public List<Root> roots() {
            return this.roots;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Root {
        private final String uri;
        private final String name;

        @JsonCreator
        public Root(@JsonProperty(value="uri") String uri, @JsonProperty(value="name") String name) {
            this.uri = uri;
            this.name = name;
        }

        @JsonProperty(value="uri")
        public String uri() {
            return this.uri;
        }

        @JsonProperty(value="name")
        public String name() {
            return this.name;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class EmbeddedResource
    implements Content {
        private final List<Role> audience;
        private final Double priority;
        private final ResourceContents resource;

        @JsonCreator
        public EmbeddedResource(@JsonProperty(value="audience") List<Role> audience, @JsonProperty(value="priority") Double priority, @JsonProperty(value="resource") ResourceContents resource) {
            this.audience = audience;
            this.priority = priority;
            this.resource = resource;
        }

        @JsonProperty(value="audience")
        public List<Role> audience() {
            return this.audience;
        }

        @JsonProperty(value="priority")
        public Double priority() {
            return this.priority;
        }

        @JsonProperty(value="resource")
        public ResourceContents resource() {
            return this.resource;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ImageContent
    implements Content {
        private final List<Role> audience;
        private final Double priority;
        private final String data;
        private final String mimeType;

        @JsonCreator
        public ImageContent(@JsonProperty(value="audience") List<Role> audience, @JsonProperty(value="priority") Double priority, @JsonProperty(value="data") String data, @JsonProperty(value="mimeType") String mimeType) {
            this.audience = audience;
            this.priority = priority;
            this.data = data;
            this.mimeType = mimeType;
        }

        @JsonProperty(value="audience")
        public List<Role> audience() {
            return this.audience;
        }

        @JsonProperty(value="priority")
        public Double priority() {
            return this.priority;
        }

        @JsonProperty(value="data")
        public String data() {
            return this.data;
        }

        @JsonProperty(value="mimeType")
        public String mimeType() {
            return this.mimeType;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TextContent
    implements Content {
        private final List<Role> audience;
        private final Double priority;
        private final String text;

        @JsonCreator
        public TextContent(@JsonProperty(value="audience") List<Role> audience, @JsonProperty(value="priority") Double priority, @JsonProperty(value="text") String text) {
            this.audience = audience;
            this.priority = priority;
            this.text = text;
        }

        public TextContent(String content) {
            this(null, null, content);
        }

        @JsonProperty(value="audience")
        public List<Role> audience() {
            return this.audience;
        }

        @JsonProperty(value="priority")
        public Double priority() {
            return this.priority;
        }

        @JsonProperty(value="text")
        public String text() {
            return this.text;
        }
    }

    public static class CompleteResult {
        private final CompleteCompletion completion;

        @JsonCreator
        public CompleteResult(@JsonProperty(value="completion") CompleteCompletion completion) {
            this.completion = completion;
        }

        public CompleteCompletion completion() {
            return this.completion;
        }

        public static class CompleteCompletion {
            private final List<String> values;
            private final Integer total;
            private final Boolean hasMore;

            @JsonCreator
            public CompleteCompletion(@JsonProperty(value="values") List<String> values, @JsonProperty(value="total") Integer total, @JsonProperty(value="hasMore") Boolean hasMore) {
                this.values = values;
                this.total = total;
                this.hasMore = hasMore;
            }

            @JsonProperty(value="values")
            public List<String> values() {
                return this.values;
            }

            @JsonProperty(value="total")
            public Integer total() {
                return this.total;
            }

            @JsonProperty(value="hasMore")
            public Boolean hasMore() {
                return this.hasMore;
            }
        }
    }

    public static class CompleteRequest
    implements Request {
        private final PromptOrResourceReference ref;
        private final CompleteArgument argument;

        @JsonCreator
        public CompleteRequest(@JsonProperty(value="ref") PromptOrResourceReference ref, @JsonProperty(value="argument") CompleteArgument argument) {
            this.ref = ref;
            this.argument = argument;
        }

        @JsonProperty(value="ref")
        public PromptOrResourceReference ref() {
            return this.ref;
        }

        @JsonProperty(value="argument")
        public CompleteArgument argument() {
            return this.argument;
        }

        public static class CompleteArgument {
            private final String name;
            private final String value;

            @JsonCreator
            public CompleteArgument(@JsonProperty(value="name") String name, @JsonProperty(value="value") String value) {
                this.name = name;
                this.value = value;
            }

            @JsonProperty(value="name")
            public String name() {
                return this.name;
            }

            @JsonProperty(value="value")
            public String value() {
                return this.value;
            }
        }

        public static class ResourceReference
        implements PromptOrResourceReference {
            private final String type;
            private final String uri;

            @JsonCreator
            public ResourceReference(@JsonProperty(value="type") String type, @JsonProperty(value="uri") String uri) {
                this.type = type;
                this.uri = uri;
            }

            @Override
            public String type() {
                return this.type;
            }

            @JsonProperty(value="uri")
            public String uri() {
                return this.uri;
            }
        }

        public static class PromptReference
        implements PromptOrResourceReference {
            private final String type;
            private final String name;

            @JsonCreator
            public PromptReference(@JsonProperty(value="type") String type, @JsonProperty(value="name") String name) {
                this.type = type;
                this.name = name;
            }

            @Override
            public String type() {
                return this.type;
            }

            @JsonProperty(value="name")
            public String name() {
                return this.name;
            }
        }

        public static interface PromptOrResourceReference {
            public String type();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class LoggingMessageNotification {
        private final LoggingLevel level;
        private final String logger;
        private final String data;

        @JsonCreator
        public LoggingMessageNotification(@JsonProperty(value="level") LoggingLevel level, @JsonProperty(value="logger") String logger, @JsonProperty(value="data") String data) {
            this.level = level;
            this.logger = logger;
            this.data = data;
        }

        @JsonProperty(value="level")
        public LoggingLevel level() {
            return this.level;
        }

        @JsonProperty(value="logger")
        public String logger() {
            return this.logger;
        }

        @JsonProperty(value="data")
        public String data() {
            return this.data;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ProgressNotification {
        private final String message;
        private final Map<String, Object> experimental;

        @JsonCreator
        public ProgressNotification(@JsonProperty(value="message") String message, @JsonProperty(value="experimental") Map<String, Object> experimental) {
            this.message = message;
            this.experimental = experimental;
        }

        @JsonProperty(value="message")
        public String message() {
            return this.message;
        }

        @JsonProperty(value="experimental")
        public Map<String, Object> experimental() {
            return this.experimental;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PaginatedResult {
        private final String nextCursor;

        @JsonCreator
        public PaginatedResult(@JsonProperty(value="nextCursor") String nextCursor) {
            this.nextCursor = nextCursor;
        }

        @JsonProperty(value="nextCursor")
        public String nextCursor() {
            return this.nextCursor;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PaginatedRequest
    implements Request {
        private final String cursor;

        @JsonCreator
        public PaginatedRequest(@JsonProperty(value="cursor") String cursor) {
            this.cursor = cursor;
        }

        @JsonProperty(value="cursor")
        public String cursor() {
            return this.cursor;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateMessageResult {
        private final List<Content> content;
        private final Map<String, Object> experimental;

        @JsonCreator
        public CreateMessageResult(@JsonProperty(value="content") List<Content> content, @JsonProperty(value="experimental") Map<String, Object> experimental) {
            this.content = content;
            this.experimental = experimental;
        }

        @JsonProperty(value="content")
        public List<Content> content() {
            return this.content;
        }

        @JsonProperty(value="experimental")
        public Map<String, Object> experimental() {
            return this.experimental;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateMessageRequest
    implements Request {
        private final String prompt;
        private final List<Content> context;
        private final ModelPreferences modelPreferences;
        private final Map<String, Object> experimental;

        @JsonCreator
        public CreateMessageRequest(@JsonProperty(value="prompt") String prompt, @JsonProperty(value="context") List<Content> context, @JsonProperty(value="modelPreferences") ModelPreferences modelPreferences, @JsonProperty(value="experimental") Map<String, Object> experimental) {
            this.prompt = prompt;
            this.context = context;
            this.modelPreferences = modelPreferences;
            this.experimental = experimental;
        }

        @JsonProperty(value="prompt")
        public String prompt() {
            return this.prompt;
        }

        @JsonProperty(value="context")
        public List<Content> context() {
            return this.context;
        }

        @JsonProperty(value="modelPreferences")
        public ModelPreferences modelPreferences() {
            return this.modelPreferences;
        }

        @JsonProperty(value="experimental")
        public Map<String, Object> experimental() {
            return this.experimental;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SamplingMessage {
        private final String message;
        private final Map<String, Object> experimental;

        @JsonCreator
        public SamplingMessage(@JsonProperty(value="message") String message, @JsonProperty(value="experimental") Map<String, Object> experimental) {
            this.message = message;
            this.experimental = experimental;
        }

        @JsonProperty(value="message")
        public String message() {
            return this.message;
        }

        @JsonProperty(value="experimental")
        public Map<String, Object> experimental() {
            return this.experimental;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModelHint {
        private final String name;

        @JsonCreator
        public ModelHint(@JsonProperty(value="name") String name) {
            this.name = name;
        }

        @JsonProperty(value="name")
        public String name() {
            return this.name;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModelPreferences {
        private final List<ModelHint> hints;
        private final Map<String, Object> experimental;

        @JsonCreator
        public ModelPreferences(@JsonProperty(value="hints") List<ModelHint> hints, @JsonProperty(value="experimental") Map<String, Object> experimental) {
            this.hints = hints;
            this.experimental = experimental;
        }

        @JsonProperty(value="hints")
        public List<ModelHint> hints() {
            return this.hints;
        }

        @JsonProperty(value="experimental")
        public Map<String, Object> experimental() {
            return this.experimental;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public static class Tool {
        private final String name;
        private final String description;
        private final String category;
        private final String icon;
        private final JsonSchema inputSchema;
        private final JsonSchema outputSchema;
        private final Map<String, Object> experimental;

        @JsonCreator
        public Tool(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="category") String category, @JsonProperty(value="icon") String icon, @JsonProperty(value="inputSchema") JsonSchema inputSchema, @JsonProperty(value="outputSchema") JsonSchema outputSchema, @JsonProperty(value="experimental") Map<String, Object> experimental) {
            this.name = name;
            this.description = description;
            this.category = category;
            this.icon = icon;
            this.inputSchema = inputSchema;
            this.outputSchema = outputSchema;
            this.experimental = experimental;
        }

        @JsonProperty(value="name")
        public String name() {
            return this.name;
        }

        @JsonProperty(value="description")
        public String description() {
            return this.description;
        }

        @JsonProperty(value="category")
        public String category() {
            return this.category;
        }

        @JsonProperty(value="icon")
        public String icon() {
            return this.icon;
        }

        @JsonProperty(value="inputSchema")
        public JsonSchema inputSchema() {
            return this.inputSchema;
        }

        @JsonProperty(value="outputSchema")
        public JsonSchema outputSchema() {
            return this.outputSchema;
        }

        @JsonProperty(value="experimental")
        public Map<String, Object> experimental() {
            return this.experimental;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JsonSchema {
        private final String type;
        private final String title;
        private final String description;
        private final Map<String, JsonSchema> properties;
        private final List<String> required;
        private final List<JsonSchema> anyOf;
        private final List<JsonSchema> allOf;
        private final List<JsonSchema> oneOf;
        private final JsonSchema items;
        private final Map<String, Object> experimental;

        @JsonCreator
        public JsonSchema(@JsonProperty(value="type") String type, @JsonProperty(value="title") String title, @JsonProperty(value="description") String description, @JsonProperty(value="properties") Map<String, JsonSchema> properties, @JsonProperty(value="required") List<String> required, @JsonProperty(value="anyOf") List<JsonSchema> anyOf, @JsonProperty(value="allOf") List<JsonSchema> allOf, @JsonProperty(value="oneOf") List<JsonSchema> oneOf, @JsonProperty(value="items") JsonSchema items, @JsonProperty(value="experimental") Map<String, Object> experimental) {
            this.type = type;
            this.title = title;
            this.description = description;
            this.properties = properties;
            this.required = required;
            this.anyOf = anyOf;
            this.allOf = allOf;
            this.oneOf = oneOf;
            this.items = items;
            this.experimental = experimental;
        }

        @JsonProperty(value="type")
        public String type() {
            return this.type;
        }

        @JsonProperty(value="title")
        public String title() {
            return this.title;
        }

        @JsonProperty(value="description")
        public String description() {
            return this.description;
        }

        @JsonProperty(value="properties")
        public Map<String, JsonSchema> properties() {
            return this.properties;
        }

        @JsonProperty(value="required")
        public List<String> required() {
            return this.required;
        }

        @JsonProperty(value="anyOf")
        public List<JsonSchema> anyOf() {
            return this.anyOf;
        }

        @JsonProperty(value="allOf")
        public List<JsonSchema> allOf() {
            return this.allOf;
        }

        @JsonProperty(value="oneOf")
        public List<JsonSchema> oneOf() {
            return this.oneOf;
        }

        @JsonProperty(value="items")
        public JsonSchema items() {
            return this.items;
        }

        @JsonProperty(value="experimental")
        public Map<String, Object> experimental() {
            return this.experimental;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public static class ListToolsResult {
        private final List<Tool> tools;

        @JsonCreator
        public ListToolsResult(@JsonProperty(value="tools") List<Tool> tools) {
            this.tools = tools;
        }

        @JsonProperty(value="tools")
        public List<Tool> tools() {
            return this.tools;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GetPromptResult {
        private final String description;
        private final List<PromptMessage> messages;

        @JsonCreator
        public GetPromptResult(@JsonProperty(value="description") String description, @JsonProperty(value="messages") List<PromptMessage> messages) {
            this.description = description;
            this.messages = messages;
        }

        @JsonProperty(value="description")
        public String description() {
            return this.description;
        }

        @JsonProperty(value="messages")
        public List<PromptMessage> messages() {
            return this.messages;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GetPromptRequest
    implements Request {
        private final String name;
        private final Map<String, Object> arguments;

        @JsonCreator
        public GetPromptRequest(@JsonProperty(value="name") String name, @JsonProperty(value="arguments") Map<String, Object> arguments) {
            this.name = name;
            this.arguments = arguments;
        }

        @JsonProperty(value="name")
        public String name() {
            return this.name;
        }

        @JsonProperty(value="arguments")
        public Map<String, Object> arguments() {
            return this.arguments;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GetPromptRequest that = (GetPromptRequest)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.arguments, that.arguments);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ListPromptsResult {
        private final List<Prompt> prompts;
        private final String nextCursor;

        @JsonCreator
        public ListPromptsResult(@JsonProperty(value="prompts") List<Prompt> prompts, @JsonProperty(value="nextCursor") String nextCursor) {
            this.prompts = prompts;
            this.nextCursor = nextCursor;
        }

        @JsonProperty(value="prompts")
        public List<Prompt> prompts() {
            return this.prompts;
        }

        @JsonProperty(value="nextCursor")
        public String nextCursor() {
            return this.nextCursor;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PromptMessage {
        private final Role role;
        private final Content content;

        @JsonCreator
        public PromptMessage(@JsonProperty(value="role") Role role, @JsonProperty(value="content") Content content) {
            this.role = role;
            this.content = content;
        }

        @JsonProperty(value="role")
        public Role role() {
            return this.role;
        }

        @JsonProperty(value="content")
        public Content content() {
            return this.content;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PromptArgument {
        private final String name;
        private final String description;
        private final Boolean required;

        @JsonCreator
        public PromptArgument(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="required") Boolean required) {
            this.name = name;
            this.description = description;
            this.required = required;
        }

        @JsonProperty(value="name")
        public String name() {
            return this.name;
        }

        @JsonProperty(value="description")
        public String description() {
            return this.description;
        }

        @JsonProperty(value="required")
        public Boolean required() {
            return this.required;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Prompt {
        private final String name;
        private final String description;
        private final List<PromptArgument> arguments;

        @JsonCreator
        public Prompt(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="arguments") List<PromptArgument> arguments) {
            this.name = name;
            this.description = description;
            this.arguments = arguments;
        }

        @JsonProperty(value="name")
        public String name() {
            return this.name;
        }

        @JsonProperty(value="description")
        public String description() {
            return this.description;
        }

        @JsonProperty(value="arguments")
        public List<PromptArgument> arguments() {
            return this.arguments;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class BlobResourceContents
    implements ResourceContents {
        private final String uri;
        private final String mimeType;
        private final String blob;

        @JsonCreator
        public BlobResourceContents(@JsonProperty(value="uri") String uri, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="blob") String blob) {
            this.uri = uri;
            this.mimeType = mimeType;
            this.blob = blob;
        }

        @Override
        @JsonProperty(value="uri")
        public String uri() {
            return this.uri;
        }

        @Override
        @JsonProperty(value="mimeType")
        public String mimeType() {
            return this.mimeType;
        }

        @JsonProperty(value="blob")
        public String blob() {
            return this.blob;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TextResourceContents
    implements ResourceContents {
        private final String uri;
        private final String mimeType;
        private final String text;

        @JsonCreator
        public TextResourceContents(@JsonProperty(value="uri") String uri, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="text") String text) {
            this.uri = uri;
            this.mimeType = mimeType;
            this.text = text;
        }

        @Override
        @JsonProperty(value="uri")
        public String uri() {
            return this.uri;
        }

        @Override
        @JsonProperty(value="mimeType")
        public String mimeType() {
            return this.mimeType;
        }

        @JsonProperty(value="text")
        public String text() {
            return this.text;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class UnsubscribeRequest {
        private final String uri;

        @JsonCreator
        public UnsubscribeRequest(@JsonProperty(value="uri") String uri) {
            this.uri = uri;
        }

        @JsonProperty(value="uri")
        public String uri() {
            return this.uri;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SubscribeRequest {
        private final String uri;

        @JsonCreator
        public SubscribeRequest(@JsonProperty(value="uri") String uri) {
            this.uri = uri;
        }

        @JsonProperty(value="uri")
        public String uri() {
            return this.uri;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ReadResourceResult {
        private final List<ResourceContents> contents;

        @JsonCreator
        public ReadResourceResult(@JsonProperty(value="contents") List<ResourceContents> contents) {
            this.contents = contents;
        }

        @JsonProperty(value="contents")
        public List<ResourceContents> contents() {
            return this.contents;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ReadResourceRequest {
        private final String uri;

        @JsonCreator
        public ReadResourceRequest(@JsonProperty(value="uri") String uri) {
            this.uri = uri;
        }

        @JsonProperty(value="uri")
        public String uri() {
            return this.uri;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ListResourceTemplatesResult {
        private final List<ResourceTemplate> resourceTemplates;
        private final String nextCursor;

        @JsonCreator
        public ListResourceTemplatesResult(@JsonProperty(value="resourceTemplates") List<ResourceTemplate> resourceTemplates, @JsonProperty(value="nextCursor") String nextCursor) {
            this.resourceTemplates = resourceTemplates;
            this.nextCursor = nextCursor;
        }

        @JsonProperty(value="resourceTemplates")
        public List<ResourceTemplate> resourceTemplates() {
            return this.resourceTemplates;
        }

        @JsonProperty(value="nextCursor")
        public String nextCursor() {
            return this.nextCursor;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ListResourcesResult {
        private final List<Resource> resources;
        private final String nextCursor;

        @JsonCreator
        public ListResourcesResult(@JsonProperty(value="resources") List<Resource> resources, @JsonProperty(value="nextCursor") String nextCursor) {
            this.resources = resources;
            this.nextCursor = nextCursor;
        }

        @JsonProperty(value="resources")
        public List<Resource> resources() {
            return this.resources;
        }

        @JsonProperty(value="nextCursor")
        public String nextCursor() {
            return this.nextCursor;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ResourceTemplate
    implements Annotated {
        private final String uriTemplate;
        private final String name;
        private final String description;
        private final String mimeType;
        private final Annotations annotations;

        @JsonCreator
        public ResourceTemplate(@JsonProperty(value="uriTemplate") String uriTemplate, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="annotations") Annotations annotations) {
            this.uriTemplate = uriTemplate;
            this.name = name;
            this.description = description;
            this.mimeType = mimeType;
            this.annotations = annotations;
        }

        @JsonProperty(value="uriTemplate")
        public String uriTemplate() {
            return this.uriTemplate;
        }

        @JsonProperty(value="name")
        public String name() {
            return this.name;
        }

        @JsonProperty(value="description")
        public String description() {
            return this.description;
        }

        @JsonProperty(value="mimeType")
        public String mimeType() {
            return this.mimeType;
        }

        @Override
        @JsonProperty(value="annotations")
        public Annotations annotations() {
            return this.annotations;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Resource {
        private final String uri;
        private final String name;
        private final String description;
        private final String mimeType;
        private final Annotations annotations;

        @JsonCreator
        public Resource(@JsonProperty(value="uri") String uri, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="annotations") Annotations annotations) {
            this.uri = uri;
            this.name = name;
            this.description = description;
            this.mimeType = mimeType;
            this.annotations = annotations;
        }

        @JsonProperty(value="uri")
        public String uri() {
            return this.uri;
        }

        @JsonProperty(value="name")
        public String name() {
            return this.name;
        }

        @JsonProperty(value="description")
        public String description() {
            return this.description;
        }

        @JsonProperty(value="mimeType")
        public String mimeType() {
            return this.mimeType;
        }

        @JsonProperty(value="annotations")
        public Annotations annotations() {
            return this.annotations;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public static class Annotations {
        private final List<String> audience;
        private final Double priority;

        @JsonCreator
        public Annotations(@JsonProperty(value="audience") List<String> audience, @JsonProperty(value="priority") Double priority) {
            this.audience = audience;
            this.priority = priority;
        }

        @JsonProperty(value="audience")
        public List<String> audience() {
            return this.audience;
        }

        @JsonProperty(value="priority")
        public Double priority() {
            return this.priority;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Implementation {
        private final String name;
        private final String version;
        private final String vendor;
        private final String homepage;
        private final String documentation;
        private final String repository;
        private final String license;

        @JsonCreator
        public Implementation(@JsonProperty(value="name") String name, @JsonProperty(value="version") String version, @JsonProperty(value="vendor") String vendor, @JsonProperty(value="homepage") String homepage, @JsonProperty(value="documentation") String documentation, @JsonProperty(value="repository") String repository, @JsonProperty(value="license") String license) {
            this.name = name;
            this.version = version;
            this.vendor = vendor;
            this.homepage = homepage;
            this.documentation = documentation;
            this.repository = repository;
            this.license = license;
        }

        @JsonProperty(value="name")
        public String name() {
            return this.name;
        }

        @JsonProperty(value="version")
        public String version() {
            return this.version;
        }

        @JsonProperty(value="vendor")
        public String vendor() {
            return this.vendor;
        }

        @JsonProperty(value="homepage")
        public String homepage() {
            return this.homepage;
        }

        @JsonProperty(value="documentation")
        public String documentation() {
            return this.documentation;
        }

        @JsonProperty(value="repository")
        public String repository() {
            return this.repository;
        }

        @JsonProperty(value="license")
        public String license() {
            return this.license;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ServerCapabilities {
        private final Map<String, Object> experimental;
        private final LoggingCapabilities logging;
        private final PromptCapabilities prompts;
        private final ResourceCapabilities resources;
        private final ToolCapabilities tools;

        @JsonCreator
        public ServerCapabilities(@JsonProperty(value="experimental") Map<String, Object> experimental, @JsonProperty(value="logging") LoggingCapabilities logging, @JsonProperty(value="prompts") PromptCapabilities prompts, @JsonProperty(value="resources") ResourceCapabilities resources, @JsonProperty(value="tools") ToolCapabilities tools) {
            this.experimental = experimental;
            this.logging = logging;
            this.prompts = prompts;
            this.resources = resources;
            this.tools = tools;
        }

        @JsonProperty(value="experimental")
        public Map<String, Object> experimental() {
            return this.experimental;
        }

        @JsonProperty(value="logging")
        public LoggingCapabilities logging() {
            return this.logging;
        }

        @JsonProperty(value="prompts")
        public PromptCapabilities prompts() {
            return this.prompts;
        }

        @JsonProperty(value="resources")
        public ResourceCapabilities resources() {
            return this.resources;
        }

        @JsonProperty(value="tools")
        public ToolCapabilities tools() {
            return this.tools;
        }

        public static class Builder {
            private Map<String, Object> experimental;
            private LoggingCapabilities logging;
            private PromptCapabilities prompts;
            private ResourceCapabilities resources;
            private ToolCapabilities tools;

            public Builder experimental(Map<String, Object> experimental) {
                this.experimental = experimental;
                return this;
            }

            public Builder logging(boolean setLevel) {
                this.logging = new LoggingCapabilities(setLevel);
                return this;
            }

            public Builder prompts(boolean listChanged) {
                this.prompts = new PromptCapabilities(listChanged);
                return this;
            }

            public Builder resources(boolean listChanged, boolean readResource) {
                this.resources = new ResourceCapabilities(listChanged, readResource);
                return this;
            }

            public Builder tools(boolean listChanged) {
                this.tools = new ToolCapabilities(listChanged);
                return this;
            }

            public ServerCapabilities build() {
                return new ServerCapabilities(this.experimental, this.logging, this.prompts, this.resources, this.tools);
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class ToolCapabilities {
            private final boolean listChanged;

            @JsonCreator
            public ToolCapabilities() {
                this.listChanged = false;
            }

            @JsonCreator
            public ToolCapabilities(@JsonProperty(value="listChanged") boolean listChanged) {
                this.listChanged = listChanged;
            }

            @JsonProperty(value="listChanged")
            public boolean listChanged() {
                return this.listChanged;
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class ResourceCapabilities {
            private final boolean listChanged;
            private final boolean readResource;

            @JsonCreator
            public ResourceCapabilities() {
                this.listChanged = false;
                this.readResource = false;
            }

            @JsonCreator
            public ResourceCapabilities(@JsonProperty(value="listChanged") boolean listChanged, @JsonProperty(value="readResource") boolean readResource) {
                this.listChanged = listChanged;
                this.readResource = readResource;
            }

            @JsonProperty(value="listChanged")
            public boolean listChanged() {
                return this.listChanged;
            }

            @JsonProperty(value="readResource")
            public boolean readResource() {
                return this.readResource;
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class PromptCapabilities {
            private final boolean listChanged;

            @JsonCreator
            public PromptCapabilities() {
                this.listChanged = false;
            }

            @JsonCreator
            public PromptCapabilities(@JsonProperty(value="listChanged") boolean listChanged) {
                this.listChanged = listChanged;
            }

            @JsonProperty(value="listChanged")
            public boolean listChanged() {
                return this.listChanged;
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class LoggingCapabilities {
            private final boolean setLevel;

            @JsonCreator
            public LoggingCapabilities() {
                this.setLevel = false;
            }

            @JsonCreator
            public LoggingCapabilities(@JsonProperty(value="setLevel") boolean setLevel) {
                this.setLevel = setLevel;
            }

            @JsonProperty(value="setLevel")
            public boolean setLevel() {
                return this.setLevel;
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ClientCapabilities {
        private final Map<String, Object> experimental;
        private final RootsCapabilities roots;
        private final SamplingCapabilities sampling;

        @JsonCreator
        public ClientCapabilities(@JsonProperty(value="experimental") Map<String, Object> experimental, @JsonProperty(value="roots") RootsCapabilities roots, @JsonProperty(value="sampling") SamplingCapabilities sampling) {
            this.experimental = experimental;
            this.roots = roots;
            this.sampling = sampling;
        }

        @JsonProperty(value="experimental")
        public Map<String, Object> experimental() {
            return this.experimental;
        }

        @JsonProperty(value="roots")
        public RootsCapabilities roots() {
            return this.roots;
        }

        @JsonProperty(value="sampling")
        public SamplingCapabilities sampling() {
            return this.sampling;
        }

        public static class Builder {
            private Map<String, Object> experimental;
            private RootsCapabilities roots;
            private SamplingCapabilities sampling;

            public Builder experimental(Map<String, Object> experimental) {
                this.experimental = experimental;
                return this;
            }

            public Builder roots(boolean listChanged) {
                this.roots = new RootsCapabilities(listChanged);
                return this;
            }

            public Builder sampling(boolean createMessage) {
                this.sampling = new SamplingCapabilities(createMessage);
                return this;
            }

            public ClientCapabilities build() {
                return new ClientCapabilities(this.experimental, this.roots, this.sampling);
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class SamplingCapabilities {
            private final boolean createMessage;

            @JsonCreator
            public SamplingCapabilities() {
                this.createMessage = false;
            }

            @JsonCreator
            public SamplingCapabilities(@JsonProperty(value="createMessage") boolean createMessage) {
                this.createMessage = createMessage;
            }

            @JsonProperty(value="createMessage")
            public boolean createMessage() {
                return this.createMessage;
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class RootsCapabilities {
            private final boolean listChanged;

            @JsonCreator
            public RootsCapabilities() {
                this.listChanged = false;
            }

            @JsonCreator
            public RootsCapabilities(@JsonProperty(value="listChanged") boolean listChanged) {
                this.listChanged = listChanged;
            }

            @JsonProperty(value="listChanged")
            public boolean listChanged() {
                return this.listChanged;
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class InitializeResult {
        private final String protocolVersion;
        private final ServerCapabilities capabilities;
        private final Implementation serverInfo;
        private final String instructions;

        @JsonCreator
        public InitializeResult(@JsonProperty(value="protocolVersion") String protocolVersion, @JsonProperty(value="capabilities") ServerCapabilities capabilities, @JsonProperty(value="serverInfo") Implementation serverInfo, @JsonProperty(value="instructions") String instructions) {
            this.protocolVersion = protocolVersion;
            this.capabilities = capabilities;
            this.serverInfo = serverInfo;
            this.instructions = instructions;
        }

        @JsonProperty(value="protocolVersion")
        public String protocolVersion() {
            return this.protocolVersion;
        }

        @JsonProperty(value="capabilities")
        public ServerCapabilities capabilities() {
            return this.capabilities;
        }

        @JsonProperty(value="serverInfo")
        public Implementation serverInfo() {
            return this.serverInfo;
        }

        @JsonProperty(value="instructions")
        public String instructions() {
            return this.instructions;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class InitializeRequest
    implements Request {
        private final String protocolVersion;
        private final ClientCapabilities capabilities;
        private final Implementation clientInfo;

        @JsonCreator
        public InitializeRequest(@JsonProperty(value="protocolVersion") String protocolVersion, @JsonProperty(value="capabilities") ClientCapabilities capabilities, @JsonProperty(value="clientInfo") Implementation clientInfo) {
            this.protocolVersion = protocolVersion;
            this.capabilities = capabilities;
            this.clientInfo = clientInfo;
        }

        @JsonProperty(value="protocolVersion")
        public String protocolVersion() {
            return this.protocolVersion;
        }

        @JsonProperty(value="capabilities")
        public ClientCapabilities capabilities() {
            return this.capabilities;
        }

        @JsonProperty(value="clientInfo")
        public Implementation clientInfo() {
            return this.clientInfo;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JSONRPCResponse
    implements JSONRPCMessage {
        private final String jsonrpc;
        private final Object id;
        private final Object result;
        private final JSONRPCError error;

        @JsonCreator
        public JSONRPCResponse(@JsonProperty(value="jsonrpc") String jsonrpc, @JsonProperty(value="id") Object id, @JsonProperty(value="result") Object result, @JsonProperty(value="error") JSONRPCError error) {
            this.jsonrpc = jsonrpc;
            this.id = id;
            this.result = result;
            this.error = error;
        }

        @Override
        @JsonProperty(value="jsonrpc")
        public String jsonrpc() {
            return this.jsonrpc;
        }

        @JsonProperty(value="id")
        public Object id() {
            return this.id;
        }

        @JsonProperty(value="result")
        public Object result() {
            return this.result;
        }

        @JsonProperty(value="error")
        public JSONRPCError error() {
            return this.error;
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class JSONRPCError {
            private final int code;
            private final String message;
            private final Object data;

            @JsonCreator
            public JSONRPCError(@JsonProperty(value="code") int code, @JsonProperty(value="message") String message, @JsonProperty(value="data") Object data) {
                this.code = code;
                this.message = message;
                this.data = data;
            }

            @JsonProperty(value="code")
            public int code() {
                return this.code;
            }

            @JsonProperty(value="message")
            public String message() {
                return this.message;
            }

            @JsonProperty(value="data")
            public Object data() {
                return this.data;
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JSONRPCNotification
    implements JSONRPCMessage {
        private final String jsonrpc;
        private final String method;
        private final Map<String, Object> params;

        @JsonCreator
        public JSONRPCNotification(@JsonProperty(value="jsonrpc") String jsonrpc, @JsonProperty(value="method") String method, @JsonProperty(value="params") Map<String, Object> params) {
            this.jsonrpc = jsonrpc;
            this.method = method;
            this.params = params;
        }

        @Override
        @JsonProperty(value="jsonrpc")
        public String jsonrpc() {
            return this.jsonrpc;
        }

        @JsonProperty(value="method")
        public String method() {
            return this.method;
        }

        @JsonProperty(value="params")
        public Map<String, Object> params() {
            return this.params;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JSONRPCRequest
    implements JSONRPCMessage {
        private final String jsonrpc;
        private final String method;
        private final Object id;
        private final Object params;

        @JsonCreator
        public JSONRPCRequest(@JsonProperty(value="jsonrpc") String jsonrpc, @JsonProperty(value="method") String method, @JsonProperty(value="id") Object id, @JsonProperty(value="params") Object params) {
            this.jsonrpc = jsonrpc;
            this.method = method;
            this.id = id;
            this.params = params;
        }

        @Override
        @JsonProperty(value="jsonrpc")
        public String jsonrpc() {
            return this.jsonrpc;
        }

        @JsonProperty(value="method")
        public String method() {
            return this.method;
        }

        @JsonProperty(value="id")
        public Object id() {
            return this.id;
        }

        @JsonProperty(value="params")
        public Object params() {
            return this.params;
        }
    }

    public static final class ErrorCodes {
        public static final int PARSE_ERROR = -32700;
        public static final int INVALID_REQUEST = -32600;
        public static final int METHOD_NOT_FOUND = -32601;
        public static final int INVALID_PARAMS = -32602;
        public static final int INTERNAL_ERROR = -32603;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.DEDUCTION, include=JsonTypeInfo.As.PROPERTY, property="type", visible=true)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=TextContent.class, name="text"), @JsonSubTypes.Type(value=ImageContent.class, name="image"), @JsonSubTypes.Type(value=EmbeddedResource.class, name="resource")})
    public static interface Content {
        default public String type() {
            if (this instanceof TextContent) {
                return "text";
            }
            if (this instanceof ImageContent) {
                return "image";
            }
            if (this instanceof EmbeddedResource) {
                return "resource";
            }
            throw new IllegalArgumentException("Unknown content type: " + this);
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.DEDUCTION, include=JsonTypeInfo.As.PROPERTY, property="type", visible=true)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=TextResourceContents.class, name="text"), @JsonSubTypes.Type(value=BlobResourceContents.class, name="blob")})
    public static interface ResourceContents {
        @JsonProperty(value="uri")
        public String uri();

        @JsonProperty(value="mimeType")
        public String mimeType();
    }

    public static interface Annotated {
        public Annotations annotations();
    }

    public static interface JSONRPCMessage {
        public String jsonrpc();
    }

    public static interface Request {
    }

    public static enum LoggingLevel {
        DEBUG(0),
        INFO(1),
        NOTICE(2),
        WARNING(3),
        ERROR(4),
        CRITICAL(5),
        ALERT(6),
        EMERGENCY(7);

        private final int level;

        private LoggingLevel(int level) {
            this.level = level;
        }

        public int level() {
            return this.level;
        }
    }

    public static enum Role {
        USER,
        ASSISTANT;

    }
}

