/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.utils.ArrayUtils;

public class ArrayTools {
    public static String arrayToString(double[] array, int top) {
        if (ArrayTools.isEmpty(array)) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (array.length > top) {
            double[] copied = new double[top];
            System.arraycopy(array, 0, copied, 0, top);
            sb.append(Arrays.toString(copied)).append("...");
        } else {
            sb.append(Arrays.toString(array));
        }
        sb.append("]");
        return sb.toString();
    }

    public static boolean isEmpty(double[] array) {
        return array == null || array.length == 0;
    }

    public static boolean[] increase(boolean[] values, int increment) {
        boolean[] newData = new boolean[values.length + increment];
        System.arraycopy(values, 0, newData, 0, values.length);
        return newData;
    }

    public static byte[] increase(byte[] values, int increment) {
        byte[] newData = new byte[values.length + increment];
        System.arraycopy(values, 0, newData, 0, values.length);
        return newData;
    }

    public static int[] increase(int[] values, int increment) {
        int[] newData = new int[values.length + increment];
        System.arraycopy(values, 0, newData, 0, values.length);
        return newData;
    }

    public static long[] increase(long[] values, int increment) {
        long[] newData = new long[values.length + increment];
        System.arraycopy(values, 0, newData, 0, values.length);
        return newData;
    }

    public static float[] increase(float[] values, int increment) {
        float[] newData = new float[values.length + increment];
        System.arraycopy(values, 0, newData, 0, values.length);
        return newData;
    }

    public static double[] increase(double[] values, int increment) {
        double[] newData = new double[values.length + increment];
        System.arraycopy(values, 0, newData, 0, values.length);
        return newData;
    }

    public static Object[] increase(Object[] objects, int increment) {
        Object[] newData = new Object[objects.length + increment];
        System.arraycopy(objects, 0, newData, 0, objects.length);
        return newData;
    }

    public static Object[][] increase(Object[][] objects, int increment) {
        Object[][] newData = new Object[objects.length + increment][];
        System.arraycopy(objects, 0, newData, 0, objects.length);
        return newData;
    }

    public static <T> T[] increase(T[] objects, int increment, Class<T> clazz) {
        Object[] newData = (Object[])Array.newInstance(clazz, objects.length + increment);
        System.arraycopy(objects, 0, newData, 0, objects.length);
        return newData;
    }

    public static <T> T[] increaseOne(T[] objects, Class<T> clazz) {
        return ArrayTools.increase(objects, 1, clazz);
    }

    public static double[] toDouble(float[] floatValues) {
        if (ArrayUtils.isEmpty((float[])floatValues)) {
            return new double[0];
        }
        double[] doubleValues = new double[floatValues.length];
        for (int i = 0; i < floatValues.length; ++i) {
            doubleValues[i] = floatValues[i];
        }
        return doubleValues;
    }

    public static float[] toFloat(double[] doubles) {
        if (ArrayUtils.isEmpty((double[])doubles)) {
            return new float[0];
        }
        float[] floatValues = new float[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            floatValues[i] = (float)doubles[i];
        }
        return floatValues;
    }

    public static List<Float> asFloatList(double[] doubles) {
        if (ArrayUtils.isEmpty((double[])doubles)) {
            return new ArrayList<Float>(0);
        }
        ArrayList<Float> ret = new ArrayList<Float>(doubles.length);
        for (double d : doubles) {
            ret.add(Float.valueOf((float)d));
        }
        return ret;
    }
}

