/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb;

import kd.ai.vdb.BoolOperator;
import kd.ai.vdb.FilterVisitor;
import kd.ai.vdb.filterImpl.BoolFilter;
import kd.ai.vdb.filterImpl.EqualFilter;
import kd.ai.vdb.filterImpl.InFilter;
import kd.ai.vdb.filterImpl.RangeFilter;
import kd.ai.vdb.filterImpl.TextMatchFilter;
import kd.ai.vdb.filterImpl.VectorFilter;
import kd.ai.vdb.objects.TokenizeType;

public interface Filter {
    public static Filter and(Filter ... filters) {
        return new BoolFilter(BoolOperator.AND, filters);
    }

    public static Filter and1(Filter ... filters) {
        BoolFilter filter = new BoolFilter(BoolOperator.AND, filters);
        filter.setBoost(1.0f);
        return filter;
    }

    public static Filter or(Filter ... filters) {
        return new BoolFilter(BoolOperator.OR, filters);
    }

    public static Filter or1(Filter ... filters) {
        BoolFilter filter = new BoolFilter(BoolOperator.OR, filters);
        filter.setBoost(1.0f);
        return filter;
    }

    public static Filter in(String field, Object ... values) {
        return new InFilter(field, values);
    }

    public static Filter in1(String field, Object ... values) {
        InFilter filter = new InFilter(field, values);
        filter.setBoost(1.0f);
        return filter;
    }

    public static Filter equal(String field, Object value) {
        return new EqualFilter(field, value);
    }

    public static Filter equal(String field, Object value, float boost) {
        EqualFilter filter = new EqualFilter(field, value);
        filter.setBoost(boost);
        return filter;
    }

    public static Filter range(String field, Object from, Object to) {
        return new RangeFilter(field, from, true, to, true);
    }

    public static Filter range(String field, Object from, boolean includeFrom, Object to, boolean includeTo) {
        return new RangeFilter(field, from, includeFrom, to, includeTo);
    }

    public static Filter range(String field, Object from, boolean includeFrom, Object to, boolean includeTo, float boost) {
        RangeFilter filter = new RangeFilter(field, from, includeFrom, to, includeTo);
        filter.setBoost(boost);
        return filter;
    }

    public static Filter gt(String field, Object from) {
        return Filter.range(field, from, false, null, false);
    }

    public static Filter gte(String field, Object from) {
        return Filter.range(field, from, true, null, false);
    }

    public static Filter lte(String field, Object to) {
        return Filter.range(field, null, false, to, true);
    }

    public static Filter lt(String field, Object to) {
        return Filter.range(field, null, false, to, false);
    }

    public static Filter textMatch(String name, String text) {
        return new TextMatchFilter(name, text);
    }

    public static Filter textMatch(String name, String text, TokenizeType tokenizeType) {
        return new TextMatchFilter(name, text, tokenizeType);
    }

    public static Filter textMatch(String name, String text, TokenizeType tokenizeType, boolean matchAny) {
        return new TextMatchFilter(name, text, tokenizeType, matchAny);
    }

    public static Filter textMatch(String name, String text, TokenizeType tokenizeType, boolean matchAny, float boost) {
        TextMatchFilter filter = new TextMatchFilter(name, text, tokenizeType, matchAny);
        filter.setBoost(boost);
        return filter;
    }

    public static Filter vector(String field, double[] vectors, int topK) {
        return new VectorFilter(field, vectors, topK);
    }

    public static Filter vector(String field, double[] vectors, int topK, float boost) {
        VectorFilter filter = new VectorFilter(field, vectors, topK);
        filter.setBoost(boost);
        return filter;
    }

    public float getBoost();

    public void setBoost(float var1);

    public <T> T accept(FilterVisitor<T> var1);
}

