/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Objects;
import kd.ai.vdb.NotSupportedException;
import kd.ai.vdb.VDBException;
import kd.ai.vdb.objects.DataType;
import kd.ai.vdb.objects.FieldMeta;
import kd.bos.dataentity.utils.StringUtils;

public class JsonUtils {
    public static <T> T toObject(InputStream stream, Class<T> clazz) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        try {
            return (T)objectMapper.readValue(stream, clazz);
        }
        catch (IOException e) {
            throw new VDBException("toObject error", e);
        }
    }

    public static <T> T toObject(String json, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            throw new IllegalArgumentException("json is empty");
        }
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        try {
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new VDBException("toObject error", e);
        }
    }

    public static String toJson(Object obj) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            return objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new VDBException("toJson error", e);
        }
    }

    public static String getJsonValue(FieldMeta field, Object value) {
        Objects.requireNonNull(field, "field is null");
        if (value == null) {
            return null;
        }
        DataType dt = field.getDataType();
        switch (dt) {
            case STRING: 
            case TEXT: {
                return JsonUtils.toJson(value);
            }
            case DATETIME: {
                return "\"" + DataType.dateToString((Date)value) + "\"";
            }
            case INT: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case BOOL: 
            case BYTE: {
                return value.toString();
            }
            case VECTOR: {
                return JsonUtils.getVectorJsonValue(value);
            }
        }
        throw new NotSupportedException("unsupported data type", new Object[0]);
    }

    private static String getVectorJsonValue(Object value) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (value instanceof double[]) {
            double[] doubles = (double[])value;
            for (int i = 0; i < doubles.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(doubles[i]);
            }
        } else if (value instanceof float[]) {
            float[] floats = (float[])value;
            for (int i = 0; i < floats.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(floats[i]);
            }
        } else {
            throw new NotSupportedException("not support vector datatype %s", value.getClass());
        }
        sb.append("]");
        return sb.toString();
    }

    public static String jsonArray(double[] array) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(array[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    public static String jsonArray(String[] array) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("\"");
            sb.append(array[i]);
            sb.append("\"");
        }
        sb.append("]");
        return sb.toString();
    }
}

