/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb;

import java.util.Arrays;
import kd.ai.vdb.Filter;

public class QueryParameters {
    private final String collectionName;
    private final int offset;
    private final int limit;
    private final String[] selectFields;
    private Filter filter;

    public QueryParameters(String collectionName, int offset, int limit, String[] selectFields, Filter filter) {
        if (collectionName == null || collectionName.isEmpty()) {
            throw new IllegalArgumentException("collectionName is null or empty");
        }
        if (limit <= 0) {
            throw new IllegalArgumentException("limit must be greater than 0");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset must be greater than or equal to 0");
        }
        this.collectionName = collectionName;
        this.offset = offset;
        this.limit = limit;
        this.selectFields = selectFields;
        this.filter = filter;
    }

    public QueryParameters(String collectionName, int offset, int limit, String[] selectFields) {
        this(collectionName, offset, limit, selectFields, null);
    }

    public QueryParameters(String collectionName, int top, String[] selectFields) {
        this(collectionName, 0, top, selectFields);
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String[] getSelectFields() {
        return this.selectFields;
    }

    public String toString() {
        String got = this.offset == 0 ? "top:" + this.limit : "skip:" + this.offset + ",top:" + this.limit;
        return this.collectionName + "{" + got + ", selectFields:" + Arrays.toString(this.selectFields) + ", filter:" + this.filter + '}';
    }
}

