/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.ai.vdb.ArrayTools;
import kd.ai.vdb.MapUtils;
import kd.ai.vdb.VDBHost;
import kd.bos.dataentity.utils.ArrayUtils;
import org.apache.http.HttpHost;

public class VDBClientConfig {
    @JsonProperty
    private Map<String, String> properties = new HashMap<String, String>();
    private String user;
    private String password;
    private String driverClass;
    private String driverVersion;
    private String defaultVDB;
    private VDBHost[] hosts;

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public VDBHost[] getHosts() {
        return this.hosts;
    }

    @JsonIgnore
    public HttpHost[] getHttpHosts() {
        if (ArrayUtils.isEmpty((Object[])this.getHosts())) {
            return new HttpHost[0];
        }
        HttpHost[] hosts = new HttpHost[this.getHosts().length];
        for (int i = 0; i < hosts.length; ++i) {
            VDBHost host = this.getHosts()[i];
            hosts[i] = new HttpHost(host.getHost(), host.getPort(), host.getScheme());
        }
        return hosts;
    }

    public void setHosts(VDBHost[] hosts) {
        this.hosts = hosts;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public void setDriverVersion(String driverVersion) {
        this.driverVersion = driverVersion;
    }

    public String getDefaultVDB() {
        return this.defaultVDB;
    }

    public void setDefaultVDB(String defaultVDB) {
        this.defaultVDB = defaultVDB;
    }

    public String getProperty(String propName) {
        return this.properties.getOrDefault(propName, "");
    }

    public void setProperty(String propName, String propValue) {
        this.properties.put(propName, propValue);
    }

    public void addHost(VDBHost host) {
        if (ArrayUtils.isEmpty((Object[])this.hosts)) {
            this.hosts = new VDBHost[]{host};
        } else {
            if (host.isHttps() != this.hosts[0].isHttps()) {
                throw new IllegalArgumentException("all hosts scheme must be same");
            }
            VDBHost[] newHosts = ArrayTools.increaseOne(this.hosts, VDBHost.class);
            newHosts[newHosts.length - 1] = host;
            this.hosts = newHosts;
        }
    }

    public int hashCode() {
        int hash = 31 * Objects.hash(this.user, this.password, this.driverClass, this.driverVersion, this.defaultVDB);
        if (this.hosts != null) {
            for (VDBHost host : this.hosts) {
                hash ^= host.hashCode() * 27;
            }
        }
        return hash ^ 17 * MapUtils.hashCode(this.properties);
    }
}

