/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;

public class VDBConfig {
    private static final VDBConfig _current = new VDBConfig();

    protected VDBConfig() {
    }

    public static VDBConfig current() {
        return _current;
    }

    public boolean assignDefaultValueWhenNull() {
        return this.getBoolProperty("ai.vdb.assigndefaultvalue", true);
    }

    public String getAIDefaultVDBConfig() {
        return this.getProperty("ai.vdb.default", "");
    }

    public Boolean getDisableClusterProperties() {
        String disable = this.getClusterProperty("ai.vdb.clusterproperties.disable", "false");
        return Boolean.parseBoolean(disable);
    }

    public int getTraceMaxDims() {
        return this.getIntProperty("ai.vdb.trace.maxdims", 10);
    }

    protected int getIntProperty(String key, int defaultValue) {
        String value = this.getProperty(key, String.valueOf(defaultValue));
        return Integer.parseInt(value);
    }

    protected boolean getBoolProperty(String key, boolean defaultValue) {
        String value = this.getProperty(key, String.valueOf(defaultValue));
        return Boolean.parseBoolean(value);
    }

    protected String getClusterProperty(String key, String defaultValue) {
        return System.getProperty(key, defaultValue);
    }

    protected String getProperty(String key, String defaultValue) {
        String tenantId = RequestContext.get().getTenantId();
        String pValue = System.getProperty(tenantId + "_" + key);
        if (!this.getDisableClusterProperties().booleanValue() && StringUtils.isEmpty((CharSequence)pValue)) {
            pValue = System.getProperty(key);
        }
        if (StringUtils.isEmpty((CharSequence)pValue)) {
            return defaultValue;
        }
        return pValue;
    }
}

