/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import kd.bos.util.StringUtils;

public class VDBHost {
    private final String host;
    private final int port;
    private final String scheme;

    public VDBHost(String host, int port) {
        this("http", host, port);
    }

    @JsonCreator
    public VDBHost(@JsonProperty(value="scheme") String scheme, @JsonProperty(value="host") String host, @JsonProperty(value="port") int port) {
        if (StringUtils.isEmpty((String)host)) {
            throw new IllegalArgumentException("host name is null");
        }
        if (port > 65536 || port < 0) {
            throw new IllegalArgumentException("host port is illegal");
        }
        if (StringUtils.isEmpty((String)scheme)) {
            throw new IllegalArgumentException("host scheme is null");
        }
        this.scheme = scheme;
        this.host = host;
        this.port = port;
    }

    public static VDBHost of(String scheme, String host, int port) {
        return new VDBHost(scheme, host, port);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getScheme() {
        return this.scheme;
    }

    @JsonIgnore
    public boolean isHttps() {
        return "https".equalsIgnoreCase(this.scheme);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.isHttps());
    }

    public String toString() {
        return this.scheme + "//" + this.host + ":" + this.port;
    }
}

