/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb;

import java.util.Objects;
import kd.ai.vdb.ClientRepo;
import kd.ai.vdb.JsonUtils;
import kd.ai.vdb.VDBClient;
import kd.ai.vdb.VDBClientConfig;
import kd.ai.vdb.VDBConfig;
import kd.ai.vdb.VDBException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class VDBManager {
    private static final Log log = LogFactory.getLog(VDBManager.class);

    public static VDBClient getClient(VDBClientConfig config) {
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(config.getDriverClass(), "driver class is null");
        try {
            String driverClass = config.getDriverClass();
            VDBClient client = ClientRepo.getSingleton(driverClass);
            client.init(config);
            return client;
        }
        catch (Exception ex) {
            log.error("connect vector db error, config info:" + JsonUtils.toJson(config));
            String msg = String.format("connect vector db error by %s,please retry or connect IT admin,", config.getDriverClass());
            throw new VDBException(msg, ex);
        }
    }

    public static VDBClient getDefaultClient() {
        String json = VDBConfig.current().getAIDefaultVDBConfig();
        if (StringUtils.isEmpty((String)json)) {
            throw new VDBException("ai default vdb config is null");
        }
        VDBClientConfig config = JsonUtils.toObject(json, VDBClientConfig.class);
        return VDBManager.getClient(config);
    }
}

