/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.filterImpl;

import kd.ai.vdb.BoolOperator;
import kd.ai.vdb.Filter;
import kd.ai.vdb.FilterVisitor;
import kd.ai.vdb.NotSupportedException;

public class BoolFilter
implements Filter {
    private final Filter[] filters;
    private final BoolOperator operator;
    private float boost = -1.0f;

    public BoolFilter(BoolOperator operator, Filter ... filters) {
        this.operator = operator;
        this.filters = filters;
    }

    @Override
    public float getBoost() {
        return this.boost;
    }

    @Override
    public void setBoost(float boost) {
        if (boost < 0.0f || boost > 1.0f) {
            throw new IllegalArgumentException("boost must less than 1 and great than 0");
        }
        this.boost = boost;
    }

    public Filter[] getFilters() {
        return this.filters;
    }

    public BoolOperator getOperator() {
        return this.operator;
    }

    @Override
    public <T> T accept(FilterVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        String op;
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.operator == BoolOperator.AND) {
            op = " and ";
        } else if (this.operator == BoolOperator.OR) {
            op = " or ";
        } else {
            throw new NotSupportedException("don't suppport operator:" + (Object)((Object)this.operator), new Object[0]);
        }
        for (int i = 0; i < this.filters.length; ++i) {
            Filter filter = this.filters[i];
            sb.append(filter);
            if (i == this.filters.length - 1) continue;
            sb.append(op);
        }
        sb.append(",").append(this.boost);
        sb.append("}");
        return sb.toString();
    }
}

