/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.filterImpl;

import kd.ai.vdb.FilterVisitor;
import kd.ai.vdb.filterImpl.FieldFilter;
import kd.bos.dataentity.utils.StringUtils;

public class EqualFilter
implements FieldFilter {
    private final String field;
    private final Object value;
    private float boost = -1.0f;

    public EqualFilter(String fieldName, Object value) {
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            throw new IllegalArgumentException("filed is empty");
        }
        this.field = fieldName;
        this.value = value;
    }

    @Override
    public float getBoost() {
        return this.boost;
    }

    @Override
    public void setBoost(float boost) {
        if (boost < 0.0f || boost > 1.0f) {
            throw new IllegalArgumentException("boost must less than 1 and great than 0");
        }
        this.boost = boost;
    }

    @Override
    public <T> T accept(FilterVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String getFieldName() {
        return this.field;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return "equal(" + this.field + "," + this.value + "," + this.boost + ")";
    }
}

