/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.filterImpl;

import java.util.Arrays;
import kd.ai.vdb.FilterVisitor;
import kd.ai.vdb.filterImpl.FieldFilter;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;

public class InFilter
implements FieldFilter {
    private final Object[] values;
    private final String field;
    private float boost = -1.0f;

    public InFilter(String fieldName, Object[] values) {
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            throw new IllegalArgumentException("filed is empty");
        }
        if (ArrayUtils.isEmpty((Object[])values)) {
            throw new IllegalArgumentException("values can't be empty");
        }
        this.field = fieldName;
        this.values = values;
    }

    public Object[] getValues() {
        return this.values;
    }

    @Override
    public String getFieldName() {
        return this.field;
    }

    @Override
    public float getBoost() {
        return this.boost;
    }

    @Override
    public void setBoost(float boost) {
        if (boost < 0.0f || boost > 1.0f) {
            throw new IllegalArgumentException("boost must less than 1 and great than 0");
        }
        this.boost = boost;
    }

    @Override
    public <T> T accept(FilterVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "in:(" + this.field + "," + Arrays.toString(this.values) + "," + this.boost + ')';
    }
}

